/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.AgentName;
import com.google.cloud.dialogflow.cx.v3beta1.CreateWebhookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteWebhookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetWebhookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListWebhooksRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListWebhooksResponse;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateWebhookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.Webhook;
import com.google.cloud.dialogflow.cx.v3beta1.WebhookName;
import com.google.cloud.dialogflow.cx.v3beta1.WebhooksSettings;
import com.google.cloud.dialogflow.cx.v3beta1.stub.WebhooksStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.WebhooksStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class WebhooksClient
implements BackgroundResource {
    private final WebhooksSettings settings;
    private final WebhooksStub stub;

    public static final WebhooksClient create() throws IOException {
        return WebhooksClient.create(WebhooksSettings.newBuilder().build());
    }

    public static final WebhooksClient create(WebhooksSettings settings) throws IOException {
        return new WebhooksClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final WebhooksClient create(WebhooksStub stub) {
        return new WebhooksClient(stub);
    }

    protected WebhooksClient(WebhooksSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((WebhooksStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected WebhooksClient(WebhooksStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final WebhooksSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public WebhooksStub getStub() {
        return this.stub;
    }

    public final ListWebhooksPagedResponse listWebhooks(AgentName parent) {
        ListWebhooksRequest request = ListWebhooksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWebhooks(request);
    }

    public final ListWebhooksPagedResponse listWebhooks(String parent) {
        ListWebhooksRequest request = ListWebhooksRequest.newBuilder().setParent(parent).build();
        return this.listWebhooks(request);
    }

    public final ListWebhooksPagedResponse listWebhooks(ListWebhooksRequest request) {
        return (ListWebhooksPagedResponse)((Object)this.listWebhooksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWebhooksRequest, ListWebhooksPagedResponse> listWebhooksPagedCallable() {
        return this.stub.listWebhooksPagedCallable();
    }

    public final UnaryCallable<ListWebhooksRequest, ListWebhooksResponse> listWebhooksCallable() {
        return this.stub.listWebhooksCallable();
    }

    public final Webhook getWebhook(WebhookName name) {
        GetWebhookRequest request = GetWebhookRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWebhook(request);
    }

    public final Webhook getWebhook(String name) {
        GetWebhookRequest request = GetWebhookRequest.newBuilder().setName(name).build();
        return this.getWebhook(request);
    }

    public final Webhook getWebhook(GetWebhookRequest request) {
        return (Webhook)this.getWebhookCallable().call((Object)request);
    }

    public final UnaryCallable<GetWebhookRequest, Webhook> getWebhookCallable() {
        return this.stub.getWebhookCallable();
    }

    public final Webhook createWebhook(AgentName parent, Webhook webhook) {
        CreateWebhookRequest request = CreateWebhookRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWebhook(webhook).build();
        return this.createWebhook(request);
    }

    public final Webhook createWebhook(String parent, Webhook webhook) {
        CreateWebhookRequest request = CreateWebhookRequest.newBuilder().setParent(parent).setWebhook(webhook).build();
        return this.createWebhook(request);
    }

    public final Webhook createWebhook(CreateWebhookRequest request) {
        return (Webhook)this.createWebhookCallable().call((Object)request);
    }

    public final UnaryCallable<CreateWebhookRequest, Webhook> createWebhookCallable() {
        return this.stub.createWebhookCallable();
    }

    public final Webhook updateWebhook(Webhook webhook, FieldMask updateMask) {
        UpdateWebhookRequest request = UpdateWebhookRequest.newBuilder().setWebhook(webhook).setUpdateMask(updateMask).build();
        return this.updateWebhook(request);
    }

    public final Webhook updateWebhook(UpdateWebhookRequest request) {
        return (Webhook)this.updateWebhookCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateWebhookRequest, Webhook> updateWebhookCallable() {
        return this.stub.updateWebhookCallable();
    }

    public final void deleteWebhook(WebhookName name) {
        DeleteWebhookRequest request = DeleteWebhookRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteWebhook(request);
    }

    public final void deleteWebhook(String name) {
        DeleteWebhookRequest request = DeleteWebhookRequest.newBuilder().setName(name).build();
        this.deleteWebhook(request);
    }

    public final void deleteWebhook(DeleteWebhookRequest request) {
        this.deleteWebhookCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteWebhookRequest, Empty> deleteWebhookCallable() {
        return this.stub.deleteWebhookCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListWebhooksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWebhooksRequest, ListWebhooksResponse, Webhook, ListWebhooksPage, ListWebhooksFixedSizeCollection> {
        private ListWebhooksFixedSizeCollection(List<ListWebhooksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWebhooksFixedSizeCollection createEmptyCollection() {
            return new ListWebhooksFixedSizeCollection(null, 0);
        }

        protected ListWebhooksFixedSizeCollection createCollection(List<ListWebhooksPage> pages, int collectionSize) {
            return new ListWebhooksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWebhooksPage
    extends AbstractPage<ListWebhooksRequest, ListWebhooksResponse, Webhook, ListWebhooksPage> {
        private ListWebhooksPage(PageContext<ListWebhooksRequest, ListWebhooksResponse, Webhook> context, ListWebhooksResponse response) {
            super(context, (Object)response);
        }

        private static ListWebhooksPage createEmptyPage() {
            return new ListWebhooksPage(null, null);
        }

        protected ListWebhooksPage createPage(PageContext<ListWebhooksRequest, ListWebhooksResponse, Webhook> context, ListWebhooksResponse response) {
            return new ListWebhooksPage(context, response);
        }

        public ApiFuture<ListWebhooksPage> createPageAsync(PageContext<ListWebhooksRequest, ListWebhooksResponse, Webhook> context, ApiFuture<ListWebhooksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWebhooksPagedResponse
    extends AbstractPagedListResponse<ListWebhooksRequest, ListWebhooksResponse, Webhook, ListWebhooksPage, ListWebhooksFixedSizeCollection> {
        public static ApiFuture<ListWebhooksPagedResponse> createAsync(PageContext<ListWebhooksRequest, ListWebhooksResponse, Webhook> context, ApiFuture<ListWebhooksResponse> futureResponse) {
            ApiFuture<ListWebhooksPage> futurePage = ListWebhooksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWebhooksPagedResponse((ListWebhooksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWebhooksPagedResponse(ListWebhooksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWebhooksFixedSizeCollection.createEmptyCollection());
        }
    }
}

