/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.devicestreaming.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.devicestreaming.v1.AdbMessage;
import com.google.cloud.devicestreaming.v1.CancelDeviceSessionRequest;
import com.google.cloud.devicestreaming.v1.CreateDeviceSessionRequest;
import com.google.cloud.devicestreaming.v1.DeviceMessage;
import com.google.cloud.devicestreaming.v1.DeviceSession;
import com.google.cloud.devicestreaming.v1.DirectAccessServiceClient;
import com.google.cloud.devicestreaming.v1.GetDeviceSessionRequest;
import com.google.cloud.devicestreaming.v1.ListDeviceSessionsRequest;
import com.google.cloud.devicestreaming.v1.ListDeviceSessionsResponse;
import com.google.cloud.devicestreaming.v1.UpdateDeviceSessionRequest;
import com.google.cloud.devicestreaming.v1.stub.DirectAccessServiceStub;
import com.google.cloud.devicestreaming.v1.stub.DirectAccessServiceStubSettings;
import com.google.cloud.devicestreaming.v1.stub.HttpJsonDirectAccessServiceCallableFactory;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonDirectAccessServiceStub
extends DirectAccessServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateDeviceSessionRequest, DeviceSession> createDeviceSessionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.devicestreaming.v1.DirectAccessService/CreateDeviceSession").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*}/deviceSessions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "deviceSessionId", (Object)request.getDeviceSessionId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("deviceSession", (Message)request.getDeviceSession(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DeviceSession.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListDeviceSessionsRequest, ListDeviceSessionsResponse> listDeviceSessionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.devicestreaming.v1.DirectAccessService/ListDeviceSessions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*}/deviceSessions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListDeviceSessionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetDeviceSessionRequest, DeviceSession> getDeviceSessionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.devicestreaming.v1.DirectAccessService/GetDeviceSession").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/deviceSessions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DeviceSession.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CancelDeviceSessionRequest, Empty> cancelDeviceSessionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.devicestreaming.v1.DirectAccessService/CancelDeviceSession").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/deviceSessions/*}:cancel", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateDeviceSessionRequest, DeviceSession> updateDeviceSessionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.devicestreaming.v1.DirectAccessService/UpdateDeviceSession").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{deviceSession.name=projects/*/deviceSessions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "deviceSession.name", (Object)request.getDeviceSession().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("deviceSession", (Message)request.getDeviceSession(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DeviceSession.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateDeviceSessionRequest, DeviceSession> createDeviceSessionCallable;
    private final UnaryCallable<ListDeviceSessionsRequest, ListDeviceSessionsResponse> listDeviceSessionsCallable;
    private final UnaryCallable<ListDeviceSessionsRequest, DirectAccessServiceClient.ListDeviceSessionsPagedResponse> listDeviceSessionsPagedCallable;
    private final UnaryCallable<GetDeviceSessionRequest, DeviceSession> getDeviceSessionCallable;
    private final UnaryCallable<CancelDeviceSessionRequest, Empty> cancelDeviceSessionCallable;
    private final UnaryCallable<UpdateDeviceSessionRequest, DeviceSession> updateDeviceSessionCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDirectAccessServiceStub create(DirectAccessServiceStubSettings settings) throws IOException {
        return new HttpJsonDirectAccessServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDirectAccessServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDirectAccessServiceStub(DirectAccessServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDirectAccessServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDirectAccessServiceStub(DirectAccessServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDirectAccessServiceStub(DirectAccessServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDirectAccessServiceCallableFactory());
    }

    protected HttpJsonDirectAccessServiceStub(DirectAccessServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createDeviceSessionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createDeviceSessionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listDeviceSessionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listDeviceSessionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getDeviceSessionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDeviceSessionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings cancelDeviceSessionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(cancelDeviceSessionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateDeviceSessionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateDeviceSessionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("device_session.name", String.valueOf(request.getDeviceSession().getName()));
            return builder.build();
        }).build();
        this.createDeviceSessionCallable = callableFactory.createUnaryCallable(createDeviceSessionTransportSettings, settings.createDeviceSessionSettings(), clientContext);
        this.listDeviceSessionsCallable = callableFactory.createUnaryCallable(listDeviceSessionsTransportSettings, settings.listDeviceSessionsSettings(), clientContext);
        this.listDeviceSessionsPagedCallable = callableFactory.createPagedCallable(listDeviceSessionsTransportSettings, settings.listDeviceSessionsSettings(), clientContext);
        this.getDeviceSessionCallable = callableFactory.createUnaryCallable(getDeviceSessionTransportSettings, settings.getDeviceSessionSettings(), clientContext);
        this.cancelDeviceSessionCallable = callableFactory.createUnaryCallable(cancelDeviceSessionTransportSettings, settings.cancelDeviceSessionSettings(), clientContext);
        this.updateDeviceSessionCallable = callableFactory.createUnaryCallable(updateDeviceSessionTransportSettings, settings.updateDeviceSessionSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createDeviceSessionMethodDescriptor);
        methodDescriptors.add(listDeviceSessionsMethodDescriptor);
        methodDescriptors.add(getDeviceSessionMethodDescriptor);
        methodDescriptors.add(cancelDeviceSessionMethodDescriptor);
        methodDescriptors.add(updateDeviceSessionMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateDeviceSessionRequest, DeviceSession> createDeviceSessionCallable() {
        return this.createDeviceSessionCallable;
    }

    @Override
    public UnaryCallable<ListDeviceSessionsRequest, ListDeviceSessionsResponse> listDeviceSessionsCallable() {
        return this.listDeviceSessionsCallable;
    }

    @Override
    public UnaryCallable<ListDeviceSessionsRequest, DirectAccessServiceClient.ListDeviceSessionsPagedResponse> listDeviceSessionsPagedCallable() {
        return this.listDeviceSessionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetDeviceSessionRequest, DeviceSession> getDeviceSessionCallable() {
        return this.getDeviceSessionCallable;
    }

    @Override
    public UnaryCallable<CancelDeviceSessionRequest, Empty> cancelDeviceSessionCallable() {
        return this.cancelDeviceSessionCallable;
    }

    @Override
    public UnaryCallable<UpdateDeviceSessionRequest, DeviceSession> updateDeviceSessionCallable() {
        return this.updateDeviceSessionCallable;
    }

    @Override
    public BidiStreamingCallable<AdbMessage, DeviceMessage> adbConnectCallable() {
        throw new UnsupportedOperationException("Not implemented: adbConnectCallable(). REST transport is not implemented for this method yet.");
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

