/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.developerconnect.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.developerconnect.v1.CreateInsightsConfigRequest;
import com.google.cloud.developerconnect.v1.DeleteInsightsConfigRequest;
import com.google.cloud.developerconnect.v1.GetInsightsConfigRequest;
import com.google.cloud.developerconnect.v1.InsightsConfig;
import com.google.cloud.developerconnect.v1.InsightsConfigServiceClient;
import com.google.cloud.developerconnect.v1.ListInsightsConfigsRequest;
import com.google.cloud.developerconnect.v1.ListInsightsConfigsResponse;
import com.google.cloud.developerconnect.v1.OperationMetadata;
import com.google.cloud.developerconnect.v1.UpdateInsightsConfigRequest;
import com.google.cloud.developerconnect.v1.stub.GrpcInsightsConfigServiceCallableFactory;
import com.google.cloud.developerconnect.v1.stub.InsightsConfigServiceStub;
import com.google.cloud.developerconnect.v1.stub.InsightsConfigServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcInsightsConfigServiceStub
extends InsightsConfigServiceStub {
    private static final MethodDescriptor<ListInsightsConfigsRequest, ListInsightsConfigsResponse> listInsightsConfigsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.InsightsConfigService/ListInsightsConfigs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListInsightsConfigsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListInsightsConfigsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateInsightsConfigRequest, Operation> createInsightsConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.InsightsConfigService/CreateInsightsConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateInsightsConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetInsightsConfigRequest, InsightsConfig> getInsightsConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.InsightsConfigService/GetInsightsConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInsightsConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)InsightsConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateInsightsConfigRequest, Operation> updateInsightsConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.InsightsConfigService/UpdateInsightsConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateInsightsConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteInsightsConfigRequest, Operation> deleteInsightsConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.InsightsConfigService/DeleteInsightsConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteInsightsConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListInsightsConfigsRequest, ListInsightsConfigsResponse> listInsightsConfigsCallable;
    private final UnaryCallable<ListInsightsConfigsRequest, InsightsConfigServiceClient.ListInsightsConfigsPagedResponse> listInsightsConfigsPagedCallable;
    private final UnaryCallable<CreateInsightsConfigRequest, Operation> createInsightsConfigCallable;
    private final OperationCallable<CreateInsightsConfigRequest, InsightsConfig, OperationMetadata> createInsightsConfigOperationCallable;
    private final UnaryCallable<GetInsightsConfigRequest, InsightsConfig> getInsightsConfigCallable;
    private final UnaryCallable<UpdateInsightsConfigRequest, Operation> updateInsightsConfigCallable;
    private final OperationCallable<UpdateInsightsConfigRequest, InsightsConfig, OperationMetadata> updateInsightsConfigOperationCallable;
    private final UnaryCallable<DeleteInsightsConfigRequest, Operation> deleteInsightsConfigCallable;
    private final OperationCallable<DeleteInsightsConfigRequest, Empty, OperationMetadata> deleteInsightsConfigOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, InsightsConfigServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcInsightsConfigServiceStub create(InsightsConfigServiceStubSettings settings) throws IOException {
        return new GrpcInsightsConfigServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcInsightsConfigServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcInsightsConfigServiceStub(InsightsConfigServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcInsightsConfigServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcInsightsConfigServiceStub(InsightsConfigServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcInsightsConfigServiceStub(InsightsConfigServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcInsightsConfigServiceCallableFactory());
    }

    protected GrpcInsightsConfigServiceStub(InsightsConfigServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listInsightsConfigsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listInsightsConfigsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createInsightsConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createInsightsConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getInsightsConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInsightsConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateInsightsConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateInsightsConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("insights_config.name", String.valueOf(request.getInsightsConfig().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteInsightsConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteInsightsConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listInsightsConfigsCallable = callableFactory.createUnaryCallable(listInsightsConfigsTransportSettings, settings.listInsightsConfigsSettings(), clientContext);
        this.listInsightsConfigsPagedCallable = callableFactory.createPagedCallable(listInsightsConfigsTransportSettings, settings.listInsightsConfigsSettings(), clientContext);
        this.createInsightsConfigCallable = callableFactory.createUnaryCallable(createInsightsConfigTransportSettings, settings.createInsightsConfigSettings(), clientContext);
        this.createInsightsConfigOperationCallable = callableFactory.createOperationCallable(createInsightsConfigTransportSettings, settings.createInsightsConfigOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getInsightsConfigCallable = callableFactory.createUnaryCallable(getInsightsConfigTransportSettings, settings.getInsightsConfigSettings(), clientContext);
        this.updateInsightsConfigCallable = callableFactory.createUnaryCallable(updateInsightsConfigTransportSettings, settings.updateInsightsConfigSettings(), clientContext);
        this.updateInsightsConfigOperationCallable = callableFactory.createOperationCallable(updateInsightsConfigTransportSettings, settings.updateInsightsConfigOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteInsightsConfigCallable = callableFactory.createUnaryCallable(deleteInsightsConfigTransportSettings, settings.deleteInsightsConfigSettings(), clientContext);
        this.deleteInsightsConfigOperationCallable = callableFactory.createOperationCallable(deleteInsightsConfigTransportSettings, settings.deleteInsightsConfigOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListInsightsConfigsRequest, ListInsightsConfigsResponse> listInsightsConfigsCallable() {
        return this.listInsightsConfigsCallable;
    }

    @Override
    public UnaryCallable<ListInsightsConfigsRequest, InsightsConfigServiceClient.ListInsightsConfigsPagedResponse> listInsightsConfigsPagedCallable() {
        return this.listInsightsConfigsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateInsightsConfigRequest, Operation> createInsightsConfigCallable() {
        return this.createInsightsConfigCallable;
    }

    @Override
    public OperationCallable<CreateInsightsConfigRequest, InsightsConfig, OperationMetadata> createInsightsConfigOperationCallable() {
        return this.createInsightsConfigOperationCallable;
    }

    @Override
    public UnaryCallable<GetInsightsConfigRequest, InsightsConfig> getInsightsConfigCallable() {
        return this.getInsightsConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateInsightsConfigRequest, Operation> updateInsightsConfigCallable() {
        return this.updateInsightsConfigCallable;
    }

    @Override
    public OperationCallable<UpdateInsightsConfigRequest, InsightsConfig, OperationMetadata> updateInsightsConfigOperationCallable() {
        return this.updateInsightsConfigOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteInsightsConfigRequest, Operation> deleteInsightsConfigCallable() {
        return this.deleteInsightsConfigCallable;
    }

    @Override
    public OperationCallable<DeleteInsightsConfigRequest, Empty, OperationMetadata> deleteInsightsConfigOperationCallable() {
        return this.deleteInsightsConfigOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, InsightsConfigServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

