/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.developerconnect.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.developerconnect.v1.Connection;
import com.google.cloud.developerconnect.v1.CreateConnectionRequest;
import com.google.cloud.developerconnect.v1.CreateGitRepositoryLinkRequest;
import com.google.cloud.developerconnect.v1.DeleteConnectionRequest;
import com.google.cloud.developerconnect.v1.DeleteGitRepositoryLinkRequest;
import com.google.cloud.developerconnect.v1.DeveloperConnectClient;
import com.google.cloud.developerconnect.v1.FetchGitHubInstallationsRequest;
import com.google.cloud.developerconnect.v1.FetchGitHubInstallationsResponse;
import com.google.cloud.developerconnect.v1.FetchGitRefsRequest;
import com.google.cloud.developerconnect.v1.FetchGitRefsResponse;
import com.google.cloud.developerconnect.v1.FetchLinkableGitRepositoriesRequest;
import com.google.cloud.developerconnect.v1.FetchLinkableGitRepositoriesResponse;
import com.google.cloud.developerconnect.v1.FetchReadTokenRequest;
import com.google.cloud.developerconnect.v1.FetchReadTokenResponse;
import com.google.cloud.developerconnect.v1.FetchReadWriteTokenRequest;
import com.google.cloud.developerconnect.v1.FetchReadWriteTokenResponse;
import com.google.cloud.developerconnect.v1.GetConnectionRequest;
import com.google.cloud.developerconnect.v1.GetGitRepositoryLinkRequest;
import com.google.cloud.developerconnect.v1.GitRepositoryLink;
import com.google.cloud.developerconnect.v1.ListConnectionsRequest;
import com.google.cloud.developerconnect.v1.ListConnectionsResponse;
import com.google.cloud.developerconnect.v1.ListGitRepositoryLinksRequest;
import com.google.cloud.developerconnect.v1.ListGitRepositoryLinksResponse;
import com.google.cloud.developerconnect.v1.OperationMetadata;
import com.google.cloud.developerconnect.v1.UpdateConnectionRequest;
import com.google.cloud.developerconnect.v1.stub.DeveloperConnectStub;
import com.google.cloud.developerconnect.v1.stub.DeveloperConnectStubSettings;
import com.google.cloud.developerconnect.v1.stub.HttpJsonDeveloperConnectCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonDeveloperConnectStub
extends DeveloperConnectStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(Connection.getDescriptor()).add(OperationMetadata.getDescriptor()).add(GitRepositoryLink.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListConnectionsRequest, ListConnectionsResponse> listConnectionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/ListConnections").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/connections", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListConnectionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetConnectionRequest, Connection> getConnectionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/GetConnection").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/connections/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Connection.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateConnectionRequest, Operation> createConnectionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/CreateConnection").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/connections", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "connectionId", (Object)request.getConnectionId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("connection", (Message)request.getConnection(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateConnectionRequest, Operation> updateConnectionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/UpdateConnection").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{connection.name=projects/*/locations/*/connections/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "connection.name", (Object)request.getConnection().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("connection", (Message)request.getConnection(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteConnectionRequest, Operation> deleteConnectionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/DeleteConnection").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/connections/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<CreateGitRepositoryLinkRequest, Operation> createGitRepositoryLinkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/CreateGitRepositoryLink").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/connections/*}/gitRepositoryLinks", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "gitRepositoryLinkId", (Object)request.getGitRepositoryLinkId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("gitRepositoryLink", (Message)request.getGitRepositoryLink(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteGitRepositoryLinkRequest, Operation> deleteGitRepositoryLinkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/DeleteGitRepositoryLink").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/connections/*/gitRepositoryLinks/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse> listGitRepositoryLinksMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/ListGitRepositoryLinks").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/connections/*}/gitRepositoryLinks", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListGitRepositoryLinksResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetGitRepositoryLinkRequest, GitRepositoryLink> getGitRepositoryLinkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/GetGitRepositoryLink").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/connections/*/gitRepositoryLinks/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GitRepositoryLink.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/FetchReadWriteToken").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{gitRepositoryLink=projects/*/locations/*/connections/*/gitRepositoryLinks/*}:fetchReadWriteToken", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "gitRepositoryLink", (Object)request.getGitRepositoryLink());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearGitRepositoryLink().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)FetchReadWriteTokenResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/FetchReadToken").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{gitRepositoryLink=projects/*/locations/*/connections/*/gitRepositoryLinks/*}:fetchReadToken", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "gitRepositoryLink", (Object)request.getGitRepositoryLink());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearGitRepositoryLink().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)FetchReadTokenResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse> fetchLinkableGitRepositoriesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/FetchLinkableGitRepositories").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{connection=projects/*/locations/*/connections/*}:fetchLinkableGitRepositories", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "connection", (Object)request.getConnection());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)FetchLinkableGitRepositoriesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<FetchGitHubInstallationsRequest, FetchGitHubInstallationsResponse> fetchGitHubInstallationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/FetchGitHubInstallations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{connection=projects/*/locations/*/connections/*}:fetchGitHubInstallations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "connection", (Object)request.getConnection());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)FetchGitHubInstallationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<FetchGitRefsRequest, FetchGitRefsResponse> fetchGitRefsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/FetchGitRefs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{gitRepositoryLink=projects/*/locations/*/connections/*/gitRepositoryLinks/*}:fetchGitRefs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "gitRepositoryLink", (Object)request.getGitRepositoryLink());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "refType", (Object)request.getRefTypeValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)FetchGitRefsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable;
    private final UnaryCallable<ListConnectionsRequest, DeveloperConnectClient.ListConnectionsPagedResponse> listConnectionsPagedCallable;
    private final UnaryCallable<GetConnectionRequest, Connection> getConnectionCallable;
    private final UnaryCallable<CreateConnectionRequest, Operation> createConnectionCallable;
    private final OperationCallable<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationCallable;
    private final UnaryCallable<UpdateConnectionRequest, Operation> updateConnectionCallable;
    private final OperationCallable<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationCallable;
    private final UnaryCallable<DeleteConnectionRequest, Operation> deleteConnectionCallable;
    private final OperationCallable<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationCallable;
    private final UnaryCallable<CreateGitRepositoryLinkRequest, Operation> createGitRepositoryLinkCallable;
    private final OperationCallable<CreateGitRepositoryLinkRequest, GitRepositoryLink, OperationMetadata> createGitRepositoryLinkOperationCallable;
    private final UnaryCallable<DeleteGitRepositoryLinkRequest, Operation> deleteGitRepositoryLinkCallable;
    private final OperationCallable<DeleteGitRepositoryLinkRequest, Empty, OperationMetadata> deleteGitRepositoryLinkOperationCallable;
    private final UnaryCallable<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse> listGitRepositoryLinksCallable;
    private final UnaryCallable<ListGitRepositoryLinksRequest, DeveloperConnectClient.ListGitRepositoryLinksPagedResponse> listGitRepositoryLinksPagedCallable;
    private final UnaryCallable<GetGitRepositoryLinkRequest, GitRepositoryLink> getGitRepositoryLinkCallable;
    private final UnaryCallable<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenCallable;
    private final UnaryCallable<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenCallable;
    private final UnaryCallable<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse> fetchLinkableGitRepositoriesCallable;
    private final UnaryCallable<FetchLinkableGitRepositoriesRequest, DeveloperConnectClient.FetchLinkableGitRepositoriesPagedResponse> fetchLinkableGitRepositoriesPagedCallable;
    private final UnaryCallable<FetchGitHubInstallationsRequest, FetchGitHubInstallationsResponse> fetchGitHubInstallationsCallable;
    private final UnaryCallable<FetchGitRefsRequest, FetchGitRefsResponse> fetchGitRefsCallable;
    private final UnaryCallable<FetchGitRefsRequest, DeveloperConnectClient.FetchGitRefsPagedResponse> fetchGitRefsPagedCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, DeveloperConnectClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDeveloperConnectStub create(DeveloperConnectStubSettings settings) throws IOException {
        return new HttpJsonDeveloperConnectStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDeveloperConnectStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDeveloperConnectStub(DeveloperConnectStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDeveloperConnectStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDeveloperConnectStub(DeveloperConnectStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDeveloperConnectStub(DeveloperConnectStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDeveloperConnectCallableFactory());
    }

    protected HttpJsonDeveloperConnectStub(DeveloperConnectStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings listConnectionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listConnectionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getConnectionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getConnectionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createConnectionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createConnectionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateConnectionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateConnectionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("connection.name", String.valueOf(request.getConnection().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteConnectionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteConnectionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createGitRepositoryLinkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createGitRepositoryLinkMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteGitRepositoryLinkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteGitRepositoryLinkMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listGitRepositoryLinksTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listGitRepositoryLinksMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getGitRepositoryLinkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getGitRepositoryLinkMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings fetchReadWriteTokenTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(fetchReadWriteTokenMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("git_repository_link", String.valueOf(request.getGitRepositoryLink()));
            return builder.build();
        }).build();
        HttpJsonCallSettings fetchReadTokenTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(fetchReadTokenMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("git_repository_link", String.valueOf(request.getGitRepositoryLink()));
            return builder.build();
        }).build();
        HttpJsonCallSettings fetchLinkableGitRepositoriesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(fetchLinkableGitRepositoriesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("connection", String.valueOf(request.getConnection()));
            return builder.build();
        }).build();
        HttpJsonCallSettings fetchGitHubInstallationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(fetchGitHubInstallationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("connection", String.valueOf(request.getConnection()));
            return builder.build();
        }).build();
        HttpJsonCallSettings fetchGitRefsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(fetchGitRefsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("git_repository_link", String.valueOf(request.getGitRepositoryLink()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listConnectionsCallable = callableFactory.createUnaryCallable(listConnectionsTransportSettings, settings.listConnectionsSettings(), clientContext);
        this.listConnectionsPagedCallable = callableFactory.createPagedCallable(listConnectionsTransportSettings, settings.listConnectionsSettings(), clientContext);
        this.getConnectionCallable = callableFactory.createUnaryCallable(getConnectionTransportSettings, settings.getConnectionSettings(), clientContext);
        this.createConnectionCallable = callableFactory.createUnaryCallable(createConnectionTransportSettings, settings.createConnectionSettings(), clientContext);
        this.createConnectionOperationCallable = callableFactory.createOperationCallable(createConnectionTransportSettings, settings.createConnectionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateConnectionCallable = callableFactory.createUnaryCallable(updateConnectionTransportSettings, settings.updateConnectionSettings(), clientContext);
        this.updateConnectionOperationCallable = callableFactory.createOperationCallable(updateConnectionTransportSettings, settings.updateConnectionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteConnectionCallable = callableFactory.createUnaryCallable(deleteConnectionTransportSettings, settings.deleteConnectionSettings(), clientContext);
        this.deleteConnectionOperationCallable = callableFactory.createOperationCallable(deleteConnectionTransportSettings, settings.deleteConnectionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.createGitRepositoryLinkCallable = callableFactory.createUnaryCallable(createGitRepositoryLinkTransportSettings, settings.createGitRepositoryLinkSettings(), clientContext);
        this.createGitRepositoryLinkOperationCallable = callableFactory.createOperationCallable(createGitRepositoryLinkTransportSettings, settings.createGitRepositoryLinkOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteGitRepositoryLinkCallable = callableFactory.createUnaryCallable(deleteGitRepositoryLinkTransportSettings, settings.deleteGitRepositoryLinkSettings(), clientContext);
        this.deleteGitRepositoryLinkOperationCallable = callableFactory.createOperationCallable(deleteGitRepositoryLinkTransportSettings, settings.deleteGitRepositoryLinkOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listGitRepositoryLinksCallable = callableFactory.createUnaryCallable(listGitRepositoryLinksTransportSettings, settings.listGitRepositoryLinksSettings(), clientContext);
        this.listGitRepositoryLinksPagedCallable = callableFactory.createPagedCallable(listGitRepositoryLinksTransportSettings, settings.listGitRepositoryLinksSettings(), clientContext);
        this.getGitRepositoryLinkCallable = callableFactory.createUnaryCallable(getGitRepositoryLinkTransportSettings, settings.getGitRepositoryLinkSettings(), clientContext);
        this.fetchReadWriteTokenCallable = callableFactory.createUnaryCallable(fetchReadWriteTokenTransportSettings, settings.fetchReadWriteTokenSettings(), clientContext);
        this.fetchReadTokenCallable = callableFactory.createUnaryCallable(fetchReadTokenTransportSettings, settings.fetchReadTokenSettings(), clientContext);
        this.fetchLinkableGitRepositoriesCallable = callableFactory.createUnaryCallable(fetchLinkableGitRepositoriesTransportSettings, settings.fetchLinkableGitRepositoriesSettings(), clientContext);
        this.fetchLinkableGitRepositoriesPagedCallable = callableFactory.createPagedCallable(fetchLinkableGitRepositoriesTransportSettings, settings.fetchLinkableGitRepositoriesSettings(), clientContext);
        this.fetchGitHubInstallationsCallable = callableFactory.createUnaryCallable(fetchGitHubInstallationsTransportSettings, settings.fetchGitHubInstallationsSettings(), clientContext);
        this.fetchGitRefsCallable = callableFactory.createUnaryCallable(fetchGitRefsTransportSettings, settings.fetchGitRefsSettings(), clientContext);
        this.fetchGitRefsPagedCallable = callableFactory.createPagedCallable(fetchGitRefsTransportSettings, settings.fetchGitRefsSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listConnectionsMethodDescriptor);
        methodDescriptors.add(getConnectionMethodDescriptor);
        methodDescriptors.add(createConnectionMethodDescriptor);
        methodDescriptors.add(updateConnectionMethodDescriptor);
        methodDescriptors.add(deleteConnectionMethodDescriptor);
        methodDescriptors.add(createGitRepositoryLinkMethodDescriptor);
        methodDescriptors.add(deleteGitRepositoryLinkMethodDescriptor);
        methodDescriptors.add(listGitRepositoryLinksMethodDescriptor);
        methodDescriptors.add(getGitRepositoryLinkMethodDescriptor);
        methodDescriptors.add(fetchReadWriteTokenMethodDescriptor);
        methodDescriptors.add(fetchReadTokenMethodDescriptor);
        methodDescriptors.add(fetchLinkableGitRepositoriesMethodDescriptor);
        methodDescriptors.add(fetchGitHubInstallationsMethodDescriptor);
        methodDescriptors.add(fetchGitRefsMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable() {
        return this.listConnectionsCallable;
    }

    @Override
    public UnaryCallable<ListConnectionsRequest, DeveloperConnectClient.ListConnectionsPagedResponse> listConnectionsPagedCallable() {
        return this.listConnectionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetConnectionRequest, Connection> getConnectionCallable() {
        return this.getConnectionCallable;
    }

    @Override
    public UnaryCallable<CreateConnectionRequest, Operation> createConnectionCallable() {
        return this.createConnectionCallable;
    }

    @Override
    public OperationCallable<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationCallable() {
        return this.createConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateConnectionRequest, Operation> updateConnectionCallable() {
        return this.updateConnectionCallable;
    }

    @Override
    public OperationCallable<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationCallable() {
        return this.updateConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteConnectionRequest, Operation> deleteConnectionCallable() {
        return this.deleteConnectionCallable;
    }

    @Override
    public OperationCallable<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationCallable() {
        return this.deleteConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<CreateGitRepositoryLinkRequest, Operation> createGitRepositoryLinkCallable() {
        return this.createGitRepositoryLinkCallable;
    }

    @Override
    public OperationCallable<CreateGitRepositoryLinkRequest, GitRepositoryLink, OperationMetadata> createGitRepositoryLinkOperationCallable() {
        return this.createGitRepositoryLinkOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteGitRepositoryLinkRequest, Operation> deleteGitRepositoryLinkCallable() {
        return this.deleteGitRepositoryLinkCallable;
    }

    @Override
    public OperationCallable<DeleteGitRepositoryLinkRequest, Empty, OperationMetadata> deleteGitRepositoryLinkOperationCallable() {
        return this.deleteGitRepositoryLinkOperationCallable;
    }

    @Override
    public UnaryCallable<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse> listGitRepositoryLinksCallable() {
        return this.listGitRepositoryLinksCallable;
    }

    @Override
    public UnaryCallable<ListGitRepositoryLinksRequest, DeveloperConnectClient.ListGitRepositoryLinksPagedResponse> listGitRepositoryLinksPagedCallable() {
        return this.listGitRepositoryLinksPagedCallable;
    }

    @Override
    public UnaryCallable<GetGitRepositoryLinkRequest, GitRepositoryLink> getGitRepositoryLinkCallable() {
        return this.getGitRepositoryLinkCallable;
    }

    @Override
    public UnaryCallable<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenCallable() {
        return this.fetchReadWriteTokenCallable;
    }

    @Override
    public UnaryCallable<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenCallable() {
        return this.fetchReadTokenCallable;
    }

    @Override
    public UnaryCallable<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse> fetchLinkableGitRepositoriesCallable() {
        return this.fetchLinkableGitRepositoriesCallable;
    }

    @Override
    public UnaryCallable<FetchLinkableGitRepositoriesRequest, DeveloperConnectClient.FetchLinkableGitRepositoriesPagedResponse> fetchLinkableGitRepositoriesPagedCallable() {
        return this.fetchLinkableGitRepositoriesPagedCallable;
    }

    @Override
    public UnaryCallable<FetchGitHubInstallationsRequest, FetchGitHubInstallationsResponse> fetchGitHubInstallationsCallable() {
        return this.fetchGitHubInstallationsCallable;
    }

    @Override
    public UnaryCallable<FetchGitRefsRequest, FetchGitRefsResponse> fetchGitRefsCallable() {
        return this.fetchGitRefsCallable;
    }

    @Override
    public UnaryCallable<FetchGitRefsRequest, DeveloperConnectClient.FetchGitRefsPagedResponse> fetchGitRefsPagedCallable() {
        return this.fetchGitRefsPagedCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, DeveloperConnectClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

