/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastream.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datastream.v1.ConnectionProfile;
import com.google.cloud.datastream.v1.CreateConnectionProfileRequest;
import com.google.cloud.datastream.v1.CreatePrivateConnectionRequest;
import com.google.cloud.datastream.v1.CreateRouteRequest;
import com.google.cloud.datastream.v1.CreateStreamRequest;
import com.google.cloud.datastream.v1.DatastreamClient;
import com.google.cloud.datastream.v1.DeleteConnectionProfileRequest;
import com.google.cloud.datastream.v1.DeletePrivateConnectionRequest;
import com.google.cloud.datastream.v1.DeleteRouteRequest;
import com.google.cloud.datastream.v1.DeleteStreamRequest;
import com.google.cloud.datastream.v1.DiscoverConnectionProfileRequest;
import com.google.cloud.datastream.v1.DiscoverConnectionProfileResponse;
import com.google.cloud.datastream.v1.FetchStaticIpsRequest;
import com.google.cloud.datastream.v1.FetchStaticIpsResponse;
import com.google.cloud.datastream.v1.GetConnectionProfileRequest;
import com.google.cloud.datastream.v1.GetPrivateConnectionRequest;
import com.google.cloud.datastream.v1.GetRouteRequest;
import com.google.cloud.datastream.v1.GetStreamObjectRequest;
import com.google.cloud.datastream.v1.GetStreamRequest;
import com.google.cloud.datastream.v1.ListConnectionProfilesRequest;
import com.google.cloud.datastream.v1.ListConnectionProfilesResponse;
import com.google.cloud.datastream.v1.ListPrivateConnectionsRequest;
import com.google.cloud.datastream.v1.ListPrivateConnectionsResponse;
import com.google.cloud.datastream.v1.ListRoutesRequest;
import com.google.cloud.datastream.v1.ListRoutesResponse;
import com.google.cloud.datastream.v1.ListStreamObjectsRequest;
import com.google.cloud.datastream.v1.ListStreamObjectsResponse;
import com.google.cloud.datastream.v1.ListStreamsRequest;
import com.google.cloud.datastream.v1.ListStreamsResponse;
import com.google.cloud.datastream.v1.LookupStreamObjectRequest;
import com.google.cloud.datastream.v1.OperationMetadata;
import com.google.cloud.datastream.v1.PrivateConnection;
import com.google.cloud.datastream.v1.Route;
import com.google.cloud.datastream.v1.StartBackfillJobRequest;
import com.google.cloud.datastream.v1.StartBackfillJobResponse;
import com.google.cloud.datastream.v1.StopBackfillJobRequest;
import com.google.cloud.datastream.v1.StopBackfillJobResponse;
import com.google.cloud.datastream.v1.Stream;
import com.google.cloud.datastream.v1.StreamObject;
import com.google.cloud.datastream.v1.UpdateConnectionProfileRequest;
import com.google.cloud.datastream.v1.UpdateStreamRequest;
import com.google.cloud.datastream.v1.stub.DatastreamStub;
import com.google.cloud.datastream.v1.stub.DatastreamStubSettings;
import com.google.cloud.datastream.v1.stub.HttpJsonDatastreamCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonDatastreamStub
extends DatastreamStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(ConnectionProfile.getDescriptor()).add(OperationMetadata.getDescriptor()).add(Route.getDescriptor()).add(PrivateConnection.getDescriptor()).add(Stream.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListConnectionProfilesRequest, ListConnectionProfilesResponse> listConnectionProfilesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/ListConnectionProfiles").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/connectionProfiles", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListConnectionProfilesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/GetConnectionProfile").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/connectionProfiles/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ConnectionProfile.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateConnectionProfileRequest, Operation> createConnectionProfileMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/CreateConnectionProfile").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/connectionProfiles", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "connectionProfileId", (Object)request.getConnectionProfileId());
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("connectionProfile", (Message)request.getConnectionProfile(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateConnectionProfileRequest, Operation> updateConnectionProfileMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/UpdateConnectionProfile").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{connectionProfile.name=projects/*/locations/*/connectionProfiles/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "connectionProfile.name", (Object)request.getConnectionProfile().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("connectionProfile", (Message)request.getConnectionProfile(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/DeleteConnectionProfile").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/connectionProfiles/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DiscoverConnectionProfileRequest, DiscoverConnectionProfileResponse> discoverConnectionProfileMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/DiscoverConnectionProfile").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/connectionProfiles:discover", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DiscoverConnectionProfileResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListStreamsRequest, ListStreamsResponse> listStreamsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/ListStreams").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/streams", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListStreamsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetStreamRequest, Stream> getStreamMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/GetStream").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/streams/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Stream.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateStreamRequest, Operation> createStreamMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/CreateStream").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/streams", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "streamId", (Object)request.getStreamId());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("stream", (Message)request.getStream(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateStreamRequest, Operation> updateStreamMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/UpdateStream").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{stream.name=projects/*/locations/*/streams/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "stream.name", (Object)request.getStream().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("stream", (Message)request.getStream(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteStreamRequest, Operation> deleteStreamMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/DeleteStream").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/streams/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetStreamObjectRequest, StreamObject> getStreamObjectMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/GetStreamObject").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/streams/*/objects/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)StreamObject.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<LookupStreamObjectRequest, StreamObject> lookupStreamObjectMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/LookupStreamObject").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/streams/*}/objects:lookup", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)StreamObject.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListStreamObjectsRequest, ListStreamObjectsResponse> listStreamObjectsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/ListStreamObjects").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/streams/*}/objects", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListStreamObjectsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<StartBackfillJobRequest, StartBackfillJobResponse> startBackfillJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/StartBackfillJob").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{object=projects/*/locations/*/streams/*/objects/*}:startBackfillJob", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "object", (Object)request.getObject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearObject().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)StartBackfillJobResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<StopBackfillJobRequest, StopBackfillJobResponse> stopBackfillJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/StopBackfillJob").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{object=projects/*/locations/*/streams/*/objects/*}:stopBackfillJob", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "object", (Object)request.getObject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearObject().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)StopBackfillJobResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<FetchStaticIpsRequest, FetchStaticIpsResponse> fetchStaticIpsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/FetchStaticIps").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*}:fetchStaticIps", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)FetchStaticIpsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreatePrivateConnectionRequest, Operation> createPrivateConnectionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/CreatePrivateConnection").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/privateConnections", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        serializer.putQueryParam(fields, "privateConnectionId", (Object)request.getPrivateConnectionId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("privateConnection", (Message)request.getPrivateConnection(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetPrivateConnectionRequest, PrivateConnection> getPrivateConnectionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/GetPrivateConnection").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/privateConnections/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)PrivateConnection.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse> listPrivateConnectionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/ListPrivateConnections").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/privateConnections", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListPrivateConnectionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeletePrivateConnectionRequest, Operation> deletePrivateConnectionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/DeletePrivateConnection").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/privateConnections/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<CreateRouteRequest, Operation> createRouteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/CreateRoute").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/privateConnections/*}/routes", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "routeId", (Object)request.getRouteId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("route", (Message)request.getRoute(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetRouteRequest, Route> getRouteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/GetRoute").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/privateConnections/*/routes/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Route.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListRoutesRequest, ListRoutesResponse> listRoutesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/ListRoutes").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/privateConnections/*}/routes", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListRoutesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteRouteRequest, Operation> deleteRouteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.datastream.v1.Datastream/DeleteRoute").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/privateConnections/*/routes/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListConnectionProfilesRequest, ListConnectionProfilesResponse> listConnectionProfilesCallable;
    private final UnaryCallable<ListConnectionProfilesRequest, DatastreamClient.ListConnectionProfilesPagedResponse> listConnectionProfilesPagedCallable;
    private final UnaryCallable<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileCallable;
    private final UnaryCallable<CreateConnectionProfileRequest, Operation> createConnectionProfileCallable;
    private final OperationCallable<CreateConnectionProfileRequest, ConnectionProfile, OperationMetadata> createConnectionProfileOperationCallable;
    private final UnaryCallable<UpdateConnectionProfileRequest, Operation> updateConnectionProfileCallable;
    private final OperationCallable<UpdateConnectionProfileRequest, ConnectionProfile, OperationMetadata> updateConnectionProfileOperationCallable;
    private final UnaryCallable<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileCallable;
    private final OperationCallable<DeleteConnectionProfileRequest, Empty, OperationMetadata> deleteConnectionProfileOperationCallable;
    private final UnaryCallable<DiscoverConnectionProfileRequest, DiscoverConnectionProfileResponse> discoverConnectionProfileCallable;
    private final UnaryCallable<ListStreamsRequest, ListStreamsResponse> listStreamsCallable;
    private final UnaryCallable<ListStreamsRequest, DatastreamClient.ListStreamsPagedResponse> listStreamsPagedCallable;
    private final UnaryCallable<GetStreamRequest, Stream> getStreamCallable;
    private final UnaryCallable<CreateStreamRequest, Operation> createStreamCallable;
    private final OperationCallable<CreateStreamRequest, Stream, OperationMetadata> createStreamOperationCallable;
    private final UnaryCallable<UpdateStreamRequest, Operation> updateStreamCallable;
    private final OperationCallable<UpdateStreamRequest, Stream, OperationMetadata> updateStreamOperationCallable;
    private final UnaryCallable<DeleteStreamRequest, Operation> deleteStreamCallable;
    private final OperationCallable<DeleteStreamRequest, Empty, OperationMetadata> deleteStreamOperationCallable;
    private final UnaryCallable<GetStreamObjectRequest, StreamObject> getStreamObjectCallable;
    private final UnaryCallable<LookupStreamObjectRequest, StreamObject> lookupStreamObjectCallable;
    private final UnaryCallable<ListStreamObjectsRequest, ListStreamObjectsResponse> listStreamObjectsCallable;
    private final UnaryCallable<ListStreamObjectsRequest, DatastreamClient.ListStreamObjectsPagedResponse> listStreamObjectsPagedCallable;
    private final UnaryCallable<StartBackfillJobRequest, StartBackfillJobResponse> startBackfillJobCallable;
    private final UnaryCallable<StopBackfillJobRequest, StopBackfillJobResponse> stopBackfillJobCallable;
    private final UnaryCallable<FetchStaticIpsRequest, FetchStaticIpsResponse> fetchStaticIpsCallable;
    private final UnaryCallable<FetchStaticIpsRequest, DatastreamClient.FetchStaticIpsPagedResponse> fetchStaticIpsPagedCallable;
    private final UnaryCallable<CreatePrivateConnectionRequest, Operation> createPrivateConnectionCallable;
    private final OperationCallable<CreatePrivateConnectionRequest, PrivateConnection, OperationMetadata> createPrivateConnectionOperationCallable;
    private final UnaryCallable<GetPrivateConnectionRequest, PrivateConnection> getPrivateConnectionCallable;
    private final UnaryCallable<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse> listPrivateConnectionsCallable;
    private final UnaryCallable<ListPrivateConnectionsRequest, DatastreamClient.ListPrivateConnectionsPagedResponse> listPrivateConnectionsPagedCallable;
    private final UnaryCallable<DeletePrivateConnectionRequest, Operation> deletePrivateConnectionCallable;
    private final OperationCallable<DeletePrivateConnectionRequest, Empty, OperationMetadata> deletePrivateConnectionOperationCallable;
    private final UnaryCallable<CreateRouteRequest, Operation> createRouteCallable;
    private final OperationCallable<CreateRouteRequest, Route, OperationMetadata> createRouteOperationCallable;
    private final UnaryCallable<GetRouteRequest, Route> getRouteCallable;
    private final UnaryCallable<ListRoutesRequest, ListRoutesResponse> listRoutesCallable;
    private final UnaryCallable<ListRoutesRequest, DatastreamClient.ListRoutesPagedResponse> listRoutesPagedCallable;
    private final UnaryCallable<DeleteRouteRequest, Operation> deleteRouteCallable;
    private final OperationCallable<DeleteRouteRequest, Empty, OperationMetadata> deleteRouteOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, DatastreamClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDatastreamStub create(DatastreamStubSettings settings) throws IOException {
        return new HttpJsonDatastreamStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDatastreamStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDatastreamStub(DatastreamStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDatastreamStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDatastreamStub(DatastreamStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDatastreamStub(DatastreamStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDatastreamCallableFactory());
    }

    protected HttpJsonDatastreamStub(DatastreamStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings listConnectionProfilesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listConnectionProfilesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getConnectionProfileTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getConnectionProfileMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createConnectionProfileTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createConnectionProfileMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateConnectionProfileTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateConnectionProfileMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("connection_profile.name", String.valueOf(request.getConnectionProfile().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteConnectionProfileTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteConnectionProfileMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings discoverConnectionProfileTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(discoverConnectionProfileMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listStreamsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listStreamsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getStreamTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getStreamMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createStreamTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createStreamMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateStreamTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateStreamMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("stream.name", String.valueOf(request.getStream().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteStreamTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteStreamMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getStreamObjectTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getStreamObjectMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings lookupStreamObjectTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(lookupStreamObjectMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listStreamObjectsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listStreamObjectsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings startBackfillJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(startBackfillJobMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("object", String.valueOf(request.getObject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings stopBackfillJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(stopBackfillJobMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("object", String.valueOf(request.getObject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings fetchStaticIpsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(fetchStaticIpsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createPrivateConnectionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createPrivateConnectionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getPrivateConnectionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getPrivateConnectionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listPrivateConnectionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listPrivateConnectionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deletePrivateConnectionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deletePrivateConnectionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createRouteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createRouteMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getRouteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRouteMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listRoutesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRoutesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteRouteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteRouteMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listConnectionProfilesCallable = callableFactory.createUnaryCallable(listConnectionProfilesTransportSettings, settings.listConnectionProfilesSettings(), clientContext);
        this.listConnectionProfilesPagedCallable = callableFactory.createPagedCallable(listConnectionProfilesTransportSettings, settings.listConnectionProfilesSettings(), clientContext);
        this.getConnectionProfileCallable = callableFactory.createUnaryCallable(getConnectionProfileTransportSettings, settings.getConnectionProfileSettings(), clientContext);
        this.createConnectionProfileCallable = callableFactory.createUnaryCallable(createConnectionProfileTransportSettings, settings.createConnectionProfileSettings(), clientContext);
        this.createConnectionProfileOperationCallable = callableFactory.createOperationCallable(createConnectionProfileTransportSettings, settings.createConnectionProfileOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateConnectionProfileCallable = callableFactory.createUnaryCallable(updateConnectionProfileTransportSettings, settings.updateConnectionProfileSettings(), clientContext);
        this.updateConnectionProfileOperationCallable = callableFactory.createOperationCallable(updateConnectionProfileTransportSettings, settings.updateConnectionProfileOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteConnectionProfileCallable = callableFactory.createUnaryCallable(deleteConnectionProfileTransportSettings, settings.deleteConnectionProfileSettings(), clientContext);
        this.deleteConnectionProfileOperationCallable = callableFactory.createOperationCallable(deleteConnectionProfileTransportSettings, settings.deleteConnectionProfileOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.discoverConnectionProfileCallable = callableFactory.createUnaryCallable(discoverConnectionProfileTransportSettings, settings.discoverConnectionProfileSettings(), clientContext);
        this.listStreamsCallable = callableFactory.createUnaryCallable(listStreamsTransportSettings, settings.listStreamsSettings(), clientContext);
        this.listStreamsPagedCallable = callableFactory.createPagedCallable(listStreamsTransportSettings, settings.listStreamsSettings(), clientContext);
        this.getStreamCallable = callableFactory.createUnaryCallable(getStreamTransportSettings, settings.getStreamSettings(), clientContext);
        this.createStreamCallable = callableFactory.createUnaryCallable(createStreamTransportSettings, settings.createStreamSettings(), clientContext);
        this.createStreamOperationCallable = callableFactory.createOperationCallable(createStreamTransportSettings, settings.createStreamOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateStreamCallable = callableFactory.createUnaryCallable(updateStreamTransportSettings, settings.updateStreamSettings(), clientContext);
        this.updateStreamOperationCallable = callableFactory.createOperationCallable(updateStreamTransportSettings, settings.updateStreamOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteStreamCallable = callableFactory.createUnaryCallable(deleteStreamTransportSettings, settings.deleteStreamSettings(), clientContext);
        this.deleteStreamOperationCallable = callableFactory.createOperationCallable(deleteStreamTransportSettings, settings.deleteStreamOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getStreamObjectCallable = callableFactory.createUnaryCallable(getStreamObjectTransportSettings, settings.getStreamObjectSettings(), clientContext);
        this.lookupStreamObjectCallable = callableFactory.createUnaryCallable(lookupStreamObjectTransportSettings, settings.lookupStreamObjectSettings(), clientContext);
        this.listStreamObjectsCallable = callableFactory.createUnaryCallable(listStreamObjectsTransportSettings, settings.listStreamObjectsSettings(), clientContext);
        this.listStreamObjectsPagedCallable = callableFactory.createPagedCallable(listStreamObjectsTransportSettings, settings.listStreamObjectsSettings(), clientContext);
        this.startBackfillJobCallable = callableFactory.createUnaryCallable(startBackfillJobTransportSettings, settings.startBackfillJobSettings(), clientContext);
        this.stopBackfillJobCallable = callableFactory.createUnaryCallable(stopBackfillJobTransportSettings, settings.stopBackfillJobSettings(), clientContext);
        this.fetchStaticIpsCallable = callableFactory.createUnaryCallable(fetchStaticIpsTransportSettings, settings.fetchStaticIpsSettings(), clientContext);
        this.fetchStaticIpsPagedCallable = callableFactory.createPagedCallable(fetchStaticIpsTransportSettings, settings.fetchStaticIpsSettings(), clientContext);
        this.createPrivateConnectionCallable = callableFactory.createUnaryCallable(createPrivateConnectionTransportSettings, settings.createPrivateConnectionSettings(), clientContext);
        this.createPrivateConnectionOperationCallable = callableFactory.createOperationCallable(createPrivateConnectionTransportSettings, settings.createPrivateConnectionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getPrivateConnectionCallable = callableFactory.createUnaryCallable(getPrivateConnectionTransportSettings, settings.getPrivateConnectionSettings(), clientContext);
        this.listPrivateConnectionsCallable = callableFactory.createUnaryCallable(listPrivateConnectionsTransportSettings, settings.listPrivateConnectionsSettings(), clientContext);
        this.listPrivateConnectionsPagedCallable = callableFactory.createPagedCallable(listPrivateConnectionsTransportSettings, settings.listPrivateConnectionsSettings(), clientContext);
        this.deletePrivateConnectionCallable = callableFactory.createUnaryCallable(deletePrivateConnectionTransportSettings, settings.deletePrivateConnectionSettings(), clientContext);
        this.deletePrivateConnectionOperationCallable = callableFactory.createOperationCallable(deletePrivateConnectionTransportSettings, settings.deletePrivateConnectionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.createRouteCallable = callableFactory.createUnaryCallable(createRouteTransportSettings, settings.createRouteSettings(), clientContext);
        this.createRouteOperationCallable = callableFactory.createOperationCallable(createRouteTransportSettings, settings.createRouteOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getRouteCallable = callableFactory.createUnaryCallable(getRouteTransportSettings, settings.getRouteSettings(), clientContext);
        this.listRoutesCallable = callableFactory.createUnaryCallable(listRoutesTransportSettings, settings.listRoutesSettings(), clientContext);
        this.listRoutesPagedCallable = callableFactory.createPagedCallable(listRoutesTransportSettings, settings.listRoutesSettings(), clientContext);
        this.deleteRouteCallable = callableFactory.createUnaryCallable(deleteRouteTransportSettings, settings.deleteRouteSettings(), clientContext);
        this.deleteRouteOperationCallable = callableFactory.createOperationCallable(deleteRouteTransportSettings, settings.deleteRouteOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listConnectionProfilesMethodDescriptor);
        methodDescriptors.add(getConnectionProfileMethodDescriptor);
        methodDescriptors.add(createConnectionProfileMethodDescriptor);
        methodDescriptors.add(updateConnectionProfileMethodDescriptor);
        methodDescriptors.add(deleteConnectionProfileMethodDescriptor);
        methodDescriptors.add(discoverConnectionProfileMethodDescriptor);
        methodDescriptors.add(listStreamsMethodDescriptor);
        methodDescriptors.add(getStreamMethodDescriptor);
        methodDescriptors.add(createStreamMethodDescriptor);
        methodDescriptors.add(updateStreamMethodDescriptor);
        methodDescriptors.add(deleteStreamMethodDescriptor);
        methodDescriptors.add(getStreamObjectMethodDescriptor);
        methodDescriptors.add(lookupStreamObjectMethodDescriptor);
        methodDescriptors.add(listStreamObjectsMethodDescriptor);
        methodDescriptors.add(startBackfillJobMethodDescriptor);
        methodDescriptors.add(stopBackfillJobMethodDescriptor);
        methodDescriptors.add(fetchStaticIpsMethodDescriptor);
        methodDescriptors.add(createPrivateConnectionMethodDescriptor);
        methodDescriptors.add(getPrivateConnectionMethodDescriptor);
        methodDescriptors.add(listPrivateConnectionsMethodDescriptor);
        methodDescriptors.add(deletePrivateConnectionMethodDescriptor);
        methodDescriptors.add(createRouteMethodDescriptor);
        methodDescriptors.add(getRouteMethodDescriptor);
        methodDescriptors.add(listRoutesMethodDescriptor);
        methodDescriptors.add(deleteRouteMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListConnectionProfilesRequest, ListConnectionProfilesResponse> listConnectionProfilesCallable() {
        return this.listConnectionProfilesCallable;
    }

    @Override
    public UnaryCallable<ListConnectionProfilesRequest, DatastreamClient.ListConnectionProfilesPagedResponse> listConnectionProfilesPagedCallable() {
        return this.listConnectionProfilesPagedCallable;
    }

    @Override
    public UnaryCallable<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileCallable() {
        return this.getConnectionProfileCallable;
    }

    @Override
    public UnaryCallable<CreateConnectionProfileRequest, Operation> createConnectionProfileCallable() {
        return this.createConnectionProfileCallable;
    }

    @Override
    public OperationCallable<CreateConnectionProfileRequest, ConnectionProfile, OperationMetadata> createConnectionProfileOperationCallable() {
        return this.createConnectionProfileOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateConnectionProfileRequest, Operation> updateConnectionProfileCallable() {
        return this.updateConnectionProfileCallable;
    }

    @Override
    public OperationCallable<UpdateConnectionProfileRequest, ConnectionProfile, OperationMetadata> updateConnectionProfileOperationCallable() {
        return this.updateConnectionProfileOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileCallable() {
        return this.deleteConnectionProfileCallable;
    }

    @Override
    public OperationCallable<DeleteConnectionProfileRequest, Empty, OperationMetadata> deleteConnectionProfileOperationCallable() {
        return this.deleteConnectionProfileOperationCallable;
    }

    @Override
    public UnaryCallable<DiscoverConnectionProfileRequest, DiscoverConnectionProfileResponse> discoverConnectionProfileCallable() {
        return this.discoverConnectionProfileCallable;
    }

    @Override
    public UnaryCallable<ListStreamsRequest, ListStreamsResponse> listStreamsCallable() {
        return this.listStreamsCallable;
    }

    @Override
    public UnaryCallable<ListStreamsRequest, DatastreamClient.ListStreamsPagedResponse> listStreamsPagedCallable() {
        return this.listStreamsPagedCallable;
    }

    @Override
    public UnaryCallable<GetStreamRequest, Stream> getStreamCallable() {
        return this.getStreamCallable;
    }

    @Override
    public UnaryCallable<CreateStreamRequest, Operation> createStreamCallable() {
        return this.createStreamCallable;
    }

    @Override
    public OperationCallable<CreateStreamRequest, Stream, OperationMetadata> createStreamOperationCallable() {
        return this.createStreamOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateStreamRequest, Operation> updateStreamCallable() {
        return this.updateStreamCallable;
    }

    @Override
    public OperationCallable<UpdateStreamRequest, Stream, OperationMetadata> updateStreamOperationCallable() {
        return this.updateStreamOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteStreamRequest, Operation> deleteStreamCallable() {
        return this.deleteStreamCallable;
    }

    @Override
    public OperationCallable<DeleteStreamRequest, Empty, OperationMetadata> deleteStreamOperationCallable() {
        return this.deleteStreamOperationCallable;
    }

    @Override
    public UnaryCallable<GetStreamObjectRequest, StreamObject> getStreamObjectCallable() {
        return this.getStreamObjectCallable;
    }

    @Override
    public UnaryCallable<LookupStreamObjectRequest, StreamObject> lookupStreamObjectCallable() {
        return this.lookupStreamObjectCallable;
    }

    @Override
    public UnaryCallable<ListStreamObjectsRequest, ListStreamObjectsResponse> listStreamObjectsCallable() {
        return this.listStreamObjectsCallable;
    }

    @Override
    public UnaryCallable<ListStreamObjectsRequest, DatastreamClient.ListStreamObjectsPagedResponse> listStreamObjectsPagedCallable() {
        return this.listStreamObjectsPagedCallable;
    }

    @Override
    public UnaryCallable<StartBackfillJobRequest, StartBackfillJobResponse> startBackfillJobCallable() {
        return this.startBackfillJobCallable;
    }

    @Override
    public UnaryCallable<StopBackfillJobRequest, StopBackfillJobResponse> stopBackfillJobCallable() {
        return this.stopBackfillJobCallable;
    }

    @Override
    public UnaryCallable<FetchStaticIpsRequest, FetchStaticIpsResponse> fetchStaticIpsCallable() {
        return this.fetchStaticIpsCallable;
    }

    @Override
    public UnaryCallable<FetchStaticIpsRequest, DatastreamClient.FetchStaticIpsPagedResponse> fetchStaticIpsPagedCallable() {
        return this.fetchStaticIpsPagedCallable;
    }

    @Override
    public UnaryCallable<CreatePrivateConnectionRequest, Operation> createPrivateConnectionCallable() {
        return this.createPrivateConnectionCallable;
    }

    @Override
    public OperationCallable<CreatePrivateConnectionRequest, PrivateConnection, OperationMetadata> createPrivateConnectionOperationCallable() {
        return this.createPrivateConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<GetPrivateConnectionRequest, PrivateConnection> getPrivateConnectionCallable() {
        return this.getPrivateConnectionCallable;
    }

    @Override
    public UnaryCallable<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse> listPrivateConnectionsCallable() {
        return this.listPrivateConnectionsCallable;
    }

    @Override
    public UnaryCallable<ListPrivateConnectionsRequest, DatastreamClient.ListPrivateConnectionsPagedResponse> listPrivateConnectionsPagedCallable() {
        return this.listPrivateConnectionsPagedCallable;
    }

    @Override
    public UnaryCallable<DeletePrivateConnectionRequest, Operation> deletePrivateConnectionCallable() {
        return this.deletePrivateConnectionCallable;
    }

    @Override
    public OperationCallable<DeletePrivateConnectionRequest, Empty, OperationMetadata> deletePrivateConnectionOperationCallable() {
        return this.deletePrivateConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<CreateRouteRequest, Operation> createRouteCallable() {
        return this.createRouteCallable;
    }

    @Override
    public OperationCallable<CreateRouteRequest, Route, OperationMetadata> createRouteOperationCallable() {
        return this.createRouteOperationCallable;
    }

    @Override
    public UnaryCallable<GetRouteRequest, Route> getRouteCallable() {
        return this.getRouteCallable;
    }

    @Override
    public UnaryCallable<ListRoutesRequest, ListRoutesResponse> listRoutesCallable() {
        return this.listRoutesCallable;
    }

    @Override
    public UnaryCallable<ListRoutesRequest, DatastreamClient.ListRoutesPagedResponse> listRoutesPagedCallable() {
        return this.listRoutesPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteRouteRequest, Operation> deleteRouteCallable() {
        return this.deleteRouteCallable;
    }

    @Override
    public OperationCallable<DeleteRouteRequest, Empty, OperationMetadata> deleteRouteOperationCallable() {
        return this.deleteRouteOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, DatastreamClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

