/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastream.v1alpha1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datastream.v1alpha1.ConnectionProfile;
import com.google.cloud.datastream.v1alpha1.ConnectionProfileName;
import com.google.cloud.datastream.v1alpha1.CreateConnectionProfileRequest;
import com.google.cloud.datastream.v1alpha1.CreatePrivateConnectionRequest;
import com.google.cloud.datastream.v1alpha1.CreateRouteRequest;
import com.google.cloud.datastream.v1alpha1.CreateStreamRequest;
import com.google.cloud.datastream.v1alpha1.DatastreamSettings;
import com.google.cloud.datastream.v1alpha1.DeleteConnectionProfileRequest;
import com.google.cloud.datastream.v1alpha1.DeletePrivateConnectionRequest;
import com.google.cloud.datastream.v1alpha1.DeleteRouteRequest;
import com.google.cloud.datastream.v1alpha1.DeleteStreamRequest;
import com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest;
import com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileResponse;
import com.google.cloud.datastream.v1alpha1.FetchErrorsRequest;
import com.google.cloud.datastream.v1alpha1.FetchErrorsResponse;
import com.google.cloud.datastream.v1alpha1.FetchStaticIpsRequest;
import com.google.cloud.datastream.v1alpha1.FetchStaticIpsResponse;
import com.google.cloud.datastream.v1alpha1.GetConnectionProfileRequest;
import com.google.cloud.datastream.v1alpha1.GetPrivateConnectionRequest;
import com.google.cloud.datastream.v1alpha1.GetRouteRequest;
import com.google.cloud.datastream.v1alpha1.GetStreamRequest;
import com.google.cloud.datastream.v1alpha1.ListConnectionProfilesRequest;
import com.google.cloud.datastream.v1alpha1.ListConnectionProfilesResponse;
import com.google.cloud.datastream.v1alpha1.ListPrivateConnectionsRequest;
import com.google.cloud.datastream.v1alpha1.ListPrivateConnectionsResponse;
import com.google.cloud.datastream.v1alpha1.ListRoutesRequest;
import com.google.cloud.datastream.v1alpha1.ListRoutesResponse;
import com.google.cloud.datastream.v1alpha1.ListStreamsRequest;
import com.google.cloud.datastream.v1alpha1.ListStreamsResponse;
import com.google.cloud.datastream.v1alpha1.LocationName;
import com.google.cloud.datastream.v1alpha1.OperationMetadata;
import com.google.cloud.datastream.v1alpha1.PrivateConnection;
import com.google.cloud.datastream.v1alpha1.PrivateConnectionName;
import com.google.cloud.datastream.v1alpha1.Route;
import com.google.cloud.datastream.v1alpha1.RouteName;
import com.google.cloud.datastream.v1alpha1.Stream;
import com.google.cloud.datastream.v1alpha1.StreamName;
import com.google.cloud.datastream.v1alpha1.UpdateConnectionProfileRequest;
import com.google.cloud.datastream.v1alpha1.UpdateStreamRequest;
import com.google.cloud.datastream.v1alpha1.stub.DatastreamStub;
import com.google.cloud.datastream.v1alpha1.stub.DatastreamStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DatastreamClient
implements BackgroundResource {
    private final DatastreamSettings settings;
    private final DatastreamStub stub;
    private final OperationsClient operationsClient;

    public static final DatastreamClient create() throws IOException {
        return DatastreamClient.create(DatastreamSettings.newBuilder().build());
    }

    public static final DatastreamClient create(DatastreamSettings settings) throws IOException {
        return new DatastreamClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DatastreamClient create(DatastreamStub stub) {
        return new DatastreamClient(stub);
    }

    protected DatastreamClient(DatastreamSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DatastreamStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DatastreamClient(DatastreamStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DatastreamSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DatastreamStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListConnectionProfilesPagedResponse listConnectionProfiles(LocationName parent) {
        ListConnectionProfilesRequest request = ListConnectionProfilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConnectionProfiles(request);
    }

    public final ListConnectionProfilesPagedResponse listConnectionProfiles(String parent) {
        ListConnectionProfilesRequest request = ListConnectionProfilesRequest.newBuilder().setParent(parent).build();
        return this.listConnectionProfiles(request);
    }

    public final ListConnectionProfilesPagedResponse listConnectionProfiles(ListConnectionProfilesRequest request) {
        return (ListConnectionProfilesPagedResponse)((Object)this.listConnectionProfilesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConnectionProfilesRequest, ListConnectionProfilesPagedResponse> listConnectionProfilesPagedCallable() {
        return this.stub.listConnectionProfilesPagedCallable();
    }

    public final UnaryCallable<ListConnectionProfilesRequest, ListConnectionProfilesResponse> listConnectionProfilesCallable() {
        return this.stub.listConnectionProfilesCallable();
    }

    public final ConnectionProfile getConnectionProfile(ConnectionProfileName name) {
        GetConnectionProfileRequest request = GetConnectionProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConnectionProfile(request);
    }

    public final ConnectionProfile getConnectionProfile(String name) {
        GetConnectionProfileRequest request = GetConnectionProfileRequest.newBuilder().setName(name).build();
        return this.getConnectionProfile(request);
    }

    public final ConnectionProfile getConnectionProfile(GetConnectionProfileRequest request) {
        return (ConnectionProfile)this.getConnectionProfileCallable().call((Object)request);
    }

    public final UnaryCallable<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileCallable() {
        return this.stub.getConnectionProfileCallable();
    }

    public final OperationFuture<ConnectionProfile, OperationMetadata> createConnectionProfileAsync(LocationName parent, ConnectionProfile connectionProfile, String connectionProfileId) {
        CreateConnectionProfileRequest request = CreateConnectionProfileRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConnectionProfile(connectionProfile).setConnectionProfileId(connectionProfileId).build();
        return this.createConnectionProfileAsync(request);
    }

    public final OperationFuture<ConnectionProfile, OperationMetadata> createConnectionProfileAsync(String parent, ConnectionProfile connectionProfile, String connectionProfileId) {
        CreateConnectionProfileRequest request = CreateConnectionProfileRequest.newBuilder().setParent(parent).setConnectionProfile(connectionProfile).setConnectionProfileId(connectionProfileId).build();
        return this.createConnectionProfileAsync(request);
    }

    public final OperationFuture<ConnectionProfile, OperationMetadata> createConnectionProfileAsync(CreateConnectionProfileRequest request) {
        return this.createConnectionProfileOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateConnectionProfileRequest, ConnectionProfile, OperationMetadata> createConnectionProfileOperationCallable() {
        return this.stub.createConnectionProfileOperationCallable();
    }

    public final UnaryCallable<CreateConnectionProfileRequest, Operation> createConnectionProfileCallable() {
        return this.stub.createConnectionProfileCallable();
    }

    public final OperationFuture<ConnectionProfile, OperationMetadata> updateConnectionProfileAsync(ConnectionProfile connectionProfile, FieldMask updateMask) {
        UpdateConnectionProfileRequest request = UpdateConnectionProfileRequest.newBuilder().setConnectionProfile(connectionProfile).setUpdateMask(updateMask).build();
        return this.updateConnectionProfileAsync(request);
    }

    public final OperationFuture<ConnectionProfile, OperationMetadata> updateConnectionProfileAsync(UpdateConnectionProfileRequest request) {
        return this.updateConnectionProfileOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateConnectionProfileRequest, ConnectionProfile, OperationMetadata> updateConnectionProfileOperationCallable() {
        return this.stub.updateConnectionProfileOperationCallable();
    }

    public final UnaryCallable<UpdateConnectionProfileRequest, Operation> updateConnectionProfileCallable() {
        return this.stub.updateConnectionProfileCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectionProfileAsync(ConnectionProfileName name) {
        DeleteConnectionProfileRequest request = DeleteConnectionProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteConnectionProfileAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectionProfileAsync(String name) {
        DeleteConnectionProfileRequest request = DeleteConnectionProfileRequest.newBuilder().setName(name).build();
        return this.deleteConnectionProfileAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectionProfileAsync(DeleteConnectionProfileRequest request) {
        return this.deleteConnectionProfileOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteConnectionProfileRequest, Empty, OperationMetadata> deleteConnectionProfileOperationCallable() {
        return this.stub.deleteConnectionProfileOperationCallable();
    }

    public final UnaryCallable<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileCallable() {
        return this.stub.deleteConnectionProfileCallable();
    }

    public final DiscoverConnectionProfileResponse discoverConnectionProfile(DiscoverConnectionProfileRequest request) {
        return (DiscoverConnectionProfileResponse)this.discoverConnectionProfileCallable().call((Object)request);
    }

    public final UnaryCallable<DiscoverConnectionProfileRequest, DiscoverConnectionProfileResponse> discoverConnectionProfileCallable() {
        return this.stub.discoverConnectionProfileCallable();
    }

    public final ListStreamsPagedResponse listStreams(LocationName parent) {
        ListStreamsRequest request = ListStreamsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listStreams(request);
    }

    public final ListStreamsPagedResponse listStreams(String parent) {
        ListStreamsRequest request = ListStreamsRequest.newBuilder().setParent(parent).build();
        return this.listStreams(request);
    }

    public final ListStreamsPagedResponse listStreams(ListStreamsRequest request) {
        return (ListStreamsPagedResponse)((Object)this.listStreamsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListStreamsRequest, ListStreamsPagedResponse> listStreamsPagedCallable() {
        return this.stub.listStreamsPagedCallable();
    }

    public final UnaryCallable<ListStreamsRequest, ListStreamsResponse> listStreamsCallable() {
        return this.stub.listStreamsCallable();
    }

    public final Stream getStream(StreamName name) {
        GetStreamRequest request = GetStreamRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getStream(request);
    }

    public final Stream getStream(String name) {
        GetStreamRequest request = GetStreamRequest.newBuilder().setName(name).build();
        return this.getStream(request);
    }

    public final Stream getStream(GetStreamRequest request) {
        return (Stream)this.getStreamCallable().call((Object)request);
    }

    public final UnaryCallable<GetStreamRequest, Stream> getStreamCallable() {
        return this.stub.getStreamCallable();
    }

    public final OperationFuture<Stream, OperationMetadata> createStreamAsync(LocationName parent, Stream stream, String streamId) {
        CreateStreamRequest request = CreateStreamRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setStream(stream).setStreamId(streamId).build();
        return this.createStreamAsync(request);
    }

    public final OperationFuture<Stream, OperationMetadata> createStreamAsync(String parent, Stream stream, String streamId) {
        CreateStreamRequest request = CreateStreamRequest.newBuilder().setParent(parent).setStream(stream).setStreamId(streamId).build();
        return this.createStreamAsync(request);
    }

    public final OperationFuture<Stream, OperationMetadata> createStreamAsync(CreateStreamRequest request) {
        return this.createStreamOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateStreamRequest, Stream, OperationMetadata> createStreamOperationCallable() {
        return this.stub.createStreamOperationCallable();
    }

    public final UnaryCallable<CreateStreamRequest, Operation> createStreamCallable() {
        return this.stub.createStreamCallable();
    }

    public final OperationFuture<Stream, OperationMetadata> updateStreamAsync(Stream stream, FieldMask updateMask) {
        UpdateStreamRequest request = UpdateStreamRequest.newBuilder().setStream(stream).setUpdateMask(updateMask).build();
        return this.updateStreamAsync(request);
    }

    public final OperationFuture<Stream, OperationMetadata> updateStreamAsync(UpdateStreamRequest request) {
        return this.updateStreamOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateStreamRequest, Stream, OperationMetadata> updateStreamOperationCallable() {
        return this.stub.updateStreamOperationCallable();
    }

    public final UnaryCallable<UpdateStreamRequest, Operation> updateStreamCallable() {
        return this.stub.updateStreamCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteStreamAsync(StreamName name) {
        DeleteStreamRequest request = DeleteStreamRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteStreamAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteStreamAsync(String name) {
        DeleteStreamRequest request = DeleteStreamRequest.newBuilder().setName(name).build();
        return this.deleteStreamAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteStreamAsync(DeleteStreamRequest request) {
        return this.deleteStreamOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteStreamRequest, Empty, OperationMetadata> deleteStreamOperationCallable() {
        return this.stub.deleteStreamOperationCallable();
    }

    public final UnaryCallable<DeleteStreamRequest, Operation> deleteStreamCallable() {
        return this.stub.deleteStreamCallable();
    }

    public final OperationFuture<FetchErrorsResponse, OperationMetadata> fetchErrorsAsync(FetchErrorsRequest request) {
        return this.fetchErrorsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<FetchErrorsRequest, FetchErrorsResponse, OperationMetadata> fetchErrorsOperationCallable() {
        return this.stub.fetchErrorsOperationCallable();
    }

    public final UnaryCallable<FetchErrorsRequest, Operation> fetchErrorsCallable() {
        return this.stub.fetchErrorsCallable();
    }

    public final FetchStaticIpsPagedResponse fetchStaticIps(LocationName name) {
        FetchStaticIpsRequest request = FetchStaticIpsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.fetchStaticIps(request);
    }

    public final FetchStaticIpsPagedResponse fetchStaticIps(String name) {
        FetchStaticIpsRequest request = FetchStaticIpsRequest.newBuilder().setName(name).build();
        return this.fetchStaticIps(request);
    }

    public final FetchStaticIpsPagedResponse fetchStaticIps(FetchStaticIpsRequest request) {
        return (FetchStaticIpsPagedResponse)((Object)this.fetchStaticIpsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<FetchStaticIpsRequest, FetchStaticIpsPagedResponse> fetchStaticIpsPagedCallable() {
        return this.stub.fetchStaticIpsPagedCallable();
    }

    public final UnaryCallable<FetchStaticIpsRequest, FetchStaticIpsResponse> fetchStaticIpsCallable() {
        return this.stub.fetchStaticIpsCallable();
    }

    public final OperationFuture<PrivateConnection, OperationMetadata> createPrivateConnectionAsync(LocationName parent, PrivateConnection privateConnection, String privateConnectionId) {
        CreatePrivateConnectionRequest request = CreatePrivateConnectionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPrivateConnection(privateConnection).setPrivateConnectionId(privateConnectionId).build();
        return this.createPrivateConnectionAsync(request);
    }

    public final OperationFuture<PrivateConnection, OperationMetadata> createPrivateConnectionAsync(String parent, PrivateConnection privateConnection, String privateConnectionId) {
        CreatePrivateConnectionRequest request = CreatePrivateConnectionRequest.newBuilder().setParent(parent).setPrivateConnection(privateConnection).setPrivateConnectionId(privateConnectionId).build();
        return this.createPrivateConnectionAsync(request);
    }

    public final OperationFuture<PrivateConnection, OperationMetadata> createPrivateConnectionAsync(CreatePrivateConnectionRequest request) {
        return this.createPrivateConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePrivateConnectionRequest, PrivateConnection, OperationMetadata> createPrivateConnectionOperationCallable() {
        return this.stub.createPrivateConnectionOperationCallable();
    }

    public final UnaryCallable<CreatePrivateConnectionRequest, Operation> createPrivateConnectionCallable() {
        return this.stub.createPrivateConnectionCallable();
    }

    public final PrivateConnection getPrivateConnection(PrivateConnectionName name) {
        GetPrivateConnectionRequest request = GetPrivateConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPrivateConnection(request);
    }

    public final PrivateConnection getPrivateConnection(String name) {
        GetPrivateConnectionRequest request = GetPrivateConnectionRequest.newBuilder().setName(name).build();
        return this.getPrivateConnection(request);
    }

    public final PrivateConnection getPrivateConnection(GetPrivateConnectionRequest request) {
        return (PrivateConnection)this.getPrivateConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<GetPrivateConnectionRequest, PrivateConnection> getPrivateConnectionCallable() {
        return this.stub.getPrivateConnectionCallable();
    }

    public final ListPrivateConnectionsPagedResponse listPrivateConnections(LocationName parent) {
        ListPrivateConnectionsRequest request = ListPrivateConnectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPrivateConnections(request);
    }

    public final ListPrivateConnectionsPagedResponse listPrivateConnections(String parent) {
        ListPrivateConnectionsRequest request = ListPrivateConnectionsRequest.newBuilder().setParent(parent).build();
        return this.listPrivateConnections(request);
    }

    public final ListPrivateConnectionsPagedResponse listPrivateConnections(ListPrivateConnectionsRequest request) {
        return (ListPrivateConnectionsPagedResponse)((Object)this.listPrivateConnectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPrivateConnectionsRequest, ListPrivateConnectionsPagedResponse> listPrivateConnectionsPagedCallable() {
        return this.stub.listPrivateConnectionsPagedCallable();
    }

    public final UnaryCallable<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse> listPrivateConnectionsCallable() {
        return this.stub.listPrivateConnectionsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deletePrivateConnectionAsync(PrivateConnectionName name) {
        DeletePrivateConnectionRequest request = DeletePrivateConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePrivateConnectionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePrivateConnectionAsync(String name) {
        DeletePrivateConnectionRequest request = DeletePrivateConnectionRequest.newBuilder().setName(name).build();
        return this.deletePrivateConnectionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePrivateConnectionAsync(DeletePrivateConnectionRequest request) {
        return this.deletePrivateConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePrivateConnectionRequest, Empty, OperationMetadata> deletePrivateConnectionOperationCallable() {
        return this.stub.deletePrivateConnectionOperationCallable();
    }

    public final UnaryCallable<DeletePrivateConnectionRequest, Operation> deletePrivateConnectionCallable() {
        return this.stub.deletePrivateConnectionCallable();
    }

    public final OperationFuture<Route, OperationMetadata> createRouteAsync(PrivateConnectionName parent, Route route, String routeId) {
        CreateRouteRequest request = CreateRouteRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRoute(route).setRouteId(routeId).build();
        return this.createRouteAsync(request);
    }

    public final OperationFuture<Route, OperationMetadata> createRouteAsync(String parent, Route route, String routeId) {
        CreateRouteRequest request = CreateRouteRequest.newBuilder().setParent(parent).setRoute(route).setRouteId(routeId).build();
        return this.createRouteAsync(request);
    }

    public final OperationFuture<Route, OperationMetadata> createRouteAsync(CreateRouteRequest request) {
        return this.createRouteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateRouteRequest, Route, OperationMetadata> createRouteOperationCallable() {
        return this.stub.createRouteOperationCallable();
    }

    public final UnaryCallable<CreateRouteRequest, Operation> createRouteCallable() {
        return this.stub.createRouteCallable();
    }

    public final Route getRoute(RouteName name) {
        GetRouteRequest request = GetRouteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRoute(request);
    }

    public final Route getRoute(String name) {
        GetRouteRequest request = GetRouteRequest.newBuilder().setName(name).build();
        return this.getRoute(request);
    }

    public final Route getRoute(GetRouteRequest request) {
        return (Route)this.getRouteCallable().call((Object)request);
    }

    public final UnaryCallable<GetRouteRequest, Route> getRouteCallable() {
        return this.stub.getRouteCallable();
    }

    public final ListRoutesPagedResponse listRoutes(PrivateConnectionName parent) {
        ListRoutesRequest request = ListRoutesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRoutes(request);
    }

    public final ListRoutesPagedResponse listRoutes(String parent) {
        ListRoutesRequest request = ListRoutesRequest.newBuilder().setParent(parent).build();
        return this.listRoutes(request);
    }

    public final ListRoutesPagedResponse listRoutes(ListRoutesRequest request) {
        return (ListRoutesPagedResponse)((Object)this.listRoutesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRoutesRequest, ListRoutesPagedResponse> listRoutesPagedCallable() {
        return this.stub.listRoutesPagedCallable();
    }

    public final UnaryCallable<ListRoutesRequest, ListRoutesResponse> listRoutesCallable() {
        return this.stub.listRoutesCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRouteAsync(RouteName name) {
        DeleteRouteRequest request = DeleteRouteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRouteAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRouteAsync(String name) {
        DeleteRouteRequest request = DeleteRouteRequest.newBuilder().setName(name).build();
        return this.deleteRouteAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRouteAsync(DeleteRouteRequest request) {
        return this.deleteRouteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRouteRequest, Empty, OperationMetadata> deleteRouteOperationCallable() {
        return this.stub.deleteRouteOperationCallable();
    }

    public final UnaryCallable<DeleteRouteRequest, Operation> deleteRouteCallable() {
        return this.stub.deleteRouteCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRoutesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRoutesRequest, ListRoutesResponse, Route, ListRoutesPage, ListRoutesFixedSizeCollection> {
        private ListRoutesFixedSizeCollection(List<ListRoutesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRoutesFixedSizeCollection createEmptyCollection() {
            return new ListRoutesFixedSizeCollection(null, 0);
        }

        protected ListRoutesFixedSizeCollection createCollection(List<ListRoutesPage> pages, int collectionSize) {
            return new ListRoutesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRoutesPage
    extends AbstractPage<ListRoutesRequest, ListRoutesResponse, Route, ListRoutesPage> {
        private ListRoutesPage(PageContext<ListRoutesRequest, ListRoutesResponse, Route> context, ListRoutesResponse response) {
            super(context, (Object)response);
        }

        private static ListRoutesPage createEmptyPage() {
            return new ListRoutesPage(null, null);
        }

        protected ListRoutesPage createPage(PageContext<ListRoutesRequest, ListRoutesResponse, Route> context, ListRoutesResponse response) {
            return new ListRoutesPage(context, response);
        }

        public ApiFuture<ListRoutesPage> createPageAsync(PageContext<ListRoutesRequest, ListRoutesResponse, Route> context, ApiFuture<ListRoutesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRoutesPagedResponse
    extends AbstractPagedListResponse<ListRoutesRequest, ListRoutesResponse, Route, ListRoutesPage, ListRoutesFixedSizeCollection> {
        public static ApiFuture<ListRoutesPagedResponse> createAsync(PageContext<ListRoutesRequest, ListRoutesResponse, Route> context, ApiFuture<ListRoutesResponse> futureResponse) {
            ApiFuture<ListRoutesPage> futurePage = ListRoutesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRoutesPagedResponse((ListRoutesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRoutesPagedResponse(ListRoutesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRoutesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPrivateConnectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection, ListPrivateConnectionsPage, ListPrivateConnectionsFixedSizeCollection> {
        private ListPrivateConnectionsFixedSizeCollection(List<ListPrivateConnectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPrivateConnectionsFixedSizeCollection createEmptyCollection() {
            return new ListPrivateConnectionsFixedSizeCollection(null, 0);
        }

        protected ListPrivateConnectionsFixedSizeCollection createCollection(List<ListPrivateConnectionsPage> pages, int collectionSize) {
            return new ListPrivateConnectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPrivateConnectionsPage
    extends AbstractPage<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection, ListPrivateConnectionsPage> {
        private ListPrivateConnectionsPage(PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> context, ListPrivateConnectionsResponse response) {
            super(context, (Object)response);
        }

        private static ListPrivateConnectionsPage createEmptyPage() {
            return new ListPrivateConnectionsPage(null, null);
        }

        protected ListPrivateConnectionsPage createPage(PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> context, ListPrivateConnectionsResponse response) {
            return new ListPrivateConnectionsPage(context, response);
        }

        public ApiFuture<ListPrivateConnectionsPage> createPageAsync(PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> context, ApiFuture<ListPrivateConnectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPrivateConnectionsPagedResponse
    extends AbstractPagedListResponse<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection, ListPrivateConnectionsPage, ListPrivateConnectionsFixedSizeCollection> {
        public static ApiFuture<ListPrivateConnectionsPagedResponse> createAsync(PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> context, ApiFuture<ListPrivateConnectionsResponse> futureResponse) {
            ApiFuture<ListPrivateConnectionsPage> futurePage = ListPrivateConnectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPrivateConnectionsPagedResponse((ListPrivateConnectionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPrivateConnectionsPagedResponse(ListPrivateConnectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPrivateConnectionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class FetchStaticIpsFixedSizeCollection
    extends AbstractFixedSizeCollection<FetchStaticIpsRequest, FetchStaticIpsResponse, String, FetchStaticIpsPage, FetchStaticIpsFixedSizeCollection> {
        private FetchStaticIpsFixedSizeCollection(List<FetchStaticIpsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static FetchStaticIpsFixedSizeCollection createEmptyCollection() {
            return new FetchStaticIpsFixedSizeCollection(null, 0);
        }

        protected FetchStaticIpsFixedSizeCollection createCollection(List<FetchStaticIpsPage> pages, int collectionSize) {
            return new FetchStaticIpsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class FetchStaticIpsPage
    extends AbstractPage<FetchStaticIpsRequest, FetchStaticIpsResponse, String, FetchStaticIpsPage> {
        private FetchStaticIpsPage(PageContext<FetchStaticIpsRequest, FetchStaticIpsResponse, String> context, FetchStaticIpsResponse response) {
            super(context, (Object)response);
        }

        private static FetchStaticIpsPage createEmptyPage() {
            return new FetchStaticIpsPage(null, null);
        }

        protected FetchStaticIpsPage createPage(PageContext<FetchStaticIpsRequest, FetchStaticIpsResponse, String> context, FetchStaticIpsResponse response) {
            return new FetchStaticIpsPage(context, response);
        }

        public ApiFuture<FetchStaticIpsPage> createPageAsync(PageContext<FetchStaticIpsRequest, FetchStaticIpsResponse, String> context, ApiFuture<FetchStaticIpsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class FetchStaticIpsPagedResponse
    extends AbstractPagedListResponse<FetchStaticIpsRequest, FetchStaticIpsResponse, String, FetchStaticIpsPage, FetchStaticIpsFixedSizeCollection> {
        public static ApiFuture<FetchStaticIpsPagedResponse> createAsync(PageContext<FetchStaticIpsRequest, FetchStaticIpsResponse, String> context, ApiFuture<FetchStaticIpsResponse> futureResponse) {
            ApiFuture<FetchStaticIpsPage> futurePage = FetchStaticIpsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new FetchStaticIpsPagedResponse((FetchStaticIpsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private FetchStaticIpsPagedResponse(FetchStaticIpsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)FetchStaticIpsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListStreamsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListStreamsRequest, ListStreamsResponse, Stream, ListStreamsPage, ListStreamsFixedSizeCollection> {
        private ListStreamsFixedSizeCollection(List<ListStreamsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListStreamsFixedSizeCollection createEmptyCollection() {
            return new ListStreamsFixedSizeCollection(null, 0);
        }

        protected ListStreamsFixedSizeCollection createCollection(List<ListStreamsPage> pages, int collectionSize) {
            return new ListStreamsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListStreamsPage
    extends AbstractPage<ListStreamsRequest, ListStreamsResponse, Stream, ListStreamsPage> {
        private ListStreamsPage(PageContext<ListStreamsRequest, ListStreamsResponse, Stream> context, ListStreamsResponse response) {
            super(context, (Object)response);
        }

        private static ListStreamsPage createEmptyPage() {
            return new ListStreamsPage(null, null);
        }

        protected ListStreamsPage createPage(PageContext<ListStreamsRequest, ListStreamsResponse, Stream> context, ListStreamsResponse response) {
            return new ListStreamsPage(context, response);
        }

        public ApiFuture<ListStreamsPage> createPageAsync(PageContext<ListStreamsRequest, ListStreamsResponse, Stream> context, ApiFuture<ListStreamsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListStreamsPagedResponse
    extends AbstractPagedListResponse<ListStreamsRequest, ListStreamsResponse, Stream, ListStreamsPage, ListStreamsFixedSizeCollection> {
        public static ApiFuture<ListStreamsPagedResponse> createAsync(PageContext<ListStreamsRequest, ListStreamsResponse, Stream> context, ApiFuture<ListStreamsResponse> futureResponse) {
            ApiFuture<ListStreamsPage> futurePage = ListStreamsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListStreamsPagedResponse((ListStreamsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListStreamsPagedResponse(ListStreamsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListStreamsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConnectionProfilesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile, ListConnectionProfilesPage, ListConnectionProfilesFixedSizeCollection> {
        private ListConnectionProfilesFixedSizeCollection(List<ListConnectionProfilesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConnectionProfilesFixedSizeCollection createEmptyCollection() {
            return new ListConnectionProfilesFixedSizeCollection(null, 0);
        }

        protected ListConnectionProfilesFixedSizeCollection createCollection(List<ListConnectionProfilesPage> pages, int collectionSize) {
            return new ListConnectionProfilesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConnectionProfilesPage
    extends AbstractPage<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile, ListConnectionProfilesPage> {
        private ListConnectionProfilesPage(PageContext<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile> context, ListConnectionProfilesResponse response) {
            super(context, (Object)response);
        }

        private static ListConnectionProfilesPage createEmptyPage() {
            return new ListConnectionProfilesPage(null, null);
        }

        protected ListConnectionProfilesPage createPage(PageContext<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile> context, ListConnectionProfilesResponse response) {
            return new ListConnectionProfilesPage(context, response);
        }

        public ApiFuture<ListConnectionProfilesPage> createPageAsync(PageContext<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile> context, ApiFuture<ListConnectionProfilesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConnectionProfilesPagedResponse
    extends AbstractPagedListResponse<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile, ListConnectionProfilesPage, ListConnectionProfilesFixedSizeCollection> {
        public static ApiFuture<ListConnectionProfilesPagedResponse> createAsync(PageContext<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile> context, ApiFuture<ListConnectionProfilesResponse> futureResponse) {
            ApiFuture<ListConnectionProfilesPage> futurePage = ListConnectionProfilesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConnectionProfilesPagedResponse((ListConnectionProfilesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConnectionProfilesPagedResponse(ListConnectionProfilesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConnectionProfilesFixedSizeCollection.createEmptyCollection());
        }
    }
}

