/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.admin.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datastore.admin.v1.DatastoreAdminSettings;
import com.google.cloud.datastore.admin.v1.stub.DatastoreAdminStub;
import com.google.cloud.datastore.admin.v1.stub.DatastoreAdminStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.datastore.admin.v1.CreateIndexRequest;
import com.google.datastore.admin.v1.DeleteIndexRequest;
import com.google.datastore.admin.v1.EntityFilter;
import com.google.datastore.admin.v1.ExportEntitiesMetadata;
import com.google.datastore.admin.v1.ExportEntitiesRequest;
import com.google.datastore.admin.v1.ExportEntitiesResponse;
import com.google.datastore.admin.v1.GetIndexRequest;
import com.google.datastore.admin.v1.ImportEntitiesMetadata;
import com.google.datastore.admin.v1.ImportEntitiesRequest;
import com.google.datastore.admin.v1.Index;
import com.google.datastore.admin.v1.IndexOperationMetadata;
import com.google.datastore.admin.v1.ListIndexesRequest;
import com.google.datastore.admin.v1.ListIndexesResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DatastoreAdminClient
implements BackgroundResource {
    private final DatastoreAdminSettings settings;
    private final DatastoreAdminStub stub;
    private final OperationsClient operationsClient;

    public static final DatastoreAdminClient create() throws IOException {
        return DatastoreAdminClient.create(DatastoreAdminSettings.newBuilder().build());
    }

    public static final DatastoreAdminClient create(DatastoreAdminSettings settings) throws IOException {
        return new DatastoreAdminClient(settings);
    }

    public static final DatastoreAdminClient create(DatastoreAdminStub stub) {
        return new DatastoreAdminClient(stub);
    }

    protected DatastoreAdminClient(DatastoreAdminSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DatastoreAdminStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected DatastoreAdminClient(DatastoreAdminStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DatastoreAdminSettings getSettings() {
        return this.settings;
    }

    public DatastoreAdminStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<ExportEntitiesResponse, ExportEntitiesMetadata> exportEntitiesAsync(String projectId, Map<String, String> labels, EntityFilter entityFilter, String outputUrlPrefix) {
        ExportEntitiesRequest request = ExportEntitiesRequest.newBuilder().setProjectId(projectId).putAllLabels(labels).setEntityFilter(entityFilter).setOutputUrlPrefix(outputUrlPrefix).build();
        return this.exportEntitiesAsync(request);
    }

    public final OperationFuture<ExportEntitiesResponse, ExportEntitiesMetadata> exportEntitiesAsync(ExportEntitiesRequest request) {
        return this.exportEntitiesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportEntitiesRequest, ExportEntitiesResponse, ExportEntitiesMetadata> exportEntitiesOperationCallable() {
        return this.stub.exportEntitiesOperationCallable();
    }

    public final UnaryCallable<ExportEntitiesRequest, Operation> exportEntitiesCallable() {
        return this.stub.exportEntitiesCallable();
    }

    public final OperationFuture<Empty, ImportEntitiesMetadata> importEntitiesAsync(String projectId, Map<String, String> labels, String inputUrl, EntityFilter entityFilter) {
        ImportEntitiesRequest request = ImportEntitiesRequest.newBuilder().setProjectId(projectId).putAllLabels(labels).setInputUrl(inputUrl).setEntityFilter(entityFilter).build();
        return this.importEntitiesAsync(request);
    }

    public final OperationFuture<Empty, ImportEntitiesMetadata> importEntitiesAsync(ImportEntitiesRequest request) {
        return this.importEntitiesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportEntitiesRequest, Empty, ImportEntitiesMetadata> importEntitiesOperationCallable() {
        return this.stub.importEntitiesOperationCallable();
    }

    public final UnaryCallable<ImportEntitiesRequest, Operation> importEntitiesCallable() {
        return this.stub.importEntitiesCallable();
    }

    public final OperationFuture<Index, IndexOperationMetadata> createIndexAsync(CreateIndexRequest request) {
        return this.createIndexOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationCallable() {
        return this.stub.createIndexOperationCallable();
    }

    public final UnaryCallable<CreateIndexRequest, Operation> createIndexCallable() {
        return this.stub.createIndexCallable();
    }

    public final OperationFuture<Index, IndexOperationMetadata> deleteIndexAsync(DeleteIndexRequest request) {
        return this.deleteIndexOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteIndexRequest, Index, IndexOperationMetadata> deleteIndexOperationCallable() {
        return this.stub.deleteIndexOperationCallable();
    }

    public final UnaryCallable<DeleteIndexRequest, Operation> deleteIndexCallable() {
        return this.stub.deleteIndexCallable();
    }

    public final Index getIndex(GetIndexRequest request) {
        return (Index)this.getIndexCallable().call((Object)request);
    }

    public final UnaryCallable<GetIndexRequest, Index> getIndexCallable() {
        return this.stub.getIndexCallable();
    }

    public final ListIndexesPagedResponse listIndexes(ListIndexesRequest request) {
        return (ListIndexesPagedResponse)((Object)this.listIndexesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListIndexesRequest, ListIndexesPagedResponse> listIndexesPagedCallable() {
        return this.stub.listIndexesPagedCallable();
    }

    public final UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable() {
        return this.stub.listIndexesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListIndexesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListIndexesRequest, ListIndexesResponse, Index, ListIndexesPage, ListIndexesFixedSizeCollection> {
        private ListIndexesFixedSizeCollection(List<ListIndexesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListIndexesFixedSizeCollection createEmptyCollection() {
            return new ListIndexesFixedSizeCollection(null, 0);
        }

        protected ListIndexesFixedSizeCollection createCollection(List<ListIndexesPage> pages, int collectionSize) {
            return new ListIndexesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListIndexesPage
    extends AbstractPage<ListIndexesRequest, ListIndexesResponse, Index, ListIndexesPage> {
        private ListIndexesPage(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ListIndexesResponse response) {
            super(context, (Object)response);
        }

        private static ListIndexesPage createEmptyPage() {
            return new ListIndexesPage(null, null);
        }

        protected ListIndexesPage createPage(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ListIndexesResponse response) {
            return new ListIndexesPage(context, response);
        }

        public ApiFuture<ListIndexesPage> createPageAsync(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ApiFuture<ListIndexesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListIndexesPagedResponse
    extends AbstractPagedListResponse<ListIndexesRequest, ListIndexesResponse, Index, ListIndexesPage, ListIndexesFixedSizeCollection> {
        public static ApiFuture<ListIndexesPagedResponse> createAsync(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ApiFuture<ListIndexesResponse> futureResponse) {
            ApiFuture<ListIndexesPage> futurePage = ListIndexesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListIndexesPagedResponse((ListIndexesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListIndexesPagedResponse(ListIndexesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListIndexesFixedSizeCollection.createEmptyCollection());
        }
    }
}

