/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.core.InternalApi;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.ReadOption;
import com.google.cloud.datastore.execution.request.ProtoPreparer;
import com.google.datastore.v1.ReadOptions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@InternalApi
public class ReadOptionProtoPreparer
implements ProtoPreparer<List<ReadOption>, Optional<ReadOptions>> {
    @Override
    public Optional<ReadOptions> prepare(List<ReadOption> options) {
        boolean moreThanOneReadOption;
        if (options == null || options.isEmpty()) {
            return Optional.empty();
        }
        ReadOptions readOptionsPb = null;
        Map<Class<? extends ReadOption>, ReadOption> optionsByType = ReadOption.asImmutableMap(options);
        boolean bl = moreThanOneReadOption = optionsByType.keySet().size() > 1;
        if (moreThanOneReadOption) {
            throw DatastoreException.throwInvalidRequest(String.format("Can not use %s together.", this.getInvalidOptions(optionsByType)), new Object[0]);
        }
        if (optionsByType.containsKey(ReadOption.EventualConsistency.class)) {
            readOptionsPb = ReadOptions.newBuilder().setReadConsistency(ReadOptions.ReadConsistency.EVENTUAL).build();
        }
        if (optionsByType.containsKey(ReadOption.ReadTime.class)) {
            readOptionsPb = ReadOptions.newBuilder().setReadTime(((ReadOption.ReadTime)optionsByType.get(ReadOption.ReadTime.class)).time().toProto()).build();
        }
        if (optionsByType.containsKey(ReadOption.TransactionId.class)) {
            readOptionsPb = ReadOptions.newBuilder().setTransaction(((ReadOption.TransactionId)optionsByType.get(ReadOption.TransactionId.class)).getTransactionId()).build();
        }
        return Optional.ofNullable(readOptionsPb);
    }

    private String getInvalidOptions(Map<Class<? extends ReadOption>, ReadOption> optionsByType) {
        String regex = "([a-z])([A-Z]+)";
        String replacement = "$1 $2";
        return optionsByType.keySet().stream().map(Class::getSimpleName).map(s -> s.replaceAll(regex, replacement).toLowerCase()).collect(Collectors.joining(", "));
    }
}

