/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.CreateSessionRequest;
import com.google.cloud.dataproc.v1.DeleteSessionRequest;
import com.google.cloud.dataproc.v1.GetSessionRequest;
import com.google.cloud.dataproc.v1.ListSessionsRequest;
import com.google.cloud.dataproc.v1.ListSessionsResponse;
import com.google.cloud.dataproc.v1.Session;
import com.google.cloud.dataproc.v1.SessionControllerClient;
import com.google.cloud.dataproc.v1.SessionOperationMetadata;
import com.google.cloud.dataproc.v1.TerminateSessionRequest;
import com.google.cloud.dataproc.v1.stub.GrpcSessionControllerStub;
import com.google.cloud.dataproc.v1.stub.HttpJsonSessionControllerStub;
import com.google.cloud.dataproc.v1.stub.SessionControllerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class SessionControllerStubSettings
extends StubSettings<SessionControllerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateSessionRequest, Operation> createSessionSettings;
    private final OperationCallSettings<CreateSessionRequest, Session, SessionOperationMetadata> createSessionOperationSettings;
    private final UnaryCallSettings<GetSessionRequest, Session> getSessionSettings;
    private final PagedCallSettings<ListSessionsRequest, ListSessionsResponse, SessionControllerClient.ListSessionsPagedResponse> listSessionsSettings;
    private final UnaryCallSettings<TerminateSessionRequest, Operation> terminateSessionSettings;
    private final OperationCallSettings<TerminateSessionRequest, Session, SessionOperationMetadata> terminateSessionOperationSettings;
    private final UnaryCallSettings<DeleteSessionRequest, Operation> deleteSessionSettings;
    private final OperationCallSettings<DeleteSessionRequest, Session, SessionOperationMetadata> deleteSessionOperationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListSessionsRequest, ListSessionsResponse, Session> LIST_SESSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListSessionsRequest, ListSessionsResponse, Session>(){

        public String emptyToken() {
            return "";
        }

        public ListSessionsRequest injectToken(ListSessionsRequest payload, String token) {
            return ListSessionsRequest.newBuilder((ListSessionsRequest)payload).setPageToken(token).build();
        }

        public ListSessionsRequest injectPageSize(ListSessionsRequest payload, int pageSize) {
            return ListSessionsRequest.newBuilder((ListSessionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSessionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSessionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Session> extractResources(ListSessionsResponse payload) {
            return payload.getSessionsList() == null ? ImmutableList.of() : payload.getSessionsList();
        }
    };
    private static final PagedListResponseFactory<ListSessionsRequest, ListSessionsResponse, SessionControllerClient.ListSessionsPagedResponse> LIST_SESSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListSessionsRequest, ListSessionsResponse, SessionControllerClient.ListSessionsPagedResponse>(){

        public ApiFuture<SessionControllerClient.ListSessionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSessionsRequest, ListSessionsResponse> callable, ListSessionsRequest request, ApiCallContext context, ApiFuture<ListSessionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SESSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SessionControllerClient.ListSessionsPagedResponse.createAsync((PageContext<ListSessionsRequest, ListSessionsResponse, Session>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateSessionRequest, Operation> createSessionSettings() {
        return this.createSessionSettings;
    }

    public OperationCallSettings<CreateSessionRequest, Session, SessionOperationMetadata> createSessionOperationSettings() {
        return this.createSessionOperationSettings;
    }

    public UnaryCallSettings<GetSessionRequest, Session> getSessionSettings() {
        return this.getSessionSettings;
    }

    public PagedCallSettings<ListSessionsRequest, ListSessionsResponse, SessionControllerClient.ListSessionsPagedResponse> listSessionsSettings() {
        return this.listSessionsSettings;
    }

    public UnaryCallSettings<TerminateSessionRequest, Operation> terminateSessionSettings() {
        return this.terminateSessionSettings;
    }

    public OperationCallSettings<TerminateSessionRequest, Session, SessionOperationMetadata> terminateSessionOperationSettings() {
        return this.terminateSessionOperationSettings;
    }

    public UnaryCallSettings<DeleteSessionRequest, Operation> deleteSessionSettings() {
        return this.deleteSessionSettings;
    }

    public OperationCallSettings<DeleteSessionRequest, Session, SessionOperationMetadata> deleteSessionOperationSettings() {
        return this.deleteSessionOperationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public SessionControllerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSessionControllerStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSessionControllerStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return SessionControllerStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "dataproc";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dataproc.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dataproc.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SessionControllerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SessionControllerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SessionControllerStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SessionControllerStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SessionControllerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSessionSettings = settingsBuilder.createSessionSettings().build();
        this.createSessionOperationSettings = settingsBuilder.createSessionOperationSettings().build();
        this.getSessionSettings = settingsBuilder.getSessionSettings().build();
        this.listSessionsSettings = settingsBuilder.listSessionsSettings().build();
        this.terminateSessionSettings = settingsBuilder.terminateSessionSettings().build();
        this.terminateSessionOperationSettings = settingsBuilder.terminateSessionOperationSettings().build();
        this.deleteSessionSettings = settingsBuilder.deleteSessionSettings().build();
        this.deleteSessionOperationSettings = settingsBuilder.deleteSessionOperationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SessionControllerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSessionRequest, Operation> createSessionSettings;
        private final OperationCallSettings.Builder<CreateSessionRequest, Session, SessionOperationMetadata> createSessionOperationSettings;
        private final UnaryCallSettings.Builder<GetSessionRequest, Session> getSessionSettings;
        private final PagedCallSettings.Builder<ListSessionsRequest, ListSessionsResponse, SessionControllerClient.ListSessionsPagedResponse> listSessionsSettings;
        private final UnaryCallSettings.Builder<TerminateSessionRequest, Operation> terminateSessionSettings;
        private final OperationCallSettings.Builder<TerminateSessionRequest, Session, SessionOperationMetadata> terminateSessionOperationSettings;
        private final UnaryCallSettings.Builder<DeleteSessionRequest, Operation> deleteSessionSettings;
        private final OperationCallSettings.Builder<DeleteSessionRequest, Session, SessionOperationMetadata> deleteSessionOperationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSessionOperationSettings = OperationCallSettings.newBuilder();
            this.getSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSessionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SESSIONS_PAGE_STR_FACT);
            this.terminateSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.terminateSessionOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSessionOperationSettings = OperationCallSettings.newBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSessionSettings, this.getSessionSettings, this.listSessionsSettings, this.terminateSessionSettings, this.deleteSessionSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SessionControllerStubSettings settings) {
            super((StubSettings)settings);
            this.createSessionSettings = settings.createSessionSettings.toBuilder();
            this.createSessionOperationSettings = settings.createSessionOperationSettings.toBuilder();
            this.getSessionSettings = settings.getSessionSettings.toBuilder();
            this.listSessionsSettings = settings.listSessionsSettings.toBuilder();
            this.terminateSessionSettings = settings.terminateSessionSettings.toBuilder();
            this.terminateSessionOperationSettings = settings.terminateSessionOperationSettings.toBuilder();
            this.deleteSessionSettings = settings.deleteSessionSettings.toBuilder();
            this.deleteSessionOperationSettings = settings.deleteSessionOperationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSessionSettings, this.getSessionSettings, this.listSessionsSettings, this.terminateSessionSettings, this.deleteSessionSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SessionControllerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SessionControllerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SessionControllerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SessionControllerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SessionControllerStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SessionControllerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SessionControllerStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SessionControllerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listSessionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.terminateSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createSessionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Session.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(SessionOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.terminateSessionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Session.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(SessionOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteSessionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Session.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(SessionOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSessionRequest, Operation> createSessionSettings() {
            return this.createSessionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateSessionRequest, Session, SessionOperationMetadata> createSessionOperationSettings() {
            return this.createSessionOperationSettings;
        }

        public UnaryCallSettings.Builder<GetSessionRequest, Session> getSessionSettings() {
            return this.getSessionSettings;
        }

        public PagedCallSettings.Builder<ListSessionsRequest, ListSessionsResponse, SessionControllerClient.ListSessionsPagedResponse> listSessionsSettings() {
            return this.listSessionsSettings;
        }

        public UnaryCallSettings.Builder<TerminateSessionRequest, Operation> terminateSessionSettings() {
            return this.terminateSessionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<TerminateSessionRequest, Session, SessionOperationMetadata> terminateSessionOperationSettings() {
            return this.terminateSessionOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteSessionRequest, Operation> deleteSessionSettings() {
            return this.deleteSessionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteSessionRequest, Session, SessionOperationMetadata> deleteSessionOperationSettings() {
            return this.deleteSessionOperationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return SessionControllerStubSettings.getDefaultEndpoint();
        }

        public SessionControllerStubSettings build() throws IOException {
            return new SessionControllerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

