/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.CreateSessionTemplateRequest;
import com.google.cloud.dataproc.v1.DeleteSessionTemplateRequest;
import com.google.cloud.dataproc.v1.GetSessionTemplateRequest;
import com.google.cloud.dataproc.v1.ListSessionTemplatesRequest;
import com.google.cloud.dataproc.v1.ListSessionTemplatesResponse;
import com.google.cloud.dataproc.v1.SessionTemplate;
import com.google.cloud.dataproc.v1.SessionTemplateControllerClient;
import com.google.cloud.dataproc.v1.UpdateSessionTemplateRequest;
import com.google.cloud.dataproc.v1.stub.HttpJsonSessionTemplateControllerCallableFactory;
import com.google.cloud.dataproc.v1.stub.SessionTemplateControllerStub;
import com.google.cloud.dataproc.v1.stub.SessionTemplateControllerStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonSessionTemplateControllerStub
extends SessionTemplateControllerStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateSessionTemplateRequest, SessionTemplate> createSessionTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.SessionTemplateController/CreateSessionTemplate").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/sessionTemplates", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("sessionTemplate", (Message)request.getSessionTemplate(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SessionTemplate.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateSessionTemplateRequest, SessionTemplate> updateSessionTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.SessionTemplateController/UpdateSessionTemplate").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{sessionTemplate.name=projects/*/locations/*/sessionTemplates/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "sessionTemplate.name", (Object)request.getSessionTemplate().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("sessionTemplate", (Message)request.getSessionTemplate(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SessionTemplate.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetSessionTemplateRequest, SessionTemplate> getSessionTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.SessionTemplateController/GetSessionTemplate").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/sessionTemplates/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SessionTemplate.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListSessionTemplatesRequest, ListSessionTemplatesResponse> listSessionTemplatesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.SessionTemplateController/ListSessionTemplates").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/sessionTemplates", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListSessionTemplatesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteSessionTemplateRequest, Empty> deleteSessionTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.SessionTemplateController/DeleteSessionTemplate").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/sessionTemplates/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/regions/*/clusters/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/regions/*/jobs/*}:setIamPolicy", "/v1/{resource=projects/*/regions/*/operations/*}:setIamPolicy", "/v1/{resource=projects/*/regions/*/workflowTemplates/*}:setIamPolicy", "/v1/{resource=projects/*/locations/*/workflowTemplates/*}:setIamPolicy", "/v1/{resource=projects/*/regions/*/autoscalingPolicies/*}:setIamPolicy", "/v1/{resource=projects/*/locations/*/autoscalingPolicies/*}:setIamPolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/regions/*/clusters/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/regions/*/jobs/*}:getIamPolicy", "/v1/{resource=projects/*/regions/*/operations/*}:getIamPolicy", "/v1/{resource=projects/*/regions/*/workflowTemplates/*}:getIamPolicy", "/v1/{resource=projects/*/locations/*/workflowTemplates/*}:getIamPolicy", "/v1/{resource=projects/*/regions/*/autoscalingPolicies/*}:getIamPolicy", "/v1/{resource=projects/*/locations/*/autoscalingPolicies/*}:getIamPolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/regions/*/clusters/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/regions/*/jobs/*}:testIamPermissions", "/v1/{resource=projects/*/regions/*/operations/*}:testIamPermissions", "/v1/{resource=projects/*/regions/*/workflowTemplates/*}:testIamPermissions", "/v1/{resource=projects/*/locations/*/workflowTemplates/*}:testIamPermissions", "/v1/{resource=projects/*/regions/*/autoscalingPolicies/*}:testIamPermissions", "/v1/{resource=projects/*/locations/*/autoscalingPolicies/*}:testIamPermissions"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateSessionTemplateRequest, SessionTemplate> createSessionTemplateCallable;
    private final UnaryCallable<UpdateSessionTemplateRequest, SessionTemplate> updateSessionTemplateCallable;
    private final UnaryCallable<GetSessionTemplateRequest, SessionTemplate> getSessionTemplateCallable;
    private final UnaryCallable<ListSessionTemplatesRequest, ListSessionTemplatesResponse> listSessionTemplatesCallable;
    private final UnaryCallable<ListSessionTemplatesRequest, SessionTemplateControllerClient.ListSessionTemplatesPagedResponse> listSessionTemplatesPagedCallable;
    private final UnaryCallable<DeleteSessionTemplateRequest, Empty> deleteSessionTemplateCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonSessionTemplateControllerStub create(SessionTemplateControllerStubSettings settings) throws IOException {
        return new HttpJsonSessionTemplateControllerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonSessionTemplateControllerStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonSessionTemplateControllerStub(SessionTemplateControllerStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonSessionTemplateControllerStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonSessionTemplateControllerStub(SessionTemplateControllerStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonSessionTemplateControllerStub(SessionTemplateControllerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonSessionTemplateControllerCallableFactory());
    }

    protected HttpJsonSessionTemplateControllerStub(SessionTemplateControllerStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createSessionTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createSessionTemplateMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateSessionTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateSessionTemplateMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("session_template.name", String.valueOf(request.getSessionTemplate().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getSessionTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSessionTemplateMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listSessionTemplatesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listSessionTemplatesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteSessionTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteSessionTemplateMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createSessionTemplateCallable = callableFactory.createUnaryCallable(createSessionTemplateTransportSettings, settings.createSessionTemplateSettings(), clientContext);
        this.updateSessionTemplateCallable = callableFactory.createUnaryCallable(updateSessionTemplateTransportSettings, settings.updateSessionTemplateSettings(), clientContext);
        this.getSessionTemplateCallable = callableFactory.createUnaryCallable(getSessionTemplateTransportSettings, settings.getSessionTemplateSettings(), clientContext);
        this.listSessionTemplatesCallable = callableFactory.createUnaryCallable(listSessionTemplatesTransportSettings, settings.listSessionTemplatesSettings(), clientContext);
        this.listSessionTemplatesPagedCallable = callableFactory.createPagedCallable(listSessionTemplatesTransportSettings, settings.listSessionTemplatesSettings(), clientContext);
        this.deleteSessionTemplateCallable = callableFactory.createUnaryCallable(deleteSessionTemplateTransportSettings, settings.deleteSessionTemplateSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createSessionTemplateMethodDescriptor);
        methodDescriptors.add(updateSessionTemplateMethodDescriptor);
        methodDescriptors.add(getSessionTemplateMethodDescriptor);
        methodDescriptors.add(listSessionTemplatesMethodDescriptor);
        methodDescriptors.add(deleteSessionTemplateMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateSessionTemplateRequest, SessionTemplate> createSessionTemplateCallable() {
        return this.createSessionTemplateCallable;
    }

    @Override
    public UnaryCallable<UpdateSessionTemplateRequest, SessionTemplate> updateSessionTemplateCallable() {
        return this.updateSessionTemplateCallable;
    }

    @Override
    public UnaryCallable<GetSessionTemplateRequest, SessionTemplate> getSessionTemplateCallable() {
        return this.getSessionTemplateCallable;
    }

    @Override
    public UnaryCallable<ListSessionTemplatesRequest, ListSessionTemplatesResponse> listSessionTemplatesCallable() {
        return this.listSessionTemplatesCallable;
    }

    @Override
    public UnaryCallable<ListSessionTemplatesRequest, SessionTemplateControllerClient.ListSessionTemplatesPagedResponse> listSessionTemplatesPagedCallable() {
        return this.listSessionTemplatesPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteSessionTemplateRequest, Empty> deleteSessionTemplateCallable() {
        return this.deleteSessionTemplateCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

