/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.Batch;
import com.google.cloud.dataproc.v1.BatchControllerClient;
import com.google.cloud.dataproc.v1.BatchOperationMetadata;
import com.google.cloud.dataproc.v1.CreateBatchRequest;
import com.google.cloud.dataproc.v1.DeleteBatchRequest;
import com.google.cloud.dataproc.v1.GetBatchRequest;
import com.google.cloud.dataproc.v1.ListBatchesRequest;
import com.google.cloud.dataproc.v1.ListBatchesResponse;
import com.google.cloud.dataproc.v1.stub.BatchControllerStub;
import com.google.cloud.dataproc.v1.stub.BatchControllerStubSettings;
import com.google.cloud.dataproc.v1.stub.GrpcBatchControllerCallableFactory;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcBatchControllerStub
extends BatchControllerStub {
    private static final MethodDescriptor<CreateBatchRequest, Operation> createBatchMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.BatchController/CreateBatch").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateBatchRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetBatchRequest, Batch> getBatchMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.BatchController/GetBatch").setRequestMarshaller(ProtoUtils.marshaller((Message)GetBatchRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Batch.getDefaultInstance())).build();
    private static final MethodDescriptor<ListBatchesRequest, ListBatchesResponse> listBatchesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.BatchController/ListBatches").setRequestMarshaller(ProtoUtils.marshaller((Message)ListBatchesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListBatchesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteBatchRequest, Empty> deleteBatchMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.BatchController/DeleteBatch").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteBatchRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateBatchRequest, Operation> createBatchCallable;
    private final OperationCallable<CreateBatchRequest, Batch, BatchOperationMetadata> createBatchOperationCallable;
    private final UnaryCallable<GetBatchRequest, Batch> getBatchCallable;
    private final UnaryCallable<ListBatchesRequest, ListBatchesResponse> listBatchesCallable;
    private final UnaryCallable<ListBatchesRequest, BatchControllerClient.ListBatchesPagedResponse> listBatchesPagedCallable;
    private final UnaryCallable<DeleteBatchRequest, Empty> deleteBatchCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBatchControllerStub create(BatchControllerStubSettings settings) throws IOException {
        return new GrpcBatchControllerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBatchControllerStub create(ClientContext clientContext) throws IOException {
        return new GrpcBatchControllerStub(BatchControllerStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBatchControllerStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBatchControllerStub(BatchControllerStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBatchControllerStub(BatchControllerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBatchControllerCallableFactory());
    }

    protected GrpcBatchControllerStub(BatchControllerStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createBatchTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createBatchMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getBatchTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getBatchMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listBatchesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listBatchesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteBatchTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteBatchMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createBatchCallable = callableFactory.createUnaryCallable(createBatchTransportSettings, settings.createBatchSettings(), clientContext);
        this.createBatchOperationCallable = callableFactory.createOperationCallable(createBatchTransportSettings, settings.createBatchOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getBatchCallable = callableFactory.createUnaryCallable(getBatchTransportSettings, settings.getBatchSettings(), clientContext);
        this.listBatchesCallable = callableFactory.createUnaryCallable(listBatchesTransportSettings, settings.listBatchesSettings(), clientContext);
        this.listBatchesPagedCallable = callableFactory.createPagedCallable(listBatchesTransportSettings, settings.listBatchesSettings(), clientContext);
        this.deleteBatchCallable = callableFactory.createUnaryCallable(deleteBatchTransportSettings, settings.deleteBatchSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateBatchRequest, Operation> createBatchCallable() {
        return this.createBatchCallable;
    }

    @Override
    public OperationCallable<CreateBatchRequest, Batch, BatchOperationMetadata> createBatchOperationCallable() {
        return this.createBatchOperationCallable;
    }

    @Override
    public UnaryCallable<GetBatchRequest, Batch> getBatchCallable() {
        return this.getBatchCallable;
    }

    @Override
    public UnaryCallable<ListBatchesRequest, ListBatchesResponse> listBatchesCallable() {
        return this.listBatchesCallable;
    }

    @Override
    public UnaryCallable<ListBatchesRequest, BatchControllerClient.ListBatchesPagedResponse> listBatchesPagedCallable() {
        return this.listBatchesPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteBatchRequest, Empty> deleteBatchCallable() {
        return this.deleteBatchCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

