/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.CreateNodeGroupRequest;
import com.google.cloud.dataproc.v1.GetNodeGroupRequest;
import com.google.cloud.dataproc.v1.NodeGroup;
import com.google.cloud.dataproc.v1.NodeGroupOperationMetadata;
import com.google.cloud.dataproc.v1.ResizeNodeGroupRequest;
import com.google.cloud.dataproc.v1.stub.HttpJsonNodeGroupControllerCallableFactory;
import com.google.cloud.dataproc.v1.stub.NodeGroupControllerStub;
import com.google.cloud.dataproc.v1.stub.NodeGroupControllerStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonNodeGroupControllerStub
extends NodeGroupControllerStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(NodeGroup.getDescriptor()).add(NodeGroupOperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateNodeGroupRequest, Operation> createNodeGroupMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.NodeGroupController/CreateNodeGroup").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/regions/*/clusters/*}/nodeGroups", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "nodeGroupId", (Object)request.getNodeGroupId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("nodeGroup", (Message)request.getNodeGroup(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ResizeNodeGroupRequest, Operation> resizeNodeGroupMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.NodeGroupController/ResizeNodeGroup").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/regions/*/clusters/*/nodeGroups/*}:resize", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetNodeGroupRequest, NodeGroup> getNodeGroupMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.NodeGroupController/GetNodeGroup").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/regions/*/clusters/*/nodeGroups/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)NodeGroup.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateNodeGroupRequest, Operation> createNodeGroupCallable;
    private final OperationCallable<CreateNodeGroupRequest, NodeGroup, NodeGroupOperationMetadata> createNodeGroupOperationCallable;
    private final UnaryCallable<ResizeNodeGroupRequest, Operation> resizeNodeGroupCallable;
    private final OperationCallable<ResizeNodeGroupRequest, NodeGroup, NodeGroupOperationMetadata> resizeNodeGroupOperationCallable;
    private final UnaryCallable<GetNodeGroupRequest, NodeGroup> getNodeGroupCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonNodeGroupControllerStub create(NodeGroupControllerStubSettings settings) throws IOException {
        return new HttpJsonNodeGroupControllerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonNodeGroupControllerStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonNodeGroupControllerStub(NodeGroupControllerStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonNodeGroupControllerStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonNodeGroupControllerStub(NodeGroupControllerStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonNodeGroupControllerStub(NodeGroupControllerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonNodeGroupControllerCallableFactory());
    }

    protected HttpJsonNodeGroupControllerStub(NodeGroupControllerStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/regions/*/operations/*}:cancel").addAdditionalBindings(HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/operations/*}:cancel").build()).build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/regions/*/operations/*}").addAdditionalBindings(HttpRule.newBuilder().setDelete("/v1/{name=projects/*/locations/*/operations/*}").build()).build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/regions/*/operations/*}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/regions/*/operations}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations}").build()).build()).build());
        HttpJsonCallSettings createNodeGroupTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createNodeGroupMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings resizeNodeGroupTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(resizeNodeGroupMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getNodeGroupTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getNodeGroupMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createNodeGroupCallable = callableFactory.createUnaryCallable(createNodeGroupTransportSettings, settings.createNodeGroupSettings(), clientContext);
        this.createNodeGroupOperationCallable = callableFactory.createOperationCallable(createNodeGroupTransportSettings, settings.createNodeGroupOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.resizeNodeGroupCallable = callableFactory.createUnaryCallable(resizeNodeGroupTransportSettings, settings.resizeNodeGroupSettings(), clientContext);
        this.resizeNodeGroupOperationCallable = callableFactory.createOperationCallable(resizeNodeGroupTransportSettings, settings.resizeNodeGroupOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getNodeGroupCallable = callableFactory.createUnaryCallable(getNodeGroupTransportSettings, settings.getNodeGroupSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createNodeGroupMethodDescriptor);
        methodDescriptors.add(resizeNodeGroupMethodDescriptor);
        methodDescriptors.add(getNodeGroupMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateNodeGroupRequest, Operation> createNodeGroupCallable() {
        return this.createNodeGroupCallable;
    }

    @Override
    public OperationCallable<CreateNodeGroupRequest, NodeGroup, NodeGroupOperationMetadata> createNodeGroupOperationCallable() {
        return this.createNodeGroupOperationCallable;
    }

    @Override
    public UnaryCallable<ResizeNodeGroupRequest, Operation> resizeNodeGroupCallable() {
        return this.resizeNodeGroupCallable;
    }

    @Override
    public OperationCallable<ResizeNodeGroupRequest, NodeGroup, NodeGroupOperationMetadata> resizeNodeGroupOperationCallable() {
        return this.resizeNodeGroupOperationCallable;
    }

    @Override
    public UnaryCallable<GetNodeGroupRequest, NodeGroup> getNodeGroupCallable() {
        return this.getNodeGroupCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

