/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1beta2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1beta2.AutoscalingPolicy;
import com.google.cloud.dataproc.v1beta2.AutoscalingPolicyName;
import com.google.cloud.dataproc.v1beta2.AutoscalingPolicyServiceSettings;
import com.google.cloud.dataproc.v1beta2.CreateAutoscalingPolicyRequest;
import com.google.cloud.dataproc.v1beta2.DeleteAutoscalingPolicyRequest;
import com.google.cloud.dataproc.v1beta2.GetAutoscalingPolicyRequest;
import com.google.cloud.dataproc.v1beta2.ListAutoscalingPoliciesRequest;
import com.google.cloud.dataproc.v1beta2.ListAutoscalingPoliciesResponse;
import com.google.cloud.dataproc.v1beta2.LocationName;
import com.google.cloud.dataproc.v1beta2.RegionName;
import com.google.cloud.dataproc.v1beta2.UpdateAutoscalingPolicyRequest;
import com.google.cloud.dataproc.v1beta2.stub.AutoscalingPolicyServiceStub;
import com.google.cloud.dataproc.v1beta2.stub.AutoscalingPolicyServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AutoscalingPolicyServiceClient
implements BackgroundResource {
    private final AutoscalingPolicyServiceSettings settings;
    private final AutoscalingPolicyServiceStub stub;

    public static final AutoscalingPolicyServiceClient create() throws IOException {
        return AutoscalingPolicyServiceClient.create(AutoscalingPolicyServiceSettings.newBuilder().build());
    }

    public static final AutoscalingPolicyServiceClient create(AutoscalingPolicyServiceSettings settings) throws IOException {
        return new AutoscalingPolicyServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AutoscalingPolicyServiceClient create(AutoscalingPolicyServiceStub stub) {
        return new AutoscalingPolicyServiceClient(stub);
    }

    protected AutoscalingPolicyServiceClient(AutoscalingPolicyServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AutoscalingPolicyServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AutoscalingPolicyServiceClient(AutoscalingPolicyServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AutoscalingPolicyServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AutoscalingPolicyServiceStub getStub() {
        return this.stub;
    }

    public final AutoscalingPolicy createAutoscalingPolicy(LocationName parent, AutoscalingPolicy policy) {
        CreateAutoscalingPolicyRequest request = CreateAutoscalingPolicyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPolicy(policy).build();
        return this.createAutoscalingPolicy(request);
    }

    public final AutoscalingPolicy createAutoscalingPolicy(RegionName parent, AutoscalingPolicy policy) {
        CreateAutoscalingPolicyRequest request = CreateAutoscalingPolicyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPolicy(policy).build();
        return this.createAutoscalingPolicy(request);
    }

    public final AutoscalingPolicy createAutoscalingPolicy(String parent, AutoscalingPolicy policy) {
        CreateAutoscalingPolicyRequest request = CreateAutoscalingPolicyRequest.newBuilder().setParent(parent).setPolicy(policy).build();
        return this.createAutoscalingPolicy(request);
    }

    public final AutoscalingPolicy createAutoscalingPolicy(CreateAutoscalingPolicyRequest request) {
        return (AutoscalingPolicy)this.createAutoscalingPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<CreateAutoscalingPolicyRequest, AutoscalingPolicy> createAutoscalingPolicyCallable() {
        return this.stub.createAutoscalingPolicyCallable();
    }

    public final AutoscalingPolicy updateAutoscalingPolicy(AutoscalingPolicy policy) {
        UpdateAutoscalingPolicyRequest request = UpdateAutoscalingPolicyRequest.newBuilder().setPolicy(policy).build();
        return this.updateAutoscalingPolicy(request);
    }

    public final AutoscalingPolicy updateAutoscalingPolicy(UpdateAutoscalingPolicyRequest request) {
        return (AutoscalingPolicy)this.updateAutoscalingPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAutoscalingPolicyRequest, AutoscalingPolicy> updateAutoscalingPolicyCallable() {
        return this.stub.updateAutoscalingPolicyCallable();
    }

    public final AutoscalingPolicy getAutoscalingPolicy(AutoscalingPolicyName name) {
        GetAutoscalingPolicyRequest request = GetAutoscalingPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAutoscalingPolicy(request);
    }

    public final AutoscalingPolicy getAutoscalingPolicy(String name) {
        GetAutoscalingPolicyRequest request = GetAutoscalingPolicyRequest.newBuilder().setName(name).build();
        return this.getAutoscalingPolicy(request);
    }

    public final AutoscalingPolicy getAutoscalingPolicy(GetAutoscalingPolicyRequest request) {
        return (AutoscalingPolicy)this.getAutoscalingPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetAutoscalingPolicyRequest, AutoscalingPolicy> getAutoscalingPolicyCallable() {
        return this.stub.getAutoscalingPolicyCallable();
    }

    public final ListAutoscalingPoliciesPagedResponse listAutoscalingPolicies(LocationName parent) {
        ListAutoscalingPoliciesRequest request = ListAutoscalingPoliciesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAutoscalingPolicies(request);
    }

    public final ListAutoscalingPoliciesPagedResponse listAutoscalingPolicies(RegionName parent) {
        ListAutoscalingPoliciesRequest request = ListAutoscalingPoliciesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAutoscalingPolicies(request);
    }

    public final ListAutoscalingPoliciesPagedResponse listAutoscalingPolicies(String parent) {
        ListAutoscalingPoliciesRequest request = ListAutoscalingPoliciesRequest.newBuilder().setParent(parent).build();
        return this.listAutoscalingPolicies(request);
    }

    public final ListAutoscalingPoliciesPagedResponse listAutoscalingPolicies(ListAutoscalingPoliciesRequest request) {
        return (ListAutoscalingPoliciesPagedResponse)((Object)this.listAutoscalingPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesPagedResponse> listAutoscalingPoliciesPagedCallable() {
        return this.stub.listAutoscalingPoliciesPagedCallable();
    }

    public final UnaryCallable<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse> listAutoscalingPoliciesCallable() {
        return this.stub.listAutoscalingPoliciesCallable();
    }

    public final void deleteAutoscalingPolicy(AutoscalingPolicyName name) {
        DeleteAutoscalingPolicyRequest request = DeleteAutoscalingPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAutoscalingPolicy(request);
    }

    public final void deleteAutoscalingPolicy(String name) {
        DeleteAutoscalingPolicyRequest request = DeleteAutoscalingPolicyRequest.newBuilder().setName(name).build();
        this.deleteAutoscalingPolicy(request);
    }

    public final void deleteAutoscalingPolicy(DeleteAutoscalingPolicyRequest request) {
        this.deleteAutoscalingPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAutoscalingPolicyRequest, Empty> deleteAutoscalingPolicyCallable() {
        return this.stub.deleteAutoscalingPolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAutoscalingPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse, AutoscalingPolicy, ListAutoscalingPoliciesPage, ListAutoscalingPoliciesFixedSizeCollection> {
        private ListAutoscalingPoliciesFixedSizeCollection(List<ListAutoscalingPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAutoscalingPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListAutoscalingPoliciesFixedSizeCollection(null, 0);
        }

        protected ListAutoscalingPoliciesFixedSizeCollection createCollection(List<ListAutoscalingPoliciesPage> pages, int collectionSize) {
            return new ListAutoscalingPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAutoscalingPoliciesPage
    extends AbstractPage<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse, AutoscalingPolicy, ListAutoscalingPoliciesPage> {
        private ListAutoscalingPoliciesPage(PageContext<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse, AutoscalingPolicy> context, ListAutoscalingPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListAutoscalingPoliciesPage createEmptyPage() {
            return new ListAutoscalingPoliciesPage(null, null);
        }

        protected ListAutoscalingPoliciesPage createPage(PageContext<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse, AutoscalingPolicy> context, ListAutoscalingPoliciesResponse response) {
            return new ListAutoscalingPoliciesPage(context, response);
        }

        public ApiFuture<ListAutoscalingPoliciesPage> createPageAsync(PageContext<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse, AutoscalingPolicy> context, ApiFuture<ListAutoscalingPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAutoscalingPoliciesPagedResponse
    extends AbstractPagedListResponse<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse, AutoscalingPolicy, ListAutoscalingPoliciesPage, ListAutoscalingPoliciesFixedSizeCollection> {
        public static ApiFuture<ListAutoscalingPoliciesPagedResponse> createAsync(PageContext<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse, AutoscalingPolicy> context, ApiFuture<ListAutoscalingPoliciesResponse> futureResponse) {
            ApiFuture<ListAutoscalingPoliciesPage> futurePage = ListAutoscalingPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAutoscalingPoliciesPagedResponse((ListAutoscalingPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAutoscalingPoliciesPagedResponse(ListAutoscalingPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAutoscalingPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }
}

