/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1beta2.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1beta2.AutoscalingPolicy;
import com.google.cloud.dataproc.v1beta2.AutoscalingPolicyServiceClient;
import com.google.cloud.dataproc.v1beta2.CreateAutoscalingPolicyRequest;
import com.google.cloud.dataproc.v1beta2.DeleteAutoscalingPolicyRequest;
import com.google.cloud.dataproc.v1beta2.GetAutoscalingPolicyRequest;
import com.google.cloud.dataproc.v1beta2.ListAutoscalingPoliciesRequest;
import com.google.cloud.dataproc.v1beta2.ListAutoscalingPoliciesResponse;
import com.google.cloud.dataproc.v1beta2.UpdateAutoscalingPolicyRequest;
import com.google.cloud.dataproc.v1beta2.stub.AutoscalingPolicyServiceStub;
import com.google.cloud.dataproc.v1beta2.stub.AutoscalingPolicyServiceStubSettings;
import com.google.cloud.dataproc.v1beta2.stub.GrpcAutoscalingPolicyServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcAutoscalingPolicyServiceStub
extends AutoscalingPolicyServiceStub {
    private static final MethodDescriptor<CreateAutoscalingPolicyRequest, AutoscalingPolicy> createAutoscalingPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1beta2.AutoscalingPolicyService/CreateAutoscalingPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateAutoscalingPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AutoscalingPolicy.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateAutoscalingPolicyRequest, AutoscalingPolicy> updateAutoscalingPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1beta2.AutoscalingPolicyService/UpdateAutoscalingPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateAutoscalingPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AutoscalingPolicy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetAutoscalingPolicyRequest, AutoscalingPolicy> getAutoscalingPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1beta2.AutoscalingPolicyService/GetAutoscalingPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAutoscalingPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AutoscalingPolicy.getDefaultInstance())).build();
    private static final MethodDescriptor<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse> listAutoscalingPoliciesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1beta2.AutoscalingPolicyService/ListAutoscalingPolicies").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAutoscalingPoliciesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAutoscalingPoliciesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteAutoscalingPolicyRequest, Empty> deleteAutoscalingPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1beta2.AutoscalingPolicyService/DeleteAutoscalingPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteAutoscalingPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private final UnaryCallable<CreateAutoscalingPolicyRequest, AutoscalingPolicy> createAutoscalingPolicyCallable;
    private final UnaryCallable<UpdateAutoscalingPolicyRequest, AutoscalingPolicy> updateAutoscalingPolicyCallable;
    private final UnaryCallable<GetAutoscalingPolicyRequest, AutoscalingPolicy> getAutoscalingPolicyCallable;
    private final UnaryCallable<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse> listAutoscalingPoliciesCallable;
    private final UnaryCallable<ListAutoscalingPoliciesRequest, AutoscalingPolicyServiceClient.ListAutoscalingPoliciesPagedResponse> listAutoscalingPoliciesPagedCallable;
    private final UnaryCallable<DeleteAutoscalingPolicyRequest, Empty> deleteAutoscalingPolicyCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAutoscalingPolicyServiceStub create(AutoscalingPolicyServiceStubSettings settings) throws IOException {
        return new GrpcAutoscalingPolicyServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAutoscalingPolicyServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAutoscalingPolicyServiceStub(AutoscalingPolicyServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAutoscalingPolicyServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAutoscalingPolicyServiceStub(AutoscalingPolicyServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAutoscalingPolicyServiceStub(AutoscalingPolicyServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAutoscalingPolicyServiceCallableFactory());
    }

    protected GrpcAutoscalingPolicyServiceStub(AutoscalingPolicyServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createAutoscalingPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createAutoscalingPolicyMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateAutoscalingPolicyRequest>(){

            public Map<String, String> extract(CreateAutoscalingPolicyRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateAutoscalingPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateAutoscalingPolicyMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateAutoscalingPolicyRequest>(){

            public Map<String, String> extract(UpdateAutoscalingPolicyRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"policy.name", (Object)String.valueOf(request.getPolicy().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getAutoscalingPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAutoscalingPolicyMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetAutoscalingPolicyRequest>(){

            public Map<String, String> extract(GetAutoscalingPolicyRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listAutoscalingPoliciesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAutoscalingPoliciesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListAutoscalingPoliciesRequest>(){

            public Map<String, String> extract(ListAutoscalingPoliciesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteAutoscalingPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteAutoscalingPolicyMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteAutoscalingPolicyRequest>(){

            public Map<String, String> extract(DeleteAutoscalingPolicyRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.createAutoscalingPolicyCallable = callableFactory.createUnaryCallable(createAutoscalingPolicyTransportSettings, settings.createAutoscalingPolicySettings(), clientContext);
        this.updateAutoscalingPolicyCallable = callableFactory.createUnaryCallable(updateAutoscalingPolicyTransportSettings, settings.updateAutoscalingPolicySettings(), clientContext);
        this.getAutoscalingPolicyCallable = callableFactory.createUnaryCallable(getAutoscalingPolicyTransportSettings, settings.getAutoscalingPolicySettings(), clientContext);
        this.listAutoscalingPoliciesCallable = callableFactory.createUnaryCallable(listAutoscalingPoliciesTransportSettings, settings.listAutoscalingPoliciesSettings(), clientContext);
        this.listAutoscalingPoliciesPagedCallable = callableFactory.createPagedCallable(listAutoscalingPoliciesTransportSettings, settings.listAutoscalingPoliciesSettings(), clientContext);
        this.deleteAutoscalingPolicyCallable = callableFactory.createUnaryCallable(deleteAutoscalingPolicyTransportSettings, settings.deleteAutoscalingPolicySettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateAutoscalingPolicyRequest, AutoscalingPolicy> createAutoscalingPolicyCallable() {
        return this.createAutoscalingPolicyCallable;
    }

    @Override
    public UnaryCallable<UpdateAutoscalingPolicyRequest, AutoscalingPolicy> updateAutoscalingPolicyCallable() {
        return this.updateAutoscalingPolicyCallable;
    }

    @Override
    public UnaryCallable<GetAutoscalingPolicyRequest, AutoscalingPolicy> getAutoscalingPolicyCallable() {
        return this.getAutoscalingPolicyCallable;
    }

    @Override
    public UnaryCallable<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse> listAutoscalingPoliciesCallable() {
        return this.listAutoscalingPoliciesCallable;
    }

    @Override
    public UnaryCallable<ListAutoscalingPoliciesRequest, AutoscalingPolicyServiceClient.ListAutoscalingPoliciesPagedResponse> listAutoscalingPoliciesPagedCallable() {
        return this.listAutoscalingPoliciesPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteAutoscalingPolicyRequest, Empty> deleteAutoscalingPolicyCallable() {
        return this.deleteAutoscalingPolicyCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

