/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.AutoscalingPolicy;
import com.google.cloud.dataproc.v1.AutoscalingPolicyServiceClient;
import com.google.cloud.dataproc.v1.CreateAutoscalingPolicyRequest;
import com.google.cloud.dataproc.v1.DeleteAutoscalingPolicyRequest;
import com.google.cloud.dataproc.v1.GetAutoscalingPolicyRequest;
import com.google.cloud.dataproc.v1.ListAutoscalingPoliciesRequest;
import com.google.cloud.dataproc.v1.ListAutoscalingPoliciesResponse;
import com.google.cloud.dataproc.v1.UpdateAutoscalingPolicyRequest;
import com.google.cloud.dataproc.v1.stub.AutoscalingPolicyServiceStub;
import com.google.cloud.dataproc.v1.stub.GrpcAutoscalingPolicyServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AutoscalingPolicyServiceStubSettings
extends StubSettings<AutoscalingPolicyServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateAutoscalingPolicyRequest, AutoscalingPolicy> createAutoscalingPolicySettings;
    private final UnaryCallSettings<UpdateAutoscalingPolicyRequest, AutoscalingPolicy> updateAutoscalingPolicySettings;
    private final UnaryCallSettings<GetAutoscalingPolicyRequest, AutoscalingPolicy> getAutoscalingPolicySettings;
    private final PagedCallSettings<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse, AutoscalingPolicyServiceClient.ListAutoscalingPoliciesPagedResponse> listAutoscalingPoliciesSettings;
    private final UnaryCallSettings<DeleteAutoscalingPolicyRequest, Empty> deleteAutoscalingPolicySettings;
    private static final PagedListDescriptor<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse, AutoscalingPolicy> LIST_AUTOSCALING_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse, AutoscalingPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListAutoscalingPoliciesRequest injectToken(ListAutoscalingPoliciesRequest payload, String token) {
            return ListAutoscalingPoliciesRequest.newBuilder((ListAutoscalingPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListAutoscalingPoliciesRequest injectPageSize(ListAutoscalingPoliciesRequest payload, int pageSize) {
            return ListAutoscalingPoliciesRequest.newBuilder((ListAutoscalingPoliciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAutoscalingPoliciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAutoscalingPoliciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AutoscalingPolicy> extractResources(ListAutoscalingPoliciesResponse payload) {
            return payload.getPoliciesList() == null ? ImmutableList.of() : payload.getPoliciesList();
        }
    };
    private static final PagedListResponseFactory<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse, AutoscalingPolicyServiceClient.ListAutoscalingPoliciesPagedResponse> LIST_AUTOSCALING_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse, AutoscalingPolicyServiceClient.ListAutoscalingPoliciesPagedResponse>(){

        public ApiFuture<AutoscalingPolicyServiceClient.ListAutoscalingPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse> callable, ListAutoscalingPoliciesRequest request, ApiCallContext context, ApiFuture<ListAutoscalingPoliciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AUTOSCALING_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AutoscalingPolicyServiceClient.ListAutoscalingPoliciesPagedResponse.createAsync((PageContext<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse, AutoscalingPolicy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateAutoscalingPolicyRequest, AutoscalingPolicy> createAutoscalingPolicySettings() {
        return this.createAutoscalingPolicySettings;
    }

    public UnaryCallSettings<UpdateAutoscalingPolicyRequest, AutoscalingPolicy> updateAutoscalingPolicySettings() {
        return this.updateAutoscalingPolicySettings;
    }

    public UnaryCallSettings<GetAutoscalingPolicyRequest, AutoscalingPolicy> getAutoscalingPolicySettings() {
        return this.getAutoscalingPolicySettings;
    }

    public PagedCallSettings<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse, AutoscalingPolicyServiceClient.ListAutoscalingPoliciesPagedResponse> listAutoscalingPoliciesSettings() {
        return this.listAutoscalingPoliciesSettings;
    }

    public UnaryCallSettings<DeleteAutoscalingPolicyRequest, Empty> deleteAutoscalingPolicySettings() {
        return this.deleteAutoscalingPolicySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AutoscalingPolicyServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAutoscalingPolicyServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dataproc.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dataproc.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AutoscalingPolicyServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AutoscalingPolicyServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AutoscalingPolicyServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createAutoscalingPolicySettings = settingsBuilder.createAutoscalingPolicySettings().build();
        this.updateAutoscalingPolicySettings = settingsBuilder.updateAutoscalingPolicySettings().build();
        this.getAutoscalingPolicySettings = settingsBuilder.getAutoscalingPolicySettings().build();
        this.listAutoscalingPoliciesSettings = settingsBuilder.listAutoscalingPoliciesSettings().build();
        this.deleteAutoscalingPolicySettings = settingsBuilder.deleteAutoscalingPolicySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AutoscalingPolicyServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateAutoscalingPolicyRequest, AutoscalingPolicy> createAutoscalingPolicySettings;
        private final UnaryCallSettings.Builder<UpdateAutoscalingPolicyRequest, AutoscalingPolicy> updateAutoscalingPolicySettings;
        private final UnaryCallSettings.Builder<GetAutoscalingPolicyRequest, AutoscalingPolicy> getAutoscalingPolicySettings;
        private final PagedCallSettings.Builder<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse, AutoscalingPolicyServiceClient.ListAutoscalingPoliciesPagedResponse> listAutoscalingPoliciesSettings;
        private final UnaryCallSettings.Builder<DeleteAutoscalingPolicyRequest, Empty> deleteAutoscalingPolicySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createAutoscalingPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAutoscalingPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAutoscalingPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAutoscalingPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AUTOSCALING_POLICIES_PAGE_STR_FACT);
            this.deleteAutoscalingPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createAutoscalingPolicySettings, this.updateAutoscalingPolicySettings, this.getAutoscalingPolicySettings, this.listAutoscalingPoliciesSettings, this.deleteAutoscalingPolicySettings);
            Builder.initDefaults(this);
        }

        protected Builder(AutoscalingPolicyServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createAutoscalingPolicySettings = settings.createAutoscalingPolicySettings.toBuilder();
            this.updateAutoscalingPolicySettings = settings.updateAutoscalingPolicySettings.toBuilder();
            this.getAutoscalingPolicySettings = settings.getAutoscalingPolicySettings.toBuilder();
            this.listAutoscalingPoliciesSettings = settings.listAutoscalingPoliciesSettings.toBuilder();
            this.deleteAutoscalingPolicySettings = settings.deleteAutoscalingPolicySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createAutoscalingPolicySettings, this.updateAutoscalingPolicySettings, this.getAutoscalingPolicySettings, this.listAutoscalingPoliciesSettings, this.deleteAutoscalingPolicySettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AutoscalingPolicyServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AutoscalingPolicyServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AutoscalingPolicyServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AutoscalingPolicyServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AutoscalingPolicyServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createAutoscalingPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateAutoscalingPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getAutoscalingPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listAutoscalingPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteAutoscalingPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateAutoscalingPolicyRequest, AutoscalingPolicy> createAutoscalingPolicySettings() {
            return this.createAutoscalingPolicySettings;
        }

        public UnaryCallSettings.Builder<UpdateAutoscalingPolicyRequest, AutoscalingPolicy> updateAutoscalingPolicySettings() {
            return this.updateAutoscalingPolicySettings;
        }

        public UnaryCallSettings.Builder<GetAutoscalingPolicyRequest, AutoscalingPolicy> getAutoscalingPolicySettings() {
            return this.getAutoscalingPolicySettings;
        }

        public PagedCallSettings.Builder<ListAutoscalingPoliciesRequest, ListAutoscalingPoliciesResponse, AutoscalingPolicyServiceClient.ListAutoscalingPoliciesPagedResponse> listAutoscalingPoliciesSettings() {
            return this.listAutoscalingPoliciesSettings;
        }

        public UnaryCallSettings.Builder<DeleteAutoscalingPolicyRequest, Empty> deleteAutoscalingPolicySettings() {
            return this.deleteAutoscalingPolicySettings;
        }

        public AutoscalingPolicyServiceStubSettings build() throws IOException {
            return new AutoscalingPolicyServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

