/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1beta2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1beta2.CreateWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1beta2.DeleteWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1beta2.GetWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1beta2.InstantiateInlineWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1beta2.InstantiateWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1beta2.ListWorkflowTemplatesRequest;
import com.google.cloud.dataproc.v1beta2.ListWorkflowTemplatesResponse;
import com.google.cloud.dataproc.v1beta2.UpdateWorkflowTemplateRequest;
import com.google.cloud.dataproc.v1beta2.WorkflowMetadata;
import com.google.cloud.dataproc.v1beta2.WorkflowTemplate;
import com.google.cloud.dataproc.v1beta2.WorkflowTemplateServiceClient;
import com.google.cloud.dataproc.v1beta2.stub.GrpcWorkflowTemplateServiceStub;
import com.google.cloud.dataproc.v1beta2.stub.WorkflowTemplateServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class WorkflowTemplateServiceStubSettings
extends StubSettings<WorkflowTemplateServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateWorkflowTemplateRequest, WorkflowTemplate> createWorkflowTemplateSettings;
    private final UnaryCallSettings<GetWorkflowTemplateRequest, WorkflowTemplate> getWorkflowTemplateSettings;
    private final UnaryCallSettings<InstantiateWorkflowTemplateRequest, Operation> instantiateWorkflowTemplateSettings;
    private final OperationCallSettings<InstantiateWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateWorkflowTemplateOperationSettings;
    private final UnaryCallSettings<InstantiateInlineWorkflowTemplateRequest, Operation> instantiateInlineWorkflowTemplateSettings;
    private final OperationCallSettings<InstantiateInlineWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateInlineWorkflowTemplateOperationSettings;
    private final UnaryCallSettings<UpdateWorkflowTemplateRequest, WorkflowTemplate> updateWorkflowTemplateSettings;
    private final PagedCallSettings<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse, WorkflowTemplateServiceClient.ListWorkflowTemplatesPagedResponse> listWorkflowTemplatesSettings;
    private final UnaryCallSettings<DeleteWorkflowTemplateRequest, Empty> deleteWorkflowTemplateSettings;
    private static final PagedListDescriptor<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse, WorkflowTemplate> LIST_WORKFLOW_TEMPLATES_PAGE_STR_DESC = new PagedListDescriptor<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse, WorkflowTemplate>(){

        public String emptyToken() {
            return "";
        }

        public ListWorkflowTemplatesRequest injectToken(ListWorkflowTemplatesRequest payload, String token) {
            return ListWorkflowTemplatesRequest.newBuilder((ListWorkflowTemplatesRequest)payload).setPageToken(token).build();
        }

        public ListWorkflowTemplatesRequest injectPageSize(ListWorkflowTemplatesRequest payload, int pageSize) {
            return ListWorkflowTemplatesRequest.newBuilder((ListWorkflowTemplatesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListWorkflowTemplatesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListWorkflowTemplatesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<WorkflowTemplate> extractResources(ListWorkflowTemplatesResponse payload) {
            return payload.getTemplatesList() != null ? payload.getTemplatesList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse, WorkflowTemplateServiceClient.ListWorkflowTemplatesPagedResponse> LIST_WORKFLOW_TEMPLATES_PAGE_STR_FACT = new PagedListResponseFactory<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse, WorkflowTemplateServiceClient.ListWorkflowTemplatesPagedResponse>(){

        public ApiFuture<WorkflowTemplateServiceClient.ListWorkflowTemplatesPagedResponse> getFuturePagedResponse(UnaryCallable<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse> callable, ListWorkflowTemplatesRequest request, ApiCallContext context, ApiFuture<ListWorkflowTemplatesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_WORKFLOW_TEMPLATES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return WorkflowTemplateServiceClient.ListWorkflowTemplatesPagedResponse.createAsync((PageContext<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse, WorkflowTemplate>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateWorkflowTemplateRequest, WorkflowTemplate> createWorkflowTemplateSettings() {
        return this.createWorkflowTemplateSettings;
    }

    public UnaryCallSettings<GetWorkflowTemplateRequest, WorkflowTemplate> getWorkflowTemplateSettings() {
        return this.getWorkflowTemplateSettings;
    }

    public UnaryCallSettings<InstantiateWorkflowTemplateRequest, Operation> instantiateWorkflowTemplateSettings() {
        return this.instantiateWorkflowTemplateSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<InstantiateWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateWorkflowTemplateOperationSettings() {
        return this.instantiateWorkflowTemplateOperationSettings;
    }

    public UnaryCallSettings<InstantiateInlineWorkflowTemplateRequest, Operation> instantiateInlineWorkflowTemplateSettings() {
        return this.instantiateInlineWorkflowTemplateSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<InstantiateInlineWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateInlineWorkflowTemplateOperationSettings() {
        return this.instantiateInlineWorkflowTemplateOperationSettings;
    }

    public UnaryCallSettings<UpdateWorkflowTemplateRequest, WorkflowTemplate> updateWorkflowTemplateSettings() {
        return this.updateWorkflowTemplateSettings;
    }

    public PagedCallSettings<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse, WorkflowTemplateServiceClient.ListWorkflowTemplatesPagedResponse> listWorkflowTemplatesSettings() {
        return this.listWorkflowTemplatesSettings;
    }

    public UnaryCallSettings<DeleteWorkflowTemplateRequest, Empty> deleteWorkflowTemplateSettings() {
        return this.deleteWorkflowTemplateSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public WorkflowTemplateServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcWorkflowTemplateServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dataproc.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return WorkflowTemplateServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(WorkflowTemplateServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected WorkflowTemplateServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createWorkflowTemplateSettings = settingsBuilder.createWorkflowTemplateSettings().build();
        this.getWorkflowTemplateSettings = settingsBuilder.getWorkflowTemplateSettings().build();
        this.instantiateWorkflowTemplateSettings = settingsBuilder.instantiateWorkflowTemplateSettings().build();
        this.instantiateWorkflowTemplateOperationSettings = settingsBuilder.instantiateWorkflowTemplateOperationSettings().build();
        this.instantiateInlineWorkflowTemplateSettings = settingsBuilder.instantiateInlineWorkflowTemplateSettings().build();
        this.instantiateInlineWorkflowTemplateOperationSettings = settingsBuilder.instantiateInlineWorkflowTemplateOperationSettings().build();
        this.updateWorkflowTemplateSettings = settingsBuilder.updateWorkflowTemplateSettings().build();
        this.listWorkflowTemplatesSettings = settingsBuilder.listWorkflowTemplatesSettings().build();
        this.deleteWorkflowTemplateSettings = settingsBuilder.deleteWorkflowTemplateSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<WorkflowTemplateServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateWorkflowTemplateRequest, WorkflowTemplate> createWorkflowTemplateSettings;
        private final UnaryCallSettings.Builder<GetWorkflowTemplateRequest, WorkflowTemplate> getWorkflowTemplateSettings;
        private final UnaryCallSettings.Builder<InstantiateWorkflowTemplateRequest, Operation> instantiateWorkflowTemplateSettings;
        private final OperationCallSettings.Builder<InstantiateWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateWorkflowTemplateOperationSettings;
        private final UnaryCallSettings.Builder<InstantiateInlineWorkflowTemplateRequest, Operation> instantiateInlineWorkflowTemplateSettings;
        private final OperationCallSettings.Builder<InstantiateInlineWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateInlineWorkflowTemplateOperationSettings;
        private final UnaryCallSettings.Builder<UpdateWorkflowTemplateRequest, WorkflowTemplate> updateWorkflowTemplateSettings;
        private final PagedCallSettings.Builder<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse, WorkflowTemplateServiceClient.ListWorkflowTemplatesPagedResponse> listWorkflowTemplatesSettings;
        private final UnaryCallSettings.Builder<DeleteWorkflowTemplateRequest, Empty> deleteWorkflowTemplateSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createWorkflowTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getWorkflowTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.instantiateWorkflowTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.instantiateWorkflowTemplateOperationSettings = OperationCallSettings.newBuilder();
            this.instantiateInlineWorkflowTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.instantiateInlineWorkflowTemplateOperationSettings = OperationCallSettings.newBuilder();
            this.updateWorkflowTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listWorkflowTemplatesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_WORKFLOW_TEMPLATES_PAGE_STR_FACT);
            this.deleteWorkflowTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createWorkflowTemplateSettings, this.getWorkflowTemplateSettings, this.instantiateWorkflowTemplateSettings, this.instantiateInlineWorkflowTemplateSettings, this.updateWorkflowTemplateSettings, this.listWorkflowTemplatesSettings, this.deleteWorkflowTemplateSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(WorkflowTemplateServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)WorkflowTemplateServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)WorkflowTemplateServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(WorkflowTemplateServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createWorkflowTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getWorkflowTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.instantiateWorkflowTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.instantiateInlineWorkflowTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateWorkflowTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listWorkflowTemplatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteWorkflowTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.instantiateWorkflowTemplateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(WorkflowMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)43200000L)).build()));
            builder.instantiateInlineWorkflowTemplateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(WorkflowMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)43200000L)).build()));
            return builder;
        }

        protected Builder(WorkflowTemplateServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createWorkflowTemplateSettings = settings.createWorkflowTemplateSettings.toBuilder();
            this.getWorkflowTemplateSettings = settings.getWorkflowTemplateSettings.toBuilder();
            this.instantiateWorkflowTemplateSettings = settings.instantiateWorkflowTemplateSettings.toBuilder();
            this.instantiateWorkflowTemplateOperationSettings = settings.instantiateWorkflowTemplateOperationSettings.toBuilder();
            this.instantiateInlineWorkflowTemplateSettings = settings.instantiateInlineWorkflowTemplateSettings.toBuilder();
            this.instantiateInlineWorkflowTemplateOperationSettings = settings.instantiateInlineWorkflowTemplateOperationSettings.toBuilder();
            this.updateWorkflowTemplateSettings = settings.updateWorkflowTemplateSettings.toBuilder();
            this.listWorkflowTemplatesSettings = settings.listWorkflowTemplatesSettings.toBuilder();
            this.deleteWorkflowTemplateSettings = settings.deleteWorkflowTemplateSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createWorkflowTemplateSettings, this.getWorkflowTemplateSettings, this.instantiateWorkflowTemplateSettings, this.instantiateInlineWorkflowTemplateSettings, this.updateWorkflowTemplateSettings, this.listWorkflowTemplatesSettings, this.deleteWorkflowTemplateSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateWorkflowTemplateRequest, WorkflowTemplate> createWorkflowTemplateSettings() {
            return this.createWorkflowTemplateSettings;
        }

        public UnaryCallSettings.Builder<GetWorkflowTemplateRequest, WorkflowTemplate> getWorkflowTemplateSettings() {
            return this.getWorkflowTemplateSettings;
        }

        public UnaryCallSettings.Builder<InstantiateWorkflowTemplateRequest, Operation> instantiateWorkflowTemplateSettings() {
            return this.instantiateWorkflowTemplateSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<InstantiateWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateWorkflowTemplateOperationSettings() {
            return this.instantiateWorkflowTemplateOperationSettings;
        }

        public UnaryCallSettings.Builder<InstantiateInlineWorkflowTemplateRequest, Operation> instantiateInlineWorkflowTemplateSettings() {
            return this.instantiateInlineWorkflowTemplateSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<InstantiateInlineWorkflowTemplateRequest, Empty, WorkflowMetadata> instantiateInlineWorkflowTemplateOperationSettings() {
            return this.instantiateInlineWorkflowTemplateOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateWorkflowTemplateRequest, WorkflowTemplate> updateWorkflowTemplateSettings() {
            return this.updateWorkflowTemplateSettings;
        }

        public PagedCallSettings.Builder<ListWorkflowTemplatesRequest, ListWorkflowTemplatesResponse, WorkflowTemplateServiceClient.ListWorkflowTemplatesPagedResponse> listWorkflowTemplatesSettings() {
            return this.listWorkflowTemplatesSettings;
        }

        public UnaryCallSettings.Builder<DeleteWorkflowTemplateRequest, Empty> deleteWorkflowTemplateSettings() {
            return this.deleteWorkflowTemplateSettings;
        }

        public WorkflowTemplateServiceStubSettings build() throws IOException {
            return new WorkflowTemplateServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.INTERNAL, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

