/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.metastore.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.metastore.v1beta.AlterMetadataResourceLocationRequest;
import com.google.cloud.metastore.v1beta.AlterMetadataResourceLocationResponse;
import com.google.cloud.metastore.v1beta.Backup;
import com.google.cloud.metastore.v1beta.CreateBackupRequest;
import com.google.cloud.metastore.v1beta.CreateMetadataImportRequest;
import com.google.cloud.metastore.v1beta.CreateServiceRequest;
import com.google.cloud.metastore.v1beta.DataprocMetastoreClient;
import com.google.cloud.metastore.v1beta.DeleteBackupRequest;
import com.google.cloud.metastore.v1beta.DeleteServiceRequest;
import com.google.cloud.metastore.v1beta.ExportMetadataRequest;
import com.google.cloud.metastore.v1beta.GetBackupRequest;
import com.google.cloud.metastore.v1beta.GetMetadataImportRequest;
import com.google.cloud.metastore.v1beta.GetServiceRequest;
import com.google.cloud.metastore.v1beta.ListBackupsRequest;
import com.google.cloud.metastore.v1beta.ListBackupsResponse;
import com.google.cloud.metastore.v1beta.ListMetadataImportsRequest;
import com.google.cloud.metastore.v1beta.ListMetadataImportsResponse;
import com.google.cloud.metastore.v1beta.ListServicesRequest;
import com.google.cloud.metastore.v1beta.ListServicesResponse;
import com.google.cloud.metastore.v1beta.MetadataExport;
import com.google.cloud.metastore.v1beta.MetadataImport;
import com.google.cloud.metastore.v1beta.MoveTableToDatabaseRequest;
import com.google.cloud.metastore.v1beta.MoveTableToDatabaseResponse;
import com.google.cloud.metastore.v1beta.OperationMetadata;
import com.google.cloud.metastore.v1beta.QueryMetadataRequest;
import com.google.cloud.metastore.v1beta.QueryMetadataResponse;
import com.google.cloud.metastore.v1beta.RemoveIamPolicyRequest;
import com.google.cloud.metastore.v1beta.RemoveIamPolicyResponse;
import com.google.cloud.metastore.v1beta.Restore;
import com.google.cloud.metastore.v1beta.RestoreServiceRequest;
import com.google.cloud.metastore.v1beta.Service;
import com.google.cloud.metastore.v1beta.UpdateMetadataImportRequest;
import com.google.cloud.metastore.v1beta.UpdateServiceRequest;
import com.google.cloud.metastore.v1beta.stub.DataprocMetastoreStub;
import com.google.cloud.metastore.v1beta.stub.GrpcDataprocMetastoreStub;
import com.google.cloud.metastore.v1beta.stub.HttpJsonDataprocMetastoreStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DataprocMetastoreStubSettings
extends StubSettings<DataprocMetastoreStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListServicesRequest, ListServicesResponse, DataprocMetastoreClient.ListServicesPagedResponse> listServicesSettings;
    private final UnaryCallSettings<GetServiceRequest, Service> getServiceSettings;
    private final UnaryCallSettings<CreateServiceRequest, Operation> createServiceSettings;
    private final OperationCallSettings<CreateServiceRequest, Service, OperationMetadata> createServiceOperationSettings;
    private final UnaryCallSettings<UpdateServiceRequest, Operation> updateServiceSettings;
    private final OperationCallSettings<UpdateServiceRequest, Service, OperationMetadata> updateServiceOperationSettings;
    private final UnaryCallSettings<DeleteServiceRequest, Operation> deleteServiceSettings;
    private final OperationCallSettings<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationSettings;
    private final PagedCallSettings<ListMetadataImportsRequest, ListMetadataImportsResponse, DataprocMetastoreClient.ListMetadataImportsPagedResponse> listMetadataImportsSettings;
    private final UnaryCallSettings<GetMetadataImportRequest, MetadataImport> getMetadataImportSettings;
    private final UnaryCallSettings<CreateMetadataImportRequest, Operation> createMetadataImportSettings;
    private final OperationCallSettings<CreateMetadataImportRequest, MetadataImport, OperationMetadata> createMetadataImportOperationSettings;
    private final UnaryCallSettings<UpdateMetadataImportRequest, Operation> updateMetadataImportSettings;
    private final OperationCallSettings<UpdateMetadataImportRequest, MetadataImport, OperationMetadata> updateMetadataImportOperationSettings;
    private final UnaryCallSettings<ExportMetadataRequest, Operation> exportMetadataSettings;
    private final OperationCallSettings<ExportMetadataRequest, MetadataExport, OperationMetadata> exportMetadataOperationSettings;
    private final UnaryCallSettings<RestoreServiceRequest, Operation> restoreServiceSettings;
    private final OperationCallSettings<RestoreServiceRequest, Restore, OperationMetadata> restoreServiceOperationSettings;
    private final PagedCallSettings<ListBackupsRequest, ListBackupsResponse, DataprocMetastoreClient.ListBackupsPagedResponse> listBackupsSettings;
    private final UnaryCallSettings<GetBackupRequest, Backup> getBackupSettings;
    private final UnaryCallSettings<CreateBackupRequest, Operation> createBackupSettings;
    private final OperationCallSettings<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationSettings;
    private final UnaryCallSettings<DeleteBackupRequest, Operation> deleteBackupSettings;
    private final OperationCallSettings<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationSettings;
    private final UnaryCallSettings<RemoveIamPolicyRequest, RemoveIamPolicyResponse> removeIamPolicySettings;
    private final UnaryCallSettings<QueryMetadataRequest, Operation> queryMetadataSettings;
    private final OperationCallSettings<QueryMetadataRequest, QueryMetadataResponse, OperationMetadata> queryMetadataOperationSettings;
    private final UnaryCallSettings<MoveTableToDatabaseRequest, Operation> moveTableToDatabaseSettings;
    private final OperationCallSettings<MoveTableToDatabaseRequest, MoveTableToDatabaseResponse, OperationMetadata> moveTableToDatabaseOperationSettings;
    private final UnaryCallSettings<AlterMetadataResourceLocationRequest, Operation> alterMetadataResourceLocationSettings;
    private final OperationCallSettings<AlterMetadataResourceLocationRequest, AlterMetadataResourceLocationResponse, OperationMetadata> alterMetadataResourceLocationOperationSettings;
    private static final PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service> LIST_SERVICES_PAGE_STR_DESC = new PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service>(){

        public String emptyToken() {
            return "";
        }

        public ListServicesRequest injectToken(ListServicesRequest payload, String token) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageToken(token).build();
        }

        public ListServicesRequest injectPageSize(ListServicesRequest payload, int pageSize) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServicesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServicesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Service> extractResources(ListServicesResponse payload) {
            return payload.getServicesList() == null ? ImmutableList.of() : payload.getServicesList();
        }
    };
    private static final PagedListDescriptor<ListMetadataImportsRequest, ListMetadataImportsResponse, MetadataImport> LIST_METADATA_IMPORTS_PAGE_STR_DESC = new PagedListDescriptor<ListMetadataImportsRequest, ListMetadataImportsResponse, MetadataImport>(){

        public String emptyToken() {
            return "";
        }

        public ListMetadataImportsRequest injectToken(ListMetadataImportsRequest payload, String token) {
            return ListMetadataImportsRequest.newBuilder((ListMetadataImportsRequest)payload).setPageToken(token).build();
        }

        public ListMetadataImportsRequest injectPageSize(ListMetadataImportsRequest payload, int pageSize) {
            return ListMetadataImportsRequest.newBuilder((ListMetadataImportsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMetadataImportsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMetadataImportsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MetadataImport> extractResources(ListMetadataImportsResponse payload) {
            return payload.getMetadataImportsList() == null ? ImmutableList.of() : payload.getMetadataImportsList();
        }
    };
    private static final PagedListDescriptor<ListBackupsRequest, ListBackupsResponse, Backup> LIST_BACKUPS_PAGE_STR_DESC = new PagedListDescriptor<ListBackupsRequest, ListBackupsResponse, Backup>(){

        public String emptyToken() {
            return "";
        }

        public ListBackupsRequest injectToken(ListBackupsRequest payload, String token) {
            return ListBackupsRequest.newBuilder((ListBackupsRequest)payload).setPageToken(token).build();
        }

        public ListBackupsRequest injectPageSize(ListBackupsRequest payload, int pageSize) {
            return ListBackupsRequest.newBuilder((ListBackupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBackupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBackupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Backup> extractResources(ListBackupsResponse payload) {
            return payload.getBackupsList() == null ? ImmutableList.of() : payload.getBackupsList();
        }
    };
    private static final PagedListResponseFactory<ListServicesRequest, ListServicesResponse, DataprocMetastoreClient.ListServicesPagedResponse> LIST_SERVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListServicesRequest, ListServicesResponse, DataprocMetastoreClient.ListServicesPagedResponse>(){

        public ApiFuture<DataprocMetastoreClient.ListServicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListServicesRequest, ListServicesResponse> callable, ListServicesRequest request, ApiCallContext context, ApiFuture<ListServicesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataprocMetastoreClient.ListServicesPagedResponse.createAsync((PageContext<ListServicesRequest, ListServicesResponse, Service>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListMetadataImportsRequest, ListMetadataImportsResponse, DataprocMetastoreClient.ListMetadataImportsPagedResponse> LIST_METADATA_IMPORTS_PAGE_STR_FACT = new PagedListResponseFactory<ListMetadataImportsRequest, ListMetadataImportsResponse, DataprocMetastoreClient.ListMetadataImportsPagedResponse>(){

        public ApiFuture<DataprocMetastoreClient.ListMetadataImportsPagedResponse> getFuturePagedResponse(UnaryCallable<ListMetadataImportsRequest, ListMetadataImportsResponse> callable, ListMetadataImportsRequest request, ApiCallContext context, ApiFuture<ListMetadataImportsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_METADATA_IMPORTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataprocMetastoreClient.ListMetadataImportsPagedResponse.createAsync((PageContext<ListMetadataImportsRequest, ListMetadataImportsResponse, MetadataImport>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListBackupsRequest, ListBackupsResponse, DataprocMetastoreClient.ListBackupsPagedResponse> LIST_BACKUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListBackupsRequest, ListBackupsResponse, DataprocMetastoreClient.ListBackupsPagedResponse>(){

        public ApiFuture<DataprocMetastoreClient.ListBackupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBackupsRequest, ListBackupsResponse> callable, ListBackupsRequest request, ApiCallContext context, ApiFuture<ListBackupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BACKUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataprocMetastoreClient.ListBackupsPagedResponse.createAsync((PageContext<ListBackupsRequest, ListBackupsResponse, Backup>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListServicesRequest, ListServicesResponse, DataprocMetastoreClient.ListServicesPagedResponse> listServicesSettings() {
        return this.listServicesSettings;
    }

    public UnaryCallSettings<GetServiceRequest, Service> getServiceSettings() {
        return this.getServiceSettings;
    }

    public UnaryCallSettings<CreateServiceRequest, Operation> createServiceSettings() {
        return this.createServiceSettings;
    }

    public OperationCallSettings<CreateServiceRequest, Service, OperationMetadata> createServiceOperationSettings() {
        return this.createServiceOperationSettings;
    }

    public UnaryCallSettings<UpdateServiceRequest, Operation> updateServiceSettings() {
        return this.updateServiceSettings;
    }

    public OperationCallSettings<UpdateServiceRequest, Service, OperationMetadata> updateServiceOperationSettings() {
        return this.updateServiceOperationSettings;
    }

    public UnaryCallSettings<DeleteServiceRequest, Operation> deleteServiceSettings() {
        return this.deleteServiceSettings;
    }

    public OperationCallSettings<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationSettings() {
        return this.deleteServiceOperationSettings;
    }

    public PagedCallSettings<ListMetadataImportsRequest, ListMetadataImportsResponse, DataprocMetastoreClient.ListMetadataImportsPagedResponse> listMetadataImportsSettings() {
        return this.listMetadataImportsSettings;
    }

    public UnaryCallSettings<GetMetadataImportRequest, MetadataImport> getMetadataImportSettings() {
        return this.getMetadataImportSettings;
    }

    public UnaryCallSettings<CreateMetadataImportRequest, Operation> createMetadataImportSettings() {
        return this.createMetadataImportSettings;
    }

    public OperationCallSettings<CreateMetadataImportRequest, MetadataImport, OperationMetadata> createMetadataImportOperationSettings() {
        return this.createMetadataImportOperationSettings;
    }

    public UnaryCallSettings<UpdateMetadataImportRequest, Operation> updateMetadataImportSettings() {
        return this.updateMetadataImportSettings;
    }

    public OperationCallSettings<UpdateMetadataImportRequest, MetadataImport, OperationMetadata> updateMetadataImportOperationSettings() {
        return this.updateMetadataImportOperationSettings;
    }

    public UnaryCallSettings<ExportMetadataRequest, Operation> exportMetadataSettings() {
        return this.exportMetadataSettings;
    }

    public OperationCallSettings<ExportMetadataRequest, MetadataExport, OperationMetadata> exportMetadataOperationSettings() {
        return this.exportMetadataOperationSettings;
    }

    public UnaryCallSettings<RestoreServiceRequest, Operation> restoreServiceSettings() {
        return this.restoreServiceSettings;
    }

    public OperationCallSettings<RestoreServiceRequest, Restore, OperationMetadata> restoreServiceOperationSettings() {
        return this.restoreServiceOperationSettings;
    }

    public PagedCallSettings<ListBackupsRequest, ListBackupsResponse, DataprocMetastoreClient.ListBackupsPagedResponse> listBackupsSettings() {
        return this.listBackupsSettings;
    }

    public UnaryCallSettings<GetBackupRequest, Backup> getBackupSettings() {
        return this.getBackupSettings;
    }

    public UnaryCallSettings<CreateBackupRequest, Operation> createBackupSettings() {
        return this.createBackupSettings;
    }

    public OperationCallSettings<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationSettings() {
        return this.createBackupOperationSettings;
    }

    public UnaryCallSettings<DeleteBackupRequest, Operation> deleteBackupSettings() {
        return this.deleteBackupSettings;
    }

    public OperationCallSettings<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationSettings() {
        return this.deleteBackupOperationSettings;
    }

    public UnaryCallSettings<RemoveIamPolicyRequest, RemoveIamPolicyResponse> removeIamPolicySettings() {
        return this.removeIamPolicySettings;
    }

    public UnaryCallSettings<QueryMetadataRequest, Operation> queryMetadataSettings() {
        return this.queryMetadataSettings;
    }

    public OperationCallSettings<QueryMetadataRequest, QueryMetadataResponse, OperationMetadata> queryMetadataOperationSettings() {
        return this.queryMetadataOperationSettings;
    }

    public UnaryCallSettings<MoveTableToDatabaseRequest, Operation> moveTableToDatabaseSettings() {
        return this.moveTableToDatabaseSettings;
    }

    public OperationCallSettings<MoveTableToDatabaseRequest, MoveTableToDatabaseResponse, OperationMetadata> moveTableToDatabaseOperationSettings() {
        return this.moveTableToDatabaseOperationSettings;
    }

    public UnaryCallSettings<AlterMetadataResourceLocationRequest, Operation> alterMetadataResourceLocationSettings() {
        return this.alterMetadataResourceLocationSettings;
    }

    public OperationCallSettings<AlterMetadataResourceLocationRequest, AlterMetadataResourceLocationResponse, OperationMetadata> alterMetadataResourceLocationOperationSettings() {
        return this.alterMetadataResourceLocationOperationSettings;
    }

    public DataprocMetastoreStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataprocMetastoreStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDataprocMetastoreStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "metastore.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "metastore.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataprocMetastoreStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataprocMetastoreStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataprocMetastoreStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DataprocMetastoreStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataprocMetastoreStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listServicesSettings = settingsBuilder.listServicesSettings().build();
        this.getServiceSettings = settingsBuilder.getServiceSettings().build();
        this.createServiceSettings = settingsBuilder.createServiceSettings().build();
        this.createServiceOperationSettings = settingsBuilder.createServiceOperationSettings().build();
        this.updateServiceSettings = settingsBuilder.updateServiceSettings().build();
        this.updateServiceOperationSettings = settingsBuilder.updateServiceOperationSettings().build();
        this.deleteServiceSettings = settingsBuilder.deleteServiceSettings().build();
        this.deleteServiceOperationSettings = settingsBuilder.deleteServiceOperationSettings().build();
        this.listMetadataImportsSettings = settingsBuilder.listMetadataImportsSettings().build();
        this.getMetadataImportSettings = settingsBuilder.getMetadataImportSettings().build();
        this.createMetadataImportSettings = settingsBuilder.createMetadataImportSettings().build();
        this.createMetadataImportOperationSettings = settingsBuilder.createMetadataImportOperationSettings().build();
        this.updateMetadataImportSettings = settingsBuilder.updateMetadataImportSettings().build();
        this.updateMetadataImportOperationSettings = settingsBuilder.updateMetadataImportOperationSettings().build();
        this.exportMetadataSettings = settingsBuilder.exportMetadataSettings().build();
        this.exportMetadataOperationSettings = settingsBuilder.exportMetadataOperationSettings().build();
        this.restoreServiceSettings = settingsBuilder.restoreServiceSettings().build();
        this.restoreServiceOperationSettings = settingsBuilder.restoreServiceOperationSettings().build();
        this.listBackupsSettings = settingsBuilder.listBackupsSettings().build();
        this.getBackupSettings = settingsBuilder.getBackupSettings().build();
        this.createBackupSettings = settingsBuilder.createBackupSettings().build();
        this.createBackupOperationSettings = settingsBuilder.createBackupOperationSettings().build();
        this.deleteBackupSettings = settingsBuilder.deleteBackupSettings().build();
        this.deleteBackupOperationSettings = settingsBuilder.deleteBackupOperationSettings().build();
        this.removeIamPolicySettings = settingsBuilder.removeIamPolicySettings().build();
        this.queryMetadataSettings = settingsBuilder.queryMetadataSettings().build();
        this.queryMetadataOperationSettings = settingsBuilder.queryMetadataOperationSettings().build();
        this.moveTableToDatabaseSettings = settingsBuilder.moveTableToDatabaseSettings().build();
        this.moveTableToDatabaseOperationSettings = settingsBuilder.moveTableToDatabaseOperationSettings().build();
        this.alterMetadataResourceLocationSettings = settingsBuilder.alterMetadataResourceLocationSettings().build();
        this.alterMetadataResourceLocationOperationSettings = settingsBuilder.alterMetadataResourceLocationOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataprocMetastoreStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, DataprocMetastoreClient.ListServicesPagedResponse> listServicesSettings;
        private final UnaryCallSettings.Builder<GetServiceRequest, Service> getServiceSettings;
        private final UnaryCallSettings.Builder<CreateServiceRequest, Operation> createServiceSettings;
        private final OperationCallSettings.Builder<CreateServiceRequest, Service, OperationMetadata> createServiceOperationSettings;
        private final UnaryCallSettings.Builder<UpdateServiceRequest, Operation> updateServiceSettings;
        private final OperationCallSettings.Builder<UpdateServiceRequest, Service, OperationMetadata> updateServiceOperationSettings;
        private final UnaryCallSettings.Builder<DeleteServiceRequest, Operation> deleteServiceSettings;
        private final OperationCallSettings.Builder<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationSettings;
        private final PagedCallSettings.Builder<ListMetadataImportsRequest, ListMetadataImportsResponse, DataprocMetastoreClient.ListMetadataImportsPagedResponse> listMetadataImportsSettings;
        private final UnaryCallSettings.Builder<GetMetadataImportRequest, MetadataImport> getMetadataImportSettings;
        private final UnaryCallSettings.Builder<CreateMetadataImportRequest, Operation> createMetadataImportSettings;
        private final OperationCallSettings.Builder<CreateMetadataImportRequest, MetadataImport, OperationMetadata> createMetadataImportOperationSettings;
        private final UnaryCallSettings.Builder<UpdateMetadataImportRequest, Operation> updateMetadataImportSettings;
        private final OperationCallSettings.Builder<UpdateMetadataImportRequest, MetadataImport, OperationMetadata> updateMetadataImportOperationSettings;
        private final UnaryCallSettings.Builder<ExportMetadataRequest, Operation> exportMetadataSettings;
        private final OperationCallSettings.Builder<ExportMetadataRequest, MetadataExport, OperationMetadata> exportMetadataOperationSettings;
        private final UnaryCallSettings.Builder<RestoreServiceRequest, Operation> restoreServiceSettings;
        private final OperationCallSettings.Builder<RestoreServiceRequest, Restore, OperationMetadata> restoreServiceOperationSettings;
        private final PagedCallSettings.Builder<ListBackupsRequest, ListBackupsResponse, DataprocMetastoreClient.ListBackupsPagedResponse> listBackupsSettings;
        private final UnaryCallSettings.Builder<GetBackupRequest, Backup> getBackupSettings;
        private final UnaryCallSettings.Builder<CreateBackupRequest, Operation> createBackupSettings;
        private final OperationCallSettings.Builder<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationSettings;
        private final UnaryCallSettings.Builder<DeleteBackupRequest, Operation> deleteBackupSettings;
        private final OperationCallSettings.Builder<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationSettings;
        private final UnaryCallSettings.Builder<RemoveIamPolicyRequest, RemoveIamPolicyResponse> removeIamPolicySettings;
        private final UnaryCallSettings.Builder<QueryMetadataRequest, Operation> queryMetadataSettings;
        private final OperationCallSettings.Builder<QueryMetadataRequest, QueryMetadataResponse, OperationMetadata> queryMetadataOperationSettings;
        private final UnaryCallSettings.Builder<MoveTableToDatabaseRequest, Operation> moveTableToDatabaseSettings;
        private final OperationCallSettings.Builder<MoveTableToDatabaseRequest, MoveTableToDatabaseResponse, OperationMetadata> moveTableToDatabaseOperationSettings;
        private final UnaryCallSettings.Builder<AlterMetadataResourceLocationRequest, Operation> alterMetadataResourceLocationSettings;
        private final OperationCallSettings.Builder<AlterMetadataResourceLocationRequest, AlterMetadataResourceLocationResponse, OperationMetadata> alterMetadataResourceLocationOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listServicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICES_PAGE_STR_FACT);
            this.getServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceOperationSettings = OperationCallSettings.newBuilder();
            this.updateServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateServiceOperationSettings = OperationCallSettings.newBuilder();
            this.deleteServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceOperationSettings = OperationCallSettings.newBuilder();
            this.listMetadataImportsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_METADATA_IMPORTS_PAGE_STR_FACT);
            this.getMetadataImportSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMetadataImportSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMetadataImportOperationSettings = OperationCallSettings.newBuilder();
            this.updateMetadataImportSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateMetadataImportOperationSettings = OperationCallSettings.newBuilder();
            this.exportMetadataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportMetadataOperationSettings = OperationCallSettings.newBuilder();
            this.restoreServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restoreServiceOperationSettings = OperationCallSettings.newBuilder();
            this.listBackupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BACKUPS_PAGE_STR_FACT);
            this.getBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBackupOperationSettings = OperationCallSettings.newBuilder();
            this.deleteBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteBackupOperationSettings = OperationCallSettings.newBuilder();
            this.removeIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.queryMetadataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.queryMetadataOperationSettings = OperationCallSettings.newBuilder();
            this.moveTableToDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.moveTableToDatabaseOperationSettings = OperationCallSettings.newBuilder();
            this.alterMetadataResourceLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.alterMetadataResourceLocationOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listServicesSettings, this.getServiceSettings, this.createServiceSettings, this.updateServiceSettings, this.deleteServiceSettings, this.listMetadataImportsSettings, this.getMetadataImportSettings, this.createMetadataImportSettings, this.updateMetadataImportSettings, this.exportMetadataSettings, this.restoreServiceSettings, this.listBackupsSettings, (Object[])new UnaryCallSettings.Builder[]{this.getBackupSettings, this.createBackupSettings, this.deleteBackupSettings, this.removeIamPolicySettings, this.queryMetadataSettings, this.moveTableToDatabaseSettings, this.alterMetadataResourceLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(DataprocMetastoreStubSettings settings) {
            super((StubSettings)settings);
            this.listServicesSettings = settings.listServicesSettings.toBuilder();
            this.getServiceSettings = settings.getServiceSettings.toBuilder();
            this.createServiceSettings = settings.createServiceSettings.toBuilder();
            this.createServiceOperationSettings = settings.createServiceOperationSettings.toBuilder();
            this.updateServiceSettings = settings.updateServiceSettings.toBuilder();
            this.updateServiceOperationSettings = settings.updateServiceOperationSettings.toBuilder();
            this.deleteServiceSettings = settings.deleteServiceSettings.toBuilder();
            this.deleteServiceOperationSettings = settings.deleteServiceOperationSettings.toBuilder();
            this.listMetadataImportsSettings = settings.listMetadataImportsSettings.toBuilder();
            this.getMetadataImportSettings = settings.getMetadataImportSettings.toBuilder();
            this.createMetadataImportSettings = settings.createMetadataImportSettings.toBuilder();
            this.createMetadataImportOperationSettings = settings.createMetadataImportOperationSettings.toBuilder();
            this.updateMetadataImportSettings = settings.updateMetadataImportSettings.toBuilder();
            this.updateMetadataImportOperationSettings = settings.updateMetadataImportOperationSettings.toBuilder();
            this.exportMetadataSettings = settings.exportMetadataSettings.toBuilder();
            this.exportMetadataOperationSettings = settings.exportMetadataOperationSettings.toBuilder();
            this.restoreServiceSettings = settings.restoreServiceSettings.toBuilder();
            this.restoreServiceOperationSettings = settings.restoreServiceOperationSettings.toBuilder();
            this.listBackupsSettings = settings.listBackupsSettings.toBuilder();
            this.getBackupSettings = settings.getBackupSettings.toBuilder();
            this.createBackupSettings = settings.createBackupSettings.toBuilder();
            this.createBackupOperationSettings = settings.createBackupOperationSettings.toBuilder();
            this.deleteBackupSettings = settings.deleteBackupSettings.toBuilder();
            this.deleteBackupOperationSettings = settings.deleteBackupOperationSettings.toBuilder();
            this.removeIamPolicySettings = settings.removeIamPolicySettings.toBuilder();
            this.queryMetadataSettings = settings.queryMetadataSettings.toBuilder();
            this.queryMetadataOperationSettings = settings.queryMetadataOperationSettings.toBuilder();
            this.moveTableToDatabaseSettings = settings.moveTableToDatabaseSettings.toBuilder();
            this.moveTableToDatabaseOperationSettings = settings.moveTableToDatabaseOperationSettings.toBuilder();
            this.alterMetadataResourceLocationSettings = settings.alterMetadataResourceLocationSettings.toBuilder();
            this.alterMetadataResourceLocationOperationSettings = settings.alterMetadataResourceLocationOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listServicesSettings, this.getServiceSettings, this.createServiceSettings, this.updateServiceSettings, this.deleteServiceSettings, this.listMetadataImportsSettings, this.getMetadataImportSettings, this.createMetadataImportSettings, this.updateMetadataImportSettings, this.exportMetadataSettings, this.restoreServiceSettings, this.listBackupsSettings, (Object[])new UnaryCallSettings.Builder[]{this.getBackupSettings, this.createBackupSettings, this.deleteBackupSettings, this.removeIamPolicySettings, this.queryMetadataSettings, this.moveTableToDatabaseSettings, this.alterMetadataResourceLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataprocMetastoreStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataprocMetastoreStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataprocMetastoreStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DataprocMetastoreStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DataprocMetastoreStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DataprocMetastoreStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DataprocMetastoreStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataprocMetastoreStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DataprocMetastoreStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DataprocMetastoreStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listMetadataImportsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getMetadataImportSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createMetadataImportSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateMetadataImportSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.exportMetadataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.restoreServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listBackupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removeIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.queryMetadataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.moveTableToDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.alterMetadataResourceLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Service.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)120000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)4800000L)).build()));
            builder.updateServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Service.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)120000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)3000000L)).build()));
            builder.deleteServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)10000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)1500000L)).build()));
            builder.createMetadataImportOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MetadataImport.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)120000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)4800000L)).build()));
            builder.updateMetadataImportOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MetadataImport.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)120000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)1200000L)).build()));
            builder.exportMetadataOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MetadataExport.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)120000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)4800000L)).build()));
            builder.restoreServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Restore.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)120000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)4800000L)).build()));
            builder.createBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Backup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)120000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)4800000L)).build()));
            builder.deleteBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)10000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)1500000L)).build()));
            builder.queryMetadataOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(QueryMetadataResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.moveTableToDatabaseOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MoveTableToDatabaseResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.alterMetadataResourceLocationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AlterMetadataResourceLocationResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, DataprocMetastoreClient.ListServicesPagedResponse> listServicesSettings() {
            return this.listServicesSettings;
        }

        public UnaryCallSettings.Builder<GetServiceRequest, Service> getServiceSettings() {
            return this.getServiceSettings;
        }

        public UnaryCallSettings.Builder<CreateServiceRequest, Operation> createServiceSettings() {
            return this.createServiceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateServiceRequest, Service, OperationMetadata> createServiceOperationSettings() {
            return this.createServiceOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateServiceRequest, Operation> updateServiceSettings() {
            return this.updateServiceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateServiceRequest, Service, OperationMetadata> updateServiceOperationSettings() {
            return this.updateServiceOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceRequest, Operation> deleteServiceSettings() {
            return this.deleteServiceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationSettings() {
            return this.deleteServiceOperationSettings;
        }

        public PagedCallSettings.Builder<ListMetadataImportsRequest, ListMetadataImportsResponse, DataprocMetastoreClient.ListMetadataImportsPagedResponse> listMetadataImportsSettings() {
            return this.listMetadataImportsSettings;
        }

        public UnaryCallSettings.Builder<GetMetadataImportRequest, MetadataImport> getMetadataImportSettings() {
            return this.getMetadataImportSettings;
        }

        public UnaryCallSettings.Builder<CreateMetadataImportRequest, Operation> createMetadataImportSettings() {
            return this.createMetadataImportSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateMetadataImportRequest, MetadataImport, OperationMetadata> createMetadataImportOperationSettings() {
            return this.createMetadataImportOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateMetadataImportRequest, Operation> updateMetadataImportSettings() {
            return this.updateMetadataImportSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateMetadataImportRequest, MetadataImport, OperationMetadata> updateMetadataImportOperationSettings() {
            return this.updateMetadataImportOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportMetadataRequest, Operation> exportMetadataSettings() {
            return this.exportMetadataSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ExportMetadataRequest, MetadataExport, OperationMetadata> exportMetadataOperationSettings() {
            return this.exportMetadataOperationSettings;
        }

        public UnaryCallSettings.Builder<RestoreServiceRequest, Operation> restoreServiceSettings() {
            return this.restoreServiceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RestoreServiceRequest, Restore, OperationMetadata> restoreServiceOperationSettings() {
            return this.restoreServiceOperationSettings;
        }

        public PagedCallSettings.Builder<ListBackupsRequest, ListBackupsResponse, DataprocMetastoreClient.ListBackupsPagedResponse> listBackupsSettings() {
            return this.listBackupsSettings;
        }

        public UnaryCallSettings.Builder<GetBackupRequest, Backup> getBackupSettings() {
            return this.getBackupSettings;
        }

        public UnaryCallSettings.Builder<CreateBackupRequest, Operation> createBackupSettings() {
            return this.createBackupSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationSettings() {
            return this.createBackupOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteBackupRequest, Operation> deleteBackupSettings() {
            return this.deleteBackupSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationSettings() {
            return this.deleteBackupOperationSettings;
        }

        public UnaryCallSettings.Builder<RemoveIamPolicyRequest, RemoveIamPolicyResponse> removeIamPolicySettings() {
            return this.removeIamPolicySettings;
        }

        public UnaryCallSettings.Builder<QueryMetadataRequest, Operation> queryMetadataSettings() {
            return this.queryMetadataSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<QueryMetadataRequest, QueryMetadataResponse, OperationMetadata> queryMetadataOperationSettings() {
            return this.queryMetadataOperationSettings;
        }

        public UnaryCallSettings.Builder<MoveTableToDatabaseRequest, Operation> moveTableToDatabaseSettings() {
            return this.moveTableToDatabaseSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<MoveTableToDatabaseRequest, MoveTableToDatabaseResponse, OperationMetadata> moveTableToDatabaseOperationSettings() {
            return this.moveTableToDatabaseOperationSettings;
        }

        public UnaryCallSettings.Builder<AlterMetadataResourceLocationRequest, Operation> alterMetadataResourceLocationSettings() {
            return this.alterMetadataResourceLocationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<AlterMetadataResourceLocationRequest, AlterMetadataResourceLocationResponse, OperationMetadata> alterMetadataResourceLocationOperationSettings() {
            return this.alterMetadataResourceLocationOperationSettings;
        }

        public DataprocMetastoreStubSettings build() throws IOException {
            return new DataprocMetastoreStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

