/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.CmekServiceClient;
import com.google.cloud.dataplex.v1.CreateEncryptionConfigRequest;
import com.google.cloud.dataplex.v1.DeleteEncryptionConfigRequest;
import com.google.cloud.dataplex.v1.EncryptionConfig;
import com.google.cloud.dataplex.v1.GetEncryptionConfigRequest;
import com.google.cloud.dataplex.v1.ListEncryptionConfigsRequest;
import com.google.cloud.dataplex.v1.ListEncryptionConfigsResponse;
import com.google.cloud.dataplex.v1.OperationMetadata;
import com.google.cloud.dataplex.v1.UpdateEncryptionConfigRequest;
import com.google.cloud.dataplex.v1.stub.CmekServiceStub;
import com.google.cloud.dataplex.v1.stub.CmekServiceStubSettings;
import com.google.cloud.dataplex.v1.stub.GrpcCmekServiceCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcCmekServiceStub
extends CmekServiceStub {
    private static final MethodDescriptor<CreateEncryptionConfigRequest, Operation> createEncryptionConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.CmekService/CreateEncryptionConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateEncryptionConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateEncryptionConfigRequest, Operation> updateEncryptionConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.CmekService/UpdateEncryptionConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateEncryptionConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteEncryptionConfigRequest, Operation> deleteEncryptionConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.CmekService/DeleteEncryptionConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteEncryptionConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse> listEncryptionConfigsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.CmekService/ListEncryptionConfigs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListEncryptionConfigsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListEncryptionConfigsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetEncryptionConfigRequest, EncryptionConfig> getEncryptionConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.CmekService/GetEncryptionConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetEncryptionConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)EncryptionConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateEncryptionConfigRequest, Operation> createEncryptionConfigCallable;
    private final OperationCallable<CreateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> createEncryptionConfigOperationCallable;
    private final UnaryCallable<UpdateEncryptionConfigRequest, Operation> updateEncryptionConfigCallable;
    private final OperationCallable<UpdateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> updateEncryptionConfigOperationCallable;
    private final UnaryCallable<DeleteEncryptionConfigRequest, Operation> deleteEncryptionConfigCallable;
    private final OperationCallable<DeleteEncryptionConfigRequest, Empty, OperationMetadata> deleteEncryptionConfigOperationCallable;
    private final UnaryCallable<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse> listEncryptionConfigsCallable;
    private final UnaryCallable<ListEncryptionConfigsRequest, CmekServiceClient.ListEncryptionConfigsPagedResponse> listEncryptionConfigsPagedCallable;
    private final UnaryCallable<GetEncryptionConfigRequest, EncryptionConfig> getEncryptionConfigCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, CmekServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCmekServiceStub create(CmekServiceStubSettings settings) throws IOException {
        return new GrpcCmekServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCmekServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCmekServiceStub(CmekServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCmekServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCmekServiceStub(CmekServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCmekServiceStub(CmekServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCmekServiceCallableFactory());
    }

    protected GrpcCmekServiceStub(CmekServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createEncryptionConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createEncryptionConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateEncryptionConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateEncryptionConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("encryption_config.name", String.valueOf(request.getEncryptionConfig().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteEncryptionConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteEncryptionConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listEncryptionConfigsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listEncryptionConfigsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getEncryptionConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getEncryptionConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createEncryptionConfigCallable = callableFactory.createUnaryCallable(createEncryptionConfigTransportSettings, settings.createEncryptionConfigSettings(), clientContext);
        this.createEncryptionConfigOperationCallable = callableFactory.createOperationCallable(createEncryptionConfigTransportSettings, settings.createEncryptionConfigOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateEncryptionConfigCallable = callableFactory.createUnaryCallable(updateEncryptionConfigTransportSettings, settings.updateEncryptionConfigSettings(), clientContext);
        this.updateEncryptionConfigOperationCallable = callableFactory.createOperationCallable(updateEncryptionConfigTransportSettings, settings.updateEncryptionConfigOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteEncryptionConfigCallable = callableFactory.createUnaryCallable(deleteEncryptionConfigTransportSettings, settings.deleteEncryptionConfigSettings(), clientContext);
        this.deleteEncryptionConfigOperationCallable = callableFactory.createOperationCallable(deleteEncryptionConfigTransportSettings, settings.deleteEncryptionConfigOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listEncryptionConfigsCallable = callableFactory.createUnaryCallable(listEncryptionConfigsTransportSettings, settings.listEncryptionConfigsSettings(), clientContext);
        this.listEncryptionConfigsPagedCallable = callableFactory.createPagedCallable(listEncryptionConfigsTransportSettings, settings.listEncryptionConfigsSettings(), clientContext);
        this.getEncryptionConfigCallable = callableFactory.createUnaryCallable(getEncryptionConfigTransportSettings, settings.getEncryptionConfigSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateEncryptionConfigRequest, Operation> createEncryptionConfigCallable() {
        return this.createEncryptionConfigCallable;
    }

    @Override
    public OperationCallable<CreateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> createEncryptionConfigOperationCallable() {
        return this.createEncryptionConfigOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateEncryptionConfigRequest, Operation> updateEncryptionConfigCallable() {
        return this.updateEncryptionConfigCallable;
    }

    @Override
    public OperationCallable<UpdateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> updateEncryptionConfigOperationCallable() {
        return this.updateEncryptionConfigOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteEncryptionConfigRequest, Operation> deleteEncryptionConfigCallable() {
        return this.deleteEncryptionConfigCallable;
    }

    @Override
    public OperationCallable<DeleteEncryptionConfigRequest, Empty, OperationMetadata> deleteEncryptionConfigOperationCallable() {
        return this.deleteEncryptionConfigOperationCallable;
    }

    @Override
    public UnaryCallable<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse> listEncryptionConfigsCallable() {
        return this.listEncryptionConfigsCallable;
    }

    @Override
    public UnaryCallable<ListEncryptionConfigsRequest, CmekServiceClient.ListEncryptionConfigsPagedResponse> listEncryptionConfigsPagedCallable() {
        return this.listEncryptionConfigsPagedCallable;
    }

    @Override
    public UnaryCallable<GetEncryptionConfigRequest, EncryptionConfig> getEncryptionConfigCallable() {
        return this.getEncryptionConfigCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, CmekServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

