/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.BusinessGlossaryServiceClient;
import com.google.cloud.dataplex.v1.CreateGlossaryCategoryRequest;
import com.google.cloud.dataplex.v1.CreateGlossaryRequest;
import com.google.cloud.dataplex.v1.CreateGlossaryTermRequest;
import com.google.cloud.dataplex.v1.DeleteGlossaryCategoryRequest;
import com.google.cloud.dataplex.v1.DeleteGlossaryRequest;
import com.google.cloud.dataplex.v1.DeleteGlossaryTermRequest;
import com.google.cloud.dataplex.v1.GetGlossaryCategoryRequest;
import com.google.cloud.dataplex.v1.GetGlossaryRequest;
import com.google.cloud.dataplex.v1.GetGlossaryTermRequest;
import com.google.cloud.dataplex.v1.Glossary;
import com.google.cloud.dataplex.v1.GlossaryCategory;
import com.google.cloud.dataplex.v1.GlossaryTerm;
import com.google.cloud.dataplex.v1.ListGlossariesRequest;
import com.google.cloud.dataplex.v1.ListGlossariesResponse;
import com.google.cloud.dataplex.v1.ListGlossaryCategoriesRequest;
import com.google.cloud.dataplex.v1.ListGlossaryCategoriesResponse;
import com.google.cloud.dataplex.v1.ListGlossaryTermsRequest;
import com.google.cloud.dataplex.v1.ListGlossaryTermsResponse;
import com.google.cloud.dataplex.v1.OperationMetadata;
import com.google.cloud.dataplex.v1.UpdateGlossaryCategoryRequest;
import com.google.cloud.dataplex.v1.UpdateGlossaryRequest;
import com.google.cloud.dataplex.v1.UpdateGlossaryTermRequest;
import com.google.cloud.dataplex.v1.stub.BusinessGlossaryServiceStub;
import com.google.cloud.dataplex.v1.stub.BusinessGlossaryServiceStubSettings;
import com.google.cloud.dataplex.v1.stub.GrpcBusinessGlossaryServiceCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcBusinessGlossaryServiceStub
extends BusinessGlossaryServiceStub {
    private static final MethodDescriptor<CreateGlossaryRequest, Operation> createGlossaryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.BusinessGlossaryService/CreateGlossary").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateGlossaryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateGlossaryRequest, Operation> updateGlossaryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.BusinessGlossaryService/UpdateGlossary").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateGlossaryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteGlossaryRequest, Operation> deleteGlossaryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.BusinessGlossaryService/DeleteGlossary").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteGlossaryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetGlossaryRequest, Glossary> getGlossaryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.BusinessGlossaryService/GetGlossary").setRequestMarshaller(ProtoUtils.marshaller((Message)GetGlossaryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Glossary.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListGlossariesRequest, ListGlossariesResponse> listGlossariesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.BusinessGlossaryService/ListGlossaries").setRequestMarshaller(ProtoUtils.marshaller((Message)ListGlossariesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListGlossariesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateGlossaryCategoryRequest, GlossaryCategory> createGlossaryCategoryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.BusinessGlossaryService/CreateGlossaryCategory").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateGlossaryCategoryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GlossaryCategory.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateGlossaryCategoryRequest, GlossaryCategory> updateGlossaryCategoryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.BusinessGlossaryService/UpdateGlossaryCategory").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateGlossaryCategoryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GlossaryCategory.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteGlossaryCategoryRequest, Empty> deleteGlossaryCategoryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.BusinessGlossaryService/DeleteGlossaryCategory").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteGlossaryCategoryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetGlossaryCategoryRequest, GlossaryCategory> getGlossaryCategoryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.BusinessGlossaryService/GetGlossaryCategory").setRequestMarshaller(ProtoUtils.marshaller((Message)GetGlossaryCategoryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GlossaryCategory.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse> listGlossaryCategoriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.BusinessGlossaryService/ListGlossaryCategories").setRequestMarshaller(ProtoUtils.marshaller((Message)ListGlossaryCategoriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListGlossaryCategoriesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateGlossaryTermRequest, GlossaryTerm> createGlossaryTermMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.BusinessGlossaryService/CreateGlossaryTerm").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateGlossaryTermRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GlossaryTerm.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateGlossaryTermRequest, GlossaryTerm> updateGlossaryTermMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.BusinessGlossaryService/UpdateGlossaryTerm").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateGlossaryTermRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GlossaryTerm.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteGlossaryTermRequest, Empty> deleteGlossaryTermMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.BusinessGlossaryService/DeleteGlossaryTerm").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteGlossaryTermRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetGlossaryTermRequest, GlossaryTerm> getGlossaryTermMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.BusinessGlossaryService/GetGlossaryTerm").setRequestMarshaller(ProtoUtils.marshaller((Message)GetGlossaryTermRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GlossaryTerm.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListGlossaryTermsRequest, ListGlossaryTermsResponse> listGlossaryTermsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.BusinessGlossaryService/ListGlossaryTerms").setRequestMarshaller(ProtoUtils.marshaller((Message)ListGlossaryTermsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListGlossaryTermsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateGlossaryRequest, Operation> createGlossaryCallable;
    private final OperationCallable<CreateGlossaryRequest, Glossary, OperationMetadata> createGlossaryOperationCallable;
    private final UnaryCallable<UpdateGlossaryRequest, Operation> updateGlossaryCallable;
    private final OperationCallable<UpdateGlossaryRequest, Glossary, OperationMetadata> updateGlossaryOperationCallable;
    private final UnaryCallable<DeleteGlossaryRequest, Operation> deleteGlossaryCallable;
    private final OperationCallable<DeleteGlossaryRequest, Empty, OperationMetadata> deleteGlossaryOperationCallable;
    private final UnaryCallable<GetGlossaryRequest, Glossary> getGlossaryCallable;
    private final UnaryCallable<ListGlossariesRequest, ListGlossariesResponse> listGlossariesCallable;
    private final UnaryCallable<ListGlossariesRequest, BusinessGlossaryServiceClient.ListGlossariesPagedResponse> listGlossariesPagedCallable;
    private final UnaryCallable<CreateGlossaryCategoryRequest, GlossaryCategory> createGlossaryCategoryCallable;
    private final UnaryCallable<UpdateGlossaryCategoryRequest, GlossaryCategory> updateGlossaryCategoryCallable;
    private final UnaryCallable<DeleteGlossaryCategoryRequest, Empty> deleteGlossaryCategoryCallable;
    private final UnaryCallable<GetGlossaryCategoryRequest, GlossaryCategory> getGlossaryCategoryCallable;
    private final UnaryCallable<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse> listGlossaryCategoriesCallable;
    private final UnaryCallable<ListGlossaryCategoriesRequest, BusinessGlossaryServiceClient.ListGlossaryCategoriesPagedResponse> listGlossaryCategoriesPagedCallable;
    private final UnaryCallable<CreateGlossaryTermRequest, GlossaryTerm> createGlossaryTermCallable;
    private final UnaryCallable<UpdateGlossaryTermRequest, GlossaryTerm> updateGlossaryTermCallable;
    private final UnaryCallable<DeleteGlossaryTermRequest, Empty> deleteGlossaryTermCallable;
    private final UnaryCallable<GetGlossaryTermRequest, GlossaryTerm> getGlossaryTermCallable;
    private final UnaryCallable<ListGlossaryTermsRequest, ListGlossaryTermsResponse> listGlossaryTermsCallable;
    private final UnaryCallable<ListGlossaryTermsRequest, BusinessGlossaryServiceClient.ListGlossaryTermsPagedResponse> listGlossaryTermsPagedCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, BusinessGlossaryServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBusinessGlossaryServiceStub create(BusinessGlossaryServiceStubSettings settings) throws IOException {
        return new GrpcBusinessGlossaryServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBusinessGlossaryServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcBusinessGlossaryServiceStub(BusinessGlossaryServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBusinessGlossaryServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBusinessGlossaryServiceStub(BusinessGlossaryServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBusinessGlossaryServiceStub(BusinessGlossaryServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBusinessGlossaryServiceCallableFactory());
    }

    protected GrpcBusinessGlossaryServiceStub(BusinessGlossaryServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createGlossaryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createGlossaryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateGlossaryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateGlossaryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("glossary.name", String.valueOf(request.getGlossary().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteGlossaryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteGlossaryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getGlossaryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getGlossaryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listGlossariesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listGlossariesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createGlossaryCategoryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createGlossaryCategoryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateGlossaryCategoryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateGlossaryCategoryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("category.name", String.valueOf(request.getCategory().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteGlossaryCategoryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteGlossaryCategoryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getGlossaryCategoryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getGlossaryCategoryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listGlossaryCategoriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listGlossaryCategoriesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createGlossaryTermTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createGlossaryTermMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateGlossaryTermTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateGlossaryTermMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("term.name", String.valueOf(request.getTerm().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteGlossaryTermTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteGlossaryTermMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getGlossaryTermTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getGlossaryTermMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listGlossaryTermsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listGlossaryTermsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createGlossaryCallable = callableFactory.createUnaryCallable(createGlossaryTransportSettings, settings.createGlossarySettings(), clientContext);
        this.createGlossaryOperationCallable = callableFactory.createOperationCallable(createGlossaryTransportSettings, settings.createGlossaryOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateGlossaryCallable = callableFactory.createUnaryCallable(updateGlossaryTransportSettings, settings.updateGlossarySettings(), clientContext);
        this.updateGlossaryOperationCallable = callableFactory.createOperationCallable(updateGlossaryTransportSettings, settings.updateGlossaryOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteGlossaryCallable = callableFactory.createUnaryCallable(deleteGlossaryTransportSettings, settings.deleteGlossarySettings(), clientContext);
        this.deleteGlossaryOperationCallable = callableFactory.createOperationCallable(deleteGlossaryTransportSettings, settings.deleteGlossaryOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getGlossaryCallable = callableFactory.createUnaryCallable(getGlossaryTransportSettings, settings.getGlossarySettings(), clientContext);
        this.listGlossariesCallable = callableFactory.createUnaryCallable(listGlossariesTransportSettings, settings.listGlossariesSettings(), clientContext);
        this.listGlossariesPagedCallable = callableFactory.createPagedCallable(listGlossariesTransportSettings, settings.listGlossariesSettings(), clientContext);
        this.createGlossaryCategoryCallable = callableFactory.createUnaryCallable(createGlossaryCategoryTransportSettings, settings.createGlossaryCategorySettings(), clientContext);
        this.updateGlossaryCategoryCallable = callableFactory.createUnaryCallable(updateGlossaryCategoryTransportSettings, settings.updateGlossaryCategorySettings(), clientContext);
        this.deleteGlossaryCategoryCallable = callableFactory.createUnaryCallable(deleteGlossaryCategoryTransportSettings, settings.deleteGlossaryCategorySettings(), clientContext);
        this.getGlossaryCategoryCallable = callableFactory.createUnaryCallable(getGlossaryCategoryTransportSettings, settings.getGlossaryCategorySettings(), clientContext);
        this.listGlossaryCategoriesCallable = callableFactory.createUnaryCallable(listGlossaryCategoriesTransportSettings, settings.listGlossaryCategoriesSettings(), clientContext);
        this.listGlossaryCategoriesPagedCallable = callableFactory.createPagedCallable(listGlossaryCategoriesTransportSettings, settings.listGlossaryCategoriesSettings(), clientContext);
        this.createGlossaryTermCallable = callableFactory.createUnaryCallable(createGlossaryTermTransportSettings, settings.createGlossaryTermSettings(), clientContext);
        this.updateGlossaryTermCallable = callableFactory.createUnaryCallable(updateGlossaryTermTransportSettings, settings.updateGlossaryTermSettings(), clientContext);
        this.deleteGlossaryTermCallable = callableFactory.createUnaryCallable(deleteGlossaryTermTransportSettings, settings.deleteGlossaryTermSettings(), clientContext);
        this.getGlossaryTermCallable = callableFactory.createUnaryCallable(getGlossaryTermTransportSettings, settings.getGlossaryTermSettings(), clientContext);
        this.listGlossaryTermsCallable = callableFactory.createUnaryCallable(listGlossaryTermsTransportSettings, settings.listGlossaryTermsSettings(), clientContext);
        this.listGlossaryTermsPagedCallable = callableFactory.createPagedCallable(listGlossaryTermsTransportSettings, settings.listGlossaryTermsSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateGlossaryRequest, Operation> createGlossaryCallable() {
        return this.createGlossaryCallable;
    }

    @Override
    public OperationCallable<CreateGlossaryRequest, Glossary, OperationMetadata> createGlossaryOperationCallable() {
        return this.createGlossaryOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateGlossaryRequest, Operation> updateGlossaryCallable() {
        return this.updateGlossaryCallable;
    }

    @Override
    public OperationCallable<UpdateGlossaryRequest, Glossary, OperationMetadata> updateGlossaryOperationCallable() {
        return this.updateGlossaryOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteGlossaryRequest, Operation> deleteGlossaryCallable() {
        return this.deleteGlossaryCallable;
    }

    @Override
    public OperationCallable<DeleteGlossaryRequest, Empty, OperationMetadata> deleteGlossaryOperationCallable() {
        return this.deleteGlossaryOperationCallable;
    }

    @Override
    public UnaryCallable<GetGlossaryRequest, Glossary> getGlossaryCallable() {
        return this.getGlossaryCallable;
    }

    @Override
    public UnaryCallable<ListGlossariesRequest, ListGlossariesResponse> listGlossariesCallable() {
        return this.listGlossariesCallable;
    }

    @Override
    public UnaryCallable<ListGlossariesRequest, BusinessGlossaryServiceClient.ListGlossariesPagedResponse> listGlossariesPagedCallable() {
        return this.listGlossariesPagedCallable;
    }

    @Override
    public UnaryCallable<CreateGlossaryCategoryRequest, GlossaryCategory> createGlossaryCategoryCallable() {
        return this.createGlossaryCategoryCallable;
    }

    @Override
    public UnaryCallable<UpdateGlossaryCategoryRequest, GlossaryCategory> updateGlossaryCategoryCallable() {
        return this.updateGlossaryCategoryCallable;
    }

    @Override
    public UnaryCallable<DeleteGlossaryCategoryRequest, Empty> deleteGlossaryCategoryCallable() {
        return this.deleteGlossaryCategoryCallable;
    }

    @Override
    public UnaryCallable<GetGlossaryCategoryRequest, GlossaryCategory> getGlossaryCategoryCallable() {
        return this.getGlossaryCategoryCallable;
    }

    @Override
    public UnaryCallable<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse> listGlossaryCategoriesCallable() {
        return this.listGlossaryCategoriesCallable;
    }

    @Override
    public UnaryCallable<ListGlossaryCategoriesRequest, BusinessGlossaryServiceClient.ListGlossaryCategoriesPagedResponse> listGlossaryCategoriesPagedCallable() {
        return this.listGlossaryCategoriesPagedCallable;
    }

    @Override
    public UnaryCallable<CreateGlossaryTermRequest, GlossaryTerm> createGlossaryTermCallable() {
        return this.createGlossaryTermCallable;
    }

    @Override
    public UnaryCallable<UpdateGlossaryTermRequest, GlossaryTerm> updateGlossaryTermCallable() {
        return this.updateGlossaryTermCallable;
    }

    @Override
    public UnaryCallable<DeleteGlossaryTermRequest, Empty> deleteGlossaryTermCallable() {
        return this.deleteGlossaryTermCallable;
    }

    @Override
    public UnaryCallable<GetGlossaryTermRequest, GlossaryTerm> getGlossaryTermCallable() {
        return this.getGlossaryTermCallable;
    }

    @Override
    public UnaryCallable<ListGlossaryTermsRequest, ListGlossaryTermsResponse> listGlossaryTermsCallable() {
        return this.listGlossaryTermsCallable;
    }

    @Override
    public UnaryCallable<ListGlossaryTermsRequest, BusinessGlossaryServiceClient.ListGlossaryTermsPagedResponse> listGlossaryTermsPagedCallable() {
        return this.listGlossaryTermsPagedCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, BusinessGlossaryServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

