/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.AspectType;
import com.google.cloud.dataplex.v1.CancelMetadataJobRequest;
import com.google.cloud.dataplex.v1.CatalogServiceClient;
import com.google.cloud.dataplex.v1.CreateAspectTypeRequest;
import com.google.cloud.dataplex.v1.CreateEntryGroupRequest;
import com.google.cloud.dataplex.v1.CreateEntryLinkRequest;
import com.google.cloud.dataplex.v1.CreateEntryRequest;
import com.google.cloud.dataplex.v1.CreateEntryTypeRequest;
import com.google.cloud.dataplex.v1.CreateMetadataJobRequest;
import com.google.cloud.dataplex.v1.DeleteAspectTypeRequest;
import com.google.cloud.dataplex.v1.DeleteEntryGroupRequest;
import com.google.cloud.dataplex.v1.DeleteEntryLinkRequest;
import com.google.cloud.dataplex.v1.DeleteEntryRequest;
import com.google.cloud.dataplex.v1.DeleteEntryTypeRequest;
import com.google.cloud.dataplex.v1.Entry;
import com.google.cloud.dataplex.v1.EntryGroup;
import com.google.cloud.dataplex.v1.EntryLink;
import com.google.cloud.dataplex.v1.EntryType;
import com.google.cloud.dataplex.v1.GetAspectTypeRequest;
import com.google.cloud.dataplex.v1.GetEntryGroupRequest;
import com.google.cloud.dataplex.v1.GetEntryLinkRequest;
import com.google.cloud.dataplex.v1.GetEntryRequest;
import com.google.cloud.dataplex.v1.GetEntryTypeRequest;
import com.google.cloud.dataplex.v1.GetMetadataJobRequest;
import com.google.cloud.dataplex.v1.ListAspectTypesRequest;
import com.google.cloud.dataplex.v1.ListAspectTypesResponse;
import com.google.cloud.dataplex.v1.ListEntriesRequest;
import com.google.cloud.dataplex.v1.ListEntriesResponse;
import com.google.cloud.dataplex.v1.ListEntryGroupsRequest;
import com.google.cloud.dataplex.v1.ListEntryGroupsResponse;
import com.google.cloud.dataplex.v1.ListEntryTypesRequest;
import com.google.cloud.dataplex.v1.ListEntryTypesResponse;
import com.google.cloud.dataplex.v1.ListMetadataJobsRequest;
import com.google.cloud.dataplex.v1.ListMetadataJobsResponse;
import com.google.cloud.dataplex.v1.LookupEntryRequest;
import com.google.cloud.dataplex.v1.MetadataJob;
import com.google.cloud.dataplex.v1.OperationMetadata;
import com.google.cloud.dataplex.v1.SearchEntriesRequest;
import com.google.cloud.dataplex.v1.SearchEntriesResponse;
import com.google.cloud.dataplex.v1.SearchEntriesResult;
import com.google.cloud.dataplex.v1.UpdateAspectTypeRequest;
import com.google.cloud.dataplex.v1.UpdateEntryGroupRequest;
import com.google.cloud.dataplex.v1.UpdateEntryRequest;
import com.google.cloud.dataplex.v1.UpdateEntryTypeRequest;
import com.google.cloud.dataplex.v1.stub.CatalogServiceStub;
import com.google.cloud.dataplex.v1.stub.GrpcCatalogServiceStub;
import com.google.cloud.dataplex.v1.stub.HttpJsonCatalogServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CatalogServiceStubSettings
extends StubSettings<CatalogServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateEntryTypeRequest, Operation> createEntryTypeSettings;
    private final OperationCallSettings<CreateEntryTypeRequest, EntryType, OperationMetadata> createEntryTypeOperationSettings;
    private final UnaryCallSettings<UpdateEntryTypeRequest, Operation> updateEntryTypeSettings;
    private final OperationCallSettings<UpdateEntryTypeRequest, EntryType, OperationMetadata> updateEntryTypeOperationSettings;
    private final UnaryCallSettings<DeleteEntryTypeRequest, Operation> deleteEntryTypeSettings;
    private final OperationCallSettings<DeleteEntryTypeRequest, Empty, OperationMetadata> deleteEntryTypeOperationSettings;
    private final PagedCallSettings<ListEntryTypesRequest, ListEntryTypesResponse, CatalogServiceClient.ListEntryTypesPagedResponse> listEntryTypesSettings;
    private final UnaryCallSettings<GetEntryTypeRequest, EntryType> getEntryTypeSettings;
    private final UnaryCallSettings<CreateAspectTypeRequest, Operation> createAspectTypeSettings;
    private final OperationCallSettings<CreateAspectTypeRequest, AspectType, OperationMetadata> createAspectTypeOperationSettings;
    private final UnaryCallSettings<UpdateAspectTypeRequest, Operation> updateAspectTypeSettings;
    private final OperationCallSettings<UpdateAspectTypeRequest, AspectType, OperationMetadata> updateAspectTypeOperationSettings;
    private final UnaryCallSettings<DeleteAspectTypeRequest, Operation> deleteAspectTypeSettings;
    private final OperationCallSettings<DeleteAspectTypeRequest, Empty, OperationMetadata> deleteAspectTypeOperationSettings;
    private final PagedCallSettings<ListAspectTypesRequest, ListAspectTypesResponse, CatalogServiceClient.ListAspectTypesPagedResponse> listAspectTypesSettings;
    private final UnaryCallSettings<GetAspectTypeRequest, AspectType> getAspectTypeSettings;
    private final UnaryCallSettings<CreateEntryGroupRequest, Operation> createEntryGroupSettings;
    private final OperationCallSettings<CreateEntryGroupRequest, EntryGroup, OperationMetadata> createEntryGroupOperationSettings;
    private final UnaryCallSettings<UpdateEntryGroupRequest, Operation> updateEntryGroupSettings;
    private final OperationCallSettings<UpdateEntryGroupRequest, EntryGroup, OperationMetadata> updateEntryGroupOperationSettings;
    private final UnaryCallSettings<DeleteEntryGroupRequest, Operation> deleteEntryGroupSettings;
    private final OperationCallSettings<DeleteEntryGroupRequest, Empty, OperationMetadata> deleteEntryGroupOperationSettings;
    private final PagedCallSettings<ListEntryGroupsRequest, ListEntryGroupsResponse, CatalogServiceClient.ListEntryGroupsPagedResponse> listEntryGroupsSettings;
    private final UnaryCallSettings<GetEntryGroupRequest, EntryGroup> getEntryGroupSettings;
    private final UnaryCallSettings<CreateEntryRequest, Entry> createEntrySettings;
    private final UnaryCallSettings<UpdateEntryRequest, Entry> updateEntrySettings;
    private final UnaryCallSettings<DeleteEntryRequest, Entry> deleteEntrySettings;
    private final PagedCallSettings<ListEntriesRequest, ListEntriesResponse, CatalogServiceClient.ListEntriesPagedResponse> listEntriesSettings;
    private final UnaryCallSettings<GetEntryRequest, Entry> getEntrySettings;
    private final UnaryCallSettings<LookupEntryRequest, Entry> lookupEntrySettings;
    private final PagedCallSettings<SearchEntriesRequest, SearchEntriesResponse, CatalogServiceClient.SearchEntriesPagedResponse> searchEntriesSettings;
    private final UnaryCallSettings<CreateMetadataJobRequest, Operation> createMetadataJobSettings;
    private final OperationCallSettings<CreateMetadataJobRequest, MetadataJob, OperationMetadata> createMetadataJobOperationSettings;
    private final UnaryCallSettings<GetMetadataJobRequest, MetadataJob> getMetadataJobSettings;
    private final PagedCallSettings<ListMetadataJobsRequest, ListMetadataJobsResponse, CatalogServiceClient.ListMetadataJobsPagedResponse> listMetadataJobsSettings;
    private final UnaryCallSettings<CancelMetadataJobRequest, Empty> cancelMetadataJobSettings;
    private final UnaryCallSettings<CreateEntryLinkRequest, EntryLink> createEntryLinkSettings;
    private final UnaryCallSettings<DeleteEntryLinkRequest, EntryLink> deleteEntryLinkSettings;
    private final UnaryCallSettings<GetEntryLinkRequest, EntryLink> getEntryLinkSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, CatalogServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListEntryTypesRequest, ListEntryTypesResponse, EntryType> LIST_ENTRY_TYPES_PAGE_STR_DESC = new PagedListDescriptor<ListEntryTypesRequest, ListEntryTypesResponse, EntryType>(){

        public String emptyToken() {
            return "";
        }

        public ListEntryTypesRequest injectToken(ListEntryTypesRequest payload, String token) {
            return ListEntryTypesRequest.newBuilder((ListEntryTypesRequest)payload).setPageToken(token).build();
        }

        public ListEntryTypesRequest injectPageSize(ListEntryTypesRequest payload, int pageSize) {
            return ListEntryTypesRequest.newBuilder((ListEntryTypesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEntryTypesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEntryTypesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<EntryType> extractResources(ListEntryTypesResponse payload) {
            return payload.getEntryTypesList();
        }
    };
    private static final PagedListDescriptor<ListAspectTypesRequest, ListAspectTypesResponse, AspectType> LIST_ASPECT_TYPES_PAGE_STR_DESC = new PagedListDescriptor<ListAspectTypesRequest, ListAspectTypesResponse, AspectType>(){

        public String emptyToken() {
            return "";
        }

        public ListAspectTypesRequest injectToken(ListAspectTypesRequest payload, String token) {
            return ListAspectTypesRequest.newBuilder((ListAspectTypesRequest)payload).setPageToken(token).build();
        }

        public ListAspectTypesRequest injectPageSize(ListAspectTypesRequest payload, int pageSize) {
            return ListAspectTypesRequest.newBuilder((ListAspectTypesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAspectTypesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAspectTypesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AspectType> extractResources(ListAspectTypesResponse payload) {
            return payload.getAspectTypesList();
        }
    };
    private static final PagedListDescriptor<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup> LIST_ENTRY_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListEntryGroupsRequest injectToken(ListEntryGroupsRequest payload, String token) {
            return ListEntryGroupsRequest.newBuilder((ListEntryGroupsRequest)payload).setPageToken(token).build();
        }

        public ListEntryGroupsRequest injectPageSize(ListEntryGroupsRequest payload, int pageSize) {
            return ListEntryGroupsRequest.newBuilder((ListEntryGroupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEntryGroupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEntryGroupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<EntryGroup> extractResources(ListEntryGroupsResponse payload) {
            return payload.getEntryGroupsList();
        }
    };
    private static final PagedListDescriptor<ListEntriesRequest, ListEntriesResponse, Entry> LIST_ENTRIES_PAGE_STR_DESC = new PagedListDescriptor<ListEntriesRequest, ListEntriesResponse, Entry>(){

        public String emptyToken() {
            return "";
        }

        public ListEntriesRequest injectToken(ListEntriesRequest payload, String token) {
            return ListEntriesRequest.newBuilder((ListEntriesRequest)payload).setPageToken(token).build();
        }

        public ListEntriesRequest injectPageSize(ListEntriesRequest payload, int pageSize) {
            return ListEntriesRequest.newBuilder((ListEntriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEntriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEntriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Entry> extractResources(ListEntriesResponse payload) {
            return payload.getEntriesList();
        }
    };
    private static final PagedListDescriptor<SearchEntriesRequest, SearchEntriesResponse, SearchEntriesResult> SEARCH_ENTRIES_PAGE_STR_DESC = new PagedListDescriptor<SearchEntriesRequest, SearchEntriesResponse, SearchEntriesResult>(){

        public String emptyToken() {
            return "";
        }

        public SearchEntriesRequest injectToken(SearchEntriesRequest payload, String token) {
            return SearchEntriesRequest.newBuilder((SearchEntriesRequest)payload).setPageToken(token).build();
        }

        public SearchEntriesRequest injectPageSize(SearchEntriesRequest payload, int pageSize) {
            return SearchEntriesRequest.newBuilder((SearchEntriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchEntriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchEntriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SearchEntriesResult> extractResources(SearchEntriesResponse payload) {
            return payload.getResultsList();
        }
    };
    private static final PagedListDescriptor<ListMetadataJobsRequest, ListMetadataJobsResponse, MetadataJob> LIST_METADATA_JOBS_PAGE_STR_DESC = new PagedListDescriptor<ListMetadataJobsRequest, ListMetadataJobsResponse, MetadataJob>(){

        public String emptyToken() {
            return "";
        }

        public ListMetadataJobsRequest injectToken(ListMetadataJobsRequest payload, String token) {
            return ListMetadataJobsRequest.newBuilder((ListMetadataJobsRequest)payload).setPageToken(token).build();
        }

        public ListMetadataJobsRequest injectPageSize(ListMetadataJobsRequest payload, int pageSize) {
            return ListMetadataJobsRequest.newBuilder((ListMetadataJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMetadataJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMetadataJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MetadataJob> extractResources(ListMetadataJobsResponse payload) {
            return payload.getMetadataJobsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListEntryTypesRequest, ListEntryTypesResponse, CatalogServiceClient.ListEntryTypesPagedResponse> LIST_ENTRY_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<ListEntryTypesRequest, ListEntryTypesResponse, CatalogServiceClient.ListEntryTypesPagedResponse>(){

        public ApiFuture<CatalogServiceClient.ListEntryTypesPagedResponse> getFuturePagedResponse(UnaryCallable<ListEntryTypesRequest, ListEntryTypesResponse> callable, ListEntryTypesRequest request, ApiCallContext context, ApiFuture<ListEntryTypesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENTRY_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CatalogServiceClient.ListEntryTypesPagedResponse.createAsync((PageContext<ListEntryTypesRequest, ListEntryTypesResponse, EntryType>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAspectTypesRequest, ListAspectTypesResponse, CatalogServiceClient.ListAspectTypesPagedResponse> LIST_ASPECT_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<ListAspectTypesRequest, ListAspectTypesResponse, CatalogServiceClient.ListAspectTypesPagedResponse>(){

        public ApiFuture<CatalogServiceClient.ListAspectTypesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAspectTypesRequest, ListAspectTypesResponse> callable, ListAspectTypesRequest request, ApiCallContext context, ApiFuture<ListAspectTypesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ASPECT_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CatalogServiceClient.ListAspectTypesPagedResponse.createAsync((PageContext<ListAspectTypesRequest, ListAspectTypesResponse, AspectType>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEntryGroupsRequest, ListEntryGroupsResponse, CatalogServiceClient.ListEntryGroupsPagedResponse> LIST_ENTRY_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListEntryGroupsRequest, ListEntryGroupsResponse, CatalogServiceClient.ListEntryGroupsPagedResponse>(){

        public ApiFuture<CatalogServiceClient.ListEntryGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEntryGroupsRequest, ListEntryGroupsResponse> callable, ListEntryGroupsRequest request, ApiCallContext context, ApiFuture<ListEntryGroupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENTRY_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CatalogServiceClient.ListEntryGroupsPagedResponse.createAsync((PageContext<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEntriesRequest, ListEntriesResponse, CatalogServiceClient.ListEntriesPagedResponse> LIST_ENTRIES_PAGE_STR_FACT = new PagedListResponseFactory<ListEntriesRequest, ListEntriesResponse, CatalogServiceClient.ListEntriesPagedResponse>(){

        public ApiFuture<CatalogServiceClient.ListEntriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListEntriesRequest, ListEntriesResponse> callable, ListEntriesRequest request, ApiCallContext context, ApiFuture<ListEntriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENTRIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CatalogServiceClient.ListEntriesPagedResponse.createAsync((PageContext<ListEntriesRequest, ListEntriesResponse, Entry>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchEntriesRequest, SearchEntriesResponse, CatalogServiceClient.SearchEntriesPagedResponse> SEARCH_ENTRIES_PAGE_STR_FACT = new PagedListResponseFactory<SearchEntriesRequest, SearchEntriesResponse, CatalogServiceClient.SearchEntriesPagedResponse>(){

        public ApiFuture<CatalogServiceClient.SearchEntriesPagedResponse> getFuturePagedResponse(UnaryCallable<SearchEntriesRequest, SearchEntriesResponse> callable, SearchEntriesRequest request, ApiCallContext context, ApiFuture<SearchEntriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_ENTRIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CatalogServiceClient.SearchEntriesPagedResponse.createAsync((PageContext<SearchEntriesRequest, SearchEntriesResponse, SearchEntriesResult>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListMetadataJobsRequest, ListMetadataJobsResponse, CatalogServiceClient.ListMetadataJobsPagedResponse> LIST_METADATA_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<ListMetadataJobsRequest, ListMetadataJobsResponse, CatalogServiceClient.ListMetadataJobsPagedResponse>(){

        public ApiFuture<CatalogServiceClient.ListMetadataJobsPagedResponse> getFuturePagedResponse(UnaryCallable<ListMetadataJobsRequest, ListMetadataJobsResponse> callable, ListMetadataJobsRequest request, ApiCallContext context, ApiFuture<ListMetadataJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_METADATA_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CatalogServiceClient.ListMetadataJobsPagedResponse.createAsync((PageContext<ListMetadataJobsRequest, ListMetadataJobsResponse, MetadataJob>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, CatalogServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, CatalogServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<CatalogServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CatalogServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateEntryTypeRequest, Operation> createEntryTypeSettings() {
        return this.createEntryTypeSettings;
    }

    public OperationCallSettings<CreateEntryTypeRequest, EntryType, OperationMetadata> createEntryTypeOperationSettings() {
        return this.createEntryTypeOperationSettings;
    }

    public UnaryCallSettings<UpdateEntryTypeRequest, Operation> updateEntryTypeSettings() {
        return this.updateEntryTypeSettings;
    }

    public OperationCallSettings<UpdateEntryTypeRequest, EntryType, OperationMetadata> updateEntryTypeOperationSettings() {
        return this.updateEntryTypeOperationSettings;
    }

    public UnaryCallSettings<DeleteEntryTypeRequest, Operation> deleteEntryTypeSettings() {
        return this.deleteEntryTypeSettings;
    }

    public OperationCallSettings<DeleteEntryTypeRequest, Empty, OperationMetadata> deleteEntryTypeOperationSettings() {
        return this.deleteEntryTypeOperationSettings;
    }

    public PagedCallSettings<ListEntryTypesRequest, ListEntryTypesResponse, CatalogServiceClient.ListEntryTypesPagedResponse> listEntryTypesSettings() {
        return this.listEntryTypesSettings;
    }

    public UnaryCallSettings<GetEntryTypeRequest, EntryType> getEntryTypeSettings() {
        return this.getEntryTypeSettings;
    }

    public UnaryCallSettings<CreateAspectTypeRequest, Operation> createAspectTypeSettings() {
        return this.createAspectTypeSettings;
    }

    public OperationCallSettings<CreateAspectTypeRequest, AspectType, OperationMetadata> createAspectTypeOperationSettings() {
        return this.createAspectTypeOperationSettings;
    }

    public UnaryCallSettings<UpdateAspectTypeRequest, Operation> updateAspectTypeSettings() {
        return this.updateAspectTypeSettings;
    }

    public OperationCallSettings<UpdateAspectTypeRequest, AspectType, OperationMetadata> updateAspectTypeOperationSettings() {
        return this.updateAspectTypeOperationSettings;
    }

    public UnaryCallSettings<DeleteAspectTypeRequest, Operation> deleteAspectTypeSettings() {
        return this.deleteAspectTypeSettings;
    }

    public OperationCallSettings<DeleteAspectTypeRequest, Empty, OperationMetadata> deleteAspectTypeOperationSettings() {
        return this.deleteAspectTypeOperationSettings;
    }

    public PagedCallSettings<ListAspectTypesRequest, ListAspectTypesResponse, CatalogServiceClient.ListAspectTypesPagedResponse> listAspectTypesSettings() {
        return this.listAspectTypesSettings;
    }

    public UnaryCallSettings<GetAspectTypeRequest, AspectType> getAspectTypeSettings() {
        return this.getAspectTypeSettings;
    }

    public UnaryCallSettings<CreateEntryGroupRequest, Operation> createEntryGroupSettings() {
        return this.createEntryGroupSettings;
    }

    public OperationCallSettings<CreateEntryGroupRequest, EntryGroup, OperationMetadata> createEntryGroupOperationSettings() {
        return this.createEntryGroupOperationSettings;
    }

    public UnaryCallSettings<UpdateEntryGroupRequest, Operation> updateEntryGroupSettings() {
        return this.updateEntryGroupSettings;
    }

    public OperationCallSettings<UpdateEntryGroupRequest, EntryGroup, OperationMetadata> updateEntryGroupOperationSettings() {
        return this.updateEntryGroupOperationSettings;
    }

    public UnaryCallSettings<DeleteEntryGroupRequest, Operation> deleteEntryGroupSettings() {
        return this.deleteEntryGroupSettings;
    }

    public OperationCallSettings<DeleteEntryGroupRequest, Empty, OperationMetadata> deleteEntryGroupOperationSettings() {
        return this.deleteEntryGroupOperationSettings;
    }

    public PagedCallSettings<ListEntryGroupsRequest, ListEntryGroupsResponse, CatalogServiceClient.ListEntryGroupsPagedResponse> listEntryGroupsSettings() {
        return this.listEntryGroupsSettings;
    }

    public UnaryCallSettings<GetEntryGroupRequest, EntryGroup> getEntryGroupSettings() {
        return this.getEntryGroupSettings;
    }

    public UnaryCallSettings<CreateEntryRequest, Entry> createEntrySettings() {
        return this.createEntrySettings;
    }

    public UnaryCallSettings<UpdateEntryRequest, Entry> updateEntrySettings() {
        return this.updateEntrySettings;
    }

    public UnaryCallSettings<DeleteEntryRequest, Entry> deleteEntrySettings() {
        return this.deleteEntrySettings;
    }

    public PagedCallSettings<ListEntriesRequest, ListEntriesResponse, CatalogServiceClient.ListEntriesPagedResponse> listEntriesSettings() {
        return this.listEntriesSettings;
    }

    public UnaryCallSettings<GetEntryRequest, Entry> getEntrySettings() {
        return this.getEntrySettings;
    }

    public UnaryCallSettings<LookupEntryRequest, Entry> lookupEntrySettings() {
        return this.lookupEntrySettings;
    }

    public PagedCallSettings<SearchEntriesRequest, SearchEntriesResponse, CatalogServiceClient.SearchEntriesPagedResponse> searchEntriesSettings() {
        return this.searchEntriesSettings;
    }

    public UnaryCallSettings<CreateMetadataJobRequest, Operation> createMetadataJobSettings() {
        return this.createMetadataJobSettings;
    }

    public OperationCallSettings<CreateMetadataJobRequest, MetadataJob, OperationMetadata> createMetadataJobOperationSettings() {
        return this.createMetadataJobOperationSettings;
    }

    public UnaryCallSettings<GetMetadataJobRequest, MetadataJob> getMetadataJobSettings() {
        return this.getMetadataJobSettings;
    }

    public PagedCallSettings<ListMetadataJobsRequest, ListMetadataJobsResponse, CatalogServiceClient.ListMetadataJobsPagedResponse> listMetadataJobsSettings() {
        return this.listMetadataJobsSettings;
    }

    public UnaryCallSettings<CancelMetadataJobRequest, Empty> cancelMetadataJobSettings() {
        return this.cancelMetadataJobSettings;
    }

    public UnaryCallSettings<CreateEntryLinkRequest, EntryLink> createEntryLinkSettings() {
        return this.createEntryLinkSettings;
    }

    public UnaryCallSettings<DeleteEntryLinkRequest, EntryLink> deleteEntryLinkSettings() {
        return this.deleteEntryLinkSettings;
    }

    public UnaryCallSettings<GetEntryLinkRequest, EntryLink> getEntryLinkSettings() {
        return this.getEntryLinkSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, CatalogServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public CatalogServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCatalogServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCatalogServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dataplex";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "dataplex.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dataplex.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CatalogServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CatalogServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CatalogServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CatalogServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CatalogServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createEntryTypeSettings = settingsBuilder.createEntryTypeSettings().build();
        this.createEntryTypeOperationSettings = settingsBuilder.createEntryTypeOperationSettings().build();
        this.updateEntryTypeSettings = settingsBuilder.updateEntryTypeSettings().build();
        this.updateEntryTypeOperationSettings = settingsBuilder.updateEntryTypeOperationSettings().build();
        this.deleteEntryTypeSettings = settingsBuilder.deleteEntryTypeSettings().build();
        this.deleteEntryTypeOperationSettings = settingsBuilder.deleteEntryTypeOperationSettings().build();
        this.listEntryTypesSettings = settingsBuilder.listEntryTypesSettings().build();
        this.getEntryTypeSettings = settingsBuilder.getEntryTypeSettings().build();
        this.createAspectTypeSettings = settingsBuilder.createAspectTypeSettings().build();
        this.createAspectTypeOperationSettings = settingsBuilder.createAspectTypeOperationSettings().build();
        this.updateAspectTypeSettings = settingsBuilder.updateAspectTypeSettings().build();
        this.updateAspectTypeOperationSettings = settingsBuilder.updateAspectTypeOperationSettings().build();
        this.deleteAspectTypeSettings = settingsBuilder.deleteAspectTypeSettings().build();
        this.deleteAspectTypeOperationSettings = settingsBuilder.deleteAspectTypeOperationSettings().build();
        this.listAspectTypesSettings = settingsBuilder.listAspectTypesSettings().build();
        this.getAspectTypeSettings = settingsBuilder.getAspectTypeSettings().build();
        this.createEntryGroupSettings = settingsBuilder.createEntryGroupSettings().build();
        this.createEntryGroupOperationSettings = settingsBuilder.createEntryGroupOperationSettings().build();
        this.updateEntryGroupSettings = settingsBuilder.updateEntryGroupSettings().build();
        this.updateEntryGroupOperationSettings = settingsBuilder.updateEntryGroupOperationSettings().build();
        this.deleteEntryGroupSettings = settingsBuilder.deleteEntryGroupSettings().build();
        this.deleteEntryGroupOperationSettings = settingsBuilder.deleteEntryGroupOperationSettings().build();
        this.listEntryGroupsSettings = settingsBuilder.listEntryGroupsSettings().build();
        this.getEntryGroupSettings = settingsBuilder.getEntryGroupSettings().build();
        this.createEntrySettings = settingsBuilder.createEntrySettings().build();
        this.updateEntrySettings = settingsBuilder.updateEntrySettings().build();
        this.deleteEntrySettings = settingsBuilder.deleteEntrySettings().build();
        this.listEntriesSettings = settingsBuilder.listEntriesSettings().build();
        this.getEntrySettings = settingsBuilder.getEntrySettings().build();
        this.lookupEntrySettings = settingsBuilder.lookupEntrySettings().build();
        this.searchEntriesSettings = settingsBuilder.searchEntriesSettings().build();
        this.createMetadataJobSettings = settingsBuilder.createMetadataJobSettings().build();
        this.createMetadataJobOperationSettings = settingsBuilder.createMetadataJobOperationSettings().build();
        this.getMetadataJobSettings = settingsBuilder.getMetadataJobSettings().build();
        this.listMetadataJobsSettings = settingsBuilder.listMetadataJobsSettings().build();
        this.cancelMetadataJobSettings = settingsBuilder.cancelMetadataJobSettings().build();
        this.createEntryLinkSettings = settingsBuilder.createEntryLinkSettings().build();
        this.deleteEntryLinkSettings = settingsBuilder.deleteEntryLinkSettings().build();
        this.getEntryLinkSettings = settingsBuilder.getEntryLinkSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CatalogServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateEntryTypeRequest, Operation> createEntryTypeSettings;
        private final OperationCallSettings.Builder<CreateEntryTypeRequest, EntryType, OperationMetadata> createEntryTypeOperationSettings;
        private final UnaryCallSettings.Builder<UpdateEntryTypeRequest, Operation> updateEntryTypeSettings;
        private final OperationCallSettings.Builder<UpdateEntryTypeRequest, EntryType, OperationMetadata> updateEntryTypeOperationSettings;
        private final UnaryCallSettings.Builder<DeleteEntryTypeRequest, Operation> deleteEntryTypeSettings;
        private final OperationCallSettings.Builder<DeleteEntryTypeRequest, Empty, OperationMetadata> deleteEntryTypeOperationSettings;
        private final PagedCallSettings.Builder<ListEntryTypesRequest, ListEntryTypesResponse, CatalogServiceClient.ListEntryTypesPagedResponse> listEntryTypesSettings;
        private final UnaryCallSettings.Builder<GetEntryTypeRequest, EntryType> getEntryTypeSettings;
        private final UnaryCallSettings.Builder<CreateAspectTypeRequest, Operation> createAspectTypeSettings;
        private final OperationCallSettings.Builder<CreateAspectTypeRequest, AspectType, OperationMetadata> createAspectTypeOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAspectTypeRequest, Operation> updateAspectTypeSettings;
        private final OperationCallSettings.Builder<UpdateAspectTypeRequest, AspectType, OperationMetadata> updateAspectTypeOperationSettings;
        private final UnaryCallSettings.Builder<DeleteAspectTypeRequest, Operation> deleteAspectTypeSettings;
        private final OperationCallSettings.Builder<DeleteAspectTypeRequest, Empty, OperationMetadata> deleteAspectTypeOperationSettings;
        private final PagedCallSettings.Builder<ListAspectTypesRequest, ListAspectTypesResponse, CatalogServiceClient.ListAspectTypesPagedResponse> listAspectTypesSettings;
        private final UnaryCallSettings.Builder<GetAspectTypeRequest, AspectType> getAspectTypeSettings;
        private final UnaryCallSettings.Builder<CreateEntryGroupRequest, Operation> createEntryGroupSettings;
        private final OperationCallSettings.Builder<CreateEntryGroupRequest, EntryGroup, OperationMetadata> createEntryGroupOperationSettings;
        private final UnaryCallSettings.Builder<UpdateEntryGroupRequest, Operation> updateEntryGroupSettings;
        private final OperationCallSettings.Builder<UpdateEntryGroupRequest, EntryGroup, OperationMetadata> updateEntryGroupOperationSettings;
        private final UnaryCallSettings.Builder<DeleteEntryGroupRequest, Operation> deleteEntryGroupSettings;
        private final OperationCallSettings.Builder<DeleteEntryGroupRequest, Empty, OperationMetadata> deleteEntryGroupOperationSettings;
        private final PagedCallSettings.Builder<ListEntryGroupsRequest, ListEntryGroupsResponse, CatalogServiceClient.ListEntryGroupsPagedResponse> listEntryGroupsSettings;
        private final UnaryCallSettings.Builder<GetEntryGroupRequest, EntryGroup> getEntryGroupSettings;
        private final UnaryCallSettings.Builder<CreateEntryRequest, Entry> createEntrySettings;
        private final UnaryCallSettings.Builder<UpdateEntryRequest, Entry> updateEntrySettings;
        private final UnaryCallSettings.Builder<DeleteEntryRequest, Entry> deleteEntrySettings;
        private final PagedCallSettings.Builder<ListEntriesRequest, ListEntriesResponse, CatalogServiceClient.ListEntriesPagedResponse> listEntriesSettings;
        private final UnaryCallSettings.Builder<GetEntryRequest, Entry> getEntrySettings;
        private final UnaryCallSettings.Builder<LookupEntryRequest, Entry> lookupEntrySettings;
        private final PagedCallSettings.Builder<SearchEntriesRequest, SearchEntriesResponse, CatalogServiceClient.SearchEntriesPagedResponse> searchEntriesSettings;
        private final UnaryCallSettings.Builder<CreateMetadataJobRequest, Operation> createMetadataJobSettings;
        private final OperationCallSettings.Builder<CreateMetadataJobRequest, MetadataJob, OperationMetadata> createMetadataJobOperationSettings;
        private final UnaryCallSettings.Builder<GetMetadataJobRequest, MetadataJob> getMetadataJobSettings;
        private final PagedCallSettings.Builder<ListMetadataJobsRequest, ListMetadataJobsResponse, CatalogServiceClient.ListMetadataJobsPagedResponse> listMetadataJobsSettings;
        private final UnaryCallSettings.Builder<CancelMetadataJobRequest, Empty> cancelMetadataJobSettings;
        private final UnaryCallSettings.Builder<CreateEntryLinkRequest, EntryLink> createEntryLinkSettings;
        private final UnaryCallSettings.Builder<DeleteEntryLinkRequest, EntryLink> deleteEntryLinkSettings;
        private final UnaryCallSettings.Builder<GetEntryLinkRequest, EntryLink> getEntryLinkSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, CatalogServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createEntryTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEntryTypeOperationSettings = OperationCallSettings.newBuilder();
            this.updateEntryTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEntryTypeOperationSettings = OperationCallSettings.newBuilder();
            this.deleteEntryTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEntryTypeOperationSettings = OperationCallSettings.newBuilder();
            this.listEntryTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENTRY_TYPES_PAGE_STR_FACT);
            this.getEntryTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAspectTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAspectTypeOperationSettings = OperationCallSettings.newBuilder();
            this.updateAspectTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAspectTypeOperationSettings = OperationCallSettings.newBuilder();
            this.deleteAspectTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAspectTypeOperationSettings = OperationCallSettings.newBuilder();
            this.listAspectTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ASPECT_TYPES_PAGE_STR_FACT);
            this.getAspectTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEntryGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEntryGroupOperationSettings = OperationCallSettings.newBuilder();
            this.updateEntryGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEntryGroupOperationSettings = OperationCallSettings.newBuilder();
            this.deleteEntryGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEntryGroupOperationSettings = OperationCallSettings.newBuilder();
            this.listEntryGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENTRY_GROUPS_PAGE_STR_FACT);
            this.getEntryGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEntriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENTRIES_PAGE_STR_FACT);
            this.getEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.lookupEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchEntriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_ENTRIES_PAGE_STR_FACT);
            this.createMetadataJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMetadataJobOperationSettings = OperationCallSettings.newBuilder();
            this.getMetadataJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listMetadataJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_METADATA_JOBS_PAGE_STR_FACT);
            this.cancelMetadataJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEntryLinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEntryLinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getEntryLinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createEntryTypeSettings, this.updateEntryTypeSettings, this.deleteEntryTypeSettings, this.listEntryTypesSettings, this.getEntryTypeSettings, this.createAspectTypeSettings, this.updateAspectTypeSettings, this.deleteAspectTypeSettings, this.listAspectTypesSettings, this.getAspectTypeSettings, this.createEntryGroupSettings, this.updateEntryGroupSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteEntryGroupSettings, this.listEntryGroupsSettings, this.getEntryGroupSettings, this.createEntrySettings, this.updateEntrySettings, this.deleteEntrySettings, this.listEntriesSettings, this.getEntrySettings, this.lookupEntrySettings, this.searchEntriesSettings, this.createMetadataJobSettings, this.getMetadataJobSettings, this.listMetadataJobsSettings, this.cancelMetadataJobSettings, this.createEntryLinkSettings, this.deleteEntryLinkSettings, this.getEntryLinkSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(CatalogServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createEntryTypeSettings = settings.createEntryTypeSettings.toBuilder();
            this.createEntryTypeOperationSettings = settings.createEntryTypeOperationSettings.toBuilder();
            this.updateEntryTypeSettings = settings.updateEntryTypeSettings.toBuilder();
            this.updateEntryTypeOperationSettings = settings.updateEntryTypeOperationSettings.toBuilder();
            this.deleteEntryTypeSettings = settings.deleteEntryTypeSettings.toBuilder();
            this.deleteEntryTypeOperationSettings = settings.deleteEntryTypeOperationSettings.toBuilder();
            this.listEntryTypesSettings = settings.listEntryTypesSettings.toBuilder();
            this.getEntryTypeSettings = settings.getEntryTypeSettings.toBuilder();
            this.createAspectTypeSettings = settings.createAspectTypeSettings.toBuilder();
            this.createAspectTypeOperationSettings = settings.createAspectTypeOperationSettings.toBuilder();
            this.updateAspectTypeSettings = settings.updateAspectTypeSettings.toBuilder();
            this.updateAspectTypeOperationSettings = settings.updateAspectTypeOperationSettings.toBuilder();
            this.deleteAspectTypeSettings = settings.deleteAspectTypeSettings.toBuilder();
            this.deleteAspectTypeOperationSettings = settings.deleteAspectTypeOperationSettings.toBuilder();
            this.listAspectTypesSettings = settings.listAspectTypesSettings.toBuilder();
            this.getAspectTypeSettings = settings.getAspectTypeSettings.toBuilder();
            this.createEntryGroupSettings = settings.createEntryGroupSettings.toBuilder();
            this.createEntryGroupOperationSettings = settings.createEntryGroupOperationSettings.toBuilder();
            this.updateEntryGroupSettings = settings.updateEntryGroupSettings.toBuilder();
            this.updateEntryGroupOperationSettings = settings.updateEntryGroupOperationSettings.toBuilder();
            this.deleteEntryGroupSettings = settings.deleteEntryGroupSettings.toBuilder();
            this.deleteEntryGroupOperationSettings = settings.deleteEntryGroupOperationSettings.toBuilder();
            this.listEntryGroupsSettings = settings.listEntryGroupsSettings.toBuilder();
            this.getEntryGroupSettings = settings.getEntryGroupSettings.toBuilder();
            this.createEntrySettings = settings.createEntrySettings.toBuilder();
            this.updateEntrySettings = settings.updateEntrySettings.toBuilder();
            this.deleteEntrySettings = settings.deleteEntrySettings.toBuilder();
            this.listEntriesSettings = settings.listEntriesSettings.toBuilder();
            this.getEntrySettings = settings.getEntrySettings.toBuilder();
            this.lookupEntrySettings = settings.lookupEntrySettings.toBuilder();
            this.searchEntriesSettings = settings.searchEntriesSettings.toBuilder();
            this.createMetadataJobSettings = settings.createMetadataJobSettings.toBuilder();
            this.createMetadataJobOperationSettings = settings.createMetadataJobOperationSettings.toBuilder();
            this.getMetadataJobSettings = settings.getMetadataJobSettings.toBuilder();
            this.listMetadataJobsSettings = settings.listMetadataJobsSettings.toBuilder();
            this.cancelMetadataJobSettings = settings.cancelMetadataJobSettings.toBuilder();
            this.createEntryLinkSettings = settings.createEntryLinkSettings.toBuilder();
            this.deleteEntryLinkSettings = settings.deleteEntryLinkSettings.toBuilder();
            this.getEntryLinkSettings = settings.getEntryLinkSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createEntryTypeSettings, this.updateEntryTypeSettings, this.deleteEntryTypeSettings, this.listEntryTypesSettings, this.getEntryTypeSettings, this.createAspectTypeSettings, this.updateAspectTypeSettings, this.deleteAspectTypeSettings, this.listAspectTypesSettings, this.getAspectTypeSettings, this.createEntryGroupSettings, this.updateEntryGroupSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteEntryGroupSettings, this.listEntryGroupsSettings, this.getEntryGroupSettings, this.createEntrySettings, this.updateEntrySettings, this.deleteEntrySettings, this.listEntriesSettings, this.getEntrySettings, this.lookupEntrySettings, this.searchEntriesSettings, this.createMetadataJobSettings, this.getMetadataJobSettings, this.listMetadataJobsSettings, this.cancelMetadataJobSettings, this.createEntryLinkSettings, this.deleteEntryLinkSettings, this.getEntryLinkSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CatalogServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CatalogServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CatalogServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CatalogServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CatalogServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CatalogServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CatalogServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CatalogServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createEntryTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params"));
            builder.updateEntryTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params"));
            builder.deleteEntryTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params"));
            builder.listEntryTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_12_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_12_params"));
            builder.getEntryTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_12_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_12_params"));
            builder.createAspectTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params"));
            builder.updateAspectTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params"));
            builder.deleteAspectTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params"));
            builder.listAspectTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_12_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_12_params"));
            builder.getAspectTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_12_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_12_params"));
            builder.createEntryGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params"));
            builder.updateEntryGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params"));
            builder.deleteEntryGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params"));
            builder.listEntryGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_12_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_12_params"));
            builder.getEntryGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_12_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_12_params"));
            builder.createEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.updateEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_10_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_10_params"));
            builder.deleteEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.listEntriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_9_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_9_params"));
            builder.getEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_9_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_9_params"));
            builder.lookupEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_9_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_9_params"));
            builder.searchEntriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_12_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_12_params"));
            builder.createMetadataJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getMetadataJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listMetadataJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.cancelMetadataJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createEntryLinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteEntryLinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getEntryLinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createEntryTypeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(EntryType.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateEntryTypeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(EntryType.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteEntryTypeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createAspectTypeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AspectType.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateAspectTypeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AspectType.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteAspectTypeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createEntryGroupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(EntryGroup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateEntryGroupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(EntryGroup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteEntryGroupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_13_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_13_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createMetadataJobOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MetadataJob.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateEntryTypeRequest, Operation> createEntryTypeSettings() {
            return this.createEntryTypeSettings;
        }

        public OperationCallSettings.Builder<CreateEntryTypeRequest, EntryType, OperationMetadata> createEntryTypeOperationSettings() {
            return this.createEntryTypeOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateEntryTypeRequest, Operation> updateEntryTypeSettings() {
            return this.updateEntryTypeSettings;
        }

        public OperationCallSettings.Builder<UpdateEntryTypeRequest, EntryType, OperationMetadata> updateEntryTypeOperationSettings() {
            return this.updateEntryTypeOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteEntryTypeRequest, Operation> deleteEntryTypeSettings() {
            return this.deleteEntryTypeSettings;
        }

        public OperationCallSettings.Builder<DeleteEntryTypeRequest, Empty, OperationMetadata> deleteEntryTypeOperationSettings() {
            return this.deleteEntryTypeOperationSettings;
        }

        public PagedCallSettings.Builder<ListEntryTypesRequest, ListEntryTypesResponse, CatalogServiceClient.ListEntryTypesPagedResponse> listEntryTypesSettings() {
            return this.listEntryTypesSettings;
        }

        public UnaryCallSettings.Builder<GetEntryTypeRequest, EntryType> getEntryTypeSettings() {
            return this.getEntryTypeSettings;
        }

        public UnaryCallSettings.Builder<CreateAspectTypeRequest, Operation> createAspectTypeSettings() {
            return this.createAspectTypeSettings;
        }

        public OperationCallSettings.Builder<CreateAspectTypeRequest, AspectType, OperationMetadata> createAspectTypeOperationSettings() {
            return this.createAspectTypeOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAspectTypeRequest, Operation> updateAspectTypeSettings() {
            return this.updateAspectTypeSettings;
        }

        public OperationCallSettings.Builder<UpdateAspectTypeRequest, AspectType, OperationMetadata> updateAspectTypeOperationSettings() {
            return this.updateAspectTypeOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteAspectTypeRequest, Operation> deleteAspectTypeSettings() {
            return this.deleteAspectTypeSettings;
        }

        public OperationCallSettings.Builder<DeleteAspectTypeRequest, Empty, OperationMetadata> deleteAspectTypeOperationSettings() {
            return this.deleteAspectTypeOperationSettings;
        }

        public PagedCallSettings.Builder<ListAspectTypesRequest, ListAspectTypesResponse, CatalogServiceClient.ListAspectTypesPagedResponse> listAspectTypesSettings() {
            return this.listAspectTypesSettings;
        }

        public UnaryCallSettings.Builder<GetAspectTypeRequest, AspectType> getAspectTypeSettings() {
            return this.getAspectTypeSettings;
        }

        public UnaryCallSettings.Builder<CreateEntryGroupRequest, Operation> createEntryGroupSettings() {
            return this.createEntryGroupSettings;
        }

        public OperationCallSettings.Builder<CreateEntryGroupRequest, EntryGroup, OperationMetadata> createEntryGroupOperationSettings() {
            return this.createEntryGroupOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateEntryGroupRequest, Operation> updateEntryGroupSettings() {
            return this.updateEntryGroupSettings;
        }

        public OperationCallSettings.Builder<UpdateEntryGroupRequest, EntryGroup, OperationMetadata> updateEntryGroupOperationSettings() {
            return this.updateEntryGroupOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteEntryGroupRequest, Operation> deleteEntryGroupSettings() {
            return this.deleteEntryGroupSettings;
        }

        public OperationCallSettings.Builder<DeleteEntryGroupRequest, Empty, OperationMetadata> deleteEntryGroupOperationSettings() {
            return this.deleteEntryGroupOperationSettings;
        }

        public PagedCallSettings.Builder<ListEntryGroupsRequest, ListEntryGroupsResponse, CatalogServiceClient.ListEntryGroupsPagedResponse> listEntryGroupsSettings() {
            return this.listEntryGroupsSettings;
        }

        public UnaryCallSettings.Builder<GetEntryGroupRequest, EntryGroup> getEntryGroupSettings() {
            return this.getEntryGroupSettings;
        }

        public UnaryCallSettings.Builder<CreateEntryRequest, Entry> createEntrySettings() {
            return this.createEntrySettings;
        }

        public UnaryCallSettings.Builder<UpdateEntryRequest, Entry> updateEntrySettings() {
            return this.updateEntrySettings;
        }

        public UnaryCallSettings.Builder<DeleteEntryRequest, Entry> deleteEntrySettings() {
            return this.deleteEntrySettings;
        }

        public PagedCallSettings.Builder<ListEntriesRequest, ListEntriesResponse, CatalogServiceClient.ListEntriesPagedResponse> listEntriesSettings() {
            return this.listEntriesSettings;
        }

        public UnaryCallSettings.Builder<GetEntryRequest, Entry> getEntrySettings() {
            return this.getEntrySettings;
        }

        public UnaryCallSettings.Builder<LookupEntryRequest, Entry> lookupEntrySettings() {
            return this.lookupEntrySettings;
        }

        public PagedCallSettings.Builder<SearchEntriesRequest, SearchEntriesResponse, CatalogServiceClient.SearchEntriesPagedResponse> searchEntriesSettings() {
            return this.searchEntriesSettings;
        }

        public UnaryCallSettings.Builder<CreateMetadataJobRequest, Operation> createMetadataJobSettings() {
            return this.createMetadataJobSettings;
        }

        public OperationCallSettings.Builder<CreateMetadataJobRequest, MetadataJob, OperationMetadata> createMetadataJobOperationSettings() {
            return this.createMetadataJobOperationSettings;
        }

        public UnaryCallSettings.Builder<GetMetadataJobRequest, MetadataJob> getMetadataJobSettings() {
            return this.getMetadataJobSettings;
        }

        public PagedCallSettings.Builder<ListMetadataJobsRequest, ListMetadataJobsResponse, CatalogServiceClient.ListMetadataJobsPagedResponse> listMetadataJobsSettings() {
            return this.listMetadataJobsSettings;
        }

        public UnaryCallSettings.Builder<CancelMetadataJobRequest, Empty> cancelMetadataJobSettings() {
            return this.cancelMetadataJobSettings;
        }

        public UnaryCallSettings.Builder<CreateEntryLinkRequest, EntryLink> createEntryLinkSettings() {
            return this.createEntryLinkSettings;
        }

        public UnaryCallSettings.Builder<DeleteEntryLinkRequest, EntryLink> deleteEntryLinkSettings() {
            return this.deleteEntryLinkSettings;
        }

        public UnaryCallSettings.Builder<GetEntryLinkRequest, EntryLink> getEntryLinkSettings() {
            return this.getEntryLinkSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, CatalogServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public CatalogServiceStubSettings build() throws IOException {
            return new CatalogServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_13_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_12_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.RESOURCE_EXHAUSTED})));
            definitions.put((Object)"no_retry_11_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_10_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.RESOURCE_EXHAUSTED})));
            definitions.put((Object)"retry_policy_9_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.RESOURCE_EXHAUSTED})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_13_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_12_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_11_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_10_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(20000L)).setTotalTimeoutDuration(Duration.ofMillis(20000L)).build();
            definitions.put((Object)"retry_policy_9_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

