/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.CmekServiceClient;
import com.google.cloud.dataplex.v1.CreateEncryptionConfigRequest;
import com.google.cloud.dataplex.v1.DeleteEncryptionConfigRequest;
import com.google.cloud.dataplex.v1.EncryptionConfig;
import com.google.cloud.dataplex.v1.GetEncryptionConfigRequest;
import com.google.cloud.dataplex.v1.ListEncryptionConfigsRequest;
import com.google.cloud.dataplex.v1.ListEncryptionConfigsResponse;
import com.google.cloud.dataplex.v1.OperationMetadata;
import com.google.cloud.dataplex.v1.UpdateEncryptionConfigRequest;
import com.google.cloud.dataplex.v1.stub.CmekServiceStub;
import com.google.cloud.dataplex.v1.stub.GrpcCmekServiceStub;
import com.google.cloud.dataplex.v1.stub.HttpJsonCmekServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CmekServiceStubSettings
extends StubSettings<CmekServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateEncryptionConfigRequest, Operation> createEncryptionConfigSettings;
    private final OperationCallSettings<CreateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> createEncryptionConfigOperationSettings;
    private final UnaryCallSettings<UpdateEncryptionConfigRequest, Operation> updateEncryptionConfigSettings;
    private final OperationCallSettings<UpdateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> updateEncryptionConfigOperationSettings;
    private final UnaryCallSettings<DeleteEncryptionConfigRequest, Operation> deleteEncryptionConfigSettings;
    private final OperationCallSettings<DeleteEncryptionConfigRequest, Empty, OperationMetadata> deleteEncryptionConfigOperationSettings;
    private final PagedCallSettings<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse, CmekServiceClient.ListEncryptionConfigsPagedResponse> listEncryptionConfigsSettings;
    private final UnaryCallSettings<GetEncryptionConfigRequest, EncryptionConfig> getEncryptionConfigSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, CmekServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse, EncryptionConfig> LIST_ENCRYPTION_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse, EncryptionConfig>(){

        public String emptyToken() {
            return "";
        }

        public ListEncryptionConfigsRequest injectToken(ListEncryptionConfigsRequest payload, String token) {
            return ListEncryptionConfigsRequest.newBuilder((ListEncryptionConfigsRequest)payload).setPageToken(token).build();
        }

        public ListEncryptionConfigsRequest injectPageSize(ListEncryptionConfigsRequest payload, int pageSize) {
            return ListEncryptionConfigsRequest.newBuilder((ListEncryptionConfigsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEncryptionConfigsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEncryptionConfigsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<EncryptionConfig> extractResources(ListEncryptionConfigsResponse payload) {
            return payload.getEncryptionConfigsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse, CmekServiceClient.ListEncryptionConfigsPagedResponse> LIST_ENCRYPTION_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse, CmekServiceClient.ListEncryptionConfigsPagedResponse>(){

        public ApiFuture<CmekServiceClient.ListEncryptionConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse> callable, ListEncryptionConfigsRequest request, ApiCallContext context, ApiFuture<ListEncryptionConfigsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENCRYPTION_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CmekServiceClient.ListEncryptionConfigsPagedResponse.createAsync((PageContext<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse, EncryptionConfig>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, CmekServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, CmekServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<CmekServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CmekServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateEncryptionConfigRequest, Operation> createEncryptionConfigSettings() {
        return this.createEncryptionConfigSettings;
    }

    public OperationCallSettings<CreateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> createEncryptionConfigOperationSettings() {
        return this.createEncryptionConfigOperationSettings;
    }

    public UnaryCallSettings<UpdateEncryptionConfigRequest, Operation> updateEncryptionConfigSettings() {
        return this.updateEncryptionConfigSettings;
    }

    public OperationCallSettings<UpdateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> updateEncryptionConfigOperationSettings() {
        return this.updateEncryptionConfigOperationSettings;
    }

    public UnaryCallSettings<DeleteEncryptionConfigRequest, Operation> deleteEncryptionConfigSettings() {
        return this.deleteEncryptionConfigSettings;
    }

    public OperationCallSettings<DeleteEncryptionConfigRequest, Empty, OperationMetadata> deleteEncryptionConfigOperationSettings() {
        return this.deleteEncryptionConfigOperationSettings;
    }

    public PagedCallSettings<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse, CmekServiceClient.ListEncryptionConfigsPagedResponse> listEncryptionConfigsSettings() {
        return this.listEncryptionConfigsSettings;
    }

    public UnaryCallSettings<GetEncryptionConfigRequest, EncryptionConfig> getEncryptionConfigSettings() {
        return this.getEncryptionConfigSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, CmekServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public CmekServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCmekServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCmekServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dataplex";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "dataplex.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dataplex.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CmekServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CmekServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CmekServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CmekServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CmekServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createEncryptionConfigSettings = settingsBuilder.createEncryptionConfigSettings().build();
        this.createEncryptionConfigOperationSettings = settingsBuilder.createEncryptionConfigOperationSettings().build();
        this.updateEncryptionConfigSettings = settingsBuilder.updateEncryptionConfigSettings().build();
        this.updateEncryptionConfigOperationSettings = settingsBuilder.updateEncryptionConfigOperationSettings().build();
        this.deleteEncryptionConfigSettings = settingsBuilder.deleteEncryptionConfigSettings().build();
        this.deleteEncryptionConfigOperationSettings = settingsBuilder.deleteEncryptionConfigOperationSettings().build();
        this.listEncryptionConfigsSettings = settingsBuilder.listEncryptionConfigsSettings().build();
        this.getEncryptionConfigSettings = settingsBuilder.getEncryptionConfigSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CmekServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateEncryptionConfigRequest, Operation> createEncryptionConfigSettings;
        private final OperationCallSettings.Builder<CreateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> createEncryptionConfigOperationSettings;
        private final UnaryCallSettings.Builder<UpdateEncryptionConfigRequest, Operation> updateEncryptionConfigSettings;
        private final OperationCallSettings.Builder<UpdateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> updateEncryptionConfigOperationSettings;
        private final UnaryCallSettings.Builder<DeleteEncryptionConfigRequest, Operation> deleteEncryptionConfigSettings;
        private final OperationCallSettings.Builder<DeleteEncryptionConfigRequest, Empty, OperationMetadata> deleteEncryptionConfigOperationSettings;
        private final PagedCallSettings.Builder<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse, CmekServiceClient.ListEncryptionConfigsPagedResponse> listEncryptionConfigsSettings;
        private final UnaryCallSettings.Builder<GetEncryptionConfigRequest, EncryptionConfig> getEncryptionConfigSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, CmekServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createEncryptionConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEncryptionConfigOperationSettings = OperationCallSettings.newBuilder();
            this.updateEncryptionConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEncryptionConfigOperationSettings = OperationCallSettings.newBuilder();
            this.deleteEncryptionConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEncryptionConfigOperationSettings = OperationCallSettings.newBuilder();
            this.listEncryptionConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENCRYPTION_CONFIGS_PAGE_STR_FACT);
            this.getEncryptionConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createEncryptionConfigSettings, this.updateEncryptionConfigSettings, this.deleteEncryptionConfigSettings, this.listEncryptionConfigsSettings, this.getEncryptionConfigSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CmekServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createEncryptionConfigSettings = settings.createEncryptionConfigSettings.toBuilder();
            this.createEncryptionConfigOperationSettings = settings.createEncryptionConfigOperationSettings.toBuilder();
            this.updateEncryptionConfigSettings = settings.updateEncryptionConfigSettings.toBuilder();
            this.updateEncryptionConfigOperationSettings = settings.updateEncryptionConfigOperationSettings.toBuilder();
            this.deleteEncryptionConfigSettings = settings.deleteEncryptionConfigSettings.toBuilder();
            this.deleteEncryptionConfigOperationSettings = settings.deleteEncryptionConfigOperationSettings.toBuilder();
            this.listEncryptionConfigsSettings = settings.listEncryptionConfigsSettings.toBuilder();
            this.getEncryptionConfigSettings = settings.getEncryptionConfigSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createEncryptionConfigSettings, this.updateEncryptionConfigSettings, this.deleteEncryptionConfigSettings, this.listEncryptionConfigsSettings, this.getEncryptionConfigSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CmekServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CmekServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CmekServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CmekServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CmekServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CmekServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CmekServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CmekServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createEncryptionConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateEncryptionConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteEncryptionConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listEncryptionConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getEncryptionConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createEncryptionConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(EncryptionConfig.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateEncryptionConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(EncryptionConfig.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteEncryptionConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateEncryptionConfigRequest, Operation> createEncryptionConfigSettings() {
            return this.createEncryptionConfigSettings;
        }

        public OperationCallSettings.Builder<CreateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> createEncryptionConfigOperationSettings() {
            return this.createEncryptionConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateEncryptionConfigRequest, Operation> updateEncryptionConfigSettings() {
            return this.updateEncryptionConfigSettings;
        }

        public OperationCallSettings.Builder<UpdateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> updateEncryptionConfigOperationSettings() {
            return this.updateEncryptionConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteEncryptionConfigRequest, Operation> deleteEncryptionConfigSettings() {
            return this.deleteEncryptionConfigSettings;
        }

        public OperationCallSettings.Builder<DeleteEncryptionConfigRequest, Empty, OperationMetadata> deleteEncryptionConfigOperationSettings() {
            return this.deleteEncryptionConfigOperationSettings;
        }

        public PagedCallSettings.Builder<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse, CmekServiceClient.ListEncryptionConfigsPagedResponse> listEncryptionConfigsSettings() {
            return this.listEncryptionConfigsSettings;
        }

        public UnaryCallSettings.Builder<GetEncryptionConfigRequest, EncryptionConfig> getEncryptionConfigSettings() {
            return this.getEncryptionConfigSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, CmekServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public CmekServiceStubSettings build() throws IOException {
            return new CmekServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

