/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.AspectType;
import com.google.cloud.dataplex.v1.AspectTypeName;
import com.google.cloud.dataplex.v1.CatalogServiceSettings;
import com.google.cloud.dataplex.v1.CreateAspectTypeRequest;
import com.google.cloud.dataplex.v1.CreateEntryGroupRequest;
import com.google.cloud.dataplex.v1.CreateEntryRequest;
import com.google.cloud.dataplex.v1.CreateEntryTypeRequest;
import com.google.cloud.dataplex.v1.DeleteAspectTypeRequest;
import com.google.cloud.dataplex.v1.DeleteEntryGroupRequest;
import com.google.cloud.dataplex.v1.DeleteEntryRequest;
import com.google.cloud.dataplex.v1.DeleteEntryTypeRequest;
import com.google.cloud.dataplex.v1.Entry;
import com.google.cloud.dataplex.v1.EntryGroup;
import com.google.cloud.dataplex.v1.EntryGroupName;
import com.google.cloud.dataplex.v1.EntryName;
import com.google.cloud.dataplex.v1.EntryType;
import com.google.cloud.dataplex.v1.EntryTypeName;
import com.google.cloud.dataplex.v1.GetAspectTypeRequest;
import com.google.cloud.dataplex.v1.GetEntryGroupRequest;
import com.google.cloud.dataplex.v1.GetEntryRequest;
import com.google.cloud.dataplex.v1.GetEntryTypeRequest;
import com.google.cloud.dataplex.v1.ListAspectTypesRequest;
import com.google.cloud.dataplex.v1.ListAspectTypesResponse;
import com.google.cloud.dataplex.v1.ListEntriesRequest;
import com.google.cloud.dataplex.v1.ListEntriesResponse;
import com.google.cloud.dataplex.v1.ListEntryGroupsRequest;
import com.google.cloud.dataplex.v1.ListEntryGroupsResponse;
import com.google.cloud.dataplex.v1.ListEntryTypesRequest;
import com.google.cloud.dataplex.v1.ListEntryTypesResponse;
import com.google.cloud.dataplex.v1.LocationName;
import com.google.cloud.dataplex.v1.LookupEntryRequest;
import com.google.cloud.dataplex.v1.OperationMetadata;
import com.google.cloud.dataplex.v1.SearchEntriesRequest;
import com.google.cloud.dataplex.v1.SearchEntriesResponse;
import com.google.cloud.dataplex.v1.SearchEntriesResult;
import com.google.cloud.dataplex.v1.UpdateAspectTypeRequest;
import com.google.cloud.dataplex.v1.UpdateEntryGroupRequest;
import com.google.cloud.dataplex.v1.UpdateEntryRequest;
import com.google.cloud.dataplex.v1.UpdateEntryTypeRequest;
import com.google.cloud.dataplex.v1.stub.CatalogServiceStub;
import com.google.cloud.dataplex.v1.stub.CatalogServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CatalogServiceClient
implements BackgroundResource {
    private final CatalogServiceSettings settings;
    private final CatalogServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final CatalogServiceClient create() throws IOException {
        return CatalogServiceClient.create(CatalogServiceSettings.newBuilder().build());
    }

    public static final CatalogServiceClient create(CatalogServiceSettings settings) throws IOException {
        return new CatalogServiceClient(settings);
    }

    public static final CatalogServiceClient create(CatalogServiceStub stub) {
        return new CatalogServiceClient(stub);
    }

    protected CatalogServiceClient(CatalogServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CatalogServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected CatalogServiceClient(CatalogServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final CatalogServiceSettings getSettings() {
        return this.settings;
    }

    public CatalogServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<EntryType, OperationMetadata> createEntryTypeAsync(LocationName parent, EntryType entryType, String entryTypeId) {
        CreateEntryTypeRequest request = CreateEntryTypeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEntryType(entryType).setEntryTypeId(entryTypeId).build();
        return this.createEntryTypeAsync(request);
    }

    public final OperationFuture<EntryType, OperationMetadata> createEntryTypeAsync(String parent, EntryType entryType, String entryTypeId) {
        CreateEntryTypeRequest request = CreateEntryTypeRequest.newBuilder().setParent(parent).setEntryType(entryType).setEntryTypeId(entryTypeId).build();
        return this.createEntryTypeAsync(request);
    }

    public final OperationFuture<EntryType, OperationMetadata> createEntryTypeAsync(CreateEntryTypeRequest request) {
        return this.createEntryTypeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEntryTypeRequest, EntryType, OperationMetadata> createEntryTypeOperationCallable() {
        return this.stub.createEntryTypeOperationCallable();
    }

    public final UnaryCallable<CreateEntryTypeRequest, Operation> createEntryTypeCallable() {
        return this.stub.createEntryTypeCallable();
    }

    public final OperationFuture<EntryType, OperationMetadata> updateEntryTypeAsync(EntryType entryType, FieldMask updateMask) {
        UpdateEntryTypeRequest request = UpdateEntryTypeRequest.newBuilder().setEntryType(entryType).setUpdateMask(updateMask).build();
        return this.updateEntryTypeAsync(request);
    }

    public final OperationFuture<EntryType, OperationMetadata> updateEntryTypeAsync(UpdateEntryTypeRequest request) {
        return this.updateEntryTypeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateEntryTypeRequest, EntryType, OperationMetadata> updateEntryTypeOperationCallable() {
        return this.stub.updateEntryTypeOperationCallable();
    }

    public final UnaryCallable<UpdateEntryTypeRequest, Operation> updateEntryTypeCallable() {
        return this.stub.updateEntryTypeCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEntryTypeAsync(EntryTypeName name) {
        DeleteEntryTypeRequest request = DeleteEntryTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteEntryTypeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEntryTypeAsync(String name) {
        DeleteEntryTypeRequest request = DeleteEntryTypeRequest.newBuilder().setName(name).build();
        return this.deleteEntryTypeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEntryTypeAsync(DeleteEntryTypeRequest request) {
        return this.deleteEntryTypeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEntryTypeRequest, Empty, OperationMetadata> deleteEntryTypeOperationCallable() {
        return this.stub.deleteEntryTypeOperationCallable();
    }

    public final UnaryCallable<DeleteEntryTypeRequest, Operation> deleteEntryTypeCallable() {
        return this.stub.deleteEntryTypeCallable();
    }

    public final ListEntryTypesPagedResponse listEntryTypes(LocationName parent) {
        ListEntryTypesRequest request = ListEntryTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEntryTypes(request);
    }

    public final ListEntryTypesPagedResponse listEntryTypes(String parent) {
        ListEntryTypesRequest request = ListEntryTypesRequest.newBuilder().setParent(parent).build();
        return this.listEntryTypes(request);
    }

    public final ListEntryTypesPagedResponse listEntryTypes(ListEntryTypesRequest request) {
        return (ListEntryTypesPagedResponse)((Object)this.listEntryTypesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEntryTypesRequest, ListEntryTypesPagedResponse> listEntryTypesPagedCallable() {
        return this.stub.listEntryTypesPagedCallable();
    }

    public final UnaryCallable<ListEntryTypesRequest, ListEntryTypesResponse> listEntryTypesCallable() {
        return this.stub.listEntryTypesCallable();
    }

    public final EntryType getEntryType(EntryTypeName name) {
        GetEntryTypeRequest request = GetEntryTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEntryType(request);
    }

    public final EntryType getEntryType(String name) {
        GetEntryTypeRequest request = GetEntryTypeRequest.newBuilder().setName(name).build();
        return this.getEntryType(request);
    }

    public final EntryType getEntryType(GetEntryTypeRequest request) {
        return (EntryType)this.getEntryTypeCallable().call((Object)request);
    }

    public final UnaryCallable<GetEntryTypeRequest, EntryType> getEntryTypeCallable() {
        return this.stub.getEntryTypeCallable();
    }

    public final OperationFuture<AspectType, OperationMetadata> createAspectTypeAsync(LocationName parent, AspectType aspectType, String aspectTypeId) {
        CreateAspectTypeRequest request = CreateAspectTypeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAspectType(aspectType).setAspectTypeId(aspectTypeId).build();
        return this.createAspectTypeAsync(request);
    }

    public final OperationFuture<AspectType, OperationMetadata> createAspectTypeAsync(String parent, AspectType aspectType, String aspectTypeId) {
        CreateAspectTypeRequest request = CreateAspectTypeRequest.newBuilder().setParent(parent).setAspectType(aspectType).setAspectTypeId(aspectTypeId).build();
        return this.createAspectTypeAsync(request);
    }

    public final OperationFuture<AspectType, OperationMetadata> createAspectTypeAsync(CreateAspectTypeRequest request) {
        return this.createAspectTypeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAspectTypeRequest, AspectType, OperationMetadata> createAspectTypeOperationCallable() {
        return this.stub.createAspectTypeOperationCallable();
    }

    public final UnaryCallable<CreateAspectTypeRequest, Operation> createAspectTypeCallable() {
        return this.stub.createAspectTypeCallable();
    }

    public final OperationFuture<AspectType, OperationMetadata> updateAspectTypeAsync(AspectType aspectType, FieldMask updateMask) {
        UpdateAspectTypeRequest request = UpdateAspectTypeRequest.newBuilder().setAspectType(aspectType).setUpdateMask(updateMask).build();
        return this.updateAspectTypeAsync(request);
    }

    public final OperationFuture<AspectType, OperationMetadata> updateAspectTypeAsync(UpdateAspectTypeRequest request) {
        return this.updateAspectTypeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAspectTypeRequest, AspectType, OperationMetadata> updateAspectTypeOperationCallable() {
        return this.stub.updateAspectTypeOperationCallable();
    }

    public final UnaryCallable<UpdateAspectTypeRequest, Operation> updateAspectTypeCallable() {
        return this.stub.updateAspectTypeCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAspectTypeAsync(AspectTypeName name) {
        DeleteAspectTypeRequest request = DeleteAspectTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAspectTypeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAspectTypeAsync(String name) {
        DeleteAspectTypeRequest request = DeleteAspectTypeRequest.newBuilder().setName(name).build();
        return this.deleteAspectTypeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAspectTypeAsync(DeleteAspectTypeRequest request) {
        return this.deleteAspectTypeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAspectTypeRequest, Empty, OperationMetadata> deleteAspectTypeOperationCallable() {
        return this.stub.deleteAspectTypeOperationCallable();
    }

    public final UnaryCallable<DeleteAspectTypeRequest, Operation> deleteAspectTypeCallable() {
        return this.stub.deleteAspectTypeCallable();
    }

    public final ListAspectTypesPagedResponse listAspectTypes(LocationName parent) {
        ListAspectTypesRequest request = ListAspectTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAspectTypes(request);
    }

    public final ListAspectTypesPagedResponse listAspectTypes(String parent) {
        ListAspectTypesRequest request = ListAspectTypesRequest.newBuilder().setParent(parent).build();
        return this.listAspectTypes(request);
    }

    public final ListAspectTypesPagedResponse listAspectTypes(ListAspectTypesRequest request) {
        return (ListAspectTypesPagedResponse)((Object)this.listAspectTypesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAspectTypesRequest, ListAspectTypesPagedResponse> listAspectTypesPagedCallable() {
        return this.stub.listAspectTypesPagedCallable();
    }

    public final UnaryCallable<ListAspectTypesRequest, ListAspectTypesResponse> listAspectTypesCallable() {
        return this.stub.listAspectTypesCallable();
    }

    public final AspectType getAspectType(AspectTypeName name) {
        GetAspectTypeRequest request = GetAspectTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAspectType(request);
    }

    public final AspectType getAspectType(String name) {
        GetAspectTypeRequest request = GetAspectTypeRequest.newBuilder().setName(name).build();
        return this.getAspectType(request);
    }

    public final AspectType getAspectType(GetAspectTypeRequest request) {
        return (AspectType)this.getAspectTypeCallable().call((Object)request);
    }

    public final UnaryCallable<GetAspectTypeRequest, AspectType> getAspectTypeCallable() {
        return this.stub.getAspectTypeCallable();
    }

    public final OperationFuture<EntryGroup, OperationMetadata> createEntryGroupAsync(LocationName parent, EntryGroup entryGroup, String entryGroupId) {
        CreateEntryGroupRequest request = CreateEntryGroupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEntryGroup(entryGroup).setEntryGroupId(entryGroupId).build();
        return this.createEntryGroupAsync(request);
    }

    public final OperationFuture<EntryGroup, OperationMetadata> createEntryGroupAsync(String parent, EntryGroup entryGroup, String entryGroupId) {
        CreateEntryGroupRequest request = CreateEntryGroupRequest.newBuilder().setParent(parent).setEntryGroup(entryGroup).setEntryGroupId(entryGroupId).build();
        return this.createEntryGroupAsync(request);
    }

    public final OperationFuture<EntryGroup, OperationMetadata> createEntryGroupAsync(CreateEntryGroupRequest request) {
        return this.createEntryGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEntryGroupRequest, EntryGroup, OperationMetadata> createEntryGroupOperationCallable() {
        return this.stub.createEntryGroupOperationCallable();
    }

    public final UnaryCallable<CreateEntryGroupRequest, Operation> createEntryGroupCallable() {
        return this.stub.createEntryGroupCallable();
    }

    public final OperationFuture<EntryGroup, OperationMetadata> updateEntryGroupAsync(EntryGroup entryGroup, FieldMask updateMask) {
        UpdateEntryGroupRequest request = UpdateEntryGroupRequest.newBuilder().setEntryGroup(entryGroup).setUpdateMask(updateMask).build();
        return this.updateEntryGroupAsync(request);
    }

    public final OperationFuture<EntryGroup, OperationMetadata> updateEntryGroupAsync(UpdateEntryGroupRequest request) {
        return this.updateEntryGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateEntryGroupRequest, EntryGroup, OperationMetadata> updateEntryGroupOperationCallable() {
        return this.stub.updateEntryGroupOperationCallable();
    }

    public final UnaryCallable<UpdateEntryGroupRequest, Operation> updateEntryGroupCallable() {
        return this.stub.updateEntryGroupCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEntryGroupAsync(EntryGroupName name) {
        DeleteEntryGroupRequest request = DeleteEntryGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteEntryGroupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEntryGroupAsync(String name) {
        DeleteEntryGroupRequest request = DeleteEntryGroupRequest.newBuilder().setName(name).build();
        return this.deleteEntryGroupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEntryGroupAsync(DeleteEntryGroupRequest request) {
        return this.deleteEntryGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEntryGroupRequest, Empty, OperationMetadata> deleteEntryGroupOperationCallable() {
        return this.stub.deleteEntryGroupOperationCallable();
    }

    public final UnaryCallable<DeleteEntryGroupRequest, Operation> deleteEntryGroupCallable() {
        return this.stub.deleteEntryGroupCallable();
    }

    public final ListEntryGroupsPagedResponse listEntryGroups(LocationName parent) {
        ListEntryGroupsRequest request = ListEntryGroupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEntryGroups(request);
    }

    public final ListEntryGroupsPagedResponse listEntryGroups(String parent) {
        ListEntryGroupsRequest request = ListEntryGroupsRequest.newBuilder().setParent(parent).build();
        return this.listEntryGroups(request);
    }

    public final ListEntryGroupsPagedResponse listEntryGroups(ListEntryGroupsRequest request) {
        return (ListEntryGroupsPagedResponse)((Object)this.listEntryGroupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEntryGroupsRequest, ListEntryGroupsPagedResponse> listEntryGroupsPagedCallable() {
        return this.stub.listEntryGroupsPagedCallable();
    }

    public final UnaryCallable<ListEntryGroupsRequest, ListEntryGroupsResponse> listEntryGroupsCallable() {
        return this.stub.listEntryGroupsCallable();
    }

    public final EntryGroup getEntryGroup(EntryGroupName name) {
        GetEntryGroupRequest request = GetEntryGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEntryGroup(request);
    }

    public final EntryGroup getEntryGroup(String name) {
        GetEntryGroupRequest request = GetEntryGroupRequest.newBuilder().setName(name).build();
        return this.getEntryGroup(request);
    }

    public final EntryGroup getEntryGroup(GetEntryGroupRequest request) {
        return (EntryGroup)this.getEntryGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetEntryGroupRequest, EntryGroup> getEntryGroupCallable() {
        return this.stub.getEntryGroupCallable();
    }

    public final Entry createEntry(EntryGroupName parent, Entry entry, String entryId) {
        CreateEntryRequest request = CreateEntryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEntry(entry).setEntryId(entryId).build();
        return this.createEntry(request);
    }

    public final Entry createEntry(String parent, Entry entry, String entryId) {
        CreateEntryRequest request = CreateEntryRequest.newBuilder().setParent(parent).setEntry(entry).setEntryId(entryId).build();
        return this.createEntry(request);
    }

    public final Entry createEntry(CreateEntryRequest request) {
        return (Entry)this.createEntryCallable().call((Object)request);
    }

    public final UnaryCallable<CreateEntryRequest, Entry> createEntryCallable() {
        return this.stub.createEntryCallable();
    }

    public final Entry updateEntry(Entry entry, FieldMask updateMask) {
        UpdateEntryRequest request = UpdateEntryRequest.newBuilder().setEntry(entry).setUpdateMask(updateMask).build();
        return this.updateEntry(request);
    }

    public final Entry updateEntry(UpdateEntryRequest request) {
        return (Entry)this.updateEntryCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEntryRequest, Entry> updateEntryCallable() {
        return this.stub.updateEntryCallable();
    }

    public final Entry deleteEntry(EntryName name) {
        DeleteEntryRequest request = DeleteEntryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteEntry(request);
    }

    public final Entry deleteEntry(String name) {
        DeleteEntryRequest request = DeleteEntryRequest.newBuilder().setName(name).build();
        return this.deleteEntry(request);
    }

    public final Entry deleteEntry(DeleteEntryRequest request) {
        return (Entry)this.deleteEntryCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEntryRequest, Entry> deleteEntryCallable() {
        return this.stub.deleteEntryCallable();
    }

    public final ListEntriesPagedResponse listEntries(EntryGroupName parent) {
        ListEntriesRequest request = ListEntriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEntries(request);
    }

    public final ListEntriesPagedResponse listEntries(String parent) {
        ListEntriesRequest request = ListEntriesRequest.newBuilder().setParent(parent).build();
        return this.listEntries(request);
    }

    public final ListEntriesPagedResponse listEntries(ListEntriesRequest request) {
        return (ListEntriesPagedResponse)((Object)this.listEntriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEntriesRequest, ListEntriesPagedResponse> listEntriesPagedCallable() {
        return this.stub.listEntriesPagedCallable();
    }

    public final UnaryCallable<ListEntriesRequest, ListEntriesResponse> listEntriesCallable() {
        return this.stub.listEntriesCallable();
    }

    public final Entry getEntry(EntryName name) {
        GetEntryRequest request = GetEntryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEntry(request);
    }

    public final Entry getEntry(String name) {
        GetEntryRequest request = GetEntryRequest.newBuilder().setName(name).build();
        return this.getEntry(request);
    }

    public final Entry getEntry(GetEntryRequest request) {
        return (Entry)this.getEntryCallable().call((Object)request);
    }

    public final UnaryCallable<GetEntryRequest, Entry> getEntryCallable() {
        return this.stub.getEntryCallable();
    }

    public final Entry lookupEntry(LookupEntryRequest request) {
        return (Entry)this.lookupEntryCallable().call((Object)request);
    }

    public final UnaryCallable<LookupEntryRequest, Entry> lookupEntryCallable() {
        return this.stub.lookupEntryCallable();
    }

    public final SearchEntriesPagedResponse searchEntries(String name, String query) {
        SearchEntriesRequest request = SearchEntriesRequest.newBuilder().setName(name).setQuery(query).build();
        return this.searchEntries(request);
    }

    public final SearchEntriesPagedResponse searchEntries(SearchEntriesRequest request) {
        return (SearchEntriesPagedResponse)((Object)this.searchEntriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchEntriesRequest, SearchEntriesPagedResponse> searchEntriesPagedCallable() {
        return this.stub.searchEntriesPagedCallable();
    }

    public final UnaryCallable<SearchEntriesRequest, SearchEntriesResponse> searchEntriesCallable() {
        return this.stub.searchEntriesCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchEntriesFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchEntriesRequest, SearchEntriesResponse, SearchEntriesResult, SearchEntriesPage, SearchEntriesFixedSizeCollection> {
        private SearchEntriesFixedSizeCollection(List<SearchEntriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchEntriesFixedSizeCollection createEmptyCollection() {
            return new SearchEntriesFixedSizeCollection(null, 0);
        }

        protected SearchEntriesFixedSizeCollection createCollection(List<SearchEntriesPage> pages, int collectionSize) {
            return new SearchEntriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchEntriesPage
    extends AbstractPage<SearchEntriesRequest, SearchEntriesResponse, SearchEntriesResult, SearchEntriesPage> {
        private SearchEntriesPage(PageContext<SearchEntriesRequest, SearchEntriesResponse, SearchEntriesResult> context, SearchEntriesResponse response) {
            super(context, (Object)response);
        }

        private static SearchEntriesPage createEmptyPage() {
            return new SearchEntriesPage(null, null);
        }

        protected SearchEntriesPage createPage(PageContext<SearchEntriesRequest, SearchEntriesResponse, SearchEntriesResult> context, SearchEntriesResponse response) {
            return new SearchEntriesPage(context, response);
        }

        public ApiFuture<SearchEntriesPage> createPageAsync(PageContext<SearchEntriesRequest, SearchEntriesResponse, SearchEntriesResult> context, ApiFuture<SearchEntriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchEntriesPagedResponse
    extends AbstractPagedListResponse<SearchEntriesRequest, SearchEntriesResponse, SearchEntriesResult, SearchEntriesPage, SearchEntriesFixedSizeCollection> {
        public static ApiFuture<SearchEntriesPagedResponse> createAsync(PageContext<SearchEntriesRequest, SearchEntriesResponse, SearchEntriesResult> context, ApiFuture<SearchEntriesResponse> futureResponse) {
            ApiFuture<SearchEntriesPage> futurePage = SearchEntriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchEntriesPagedResponse((SearchEntriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchEntriesPagedResponse(SearchEntriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchEntriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEntriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEntriesRequest, ListEntriesResponse, Entry, ListEntriesPage, ListEntriesFixedSizeCollection> {
        private ListEntriesFixedSizeCollection(List<ListEntriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEntriesFixedSizeCollection createEmptyCollection() {
            return new ListEntriesFixedSizeCollection(null, 0);
        }

        protected ListEntriesFixedSizeCollection createCollection(List<ListEntriesPage> pages, int collectionSize) {
            return new ListEntriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEntriesPage
    extends AbstractPage<ListEntriesRequest, ListEntriesResponse, Entry, ListEntriesPage> {
        private ListEntriesPage(PageContext<ListEntriesRequest, ListEntriesResponse, Entry> context, ListEntriesResponse response) {
            super(context, (Object)response);
        }

        private static ListEntriesPage createEmptyPage() {
            return new ListEntriesPage(null, null);
        }

        protected ListEntriesPage createPage(PageContext<ListEntriesRequest, ListEntriesResponse, Entry> context, ListEntriesResponse response) {
            return new ListEntriesPage(context, response);
        }

        public ApiFuture<ListEntriesPage> createPageAsync(PageContext<ListEntriesRequest, ListEntriesResponse, Entry> context, ApiFuture<ListEntriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEntriesPagedResponse
    extends AbstractPagedListResponse<ListEntriesRequest, ListEntriesResponse, Entry, ListEntriesPage, ListEntriesFixedSizeCollection> {
        public static ApiFuture<ListEntriesPagedResponse> createAsync(PageContext<ListEntriesRequest, ListEntriesResponse, Entry> context, ApiFuture<ListEntriesResponse> futureResponse) {
            ApiFuture<ListEntriesPage> futurePage = ListEntriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEntriesPagedResponse((ListEntriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEntriesPagedResponse(ListEntriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEntriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEntryGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup, ListEntryGroupsPage, ListEntryGroupsFixedSizeCollection> {
        private ListEntryGroupsFixedSizeCollection(List<ListEntryGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEntryGroupsFixedSizeCollection createEmptyCollection() {
            return new ListEntryGroupsFixedSizeCollection(null, 0);
        }

        protected ListEntryGroupsFixedSizeCollection createCollection(List<ListEntryGroupsPage> pages, int collectionSize) {
            return new ListEntryGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEntryGroupsPage
    extends AbstractPage<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup, ListEntryGroupsPage> {
        private ListEntryGroupsPage(PageContext<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup> context, ListEntryGroupsResponse response) {
            super(context, (Object)response);
        }

        private static ListEntryGroupsPage createEmptyPage() {
            return new ListEntryGroupsPage(null, null);
        }

        protected ListEntryGroupsPage createPage(PageContext<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup> context, ListEntryGroupsResponse response) {
            return new ListEntryGroupsPage(context, response);
        }

        public ApiFuture<ListEntryGroupsPage> createPageAsync(PageContext<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup> context, ApiFuture<ListEntryGroupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEntryGroupsPagedResponse
    extends AbstractPagedListResponse<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup, ListEntryGroupsPage, ListEntryGroupsFixedSizeCollection> {
        public static ApiFuture<ListEntryGroupsPagedResponse> createAsync(PageContext<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup> context, ApiFuture<ListEntryGroupsResponse> futureResponse) {
            ApiFuture<ListEntryGroupsPage> futurePage = ListEntryGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEntryGroupsPagedResponse((ListEntryGroupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEntryGroupsPagedResponse(ListEntryGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEntryGroupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAspectTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAspectTypesRequest, ListAspectTypesResponse, AspectType, ListAspectTypesPage, ListAspectTypesFixedSizeCollection> {
        private ListAspectTypesFixedSizeCollection(List<ListAspectTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAspectTypesFixedSizeCollection createEmptyCollection() {
            return new ListAspectTypesFixedSizeCollection(null, 0);
        }

        protected ListAspectTypesFixedSizeCollection createCollection(List<ListAspectTypesPage> pages, int collectionSize) {
            return new ListAspectTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAspectTypesPage
    extends AbstractPage<ListAspectTypesRequest, ListAspectTypesResponse, AspectType, ListAspectTypesPage> {
        private ListAspectTypesPage(PageContext<ListAspectTypesRequest, ListAspectTypesResponse, AspectType> context, ListAspectTypesResponse response) {
            super(context, (Object)response);
        }

        private static ListAspectTypesPage createEmptyPage() {
            return new ListAspectTypesPage(null, null);
        }

        protected ListAspectTypesPage createPage(PageContext<ListAspectTypesRequest, ListAspectTypesResponse, AspectType> context, ListAspectTypesResponse response) {
            return new ListAspectTypesPage(context, response);
        }

        public ApiFuture<ListAspectTypesPage> createPageAsync(PageContext<ListAspectTypesRequest, ListAspectTypesResponse, AspectType> context, ApiFuture<ListAspectTypesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAspectTypesPagedResponse
    extends AbstractPagedListResponse<ListAspectTypesRequest, ListAspectTypesResponse, AspectType, ListAspectTypesPage, ListAspectTypesFixedSizeCollection> {
        public static ApiFuture<ListAspectTypesPagedResponse> createAsync(PageContext<ListAspectTypesRequest, ListAspectTypesResponse, AspectType> context, ApiFuture<ListAspectTypesResponse> futureResponse) {
            ApiFuture<ListAspectTypesPage> futurePage = ListAspectTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAspectTypesPagedResponse((ListAspectTypesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAspectTypesPagedResponse(ListAspectTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAspectTypesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEntryTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEntryTypesRequest, ListEntryTypesResponse, EntryType, ListEntryTypesPage, ListEntryTypesFixedSizeCollection> {
        private ListEntryTypesFixedSizeCollection(List<ListEntryTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEntryTypesFixedSizeCollection createEmptyCollection() {
            return new ListEntryTypesFixedSizeCollection(null, 0);
        }

        protected ListEntryTypesFixedSizeCollection createCollection(List<ListEntryTypesPage> pages, int collectionSize) {
            return new ListEntryTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEntryTypesPage
    extends AbstractPage<ListEntryTypesRequest, ListEntryTypesResponse, EntryType, ListEntryTypesPage> {
        private ListEntryTypesPage(PageContext<ListEntryTypesRequest, ListEntryTypesResponse, EntryType> context, ListEntryTypesResponse response) {
            super(context, (Object)response);
        }

        private static ListEntryTypesPage createEmptyPage() {
            return new ListEntryTypesPage(null, null);
        }

        protected ListEntryTypesPage createPage(PageContext<ListEntryTypesRequest, ListEntryTypesResponse, EntryType> context, ListEntryTypesResponse response) {
            return new ListEntryTypesPage(context, response);
        }

        public ApiFuture<ListEntryTypesPage> createPageAsync(PageContext<ListEntryTypesRequest, ListEntryTypesResponse, EntryType> context, ApiFuture<ListEntryTypesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEntryTypesPagedResponse
    extends AbstractPagedListResponse<ListEntryTypesRequest, ListEntryTypesResponse, EntryType, ListEntryTypesPage, ListEntryTypesFixedSizeCollection> {
        public static ApiFuture<ListEntryTypesPagedResponse> createAsync(PageContext<ListEntryTypesRequest, ListEntryTypesResponse, EntryType> context, ApiFuture<ListEntryTypesResponse> futureResponse) {
            ApiFuture<ListEntryTypesPage> futurePage = ListEntryTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEntryTypesPagedResponse((ListEntryTypesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEntryTypesPagedResponse(ListEntryTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEntryTypesFixedSizeCollection.createEmptyCollection());
        }
    }
}

