/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.CreateEntityRequest;
import com.google.cloud.dataplex.v1.CreatePartitionRequest;
import com.google.cloud.dataplex.v1.DeleteEntityRequest;
import com.google.cloud.dataplex.v1.DeletePartitionRequest;
import com.google.cloud.dataplex.v1.Entity;
import com.google.cloud.dataplex.v1.GetEntityRequest;
import com.google.cloud.dataplex.v1.GetPartitionRequest;
import com.google.cloud.dataplex.v1.ListEntitiesRequest;
import com.google.cloud.dataplex.v1.ListEntitiesResponse;
import com.google.cloud.dataplex.v1.ListPartitionsRequest;
import com.google.cloud.dataplex.v1.ListPartitionsResponse;
import com.google.cloud.dataplex.v1.MetadataServiceClient;
import com.google.cloud.dataplex.v1.Partition;
import com.google.cloud.dataplex.v1.UpdateEntityRequest;
import com.google.cloud.dataplex.v1.stub.GrpcMetadataServiceCallableFactory;
import com.google.cloud.dataplex.v1.stub.MetadataServiceStub;
import com.google.cloud.dataplex.v1.stub.MetadataServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcMetadataServiceStub
extends MetadataServiceStub {
    private static final MethodDescriptor<CreateEntityRequest, Entity> createEntityMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.MetadataService/CreateEntity").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateEntityRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Entity.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateEntityRequest, Entity> updateEntityMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.MetadataService/UpdateEntity").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateEntityRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Entity.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteEntityRequest, Empty> deleteEntityMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.MetadataService/DeleteEntity").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteEntityRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetEntityRequest, Entity> getEntityMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.MetadataService/GetEntity").setRequestMarshaller(ProtoUtils.marshaller((Message)GetEntityRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Entity.getDefaultInstance())).build();
    private static final MethodDescriptor<ListEntitiesRequest, ListEntitiesResponse> listEntitiesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.MetadataService/ListEntities").setRequestMarshaller(ProtoUtils.marshaller((Message)ListEntitiesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListEntitiesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreatePartitionRequest, Partition> createPartitionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.MetadataService/CreatePartition").setRequestMarshaller(ProtoUtils.marshaller((Message)CreatePartitionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Partition.getDefaultInstance())).build();
    private static final MethodDescriptor<DeletePartitionRequest, Empty> deletePartitionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.MetadataService/DeletePartition").setRequestMarshaller(ProtoUtils.marshaller((Message)DeletePartitionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetPartitionRequest, Partition> getPartitionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.MetadataService/GetPartition").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPartitionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Partition.getDefaultInstance())).build();
    private static final MethodDescriptor<ListPartitionsRequest, ListPartitionsResponse> listPartitionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataplex.v1.MetadataService/ListPartitions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPartitionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPartitionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<CreateEntityRequest, Entity> createEntityCallable;
    private final UnaryCallable<UpdateEntityRequest, Entity> updateEntityCallable;
    private final UnaryCallable<DeleteEntityRequest, Empty> deleteEntityCallable;
    private final UnaryCallable<GetEntityRequest, Entity> getEntityCallable;
    private final UnaryCallable<ListEntitiesRequest, ListEntitiesResponse> listEntitiesCallable;
    private final UnaryCallable<ListEntitiesRequest, MetadataServiceClient.ListEntitiesPagedResponse> listEntitiesPagedCallable;
    private final UnaryCallable<CreatePartitionRequest, Partition> createPartitionCallable;
    private final UnaryCallable<DeletePartitionRequest, Empty> deletePartitionCallable;
    private final UnaryCallable<GetPartitionRequest, Partition> getPartitionCallable;
    private final UnaryCallable<ListPartitionsRequest, ListPartitionsResponse> listPartitionsCallable;
    private final UnaryCallable<ListPartitionsRequest, MetadataServiceClient.ListPartitionsPagedResponse> listPartitionsPagedCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, MetadataServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcMetadataServiceStub create(MetadataServiceStubSettings settings) throws IOException {
        return new GrpcMetadataServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcMetadataServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcMetadataServiceStub(MetadataServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcMetadataServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcMetadataServiceStub(MetadataServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcMetadataServiceStub(MetadataServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcMetadataServiceCallableFactory());
    }

    protected GrpcMetadataServiceStub(MetadataServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createEntityTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createEntityMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateEntityTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateEntityMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"entity.name", (Object)String.valueOf(request.getEntity().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteEntityTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteEntityMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getEntityTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getEntityMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listEntitiesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listEntitiesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings createPartitionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createPartitionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings deletePartitionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deletePartitionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getPartitionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPartitionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listPartitionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPartitionsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        this.createEntityCallable = callableFactory.createUnaryCallable(createEntityTransportSettings, settings.createEntitySettings(), clientContext);
        this.updateEntityCallable = callableFactory.createUnaryCallable(updateEntityTransportSettings, settings.updateEntitySettings(), clientContext);
        this.deleteEntityCallable = callableFactory.createUnaryCallable(deleteEntityTransportSettings, settings.deleteEntitySettings(), clientContext);
        this.getEntityCallable = callableFactory.createUnaryCallable(getEntityTransportSettings, settings.getEntitySettings(), clientContext);
        this.listEntitiesCallable = callableFactory.createUnaryCallable(listEntitiesTransportSettings, settings.listEntitiesSettings(), clientContext);
        this.listEntitiesPagedCallable = callableFactory.createPagedCallable(listEntitiesTransportSettings, settings.listEntitiesSettings(), clientContext);
        this.createPartitionCallable = callableFactory.createUnaryCallable(createPartitionTransportSettings, settings.createPartitionSettings(), clientContext);
        this.deletePartitionCallable = callableFactory.createUnaryCallable(deletePartitionTransportSettings, settings.deletePartitionSettings(), clientContext);
        this.getPartitionCallable = callableFactory.createUnaryCallable(getPartitionTransportSettings, settings.getPartitionSettings(), clientContext);
        this.listPartitionsCallable = callableFactory.createUnaryCallable(listPartitionsTransportSettings, settings.listPartitionsSettings(), clientContext);
        this.listPartitionsPagedCallable = callableFactory.createPagedCallable(listPartitionsTransportSettings, settings.listPartitionsSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateEntityRequest, Entity> createEntityCallable() {
        return this.createEntityCallable;
    }

    @Override
    public UnaryCallable<UpdateEntityRequest, Entity> updateEntityCallable() {
        return this.updateEntityCallable;
    }

    @Override
    public UnaryCallable<DeleteEntityRequest, Empty> deleteEntityCallable() {
        return this.deleteEntityCallable;
    }

    @Override
    public UnaryCallable<GetEntityRequest, Entity> getEntityCallable() {
        return this.getEntityCallable;
    }

    @Override
    public UnaryCallable<ListEntitiesRequest, ListEntitiesResponse> listEntitiesCallable() {
        return this.listEntitiesCallable;
    }

    @Override
    public UnaryCallable<ListEntitiesRequest, MetadataServiceClient.ListEntitiesPagedResponse> listEntitiesPagedCallable() {
        return this.listEntitiesPagedCallable;
    }

    @Override
    public UnaryCallable<CreatePartitionRequest, Partition> createPartitionCallable() {
        return this.createPartitionCallable;
    }

    @Override
    public UnaryCallable<DeletePartitionRequest, Empty> deletePartitionCallable() {
        return this.deletePartitionCallable;
    }

    @Override
    public UnaryCallable<GetPartitionRequest, Partition> getPartitionCallable() {
        return this.getPartitionCallable;
    }

    @Override
    public UnaryCallable<ListPartitionsRequest, ListPartitionsResponse> listPartitionsCallable() {
        return this.listPartitionsCallable;
    }

    @Override
    public UnaryCallable<ListPartitionsRequest, MetadataServiceClient.ListPartitionsPagedResponse> listPartitionsPagedCallable() {
        return this.listPartitionsPagedCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, MetadataServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

