/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.CreateDataAttributeBindingRequest;
import com.google.cloud.dataplex.v1.CreateDataAttributeRequest;
import com.google.cloud.dataplex.v1.CreateDataTaxonomyRequest;
import com.google.cloud.dataplex.v1.DataAttribute;
import com.google.cloud.dataplex.v1.DataAttributeBinding;
import com.google.cloud.dataplex.v1.DataAttributeBindingName;
import com.google.cloud.dataplex.v1.DataAttributeName;
import com.google.cloud.dataplex.v1.DataTaxonomy;
import com.google.cloud.dataplex.v1.DataTaxonomyName;
import com.google.cloud.dataplex.v1.DataTaxonomyServiceSettings;
import com.google.cloud.dataplex.v1.DeleteDataAttributeBindingRequest;
import com.google.cloud.dataplex.v1.DeleteDataAttributeRequest;
import com.google.cloud.dataplex.v1.DeleteDataTaxonomyRequest;
import com.google.cloud.dataplex.v1.GetDataAttributeBindingRequest;
import com.google.cloud.dataplex.v1.GetDataAttributeRequest;
import com.google.cloud.dataplex.v1.GetDataTaxonomyRequest;
import com.google.cloud.dataplex.v1.ListDataAttributeBindingsRequest;
import com.google.cloud.dataplex.v1.ListDataAttributeBindingsResponse;
import com.google.cloud.dataplex.v1.ListDataAttributesRequest;
import com.google.cloud.dataplex.v1.ListDataAttributesResponse;
import com.google.cloud.dataplex.v1.ListDataTaxonomiesRequest;
import com.google.cloud.dataplex.v1.ListDataTaxonomiesResponse;
import com.google.cloud.dataplex.v1.LocationName;
import com.google.cloud.dataplex.v1.OperationMetadata;
import com.google.cloud.dataplex.v1.UpdateDataAttributeBindingRequest;
import com.google.cloud.dataplex.v1.UpdateDataAttributeRequest;
import com.google.cloud.dataplex.v1.UpdateDataTaxonomyRequest;
import com.google.cloud.dataplex.v1.stub.DataTaxonomyServiceStub;
import com.google.cloud.dataplex.v1.stub.DataTaxonomyServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DataTaxonomyServiceClient
implements BackgroundResource {
    private final DataTaxonomyServiceSettings settings;
    private final DataTaxonomyServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final DataTaxonomyServiceClient create() throws IOException {
        return DataTaxonomyServiceClient.create(DataTaxonomyServiceSettings.newBuilder().build());
    }

    public static final DataTaxonomyServiceClient create(DataTaxonomyServiceSettings settings) throws IOException {
        return new DataTaxonomyServiceClient(settings);
    }

    public static final DataTaxonomyServiceClient create(DataTaxonomyServiceStub stub) {
        return new DataTaxonomyServiceClient(stub);
    }

    protected DataTaxonomyServiceClient(DataTaxonomyServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataTaxonomyServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected DataTaxonomyServiceClient(DataTaxonomyServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final DataTaxonomyServiceSettings getSettings() {
        return this.settings;
    }

    public DataTaxonomyServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<DataTaxonomy, OperationMetadata> createDataTaxonomyAsync(LocationName parent, DataTaxonomy dataTaxonomy, String dataTaxonomyId) {
        CreateDataTaxonomyRequest request = CreateDataTaxonomyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataTaxonomy(dataTaxonomy).setDataTaxonomyId(dataTaxonomyId).build();
        return this.createDataTaxonomyAsync(request);
    }

    public final OperationFuture<DataTaxonomy, OperationMetadata> createDataTaxonomyAsync(String parent, DataTaxonomy dataTaxonomy, String dataTaxonomyId) {
        CreateDataTaxonomyRequest request = CreateDataTaxonomyRequest.newBuilder().setParent(parent).setDataTaxonomy(dataTaxonomy).setDataTaxonomyId(dataTaxonomyId).build();
        return this.createDataTaxonomyAsync(request);
    }

    public final OperationFuture<DataTaxonomy, OperationMetadata> createDataTaxonomyAsync(CreateDataTaxonomyRequest request) {
        return this.createDataTaxonomyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDataTaxonomyRequest, DataTaxonomy, OperationMetadata> createDataTaxonomyOperationCallable() {
        return this.stub.createDataTaxonomyOperationCallable();
    }

    public final UnaryCallable<CreateDataTaxonomyRequest, Operation> createDataTaxonomyCallable() {
        return this.stub.createDataTaxonomyCallable();
    }

    public final OperationFuture<DataTaxonomy, OperationMetadata> updateDataTaxonomyAsync(DataTaxonomy dataTaxonomy, FieldMask updateMask) {
        UpdateDataTaxonomyRequest request = UpdateDataTaxonomyRequest.newBuilder().setDataTaxonomy(dataTaxonomy).setUpdateMask(updateMask).build();
        return this.updateDataTaxonomyAsync(request);
    }

    public final OperationFuture<DataTaxonomy, OperationMetadata> updateDataTaxonomyAsync(UpdateDataTaxonomyRequest request) {
        return this.updateDataTaxonomyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDataTaxonomyRequest, DataTaxonomy, OperationMetadata> updateDataTaxonomyOperationCallable() {
        return this.stub.updateDataTaxonomyOperationCallable();
    }

    public final UnaryCallable<UpdateDataTaxonomyRequest, Operation> updateDataTaxonomyCallable() {
        return this.stub.updateDataTaxonomyCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDataTaxonomyAsync(DataTaxonomyName name) {
        DeleteDataTaxonomyRequest request = DeleteDataTaxonomyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDataTaxonomyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDataTaxonomyAsync(String name) {
        DeleteDataTaxonomyRequest request = DeleteDataTaxonomyRequest.newBuilder().setName(name).build();
        return this.deleteDataTaxonomyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDataTaxonomyAsync(DeleteDataTaxonomyRequest request) {
        return this.deleteDataTaxonomyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDataTaxonomyRequest, Empty, OperationMetadata> deleteDataTaxonomyOperationCallable() {
        return this.stub.deleteDataTaxonomyOperationCallable();
    }

    public final UnaryCallable<DeleteDataTaxonomyRequest, Operation> deleteDataTaxonomyCallable() {
        return this.stub.deleteDataTaxonomyCallable();
    }

    public final ListDataTaxonomiesPagedResponse listDataTaxonomies(LocationName parent) {
        ListDataTaxonomiesRequest request = ListDataTaxonomiesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataTaxonomies(request);
    }

    public final ListDataTaxonomiesPagedResponse listDataTaxonomies(String parent) {
        ListDataTaxonomiesRequest request = ListDataTaxonomiesRequest.newBuilder().setParent(parent).build();
        return this.listDataTaxonomies(request);
    }

    public final ListDataTaxonomiesPagedResponse listDataTaxonomies(ListDataTaxonomiesRequest request) {
        return (ListDataTaxonomiesPagedResponse)((Object)this.listDataTaxonomiesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataTaxonomiesRequest, ListDataTaxonomiesPagedResponse> listDataTaxonomiesPagedCallable() {
        return this.stub.listDataTaxonomiesPagedCallable();
    }

    public final UnaryCallable<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse> listDataTaxonomiesCallable() {
        return this.stub.listDataTaxonomiesCallable();
    }

    public final DataTaxonomy getDataTaxonomy(DataTaxonomyName name) {
        GetDataTaxonomyRequest request = GetDataTaxonomyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataTaxonomy(request);
    }

    public final DataTaxonomy getDataTaxonomy(String name) {
        GetDataTaxonomyRequest request = GetDataTaxonomyRequest.newBuilder().setName(name).build();
        return this.getDataTaxonomy(request);
    }

    public final DataTaxonomy getDataTaxonomy(GetDataTaxonomyRequest request) {
        return (DataTaxonomy)this.getDataTaxonomyCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataTaxonomyRequest, DataTaxonomy> getDataTaxonomyCallable() {
        return this.stub.getDataTaxonomyCallable();
    }

    public final OperationFuture<DataAttributeBinding, OperationMetadata> createDataAttributeBindingAsync(LocationName parent, DataAttributeBinding dataAttributeBinding, String dataAttributeBindingId) {
        CreateDataAttributeBindingRequest request = CreateDataAttributeBindingRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataAttributeBinding(dataAttributeBinding).setDataAttributeBindingId(dataAttributeBindingId).build();
        return this.createDataAttributeBindingAsync(request);
    }

    public final OperationFuture<DataAttributeBinding, OperationMetadata> createDataAttributeBindingAsync(String parent, DataAttributeBinding dataAttributeBinding, String dataAttributeBindingId) {
        CreateDataAttributeBindingRequest request = CreateDataAttributeBindingRequest.newBuilder().setParent(parent).setDataAttributeBinding(dataAttributeBinding).setDataAttributeBindingId(dataAttributeBindingId).build();
        return this.createDataAttributeBindingAsync(request);
    }

    public final OperationFuture<DataAttributeBinding, OperationMetadata> createDataAttributeBindingAsync(CreateDataAttributeBindingRequest request) {
        return this.createDataAttributeBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDataAttributeBindingRequest, DataAttributeBinding, OperationMetadata> createDataAttributeBindingOperationCallable() {
        return this.stub.createDataAttributeBindingOperationCallable();
    }

    public final UnaryCallable<CreateDataAttributeBindingRequest, Operation> createDataAttributeBindingCallable() {
        return this.stub.createDataAttributeBindingCallable();
    }

    public final OperationFuture<DataAttributeBinding, OperationMetadata> updateDataAttributeBindingAsync(DataAttributeBinding dataAttributeBinding, FieldMask updateMask) {
        UpdateDataAttributeBindingRequest request = UpdateDataAttributeBindingRequest.newBuilder().setDataAttributeBinding(dataAttributeBinding).setUpdateMask(updateMask).build();
        return this.updateDataAttributeBindingAsync(request);
    }

    public final OperationFuture<DataAttributeBinding, OperationMetadata> updateDataAttributeBindingAsync(UpdateDataAttributeBindingRequest request) {
        return this.updateDataAttributeBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDataAttributeBindingRequest, DataAttributeBinding, OperationMetadata> updateDataAttributeBindingOperationCallable() {
        return this.stub.updateDataAttributeBindingOperationCallable();
    }

    public final UnaryCallable<UpdateDataAttributeBindingRequest, Operation> updateDataAttributeBindingCallable() {
        return this.stub.updateDataAttributeBindingCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDataAttributeBindingAsync(DataAttributeBindingName name) {
        DeleteDataAttributeBindingRequest request = DeleteDataAttributeBindingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDataAttributeBindingAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDataAttributeBindingAsync(String name) {
        DeleteDataAttributeBindingRequest request = DeleteDataAttributeBindingRequest.newBuilder().setName(name).build();
        return this.deleteDataAttributeBindingAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDataAttributeBindingAsync(DeleteDataAttributeBindingRequest request) {
        return this.deleteDataAttributeBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDataAttributeBindingRequest, Empty, OperationMetadata> deleteDataAttributeBindingOperationCallable() {
        return this.stub.deleteDataAttributeBindingOperationCallable();
    }

    public final UnaryCallable<DeleteDataAttributeBindingRequest, Operation> deleteDataAttributeBindingCallable() {
        return this.stub.deleteDataAttributeBindingCallable();
    }

    public final ListDataAttributeBindingsPagedResponse listDataAttributeBindings(LocationName parent) {
        ListDataAttributeBindingsRequest request = ListDataAttributeBindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataAttributeBindings(request);
    }

    public final ListDataAttributeBindingsPagedResponse listDataAttributeBindings(String parent) {
        ListDataAttributeBindingsRequest request = ListDataAttributeBindingsRequest.newBuilder().setParent(parent).build();
        return this.listDataAttributeBindings(request);
    }

    public final ListDataAttributeBindingsPagedResponse listDataAttributeBindings(ListDataAttributeBindingsRequest request) {
        return (ListDataAttributeBindingsPagedResponse)((Object)this.listDataAttributeBindingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataAttributeBindingsRequest, ListDataAttributeBindingsPagedResponse> listDataAttributeBindingsPagedCallable() {
        return this.stub.listDataAttributeBindingsPagedCallable();
    }

    public final UnaryCallable<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse> listDataAttributeBindingsCallable() {
        return this.stub.listDataAttributeBindingsCallable();
    }

    public final DataAttributeBinding getDataAttributeBinding(DataAttributeBindingName name) {
        GetDataAttributeBindingRequest request = GetDataAttributeBindingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataAttributeBinding(request);
    }

    public final DataAttributeBinding getDataAttributeBinding(String name) {
        GetDataAttributeBindingRequest request = GetDataAttributeBindingRequest.newBuilder().setName(name).build();
        return this.getDataAttributeBinding(request);
    }

    public final DataAttributeBinding getDataAttributeBinding(GetDataAttributeBindingRequest request) {
        return (DataAttributeBinding)this.getDataAttributeBindingCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataAttributeBindingRequest, DataAttributeBinding> getDataAttributeBindingCallable() {
        return this.stub.getDataAttributeBindingCallable();
    }

    public final OperationFuture<DataAttribute, OperationMetadata> createDataAttributeAsync(DataTaxonomyName parent, DataAttribute dataAttribute, String dataAttributeId) {
        CreateDataAttributeRequest request = CreateDataAttributeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataAttribute(dataAttribute).setDataAttributeId(dataAttributeId).build();
        return this.createDataAttributeAsync(request);
    }

    public final OperationFuture<DataAttribute, OperationMetadata> createDataAttributeAsync(String parent, DataAttribute dataAttribute, String dataAttributeId) {
        CreateDataAttributeRequest request = CreateDataAttributeRequest.newBuilder().setParent(parent).setDataAttribute(dataAttribute).setDataAttributeId(dataAttributeId).build();
        return this.createDataAttributeAsync(request);
    }

    public final OperationFuture<DataAttribute, OperationMetadata> createDataAttributeAsync(CreateDataAttributeRequest request) {
        return this.createDataAttributeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDataAttributeRequest, DataAttribute, OperationMetadata> createDataAttributeOperationCallable() {
        return this.stub.createDataAttributeOperationCallable();
    }

    public final UnaryCallable<CreateDataAttributeRequest, Operation> createDataAttributeCallable() {
        return this.stub.createDataAttributeCallable();
    }

    public final OperationFuture<DataAttribute, OperationMetadata> updateDataAttributeAsync(DataAttribute dataAttribute, FieldMask updateMask) {
        UpdateDataAttributeRequest request = UpdateDataAttributeRequest.newBuilder().setDataAttribute(dataAttribute).setUpdateMask(updateMask).build();
        return this.updateDataAttributeAsync(request);
    }

    public final OperationFuture<DataAttribute, OperationMetadata> updateDataAttributeAsync(UpdateDataAttributeRequest request) {
        return this.updateDataAttributeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDataAttributeRequest, DataAttribute, OperationMetadata> updateDataAttributeOperationCallable() {
        return this.stub.updateDataAttributeOperationCallable();
    }

    public final UnaryCallable<UpdateDataAttributeRequest, Operation> updateDataAttributeCallable() {
        return this.stub.updateDataAttributeCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDataAttributeAsync(DataAttributeName name) {
        DeleteDataAttributeRequest request = DeleteDataAttributeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDataAttributeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDataAttributeAsync(String name) {
        DeleteDataAttributeRequest request = DeleteDataAttributeRequest.newBuilder().setName(name).build();
        return this.deleteDataAttributeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDataAttributeAsync(DeleteDataAttributeRequest request) {
        return this.deleteDataAttributeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDataAttributeRequest, Empty, OperationMetadata> deleteDataAttributeOperationCallable() {
        return this.stub.deleteDataAttributeOperationCallable();
    }

    public final UnaryCallable<DeleteDataAttributeRequest, Operation> deleteDataAttributeCallable() {
        return this.stub.deleteDataAttributeCallable();
    }

    public final ListDataAttributesPagedResponse listDataAttributes(DataTaxonomyName parent) {
        ListDataAttributesRequest request = ListDataAttributesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataAttributes(request);
    }

    public final ListDataAttributesPagedResponse listDataAttributes(String parent) {
        ListDataAttributesRequest request = ListDataAttributesRequest.newBuilder().setParent(parent).build();
        return this.listDataAttributes(request);
    }

    public final ListDataAttributesPagedResponse listDataAttributes(ListDataAttributesRequest request) {
        return (ListDataAttributesPagedResponse)((Object)this.listDataAttributesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataAttributesRequest, ListDataAttributesPagedResponse> listDataAttributesPagedCallable() {
        return this.stub.listDataAttributesPagedCallable();
    }

    public final UnaryCallable<ListDataAttributesRequest, ListDataAttributesResponse> listDataAttributesCallable() {
        return this.stub.listDataAttributesCallable();
    }

    public final DataAttribute getDataAttribute(DataAttributeName name) {
        GetDataAttributeRequest request = GetDataAttributeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataAttribute(request);
    }

    public final DataAttribute getDataAttribute(String name) {
        GetDataAttributeRequest request = GetDataAttributeRequest.newBuilder().setName(name).build();
        return this.getDataAttribute(request);
    }

    public final DataAttribute getDataAttribute(GetDataAttributeRequest request) {
        return (DataAttribute)this.getDataAttributeCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataAttributeRequest, DataAttribute> getDataAttributeCallable() {
        return this.stub.getDataAttributeCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDataAttributesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataAttributesRequest, ListDataAttributesResponse, DataAttribute, ListDataAttributesPage, ListDataAttributesFixedSizeCollection> {
        private ListDataAttributesFixedSizeCollection(List<ListDataAttributesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataAttributesFixedSizeCollection createEmptyCollection() {
            return new ListDataAttributesFixedSizeCollection(null, 0);
        }

        protected ListDataAttributesFixedSizeCollection createCollection(List<ListDataAttributesPage> pages, int collectionSize) {
            return new ListDataAttributesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataAttributesPage
    extends AbstractPage<ListDataAttributesRequest, ListDataAttributesResponse, DataAttribute, ListDataAttributesPage> {
        private ListDataAttributesPage(PageContext<ListDataAttributesRequest, ListDataAttributesResponse, DataAttribute> context, ListDataAttributesResponse response) {
            super(context, (Object)response);
        }

        private static ListDataAttributesPage createEmptyPage() {
            return new ListDataAttributesPage(null, null);
        }

        protected ListDataAttributesPage createPage(PageContext<ListDataAttributesRequest, ListDataAttributesResponse, DataAttribute> context, ListDataAttributesResponse response) {
            return new ListDataAttributesPage(context, response);
        }

        public ApiFuture<ListDataAttributesPage> createPageAsync(PageContext<ListDataAttributesRequest, ListDataAttributesResponse, DataAttribute> context, ApiFuture<ListDataAttributesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataAttributesPagedResponse
    extends AbstractPagedListResponse<ListDataAttributesRequest, ListDataAttributesResponse, DataAttribute, ListDataAttributesPage, ListDataAttributesFixedSizeCollection> {
        public static ApiFuture<ListDataAttributesPagedResponse> createAsync(PageContext<ListDataAttributesRequest, ListDataAttributesResponse, DataAttribute> context, ApiFuture<ListDataAttributesResponse> futureResponse) {
            ApiFuture<ListDataAttributesPage> futurePage = ListDataAttributesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDataAttributesPagedResponse((ListDataAttributesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDataAttributesPagedResponse(ListDataAttributesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataAttributesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDataAttributeBindingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse, DataAttributeBinding, ListDataAttributeBindingsPage, ListDataAttributeBindingsFixedSizeCollection> {
        private ListDataAttributeBindingsFixedSizeCollection(List<ListDataAttributeBindingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataAttributeBindingsFixedSizeCollection createEmptyCollection() {
            return new ListDataAttributeBindingsFixedSizeCollection(null, 0);
        }

        protected ListDataAttributeBindingsFixedSizeCollection createCollection(List<ListDataAttributeBindingsPage> pages, int collectionSize) {
            return new ListDataAttributeBindingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataAttributeBindingsPage
    extends AbstractPage<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse, DataAttributeBinding, ListDataAttributeBindingsPage> {
        private ListDataAttributeBindingsPage(PageContext<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse, DataAttributeBinding> context, ListDataAttributeBindingsResponse response) {
            super(context, (Object)response);
        }

        private static ListDataAttributeBindingsPage createEmptyPage() {
            return new ListDataAttributeBindingsPage(null, null);
        }

        protected ListDataAttributeBindingsPage createPage(PageContext<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse, DataAttributeBinding> context, ListDataAttributeBindingsResponse response) {
            return new ListDataAttributeBindingsPage(context, response);
        }

        public ApiFuture<ListDataAttributeBindingsPage> createPageAsync(PageContext<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse, DataAttributeBinding> context, ApiFuture<ListDataAttributeBindingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataAttributeBindingsPagedResponse
    extends AbstractPagedListResponse<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse, DataAttributeBinding, ListDataAttributeBindingsPage, ListDataAttributeBindingsFixedSizeCollection> {
        public static ApiFuture<ListDataAttributeBindingsPagedResponse> createAsync(PageContext<ListDataAttributeBindingsRequest, ListDataAttributeBindingsResponse, DataAttributeBinding> context, ApiFuture<ListDataAttributeBindingsResponse> futureResponse) {
            ApiFuture<ListDataAttributeBindingsPage> futurePage = ListDataAttributeBindingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDataAttributeBindingsPagedResponse((ListDataAttributeBindingsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDataAttributeBindingsPagedResponse(ListDataAttributeBindingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataAttributeBindingsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDataTaxonomiesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse, DataTaxonomy, ListDataTaxonomiesPage, ListDataTaxonomiesFixedSizeCollection> {
        private ListDataTaxonomiesFixedSizeCollection(List<ListDataTaxonomiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataTaxonomiesFixedSizeCollection createEmptyCollection() {
            return new ListDataTaxonomiesFixedSizeCollection(null, 0);
        }

        protected ListDataTaxonomiesFixedSizeCollection createCollection(List<ListDataTaxonomiesPage> pages, int collectionSize) {
            return new ListDataTaxonomiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataTaxonomiesPage
    extends AbstractPage<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse, DataTaxonomy, ListDataTaxonomiesPage> {
        private ListDataTaxonomiesPage(PageContext<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse, DataTaxonomy> context, ListDataTaxonomiesResponse response) {
            super(context, (Object)response);
        }

        private static ListDataTaxonomiesPage createEmptyPage() {
            return new ListDataTaxonomiesPage(null, null);
        }

        protected ListDataTaxonomiesPage createPage(PageContext<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse, DataTaxonomy> context, ListDataTaxonomiesResponse response) {
            return new ListDataTaxonomiesPage(context, response);
        }

        public ApiFuture<ListDataTaxonomiesPage> createPageAsync(PageContext<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse, DataTaxonomy> context, ApiFuture<ListDataTaxonomiesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataTaxonomiesPagedResponse
    extends AbstractPagedListResponse<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse, DataTaxonomy, ListDataTaxonomiesPage, ListDataTaxonomiesFixedSizeCollection> {
        public static ApiFuture<ListDataTaxonomiesPagedResponse> createAsync(PageContext<ListDataTaxonomiesRequest, ListDataTaxonomiesResponse, DataTaxonomy> context, ApiFuture<ListDataTaxonomiesResponse> futureResponse) {
            ApiFuture<ListDataTaxonomiesPage> futurePage = ListDataTaxonomiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDataTaxonomiesPagedResponse((ListDataTaxonomiesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDataTaxonomiesPagedResponse(ListDataTaxonomiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataTaxonomiesFixedSizeCollection.createEmptyCollection());
        }
    }
}

