/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.CreateEntityRequest;
import com.google.cloud.dataplex.v1.CreatePartitionRequest;
import com.google.cloud.dataplex.v1.DeleteEntityRequest;
import com.google.cloud.dataplex.v1.DeletePartitionRequest;
import com.google.cloud.dataplex.v1.Entity;
import com.google.cloud.dataplex.v1.GetEntityRequest;
import com.google.cloud.dataplex.v1.GetPartitionRequest;
import com.google.cloud.dataplex.v1.ListEntitiesRequest;
import com.google.cloud.dataplex.v1.ListEntitiesResponse;
import com.google.cloud.dataplex.v1.ListPartitionsRequest;
import com.google.cloud.dataplex.v1.ListPartitionsResponse;
import com.google.cloud.dataplex.v1.MetadataServiceClient;
import com.google.cloud.dataplex.v1.Partition;
import com.google.cloud.dataplex.v1.UpdateEntityRequest;
import com.google.cloud.dataplex.v1.stub.HttpJsonMetadataServiceCallableFactory;
import com.google.cloud.dataplex.v1.stub.MetadataServiceStub;
import com.google.cloud.dataplex.v1.stub.MetadataServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonMetadataServiceStub
extends MetadataServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateEntityRequest, Entity> createEntityMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.MetadataService/CreateEntity").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/lakes/*/zones/*}/entities", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("entity", (Message)request.getEntity(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Entity.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateEntityRequest, Entity> updateEntityMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.MetadataService/UpdateEntity").setHttpMethod("PUT").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{entity.name=projects/*/locations/*/lakes/*/zones/*/entities/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "entity.name", (Object)request.getEntity().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("entity", (Message)request.getEntity(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Entity.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteEntityRequest, Empty> deleteEntityMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.MetadataService/DeleteEntity").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/lakes/*/zones/*/entities/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetEntityRequest, Entity> getEntityMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.MetadataService/GetEntity").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/lakes/*/zones/*/entities/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Entity.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListEntitiesRequest, ListEntitiesResponse> listEntitiesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.MetadataService/ListEntities").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/lakes/*/zones/*}/entities", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListEntitiesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreatePartitionRequest, Partition> createPartitionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.MetadataService/CreatePartition").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/lakes/*/zones/*/entities/*}/partitions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("partition", (Message)request.getPartition(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Partition.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeletePartitionRequest, Empty> deletePartitionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.MetadataService/DeletePartition").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/lakes/*/zones/*/entities/*/partitions/**}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetPartitionRequest, Partition> getPartitionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.MetadataService/GetPartition").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/lakes/*/zones/*/entities/*/partitions/**}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Partition.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListPartitionsRequest, ListPartitionsResponse> listPartitionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.MetadataService/ListPartitions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/lakes/*/zones/*/entities/*}/partitions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListPartitionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateEntityRequest, Entity> createEntityCallable;
    private final UnaryCallable<UpdateEntityRequest, Entity> updateEntityCallable;
    private final UnaryCallable<DeleteEntityRequest, Empty> deleteEntityCallable;
    private final UnaryCallable<GetEntityRequest, Entity> getEntityCallable;
    private final UnaryCallable<ListEntitiesRequest, ListEntitiesResponse> listEntitiesCallable;
    private final UnaryCallable<ListEntitiesRequest, MetadataServiceClient.ListEntitiesPagedResponse> listEntitiesPagedCallable;
    private final UnaryCallable<CreatePartitionRequest, Partition> createPartitionCallable;
    private final UnaryCallable<DeletePartitionRequest, Empty> deletePartitionCallable;
    private final UnaryCallable<GetPartitionRequest, Partition> getPartitionCallable;
    private final UnaryCallable<ListPartitionsRequest, ListPartitionsResponse> listPartitionsCallable;
    private final UnaryCallable<ListPartitionsRequest, MetadataServiceClient.ListPartitionsPagedResponse> listPartitionsPagedCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, MetadataServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonMetadataServiceStub create(MetadataServiceStubSettings settings) throws IOException {
        return new HttpJsonMetadataServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonMetadataServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonMetadataServiceStub(MetadataServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonMetadataServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonMetadataServiceStub(MetadataServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonMetadataServiceStub(MetadataServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonMetadataServiceCallableFactory());
    }

    protected HttpJsonMetadataServiceStub(MetadataServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createEntityTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createEntityMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateEntityTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateEntityMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("entity.name", String.valueOf(request.getEntity().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteEntityTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteEntityMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getEntityTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getEntityMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listEntitiesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listEntitiesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createPartitionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createPartitionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deletePartitionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deletePartitionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getPartitionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getPartitionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listPartitionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listPartitionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createEntityCallable = callableFactory.createUnaryCallable(createEntityTransportSettings, settings.createEntitySettings(), clientContext);
        this.updateEntityCallable = callableFactory.createUnaryCallable(updateEntityTransportSettings, settings.updateEntitySettings(), clientContext);
        this.deleteEntityCallable = callableFactory.createUnaryCallable(deleteEntityTransportSettings, settings.deleteEntitySettings(), clientContext);
        this.getEntityCallable = callableFactory.createUnaryCallable(getEntityTransportSettings, settings.getEntitySettings(), clientContext);
        this.listEntitiesCallable = callableFactory.createUnaryCallable(listEntitiesTransportSettings, settings.listEntitiesSettings(), clientContext);
        this.listEntitiesPagedCallable = callableFactory.createPagedCallable(listEntitiesTransportSettings, settings.listEntitiesSettings(), clientContext);
        this.createPartitionCallable = callableFactory.createUnaryCallable(createPartitionTransportSettings, settings.createPartitionSettings(), clientContext);
        this.deletePartitionCallable = callableFactory.createUnaryCallable(deletePartitionTransportSettings, settings.deletePartitionSettings(), clientContext);
        this.getPartitionCallable = callableFactory.createUnaryCallable(getPartitionTransportSettings, settings.getPartitionSettings(), clientContext);
        this.listPartitionsCallable = callableFactory.createUnaryCallable(listPartitionsTransportSettings, settings.listPartitionsSettings(), clientContext);
        this.listPartitionsPagedCallable = callableFactory.createPagedCallable(listPartitionsTransportSettings, settings.listPartitionsSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createEntityMethodDescriptor);
        methodDescriptors.add(updateEntityMethodDescriptor);
        methodDescriptors.add(deleteEntityMethodDescriptor);
        methodDescriptors.add(getEntityMethodDescriptor);
        methodDescriptors.add(listEntitiesMethodDescriptor);
        methodDescriptors.add(createPartitionMethodDescriptor);
        methodDescriptors.add(deletePartitionMethodDescriptor);
        methodDescriptors.add(getPartitionMethodDescriptor);
        methodDescriptors.add(listPartitionsMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateEntityRequest, Entity> createEntityCallable() {
        return this.createEntityCallable;
    }

    @Override
    public UnaryCallable<UpdateEntityRequest, Entity> updateEntityCallable() {
        return this.updateEntityCallable;
    }

    @Override
    public UnaryCallable<DeleteEntityRequest, Empty> deleteEntityCallable() {
        return this.deleteEntityCallable;
    }

    @Override
    public UnaryCallable<GetEntityRequest, Entity> getEntityCallable() {
        return this.getEntityCallable;
    }

    @Override
    public UnaryCallable<ListEntitiesRequest, ListEntitiesResponse> listEntitiesCallable() {
        return this.listEntitiesCallable;
    }

    @Override
    public UnaryCallable<ListEntitiesRequest, MetadataServiceClient.ListEntitiesPagedResponse> listEntitiesPagedCallable() {
        return this.listEntitiesPagedCallable;
    }

    @Override
    public UnaryCallable<CreatePartitionRequest, Partition> createPartitionCallable() {
        return this.createPartitionCallable;
    }

    @Override
    public UnaryCallable<DeletePartitionRequest, Empty> deletePartitionCallable() {
        return this.deletePartitionCallable;
    }

    @Override
    public UnaryCallable<GetPartitionRequest, Partition> getPartitionCallable() {
        return this.getPartitionCallable;
    }

    @Override
    public UnaryCallable<ListPartitionsRequest, ListPartitionsResponse> listPartitionsCallable() {
        return this.listPartitionsCallable;
    }

    @Override
    public UnaryCallable<ListPartitionsRequest, MetadataServiceClient.ListPartitionsPagedResponse> listPartitionsPagedCallable() {
        return this.listPartitionsPagedCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, MetadataServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

