/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.Content;
import com.google.cloud.dataplex.v1.ContentName;
import com.google.cloud.dataplex.v1.ContentServiceSettings;
import com.google.cloud.dataplex.v1.CreateContentRequest;
import com.google.cloud.dataplex.v1.DeleteContentRequest;
import com.google.cloud.dataplex.v1.GetContentRequest;
import com.google.cloud.dataplex.v1.LakeName;
import com.google.cloud.dataplex.v1.ListContentRequest;
import com.google.cloud.dataplex.v1.ListContentResponse;
import com.google.cloud.dataplex.v1.UpdateContentRequest;
import com.google.cloud.dataplex.v1.stub.ContentServiceStub;
import com.google.cloud.dataplex.v1.stub.ContentServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ContentServiceClient
implements BackgroundResource {
    private final ContentServiceSettings settings;
    private final ContentServiceStub stub;

    public static final ContentServiceClient create() throws IOException {
        return ContentServiceClient.create(ContentServiceSettings.newBuilder().build());
    }

    public static final ContentServiceClient create(ContentServiceSettings settings) throws IOException {
        return new ContentServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ContentServiceClient create(ContentServiceStub stub) {
        return new ContentServiceClient(stub);
    }

    protected ContentServiceClient(ContentServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ContentServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ContentServiceClient(ContentServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ContentServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ContentServiceStub getStub() {
        return this.stub;
    }

    public final Content createContent(LakeName parent, Content content) {
        CreateContentRequest request = CreateContentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setContent(content).build();
        return this.createContent(request);
    }

    public final Content createContent(String parent, Content content) {
        CreateContentRequest request = CreateContentRequest.newBuilder().setParent(parent).setContent(content).build();
        return this.createContent(request);
    }

    public final Content createContent(CreateContentRequest request) {
        return (Content)this.createContentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateContentRequest, Content> createContentCallable() {
        return this.stub.createContentCallable();
    }

    public final Content updateContent(Content content, FieldMask updateMask) {
        UpdateContentRequest request = UpdateContentRequest.newBuilder().setContent(content).setUpdateMask(updateMask).build();
        return this.updateContent(request);
    }

    public final Content updateContent(UpdateContentRequest request) {
        return (Content)this.updateContentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateContentRequest, Content> updateContentCallable() {
        return this.stub.updateContentCallable();
    }

    public final void deleteContent(ContentName name) {
        DeleteContentRequest request = DeleteContentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteContent(request);
    }

    public final void deleteContent(String name) {
        DeleteContentRequest request = DeleteContentRequest.newBuilder().setName(name).build();
        this.deleteContent(request);
    }

    public final void deleteContent(DeleteContentRequest request) {
        this.deleteContentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteContentRequest, Empty> deleteContentCallable() {
        return this.stub.deleteContentCallable();
    }

    public final Content getContent(ContentName name) {
        GetContentRequest request = GetContentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getContent(request);
    }

    public final Content getContent(String name) {
        GetContentRequest request = GetContentRequest.newBuilder().setName(name).build();
        return this.getContent(request);
    }

    public final Content getContent(GetContentRequest request) {
        return (Content)this.getContentCallable().call((Object)request);
    }

    public final UnaryCallable<GetContentRequest, Content> getContentCallable() {
        return this.stub.getContentCallable();
    }

    public final ListContentPagedResponse listContent(LakeName parent) {
        ListContentRequest request = ListContentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listContent(request);
    }

    public final ListContentPagedResponse listContent(String parent) {
        ListContentRequest request = ListContentRequest.newBuilder().setParent(parent).build();
        return this.listContent(request);
    }

    public final ListContentPagedResponse listContent(ListContentRequest request) {
        return (ListContentPagedResponse)((Object)this.listContentPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListContentRequest, ListContentPagedResponse> listContentPagedCallable() {
        return this.stub.listContentPagedCallable();
    }

    public final UnaryCallable<ListContentRequest, ListContentResponse> listContentCallable() {
        return this.stub.listContentCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListContentFixedSizeCollection
    extends AbstractFixedSizeCollection<ListContentRequest, ListContentResponse, Content, ListContentPage, ListContentFixedSizeCollection> {
        private ListContentFixedSizeCollection(List<ListContentPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListContentFixedSizeCollection createEmptyCollection() {
            return new ListContentFixedSizeCollection(null, 0);
        }

        protected ListContentFixedSizeCollection createCollection(List<ListContentPage> pages, int collectionSize) {
            return new ListContentFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListContentPage
    extends AbstractPage<ListContentRequest, ListContentResponse, Content, ListContentPage> {
        private ListContentPage(PageContext<ListContentRequest, ListContentResponse, Content> context, ListContentResponse response) {
            super(context, (Object)response);
        }

        private static ListContentPage createEmptyPage() {
            return new ListContentPage(null, null);
        }

        protected ListContentPage createPage(PageContext<ListContentRequest, ListContentResponse, Content> context, ListContentResponse response) {
            return new ListContentPage(context, response);
        }

        public ApiFuture<ListContentPage> createPageAsync(PageContext<ListContentRequest, ListContentResponse, Content> context, ApiFuture<ListContentResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListContentPagedResponse
    extends AbstractPagedListResponse<ListContentRequest, ListContentResponse, Content, ListContentPage, ListContentFixedSizeCollection> {
        public static ApiFuture<ListContentPagedResponse> createAsync(PageContext<ListContentRequest, ListContentResponse, Content> context, ApiFuture<ListContentResponse> futureResponse) {
            ApiFuture<ListContentPage> futurePage = ListContentPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListContentPagedResponse((ListContentPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListContentPagedResponse(ListContentPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListContentFixedSizeCollection.createEmptyCollection());
        }
    }
}

