/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.Action;
import com.google.cloud.dataplex.v1.Asset;
import com.google.cloud.dataplex.v1.AssetName;
import com.google.cloud.dataplex.v1.CancelJobRequest;
import com.google.cloud.dataplex.v1.CreateAssetRequest;
import com.google.cloud.dataplex.v1.CreateEnvironmentRequest;
import com.google.cloud.dataplex.v1.CreateLakeRequest;
import com.google.cloud.dataplex.v1.CreateTaskRequest;
import com.google.cloud.dataplex.v1.CreateZoneRequest;
import com.google.cloud.dataplex.v1.DataplexServiceSettings;
import com.google.cloud.dataplex.v1.DeleteAssetRequest;
import com.google.cloud.dataplex.v1.DeleteEnvironmentRequest;
import com.google.cloud.dataplex.v1.DeleteLakeRequest;
import com.google.cloud.dataplex.v1.DeleteTaskRequest;
import com.google.cloud.dataplex.v1.DeleteZoneRequest;
import com.google.cloud.dataplex.v1.Environment;
import com.google.cloud.dataplex.v1.EnvironmentName;
import com.google.cloud.dataplex.v1.GetAssetRequest;
import com.google.cloud.dataplex.v1.GetEnvironmentRequest;
import com.google.cloud.dataplex.v1.GetJobRequest;
import com.google.cloud.dataplex.v1.GetLakeRequest;
import com.google.cloud.dataplex.v1.GetTaskRequest;
import com.google.cloud.dataplex.v1.GetZoneRequest;
import com.google.cloud.dataplex.v1.Job;
import com.google.cloud.dataplex.v1.JobName;
import com.google.cloud.dataplex.v1.Lake;
import com.google.cloud.dataplex.v1.LakeName;
import com.google.cloud.dataplex.v1.ListActionsResponse;
import com.google.cloud.dataplex.v1.ListAssetActionsRequest;
import com.google.cloud.dataplex.v1.ListAssetsRequest;
import com.google.cloud.dataplex.v1.ListAssetsResponse;
import com.google.cloud.dataplex.v1.ListEnvironmentsRequest;
import com.google.cloud.dataplex.v1.ListEnvironmentsResponse;
import com.google.cloud.dataplex.v1.ListJobsRequest;
import com.google.cloud.dataplex.v1.ListJobsResponse;
import com.google.cloud.dataplex.v1.ListLakeActionsRequest;
import com.google.cloud.dataplex.v1.ListLakesRequest;
import com.google.cloud.dataplex.v1.ListLakesResponse;
import com.google.cloud.dataplex.v1.ListSessionsRequest;
import com.google.cloud.dataplex.v1.ListSessionsResponse;
import com.google.cloud.dataplex.v1.ListTasksRequest;
import com.google.cloud.dataplex.v1.ListTasksResponse;
import com.google.cloud.dataplex.v1.ListZoneActionsRequest;
import com.google.cloud.dataplex.v1.ListZonesRequest;
import com.google.cloud.dataplex.v1.ListZonesResponse;
import com.google.cloud.dataplex.v1.LocationName;
import com.google.cloud.dataplex.v1.OperationMetadata;
import com.google.cloud.dataplex.v1.Session;
import com.google.cloud.dataplex.v1.Task;
import com.google.cloud.dataplex.v1.TaskName;
import com.google.cloud.dataplex.v1.UpdateAssetRequest;
import com.google.cloud.dataplex.v1.UpdateEnvironmentRequest;
import com.google.cloud.dataplex.v1.UpdateLakeRequest;
import com.google.cloud.dataplex.v1.UpdateTaskRequest;
import com.google.cloud.dataplex.v1.UpdateZoneRequest;
import com.google.cloud.dataplex.v1.Zone;
import com.google.cloud.dataplex.v1.ZoneName;
import com.google.cloud.dataplex.v1.stub.DataplexServiceStub;
import com.google.cloud.dataplex.v1.stub.DataplexServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DataplexServiceClient
implements BackgroundResource {
    private final DataplexServiceSettings settings;
    private final DataplexServiceStub stub;
    private final OperationsClient operationsClient;

    public static final DataplexServiceClient create() throws IOException {
        return DataplexServiceClient.create(DataplexServiceSettings.newBuilder().build());
    }

    public static final DataplexServiceClient create(DataplexServiceSettings settings) throws IOException {
        return new DataplexServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DataplexServiceClient create(DataplexServiceStub stub) {
        return new DataplexServiceClient(stub);
    }

    protected DataplexServiceClient(DataplexServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataplexServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DataplexServiceClient(DataplexServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DataplexServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DataplexServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<Lake, OperationMetadata> createLakeAsync(LocationName parent, Lake lake, String lakeId) {
        CreateLakeRequest request = CreateLakeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setLake(lake).setLakeId(lakeId).build();
        return this.createLakeAsync(request);
    }

    public final OperationFuture<Lake, OperationMetadata> createLakeAsync(String parent, Lake lake, String lakeId) {
        CreateLakeRequest request = CreateLakeRequest.newBuilder().setParent(parent).setLake(lake).setLakeId(lakeId).build();
        return this.createLakeAsync(request);
    }

    public final OperationFuture<Lake, OperationMetadata> createLakeAsync(CreateLakeRequest request) {
        return this.createLakeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateLakeRequest, Lake, OperationMetadata> createLakeOperationCallable() {
        return this.stub.createLakeOperationCallable();
    }

    public final UnaryCallable<CreateLakeRequest, Operation> createLakeCallable() {
        return this.stub.createLakeCallable();
    }

    public final OperationFuture<Lake, OperationMetadata> updateLakeAsync(Lake lake, FieldMask updateMask) {
        UpdateLakeRequest request = UpdateLakeRequest.newBuilder().setLake(lake).setUpdateMask(updateMask).build();
        return this.updateLakeAsync(request);
    }

    public final OperationFuture<Lake, OperationMetadata> updateLakeAsync(UpdateLakeRequest request) {
        return this.updateLakeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateLakeRequest, Lake, OperationMetadata> updateLakeOperationCallable() {
        return this.stub.updateLakeOperationCallable();
    }

    public final UnaryCallable<UpdateLakeRequest, Operation> updateLakeCallable() {
        return this.stub.updateLakeCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLakeAsync(LakeName name) {
        DeleteLakeRequest request = DeleteLakeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteLakeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLakeAsync(String name) {
        DeleteLakeRequest request = DeleteLakeRequest.newBuilder().setName(name).build();
        return this.deleteLakeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLakeAsync(DeleteLakeRequest request) {
        return this.deleteLakeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteLakeRequest, Empty, OperationMetadata> deleteLakeOperationCallable() {
        return this.stub.deleteLakeOperationCallable();
    }

    public final UnaryCallable<DeleteLakeRequest, Operation> deleteLakeCallable() {
        return this.stub.deleteLakeCallable();
    }

    public final ListLakesPagedResponse listLakes(LocationName parent) {
        ListLakesRequest request = ListLakesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listLakes(request);
    }

    public final ListLakesPagedResponse listLakes(String parent) {
        ListLakesRequest request = ListLakesRequest.newBuilder().setParent(parent).build();
        return this.listLakes(request);
    }

    public final ListLakesPagedResponse listLakes(ListLakesRequest request) {
        return (ListLakesPagedResponse)((Object)this.listLakesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLakesRequest, ListLakesPagedResponse> listLakesPagedCallable() {
        return this.stub.listLakesPagedCallable();
    }

    public final UnaryCallable<ListLakesRequest, ListLakesResponse> listLakesCallable() {
        return this.stub.listLakesCallable();
    }

    public final Lake getLake(LakeName name) {
        GetLakeRequest request = GetLakeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getLake(request);
    }

    public final Lake getLake(String name) {
        GetLakeRequest request = GetLakeRequest.newBuilder().setName(name).build();
        return this.getLake(request);
    }

    public final Lake getLake(GetLakeRequest request) {
        return (Lake)this.getLakeCallable().call((Object)request);
    }

    public final UnaryCallable<GetLakeRequest, Lake> getLakeCallable() {
        return this.stub.getLakeCallable();
    }

    public final ListLakeActionsPagedResponse listLakeActions(LakeName parent) {
        ListLakeActionsRequest request = ListLakeActionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listLakeActions(request);
    }

    public final ListLakeActionsPagedResponse listLakeActions(String parent) {
        ListLakeActionsRequest request = ListLakeActionsRequest.newBuilder().setParent(parent).build();
        return this.listLakeActions(request);
    }

    public final ListLakeActionsPagedResponse listLakeActions(ListLakeActionsRequest request) {
        return (ListLakeActionsPagedResponse)((Object)this.listLakeActionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLakeActionsRequest, ListLakeActionsPagedResponse> listLakeActionsPagedCallable() {
        return this.stub.listLakeActionsPagedCallable();
    }

    public final UnaryCallable<ListLakeActionsRequest, ListActionsResponse> listLakeActionsCallable() {
        return this.stub.listLakeActionsCallable();
    }

    public final OperationFuture<Zone, OperationMetadata> createZoneAsync(LakeName parent, Zone zone, String zoneId) {
        CreateZoneRequest request = CreateZoneRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setZone(zone).setZoneId(zoneId).build();
        return this.createZoneAsync(request);
    }

    public final OperationFuture<Zone, OperationMetadata> createZoneAsync(String parent, Zone zone, String zoneId) {
        CreateZoneRequest request = CreateZoneRequest.newBuilder().setParent(parent).setZone(zone).setZoneId(zoneId).build();
        return this.createZoneAsync(request);
    }

    public final OperationFuture<Zone, OperationMetadata> createZoneAsync(CreateZoneRequest request) {
        return this.createZoneOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateZoneRequest, Zone, OperationMetadata> createZoneOperationCallable() {
        return this.stub.createZoneOperationCallable();
    }

    public final UnaryCallable<CreateZoneRequest, Operation> createZoneCallable() {
        return this.stub.createZoneCallable();
    }

    public final OperationFuture<Zone, OperationMetadata> updateZoneAsync(Zone zone, FieldMask updateMask) {
        UpdateZoneRequest request = UpdateZoneRequest.newBuilder().setZone(zone).setUpdateMask(updateMask).build();
        return this.updateZoneAsync(request);
    }

    public final OperationFuture<Zone, OperationMetadata> updateZoneAsync(UpdateZoneRequest request) {
        return this.updateZoneOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateZoneRequest, Zone, OperationMetadata> updateZoneOperationCallable() {
        return this.stub.updateZoneOperationCallable();
    }

    public final UnaryCallable<UpdateZoneRequest, Operation> updateZoneCallable() {
        return this.stub.updateZoneCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteZoneAsync(ZoneName name) {
        DeleteZoneRequest request = DeleteZoneRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteZoneAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteZoneAsync(String name) {
        DeleteZoneRequest request = DeleteZoneRequest.newBuilder().setName(name).build();
        return this.deleteZoneAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteZoneAsync(DeleteZoneRequest request) {
        return this.deleteZoneOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteZoneRequest, Empty, OperationMetadata> deleteZoneOperationCallable() {
        return this.stub.deleteZoneOperationCallable();
    }

    public final UnaryCallable<DeleteZoneRequest, Operation> deleteZoneCallable() {
        return this.stub.deleteZoneCallable();
    }

    public final ListZonesPagedResponse listZones(LakeName parent) {
        ListZonesRequest request = ListZonesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listZones(request);
    }

    public final ListZonesPagedResponse listZones(String parent) {
        ListZonesRequest request = ListZonesRequest.newBuilder().setParent(parent).build();
        return this.listZones(request);
    }

    public final ListZonesPagedResponse listZones(ListZonesRequest request) {
        return (ListZonesPagedResponse)((Object)this.listZonesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListZonesRequest, ListZonesPagedResponse> listZonesPagedCallable() {
        return this.stub.listZonesPagedCallable();
    }

    public final UnaryCallable<ListZonesRequest, ListZonesResponse> listZonesCallable() {
        return this.stub.listZonesCallable();
    }

    public final Zone getZone(ZoneName name) {
        GetZoneRequest request = GetZoneRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getZone(request);
    }

    public final Zone getZone(String name) {
        GetZoneRequest request = GetZoneRequest.newBuilder().setName(name).build();
        return this.getZone(request);
    }

    public final Zone getZone(GetZoneRequest request) {
        return (Zone)this.getZoneCallable().call((Object)request);
    }

    public final UnaryCallable<GetZoneRequest, Zone> getZoneCallable() {
        return this.stub.getZoneCallable();
    }

    public final ListZoneActionsPagedResponse listZoneActions(ZoneName parent) {
        ListZoneActionsRequest request = ListZoneActionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listZoneActions(request);
    }

    public final ListZoneActionsPagedResponse listZoneActions(String parent) {
        ListZoneActionsRequest request = ListZoneActionsRequest.newBuilder().setParent(parent).build();
        return this.listZoneActions(request);
    }

    public final ListZoneActionsPagedResponse listZoneActions(ListZoneActionsRequest request) {
        return (ListZoneActionsPagedResponse)((Object)this.listZoneActionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListZoneActionsRequest, ListZoneActionsPagedResponse> listZoneActionsPagedCallable() {
        return this.stub.listZoneActionsPagedCallable();
    }

    public final UnaryCallable<ListZoneActionsRequest, ListActionsResponse> listZoneActionsCallable() {
        return this.stub.listZoneActionsCallable();
    }

    public final OperationFuture<Asset, OperationMetadata> createAssetAsync(ZoneName parent, Asset asset, String assetId) {
        CreateAssetRequest request = CreateAssetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAsset(asset).setAssetId(assetId).build();
        return this.createAssetAsync(request);
    }

    public final OperationFuture<Asset, OperationMetadata> createAssetAsync(String parent, Asset asset, String assetId) {
        CreateAssetRequest request = CreateAssetRequest.newBuilder().setParent(parent).setAsset(asset).setAssetId(assetId).build();
        return this.createAssetAsync(request);
    }

    public final OperationFuture<Asset, OperationMetadata> createAssetAsync(CreateAssetRequest request) {
        return this.createAssetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAssetRequest, Asset, OperationMetadata> createAssetOperationCallable() {
        return this.stub.createAssetOperationCallable();
    }

    public final UnaryCallable<CreateAssetRequest, Operation> createAssetCallable() {
        return this.stub.createAssetCallable();
    }

    public final OperationFuture<Asset, OperationMetadata> updateAssetAsync(Asset asset, FieldMask updateMask) {
        UpdateAssetRequest request = UpdateAssetRequest.newBuilder().setAsset(asset).setUpdateMask(updateMask).build();
        return this.updateAssetAsync(request);
    }

    public final OperationFuture<Asset, OperationMetadata> updateAssetAsync(UpdateAssetRequest request) {
        return this.updateAssetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAssetRequest, Asset, OperationMetadata> updateAssetOperationCallable() {
        return this.stub.updateAssetOperationCallable();
    }

    public final UnaryCallable<UpdateAssetRequest, Operation> updateAssetCallable() {
        return this.stub.updateAssetCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAssetAsync(AssetName name) {
        DeleteAssetRequest request = DeleteAssetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAssetAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAssetAsync(String name) {
        DeleteAssetRequest request = DeleteAssetRequest.newBuilder().setName(name).build();
        return this.deleteAssetAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAssetAsync(DeleteAssetRequest request) {
        return this.deleteAssetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAssetRequest, Empty, OperationMetadata> deleteAssetOperationCallable() {
        return this.stub.deleteAssetOperationCallable();
    }

    public final UnaryCallable<DeleteAssetRequest, Operation> deleteAssetCallable() {
        return this.stub.deleteAssetCallable();
    }

    public final ListAssetsPagedResponse listAssets(ZoneName parent) {
        ListAssetsRequest request = ListAssetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAssets(request);
    }

    public final ListAssetsPagedResponse listAssets(String parent) {
        ListAssetsRequest request = ListAssetsRequest.newBuilder().setParent(parent).build();
        return this.listAssets(request);
    }

    public final ListAssetsPagedResponse listAssets(ListAssetsRequest request) {
        return (ListAssetsPagedResponse)((Object)this.listAssetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAssetsRequest, ListAssetsPagedResponse> listAssetsPagedCallable() {
        return this.stub.listAssetsPagedCallable();
    }

    public final UnaryCallable<ListAssetsRequest, ListAssetsResponse> listAssetsCallable() {
        return this.stub.listAssetsCallable();
    }

    public final Asset getAsset(AssetName name) {
        GetAssetRequest request = GetAssetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAsset(request);
    }

    public final Asset getAsset(String name) {
        GetAssetRequest request = GetAssetRequest.newBuilder().setName(name).build();
        return this.getAsset(request);
    }

    public final Asset getAsset(GetAssetRequest request) {
        return (Asset)this.getAssetCallable().call((Object)request);
    }

    public final UnaryCallable<GetAssetRequest, Asset> getAssetCallable() {
        return this.stub.getAssetCallable();
    }

    public final ListAssetActionsPagedResponse listAssetActions(AssetName parent) {
        ListAssetActionsRequest request = ListAssetActionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAssetActions(request);
    }

    public final ListAssetActionsPagedResponse listAssetActions(String parent) {
        ListAssetActionsRequest request = ListAssetActionsRequest.newBuilder().setParent(parent).build();
        return this.listAssetActions(request);
    }

    public final ListAssetActionsPagedResponse listAssetActions(ListAssetActionsRequest request) {
        return (ListAssetActionsPagedResponse)((Object)this.listAssetActionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAssetActionsRequest, ListAssetActionsPagedResponse> listAssetActionsPagedCallable() {
        return this.stub.listAssetActionsPagedCallable();
    }

    public final UnaryCallable<ListAssetActionsRequest, ListActionsResponse> listAssetActionsCallable() {
        return this.stub.listAssetActionsCallable();
    }

    public final OperationFuture<Task, OperationMetadata> createTaskAsync(LakeName parent, Task task, String taskId) {
        CreateTaskRequest request = CreateTaskRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTask(task).setTaskId(taskId).build();
        return this.createTaskAsync(request);
    }

    public final OperationFuture<Task, OperationMetadata> createTaskAsync(String parent, Task task, String taskId) {
        CreateTaskRequest request = CreateTaskRequest.newBuilder().setParent(parent).setTask(task).setTaskId(taskId).build();
        return this.createTaskAsync(request);
    }

    public final OperationFuture<Task, OperationMetadata> createTaskAsync(CreateTaskRequest request) {
        return this.createTaskOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateTaskRequest, Task, OperationMetadata> createTaskOperationCallable() {
        return this.stub.createTaskOperationCallable();
    }

    public final UnaryCallable<CreateTaskRequest, Operation> createTaskCallable() {
        return this.stub.createTaskCallable();
    }

    public final OperationFuture<Task, OperationMetadata> updateTaskAsync(Task task, FieldMask updateMask) {
        UpdateTaskRequest request = UpdateTaskRequest.newBuilder().setTask(task).setUpdateMask(updateMask).build();
        return this.updateTaskAsync(request);
    }

    public final OperationFuture<Task, OperationMetadata> updateTaskAsync(UpdateTaskRequest request) {
        return this.updateTaskOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateTaskRequest, Task, OperationMetadata> updateTaskOperationCallable() {
        return this.stub.updateTaskOperationCallable();
    }

    public final UnaryCallable<UpdateTaskRequest, Operation> updateTaskCallable() {
        return this.stub.updateTaskCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTaskAsync(TaskName name) {
        DeleteTaskRequest request = DeleteTaskRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteTaskAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTaskAsync(String name) {
        DeleteTaskRequest request = DeleteTaskRequest.newBuilder().setName(name).build();
        return this.deleteTaskAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTaskAsync(DeleteTaskRequest request) {
        return this.deleteTaskOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTaskRequest, Empty, OperationMetadata> deleteTaskOperationCallable() {
        return this.stub.deleteTaskOperationCallable();
    }

    public final UnaryCallable<DeleteTaskRequest, Operation> deleteTaskCallable() {
        return this.stub.deleteTaskCallable();
    }

    public final ListTasksPagedResponse listTasks(LakeName parent) {
        ListTasksRequest request = ListTasksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTasks(request);
    }

    public final ListTasksPagedResponse listTasks(String parent) {
        ListTasksRequest request = ListTasksRequest.newBuilder().setParent(parent).build();
        return this.listTasks(request);
    }

    public final ListTasksPagedResponse listTasks(ListTasksRequest request) {
        return (ListTasksPagedResponse)((Object)this.listTasksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTasksRequest, ListTasksPagedResponse> listTasksPagedCallable() {
        return this.stub.listTasksPagedCallable();
    }

    public final UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable() {
        return this.stub.listTasksCallable();
    }

    public final Task getTask(TaskName name) {
        GetTaskRequest request = GetTaskRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTask(request);
    }

    public final Task getTask(String name) {
        GetTaskRequest request = GetTaskRequest.newBuilder().setName(name).build();
        return this.getTask(request);
    }

    public final Task getTask(GetTaskRequest request) {
        return (Task)this.getTaskCallable().call((Object)request);
    }

    public final UnaryCallable<GetTaskRequest, Task> getTaskCallable() {
        return this.stub.getTaskCallable();
    }

    public final ListJobsPagedResponse listJobs(TaskName parent) {
        ListJobsRequest request = ListJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listJobs(request);
    }

    public final ListJobsPagedResponse listJobs(String parent) {
        ListJobsRequest request = ListJobsRequest.newBuilder().setParent(parent).build();
        return this.listJobs(request);
    }

    public final ListJobsPagedResponse listJobs(ListJobsRequest request) {
        return (ListJobsPagedResponse)((Object)this.listJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListJobsRequest, ListJobsPagedResponse> listJobsPagedCallable() {
        return this.stub.listJobsPagedCallable();
    }

    public final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.stub.listJobsCallable();
    }

    public final Job getJob(JobName name) {
        GetJobRequest request = GetJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getJob(request);
    }

    public final Job getJob(String name) {
        GetJobRequest request = GetJobRequest.newBuilder().setName(name).build();
        return this.getJob(request);
    }

    public final Job getJob(GetJobRequest request) {
        return (Job)this.getJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.stub.getJobCallable();
    }

    public final void cancelJob(JobName name) {
        CancelJobRequest request = CancelJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.cancelJob(request);
    }

    public final void cancelJob(String name) {
        CancelJobRequest request = CancelJobRequest.newBuilder().setName(name).build();
        this.cancelJob(request);
    }

    public final void cancelJob(CancelJobRequest request) {
        this.cancelJobCallable().call((Object)request);
    }

    public final UnaryCallable<CancelJobRequest, Empty> cancelJobCallable() {
        return this.stub.cancelJobCallable();
    }

    public final OperationFuture<Environment, OperationMetadata> createEnvironmentAsync(LakeName parent, Environment environment, String environmentId) {
        CreateEnvironmentRequest request = CreateEnvironmentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEnvironment(environment).setEnvironmentId(environmentId).build();
        return this.createEnvironmentAsync(request);
    }

    public final OperationFuture<Environment, OperationMetadata> createEnvironmentAsync(String parent, Environment environment, String environmentId) {
        CreateEnvironmentRequest request = CreateEnvironmentRequest.newBuilder().setParent(parent).setEnvironment(environment).setEnvironmentId(environmentId).build();
        return this.createEnvironmentAsync(request);
    }

    public final OperationFuture<Environment, OperationMetadata> createEnvironmentAsync(CreateEnvironmentRequest request) {
        return this.createEnvironmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationCallable() {
        return this.stub.createEnvironmentOperationCallable();
    }

    public final UnaryCallable<CreateEnvironmentRequest, Operation> createEnvironmentCallable() {
        return this.stub.createEnvironmentCallable();
    }

    public final OperationFuture<Environment, OperationMetadata> updateEnvironmentAsync(Environment environment, FieldMask updateMask) {
        UpdateEnvironmentRequest request = UpdateEnvironmentRequest.newBuilder().setEnvironment(environment).setUpdateMask(updateMask).build();
        return this.updateEnvironmentAsync(request);
    }

    public final OperationFuture<Environment, OperationMetadata> updateEnvironmentAsync(UpdateEnvironmentRequest request) {
        return this.updateEnvironmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationCallable() {
        return this.stub.updateEnvironmentOperationCallable();
    }

    public final UnaryCallable<UpdateEnvironmentRequest, Operation> updateEnvironmentCallable() {
        return this.stub.updateEnvironmentCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEnvironmentAsync(EnvironmentName name) {
        DeleteEnvironmentRequest request = DeleteEnvironmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteEnvironmentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEnvironmentAsync(String name) {
        DeleteEnvironmentRequest request = DeleteEnvironmentRequest.newBuilder().setName(name).build();
        return this.deleteEnvironmentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEnvironmentAsync(DeleteEnvironmentRequest request) {
        return this.deleteEnvironmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationCallable() {
        return this.stub.deleteEnvironmentOperationCallable();
    }

    public final UnaryCallable<DeleteEnvironmentRequest, Operation> deleteEnvironmentCallable() {
        return this.stub.deleteEnvironmentCallable();
    }

    public final ListEnvironmentsPagedResponse listEnvironments(LakeName parent) {
        ListEnvironmentsRequest request = ListEnvironmentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEnvironments(request);
    }

    public final ListEnvironmentsPagedResponse listEnvironments(String parent) {
        ListEnvironmentsRequest request = ListEnvironmentsRequest.newBuilder().setParent(parent).build();
        return this.listEnvironments(request);
    }

    public final ListEnvironmentsPagedResponse listEnvironments(ListEnvironmentsRequest request) {
        return (ListEnvironmentsPagedResponse)((Object)this.listEnvironmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsPagedResponse> listEnvironmentsPagedCallable() {
        return this.stub.listEnvironmentsPagedCallable();
    }

    public final UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> listEnvironmentsCallable() {
        return this.stub.listEnvironmentsCallable();
    }

    public final Environment getEnvironment(EnvironmentName name) {
        GetEnvironmentRequest request = GetEnvironmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEnvironment(request);
    }

    public final Environment getEnvironment(String name) {
        GetEnvironmentRequest request = GetEnvironmentRequest.newBuilder().setName(name).build();
        return this.getEnvironment(request);
    }

    public final Environment getEnvironment(GetEnvironmentRequest request) {
        return (Environment)this.getEnvironmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable() {
        return this.stub.getEnvironmentCallable();
    }

    public final ListSessionsPagedResponse listSessions(EnvironmentName parent) {
        ListSessionsRequest request = ListSessionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSessions(request);
    }

    public final ListSessionsPagedResponse listSessions(String parent) {
        ListSessionsRequest request = ListSessionsRequest.newBuilder().setParent(parent).build();
        return this.listSessions(request);
    }

    public final ListSessionsPagedResponse listSessions(ListSessionsRequest request) {
        return (ListSessionsPagedResponse)((Object)this.listSessionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSessionsRequest, ListSessionsPagedResponse> listSessionsPagedCallable() {
        return this.stub.listSessionsPagedCallable();
    }

    public final UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable() {
        return this.stub.listSessionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSessionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage, ListSessionsFixedSizeCollection> {
        private ListSessionsFixedSizeCollection(List<ListSessionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSessionsFixedSizeCollection createEmptyCollection() {
            return new ListSessionsFixedSizeCollection(null, 0);
        }

        protected ListSessionsFixedSizeCollection createCollection(List<ListSessionsPage> pages, int collectionSize) {
            return new ListSessionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSessionsPage
    extends AbstractPage<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage> {
        private ListSessionsPage(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ListSessionsResponse response) {
            super(context, (Object)response);
        }

        private static ListSessionsPage createEmptyPage() {
            return new ListSessionsPage(null, null);
        }

        protected ListSessionsPage createPage(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ListSessionsResponse response) {
            return new ListSessionsPage(context, response);
        }

        public ApiFuture<ListSessionsPage> createPageAsync(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ApiFuture<ListSessionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSessionsPagedResponse
    extends AbstractPagedListResponse<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage, ListSessionsFixedSizeCollection> {
        public static ApiFuture<ListSessionsPagedResponse> createAsync(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ApiFuture<ListSessionsResponse> futureResponse) {
            ApiFuture<ListSessionsPage> futurePage = ListSessionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSessionsPagedResponse((ListSessionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSessionsPagedResponse(ListSessionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSessionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEnvironmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage, ListEnvironmentsFixedSizeCollection> {
        private ListEnvironmentsFixedSizeCollection(List<ListEnvironmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEnvironmentsFixedSizeCollection createEmptyCollection() {
            return new ListEnvironmentsFixedSizeCollection(null, 0);
        }

        protected ListEnvironmentsFixedSizeCollection createCollection(List<ListEnvironmentsPage> pages, int collectionSize) {
            return new ListEnvironmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEnvironmentsPage
    extends AbstractPage<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage> {
        private ListEnvironmentsPage(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ListEnvironmentsResponse response) {
            super(context, (Object)response);
        }

        private static ListEnvironmentsPage createEmptyPage() {
            return new ListEnvironmentsPage(null, null);
        }

        protected ListEnvironmentsPage createPage(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ListEnvironmentsResponse response) {
            return new ListEnvironmentsPage(context, response);
        }

        public ApiFuture<ListEnvironmentsPage> createPageAsync(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEnvironmentsPagedResponse
    extends AbstractPagedListResponse<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage, ListEnvironmentsFixedSizeCollection> {
        public static ApiFuture<ListEnvironmentsPagedResponse> createAsync(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            ApiFuture<ListEnvironmentsPage> futurePage = ListEnvironmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEnvironmentsPagedResponse((ListEnvironmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEnvironmentsPagedResponse(ListEnvironmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEnvironmentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListJobsRequest, ListJobsResponse, Job, ListJobsPage, ListJobsFixedSizeCollection> {
        private ListJobsFixedSizeCollection(List<ListJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListJobsFixedSizeCollection createEmptyCollection() {
            return new ListJobsFixedSizeCollection(null, 0);
        }

        protected ListJobsFixedSizeCollection createCollection(List<ListJobsPage> pages, int collectionSize) {
            return new ListJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListJobsPage
    extends AbstractPage<ListJobsRequest, ListJobsResponse, Job, ListJobsPage> {
        private ListJobsPage(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ListJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListJobsPage createEmptyPage() {
            return new ListJobsPage(null, null);
        }

        protected ListJobsPage createPage(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ListJobsResponse response) {
            return new ListJobsPage(context, response);
        }

        public ApiFuture<ListJobsPage> createPageAsync(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ApiFuture<ListJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListJobsPagedResponse
    extends AbstractPagedListResponse<ListJobsRequest, ListJobsResponse, Job, ListJobsPage, ListJobsFixedSizeCollection> {
        public static ApiFuture<ListJobsPagedResponse> createAsync(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ApiFuture<ListJobsResponse> futureResponse) {
            ApiFuture<ListJobsPage> futurePage = ListJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListJobsPagedResponse((ListJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListJobsPagedResponse(ListJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListJobsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTasksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTasksRequest, ListTasksResponse, Task, ListTasksPage, ListTasksFixedSizeCollection> {
        private ListTasksFixedSizeCollection(List<ListTasksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTasksFixedSizeCollection createEmptyCollection() {
            return new ListTasksFixedSizeCollection(null, 0);
        }

        protected ListTasksFixedSizeCollection createCollection(List<ListTasksPage> pages, int collectionSize) {
            return new ListTasksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTasksPage
    extends AbstractPage<ListTasksRequest, ListTasksResponse, Task, ListTasksPage> {
        private ListTasksPage(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ListTasksResponse response) {
            super(context, (Object)response);
        }

        private static ListTasksPage createEmptyPage() {
            return new ListTasksPage(null, null);
        }

        protected ListTasksPage createPage(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ListTasksResponse response) {
            return new ListTasksPage(context, response);
        }

        public ApiFuture<ListTasksPage> createPageAsync(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ApiFuture<ListTasksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTasksPagedResponse
    extends AbstractPagedListResponse<ListTasksRequest, ListTasksResponse, Task, ListTasksPage, ListTasksFixedSizeCollection> {
        public static ApiFuture<ListTasksPagedResponse> createAsync(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ApiFuture<ListTasksResponse> futureResponse) {
            ApiFuture<ListTasksPage> futurePage = ListTasksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTasksPagedResponse((ListTasksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTasksPagedResponse(ListTasksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTasksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAssetActionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAssetActionsRequest, ListActionsResponse, Action, ListAssetActionsPage, ListAssetActionsFixedSizeCollection> {
        private ListAssetActionsFixedSizeCollection(List<ListAssetActionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAssetActionsFixedSizeCollection createEmptyCollection() {
            return new ListAssetActionsFixedSizeCollection(null, 0);
        }

        protected ListAssetActionsFixedSizeCollection createCollection(List<ListAssetActionsPage> pages, int collectionSize) {
            return new ListAssetActionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAssetActionsPage
    extends AbstractPage<ListAssetActionsRequest, ListActionsResponse, Action, ListAssetActionsPage> {
        private ListAssetActionsPage(PageContext<ListAssetActionsRequest, ListActionsResponse, Action> context, ListActionsResponse response) {
            super(context, (Object)response);
        }

        private static ListAssetActionsPage createEmptyPage() {
            return new ListAssetActionsPage(null, null);
        }

        protected ListAssetActionsPage createPage(PageContext<ListAssetActionsRequest, ListActionsResponse, Action> context, ListActionsResponse response) {
            return new ListAssetActionsPage(context, response);
        }

        public ApiFuture<ListAssetActionsPage> createPageAsync(PageContext<ListAssetActionsRequest, ListActionsResponse, Action> context, ApiFuture<ListActionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAssetActionsPagedResponse
    extends AbstractPagedListResponse<ListAssetActionsRequest, ListActionsResponse, Action, ListAssetActionsPage, ListAssetActionsFixedSizeCollection> {
        public static ApiFuture<ListAssetActionsPagedResponse> createAsync(PageContext<ListAssetActionsRequest, ListActionsResponse, Action> context, ApiFuture<ListActionsResponse> futureResponse) {
            ApiFuture<ListAssetActionsPage> futurePage = ListAssetActionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAssetActionsPagedResponse((ListAssetActionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAssetActionsPagedResponse(ListAssetActionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAssetActionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAssetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAssetsRequest, ListAssetsResponse, Asset, ListAssetsPage, ListAssetsFixedSizeCollection> {
        private ListAssetsFixedSizeCollection(List<ListAssetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAssetsFixedSizeCollection createEmptyCollection() {
            return new ListAssetsFixedSizeCollection(null, 0);
        }

        protected ListAssetsFixedSizeCollection createCollection(List<ListAssetsPage> pages, int collectionSize) {
            return new ListAssetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAssetsPage
    extends AbstractPage<ListAssetsRequest, ListAssetsResponse, Asset, ListAssetsPage> {
        private ListAssetsPage(PageContext<ListAssetsRequest, ListAssetsResponse, Asset> context, ListAssetsResponse response) {
            super(context, (Object)response);
        }

        private static ListAssetsPage createEmptyPage() {
            return new ListAssetsPage(null, null);
        }

        protected ListAssetsPage createPage(PageContext<ListAssetsRequest, ListAssetsResponse, Asset> context, ListAssetsResponse response) {
            return new ListAssetsPage(context, response);
        }

        public ApiFuture<ListAssetsPage> createPageAsync(PageContext<ListAssetsRequest, ListAssetsResponse, Asset> context, ApiFuture<ListAssetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAssetsPagedResponse
    extends AbstractPagedListResponse<ListAssetsRequest, ListAssetsResponse, Asset, ListAssetsPage, ListAssetsFixedSizeCollection> {
        public static ApiFuture<ListAssetsPagedResponse> createAsync(PageContext<ListAssetsRequest, ListAssetsResponse, Asset> context, ApiFuture<ListAssetsResponse> futureResponse) {
            ApiFuture<ListAssetsPage> futurePage = ListAssetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAssetsPagedResponse((ListAssetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAssetsPagedResponse(ListAssetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAssetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListZoneActionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListZoneActionsRequest, ListActionsResponse, Action, ListZoneActionsPage, ListZoneActionsFixedSizeCollection> {
        private ListZoneActionsFixedSizeCollection(List<ListZoneActionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListZoneActionsFixedSizeCollection createEmptyCollection() {
            return new ListZoneActionsFixedSizeCollection(null, 0);
        }

        protected ListZoneActionsFixedSizeCollection createCollection(List<ListZoneActionsPage> pages, int collectionSize) {
            return new ListZoneActionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListZoneActionsPage
    extends AbstractPage<ListZoneActionsRequest, ListActionsResponse, Action, ListZoneActionsPage> {
        private ListZoneActionsPage(PageContext<ListZoneActionsRequest, ListActionsResponse, Action> context, ListActionsResponse response) {
            super(context, (Object)response);
        }

        private static ListZoneActionsPage createEmptyPage() {
            return new ListZoneActionsPage(null, null);
        }

        protected ListZoneActionsPage createPage(PageContext<ListZoneActionsRequest, ListActionsResponse, Action> context, ListActionsResponse response) {
            return new ListZoneActionsPage(context, response);
        }

        public ApiFuture<ListZoneActionsPage> createPageAsync(PageContext<ListZoneActionsRequest, ListActionsResponse, Action> context, ApiFuture<ListActionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListZoneActionsPagedResponse
    extends AbstractPagedListResponse<ListZoneActionsRequest, ListActionsResponse, Action, ListZoneActionsPage, ListZoneActionsFixedSizeCollection> {
        public static ApiFuture<ListZoneActionsPagedResponse> createAsync(PageContext<ListZoneActionsRequest, ListActionsResponse, Action> context, ApiFuture<ListActionsResponse> futureResponse) {
            ApiFuture<ListZoneActionsPage> futurePage = ListZoneActionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListZoneActionsPagedResponse((ListZoneActionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListZoneActionsPagedResponse(ListZoneActionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListZoneActionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListZonesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListZonesRequest, ListZonesResponse, Zone, ListZonesPage, ListZonesFixedSizeCollection> {
        private ListZonesFixedSizeCollection(List<ListZonesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListZonesFixedSizeCollection createEmptyCollection() {
            return new ListZonesFixedSizeCollection(null, 0);
        }

        protected ListZonesFixedSizeCollection createCollection(List<ListZonesPage> pages, int collectionSize) {
            return new ListZonesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListZonesPage
    extends AbstractPage<ListZonesRequest, ListZonesResponse, Zone, ListZonesPage> {
        private ListZonesPage(PageContext<ListZonesRequest, ListZonesResponse, Zone> context, ListZonesResponse response) {
            super(context, (Object)response);
        }

        private static ListZonesPage createEmptyPage() {
            return new ListZonesPage(null, null);
        }

        protected ListZonesPage createPage(PageContext<ListZonesRequest, ListZonesResponse, Zone> context, ListZonesResponse response) {
            return new ListZonesPage(context, response);
        }

        public ApiFuture<ListZonesPage> createPageAsync(PageContext<ListZonesRequest, ListZonesResponse, Zone> context, ApiFuture<ListZonesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListZonesPagedResponse
    extends AbstractPagedListResponse<ListZonesRequest, ListZonesResponse, Zone, ListZonesPage, ListZonesFixedSizeCollection> {
        public static ApiFuture<ListZonesPagedResponse> createAsync(PageContext<ListZonesRequest, ListZonesResponse, Zone> context, ApiFuture<ListZonesResponse> futureResponse) {
            ApiFuture<ListZonesPage> futurePage = ListZonesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListZonesPagedResponse((ListZonesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListZonesPagedResponse(ListZonesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListZonesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListLakeActionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLakeActionsRequest, ListActionsResponse, Action, ListLakeActionsPage, ListLakeActionsFixedSizeCollection> {
        private ListLakeActionsFixedSizeCollection(List<ListLakeActionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLakeActionsFixedSizeCollection createEmptyCollection() {
            return new ListLakeActionsFixedSizeCollection(null, 0);
        }

        protected ListLakeActionsFixedSizeCollection createCollection(List<ListLakeActionsPage> pages, int collectionSize) {
            return new ListLakeActionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLakeActionsPage
    extends AbstractPage<ListLakeActionsRequest, ListActionsResponse, Action, ListLakeActionsPage> {
        private ListLakeActionsPage(PageContext<ListLakeActionsRequest, ListActionsResponse, Action> context, ListActionsResponse response) {
            super(context, (Object)response);
        }

        private static ListLakeActionsPage createEmptyPage() {
            return new ListLakeActionsPage(null, null);
        }

        protected ListLakeActionsPage createPage(PageContext<ListLakeActionsRequest, ListActionsResponse, Action> context, ListActionsResponse response) {
            return new ListLakeActionsPage(context, response);
        }

        public ApiFuture<ListLakeActionsPage> createPageAsync(PageContext<ListLakeActionsRequest, ListActionsResponse, Action> context, ApiFuture<ListActionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLakeActionsPagedResponse
    extends AbstractPagedListResponse<ListLakeActionsRequest, ListActionsResponse, Action, ListLakeActionsPage, ListLakeActionsFixedSizeCollection> {
        public static ApiFuture<ListLakeActionsPagedResponse> createAsync(PageContext<ListLakeActionsRequest, ListActionsResponse, Action> context, ApiFuture<ListActionsResponse> futureResponse) {
            ApiFuture<ListLakeActionsPage> futurePage = ListLakeActionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLakeActionsPagedResponse((ListLakeActionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLakeActionsPagedResponse(ListLakeActionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLakeActionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListLakesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLakesRequest, ListLakesResponse, Lake, ListLakesPage, ListLakesFixedSizeCollection> {
        private ListLakesFixedSizeCollection(List<ListLakesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLakesFixedSizeCollection createEmptyCollection() {
            return new ListLakesFixedSizeCollection(null, 0);
        }

        protected ListLakesFixedSizeCollection createCollection(List<ListLakesPage> pages, int collectionSize) {
            return new ListLakesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLakesPage
    extends AbstractPage<ListLakesRequest, ListLakesResponse, Lake, ListLakesPage> {
        private ListLakesPage(PageContext<ListLakesRequest, ListLakesResponse, Lake> context, ListLakesResponse response) {
            super(context, (Object)response);
        }

        private static ListLakesPage createEmptyPage() {
            return new ListLakesPage(null, null);
        }

        protected ListLakesPage createPage(PageContext<ListLakesRequest, ListLakesResponse, Lake> context, ListLakesResponse response) {
            return new ListLakesPage(context, response);
        }

        public ApiFuture<ListLakesPage> createPageAsync(PageContext<ListLakesRequest, ListLakesResponse, Lake> context, ApiFuture<ListLakesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLakesPagedResponse
    extends AbstractPagedListResponse<ListLakesRequest, ListLakesResponse, Lake, ListLakesPage, ListLakesFixedSizeCollection> {
        public static ApiFuture<ListLakesPagedResponse> createAsync(PageContext<ListLakesRequest, ListLakesResponse, Lake> context, ApiFuture<ListLakesResponse> futureResponse) {
            ApiFuture<ListLakesPage> futurePage = ListLakesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLakesPagedResponse((ListLakesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLakesPagedResponse(ListLakesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLakesFixedSizeCollection.createEmptyCollection());
        }
    }
}

