/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.CreateEntityRequest;
import com.google.cloud.dataplex.v1.CreatePartitionRequest;
import com.google.cloud.dataplex.v1.DeleteEntityRequest;
import com.google.cloud.dataplex.v1.DeletePartitionRequest;
import com.google.cloud.dataplex.v1.Entity;
import com.google.cloud.dataplex.v1.GetEntityRequest;
import com.google.cloud.dataplex.v1.GetPartitionRequest;
import com.google.cloud.dataplex.v1.ListEntitiesRequest;
import com.google.cloud.dataplex.v1.ListEntitiesResponse;
import com.google.cloud.dataplex.v1.ListPartitionsRequest;
import com.google.cloud.dataplex.v1.ListPartitionsResponse;
import com.google.cloud.dataplex.v1.MetadataServiceClient;
import com.google.cloud.dataplex.v1.Partition;
import com.google.cloud.dataplex.v1.UpdateEntityRequest;
import com.google.cloud.dataplex.v1.stub.GrpcMetadataServiceStub;
import com.google.cloud.dataplex.v1.stub.MetadataServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class MetadataServiceStubSettings
extends StubSettings<MetadataServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateEntityRequest, Entity> createEntitySettings;
    private final UnaryCallSettings<UpdateEntityRequest, Entity> updateEntitySettings;
    private final UnaryCallSettings<DeleteEntityRequest, Empty> deleteEntitySettings;
    private final UnaryCallSettings<GetEntityRequest, Entity> getEntitySettings;
    private final PagedCallSettings<ListEntitiesRequest, ListEntitiesResponse, MetadataServiceClient.ListEntitiesPagedResponse> listEntitiesSettings;
    private final UnaryCallSettings<CreatePartitionRequest, Partition> createPartitionSettings;
    private final UnaryCallSettings<DeletePartitionRequest, Empty> deletePartitionSettings;
    private final UnaryCallSettings<GetPartitionRequest, Partition> getPartitionSettings;
    private final PagedCallSettings<ListPartitionsRequest, ListPartitionsResponse, MetadataServiceClient.ListPartitionsPagedResponse> listPartitionsSettings;
    private static final PagedListDescriptor<ListEntitiesRequest, ListEntitiesResponse, Entity> LIST_ENTITIES_PAGE_STR_DESC = new PagedListDescriptor<ListEntitiesRequest, ListEntitiesResponse, Entity>(){

        public String emptyToken() {
            return "";
        }

        public ListEntitiesRequest injectToken(ListEntitiesRequest payload, String token) {
            return ListEntitiesRequest.newBuilder((ListEntitiesRequest)payload).setPageToken(token).build();
        }

        public ListEntitiesRequest injectPageSize(ListEntitiesRequest payload, int pageSize) {
            return ListEntitiesRequest.newBuilder((ListEntitiesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEntitiesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEntitiesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Entity> extractResources(ListEntitiesResponse payload) {
            return payload.getEntitiesList() == null ? ImmutableList.of() : payload.getEntitiesList();
        }
    };
    private static final PagedListDescriptor<ListPartitionsRequest, ListPartitionsResponse, Partition> LIST_PARTITIONS_PAGE_STR_DESC = new PagedListDescriptor<ListPartitionsRequest, ListPartitionsResponse, Partition>(){

        public String emptyToken() {
            return "";
        }

        public ListPartitionsRequest injectToken(ListPartitionsRequest payload, String token) {
            return ListPartitionsRequest.newBuilder((ListPartitionsRequest)payload).setPageToken(token).build();
        }

        public ListPartitionsRequest injectPageSize(ListPartitionsRequest payload, int pageSize) {
            return ListPartitionsRequest.newBuilder((ListPartitionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPartitionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPartitionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Partition> extractResources(ListPartitionsResponse payload) {
            return payload.getPartitionsList() == null ? ImmutableList.of() : payload.getPartitionsList();
        }
    };
    private static final PagedListResponseFactory<ListEntitiesRequest, ListEntitiesResponse, MetadataServiceClient.ListEntitiesPagedResponse> LIST_ENTITIES_PAGE_STR_FACT = new PagedListResponseFactory<ListEntitiesRequest, ListEntitiesResponse, MetadataServiceClient.ListEntitiesPagedResponse>(){

        public ApiFuture<MetadataServiceClient.ListEntitiesPagedResponse> getFuturePagedResponse(UnaryCallable<ListEntitiesRequest, ListEntitiesResponse> callable, ListEntitiesRequest request, ApiCallContext context, ApiFuture<ListEntitiesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENTITIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MetadataServiceClient.ListEntitiesPagedResponse.createAsync((PageContext<ListEntitiesRequest, ListEntitiesResponse, Entity>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPartitionsRequest, ListPartitionsResponse, MetadataServiceClient.ListPartitionsPagedResponse> LIST_PARTITIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListPartitionsRequest, ListPartitionsResponse, MetadataServiceClient.ListPartitionsPagedResponse>(){

        public ApiFuture<MetadataServiceClient.ListPartitionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPartitionsRequest, ListPartitionsResponse> callable, ListPartitionsRequest request, ApiCallContext context, ApiFuture<ListPartitionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PARTITIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MetadataServiceClient.ListPartitionsPagedResponse.createAsync((PageContext<ListPartitionsRequest, ListPartitionsResponse, Partition>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateEntityRequest, Entity> createEntitySettings() {
        return this.createEntitySettings;
    }

    public UnaryCallSettings<UpdateEntityRequest, Entity> updateEntitySettings() {
        return this.updateEntitySettings;
    }

    public UnaryCallSettings<DeleteEntityRequest, Empty> deleteEntitySettings() {
        return this.deleteEntitySettings;
    }

    public UnaryCallSettings<GetEntityRequest, Entity> getEntitySettings() {
        return this.getEntitySettings;
    }

    public PagedCallSettings<ListEntitiesRequest, ListEntitiesResponse, MetadataServiceClient.ListEntitiesPagedResponse> listEntitiesSettings() {
        return this.listEntitiesSettings;
    }

    public UnaryCallSettings<CreatePartitionRequest, Partition> createPartitionSettings() {
        return this.createPartitionSettings;
    }

    public UnaryCallSettings<DeletePartitionRequest, Empty> deletePartitionSettings() {
        return this.deletePartitionSettings;
    }

    public UnaryCallSettings<GetPartitionRequest, Partition> getPartitionSettings() {
        return this.getPartitionSettings;
    }

    public PagedCallSettings<ListPartitionsRequest, ListPartitionsResponse, MetadataServiceClient.ListPartitionsPagedResponse> listPartitionsSettings() {
        return this.listPartitionsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public MetadataServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcMetadataServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dataplex.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dataplex.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MetadataServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MetadataServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MetadataServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createEntitySettings = settingsBuilder.createEntitySettings().build();
        this.updateEntitySettings = settingsBuilder.updateEntitySettings().build();
        this.deleteEntitySettings = settingsBuilder.deleteEntitySettings().build();
        this.getEntitySettings = settingsBuilder.getEntitySettings().build();
        this.listEntitiesSettings = settingsBuilder.listEntitiesSettings().build();
        this.createPartitionSettings = settingsBuilder.createPartitionSettings().build();
        this.deletePartitionSettings = settingsBuilder.deletePartitionSettings().build();
        this.getPartitionSettings = settingsBuilder.getPartitionSettings().build();
        this.listPartitionsSettings = settingsBuilder.listPartitionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MetadataServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateEntityRequest, Entity> createEntitySettings;
        private final UnaryCallSettings.Builder<UpdateEntityRequest, Entity> updateEntitySettings;
        private final UnaryCallSettings.Builder<DeleteEntityRequest, Empty> deleteEntitySettings;
        private final UnaryCallSettings.Builder<GetEntityRequest, Entity> getEntitySettings;
        private final PagedCallSettings.Builder<ListEntitiesRequest, ListEntitiesResponse, MetadataServiceClient.ListEntitiesPagedResponse> listEntitiesSettings;
        private final UnaryCallSettings.Builder<CreatePartitionRequest, Partition> createPartitionSettings;
        private final UnaryCallSettings.Builder<DeletePartitionRequest, Empty> deletePartitionSettings;
        private final UnaryCallSettings.Builder<GetPartitionRequest, Partition> getPartitionSettings;
        private final PagedCallSettings.Builder<ListPartitionsRequest, ListPartitionsResponse, MetadataServiceClient.ListPartitionsPagedResponse> listPartitionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createEntitySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEntitySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEntitySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getEntitySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEntitiesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENTITIES_PAGE_STR_FACT);
            this.createPartitionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePartitionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getPartitionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPartitionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PARTITIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createEntitySettings, this.updateEntitySettings, this.deleteEntitySettings, this.getEntitySettings, this.listEntitiesSettings, this.createPartitionSettings, this.deletePartitionSettings, this.getPartitionSettings, this.listPartitionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(MetadataServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createEntitySettings = settings.createEntitySettings.toBuilder();
            this.updateEntitySettings = settings.updateEntitySettings.toBuilder();
            this.deleteEntitySettings = settings.deleteEntitySettings.toBuilder();
            this.getEntitySettings = settings.getEntitySettings.toBuilder();
            this.listEntitiesSettings = settings.listEntitiesSettings.toBuilder();
            this.createPartitionSettings = settings.createPartitionSettings.toBuilder();
            this.deletePartitionSettings = settings.deletePartitionSettings.toBuilder();
            this.getPartitionSettings = settings.getPartitionSettings.toBuilder();
            this.listPartitionsSettings = settings.listPartitionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createEntitySettings, this.updateEntitySettings, this.deleteEntitySettings, this.getEntitySettings, this.listEntitiesSettings, this.createPartitionSettings, this.deletePartitionSettings, this.getPartitionSettings, this.listPartitionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MetadataServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MetadataServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MetadataServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(MetadataServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(MetadataServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createEntitySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_5_params"));
            builder.updateEntitySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_5_params"));
            builder.deleteEntitySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_5_params"));
            builder.getEntitySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listEntitiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.createPartitionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_5_params"));
            builder.deletePartitionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_5_params"));
            builder.getPartitionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listPartitionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateEntityRequest, Entity> createEntitySettings() {
            return this.createEntitySettings;
        }

        public UnaryCallSettings.Builder<UpdateEntityRequest, Entity> updateEntitySettings() {
            return this.updateEntitySettings;
        }

        public UnaryCallSettings.Builder<DeleteEntityRequest, Empty> deleteEntitySettings() {
            return this.deleteEntitySettings;
        }

        public UnaryCallSettings.Builder<GetEntityRequest, Entity> getEntitySettings() {
            return this.getEntitySettings;
        }

        public PagedCallSettings.Builder<ListEntitiesRequest, ListEntitiesResponse, MetadataServiceClient.ListEntitiesPagedResponse> listEntitiesSettings() {
            return this.listEntitiesSettings;
        }

        public UnaryCallSettings.Builder<CreatePartitionRequest, Partition> createPartitionSettings() {
            return this.createPartitionSettings;
        }

        public UnaryCallSettings.Builder<DeletePartitionRequest, Empty> deletePartitionSettings() {
            return this.deletePartitionSettings;
        }

        public UnaryCallSettings.Builder<GetPartitionRequest, Partition> getPartitionSettings() {
            return this.getPartitionSettings;
        }

        public PagedCallSettings.Builder<ListPartitionsRequest, ListPartitionsResponse, MetadataServiceClient.ListPartitionsPagedResponse> listPartitionsSettings() {
            return this.listPartitionsSettings;
        }

        public MetadataServiceStubSettings build() throws IOException {
            return new MetadataServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_5_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"retry_policy_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_5_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_3_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

