/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.lineage.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datacatalog.lineage.v1.BatchSearchLinkProcessesRequest;
import com.google.cloud.datacatalog.lineage.v1.BatchSearchLinkProcessesResponse;
import com.google.cloud.datacatalog.lineage.v1.CreateLineageEventRequest;
import com.google.cloud.datacatalog.lineage.v1.CreateProcessRequest;
import com.google.cloud.datacatalog.lineage.v1.CreateRunRequest;
import com.google.cloud.datacatalog.lineage.v1.DeleteLineageEventRequest;
import com.google.cloud.datacatalog.lineage.v1.DeleteProcessRequest;
import com.google.cloud.datacatalog.lineage.v1.DeleteRunRequest;
import com.google.cloud.datacatalog.lineage.v1.GetLineageEventRequest;
import com.google.cloud.datacatalog.lineage.v1.GetProcessRequest;
import com.google.cloud.datacatalog.lineage.v1.GetRunRequest;
import com.google.cloud.datacatalog.lineage.v1.LineageEvent;
import com.google.cloud.datacatalog.lineage.v1.LineageEventName;
import com.google.cloud.datacatalog.lineage.v1.LineageSettings;
import com.google.cloud.datacatalog.lineage.v1.Link;
import com.google.cloud.datacatalog.lineage.v1.ListLineageEventsRequest;
import com.google.cloud.datacatalog.lineage.v1.ListLineageEventsResponse;
import com.google.cloud.datacatalog.lineage.v1.ListProcessesRequest;
import com.google.cloud.datacatalog.lineage.v1.ListProcessesResponse;
import com.google.cloud.datacatalog.lineage.v1.ListRunsRequest;
import com.google.cloud.datacatalog.lineage.v1.ListRunsResponse;
import com.google.cloud.datacatalog.lineage.v1.LocationName;
import com.google.cloud.datacatalog.lineage.v1.OperationMetadata;
import com.google.cloud.datacatalog.lineage.v1.Process;
import com.google.cloud.datacatalog.lineage.v1.ProcessLinks;
import com.google.cloud.datacatalog.lineage.v1.ProcessName;
import com.google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventRequest;
import com.google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventResponse;
import com.google.cloud.datacatalog.lineage.v1.Run;
import com.google.cloud.datacatalog.lineage.v1.RunName;
import com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest;
import com.google.cloud.datacatalog.lineage.v1.SearchLinksResponse;
import com.google.cloud.datacatalog.lineage.v1.UpdateProcessRequest;
import com.google.cloud.datacatalog.lineage.v1.UpdateRunRequest;
import com.google.cloud.datacatalog.lineage.v1.stub.LineageStub;
import com.google.cloud.datacatalog.lineage.v1.stub.LineageStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class LineageClient
implements BackgroundResource {
    private final LineageSettings settings;
    private final LineageStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final LineageClient create() throws IOException {
        return LineageClient.create(LineageSettings.newBuilder().build());
    }

    public static final LineageClient create(LineageSettings settings) throws IOException {
        return new LineageClient(settings);
    }

    public static final LineageClient create(LineageStub stub) {
        return new LineageClient(stub);
    }

    protected LineageClient(LineageSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LineageStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected LineageClient(LineageStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final LineageSettings getSettings() {
        return this.settings;
    }

    public LineageStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ProcessOpenLineageRunEventResponse processOpenLineageRunEvent(String parent, Struct openLineage) {
        ProcessOpenLineageRunEventRequest request = ProcessOpenLineageRunEventRequest.newBuilder().setParent(parent).setOpenLineage(openLineage).build();
        return this.processOpenLineageRunEvent(request);
    }

    public final ProcessOpenLineageRunEventResponse processOpenLineageRunEvent(ProcessOpenLineageRunEventRequest request) {
        return (ProcessOpenLineageRunEventResponse)this.processOpenLineageRunEventCallable().call((Object)request);
    }

    public final UnaryCallable<ProcessOpenLineageRunEventRequest, ProcessOpenLineageRunEventResponse> processOpenLineageRunEventCallable() {
        return this.stub.processOpenLineageRunEventCallable();
    }

    public final Process createProcess(LocationName parent, Process process) {
        CreateProcessRequest request = CreateProcessRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setProcess(process).build();
        return this.createProcess(request);
    }

    public final Process createProcess(String parent, Process process) {
        CreateProcessRequest request = CreateProcessRequest.newBuilder().setParent(parent).setProcess(process).build();
        return this.createProcess(request);
    }

    public final Process createProcess(CreateProcessRequest request) {
        return (Process)this.createProcessCallable().call((Object)request);
    }

    public final UnaryCallable<CreateProcessRequest, Process> createProcessCallable() {
        return this.stub.createProcessCallable();
    }

    public final Process updateProcess(Process process, FieldMask updateMask) {
        UpdateProcessRequest request = UpdateProcessRequest.newBuilder().setProcess(process).setUpdateMask(updateMask).build();
        return this.updateProcess(request);
    }

    public final Process updateProcess(UpdateProcessRequest request) {
        return (Process)this.updateProcessCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateProcessRequest, Process> updateProcessCallable() {
        return this.stub.updateProcessCallable();
    }

    public final Process getProcess(ProcessName name) {
        GetProcessRequest request = GetProcessRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProcess(request);
    }

    public final Process getProcess(String name) {
        GetProcessRequest request = GetProcessRequest.newBuilder().setName(name).build();
        return this.getProcess(request);
    }

    public final Process getProcess(GetProcessRequest request) {
        return (Process)this.getProcessCallable().call((Object)request);
    }

    public final UnaryCallable<GetProcessRequest, Process> getProcessCallable() {
        return this.stub.getProcessCallable();
    }

    public final ListProcessesPagedResponse listProcesses(LocationName parent) {
        ListProcessesRequest request = ListProcessesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProcesses(request);
    }

    public final ListProcessesPagedResponse listProcesses(String parent) {
        ListProcessesRequest request = ListProcessesRequest.newBuilder().setParent(parent).build();
        return this.listProcesses(request);
    }

    public final ListProcessesPagedResponse listProcesses(ListProcessesRequest request) {
        return (ListProcessesPagedResponse)((Object)this.listProcessesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProcessesRequest, ListProcessesPagedResponse> listProcessesPagedCallable() {
        return this.stub.listProcessesPagedCallable();
    }

    public final UnaryCallable<ListProcessesRequest, ListProcessesResponse> listProcessesCallable() {
        return this.stub.listProcessesCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteProcessAsync(ProcessName name) {
        DeleteProcessRequest request = DeleteProcessRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteProcessAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteProcessAsync(String name) {
        DeleteProcessRequest request = DeleteProcessRequest.newBuilder().setName(name).build();
        return this.deleteProcessAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteProcessAsync(DeleteProcessRequest request) {
        return this.deleteProcessOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteProcessRequest, Empty, OperationMetadata> deleteProcessOperationCallable() {
        return this.stub.deleteProcessOperationCallable();
    }

    public final UnaryCallable<DeleteProcessRequest, Operation> deleteProcessCallable() {
        return this.stub.deleteProcessCallable();
    }

    public final Run createRun(ProcessName parent, Run run) {
        CreateRunRequest request = CreateRunRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRun(run).build();
        return this.createRun(request);
    }

    public final Run createRun(String parent, Run run) {
        CreateRunRequest request = CreateRunRequest.newBuilder().setParent(parent).setRun(run).build();
        return this.createRun(request);
    }

    public final Run createRun(CreateRunRequest request) {
        return (Run)this.createRunCallable().call((Object)request);
    }

    public final UnaryCallable<CreateRunRequest, Run> createRunCallable() {
        return this.stub.createRunCallable();
    }

    public final Run updateRun(Run run, FieldMask updateMask) {
        UpdateRunRequest request = UpdateRunRequest.newBuilder().setRun(run).setUpdateMask(updateMask).build();
        return this.updateRun(request);
    }

    public final Run updateRun(UpdateRunRequest request) {
        return (Run)this.updateRunCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateRunRequest, Run> updateRunCallable() {
        return this.stub.updateRunCallable();
    }

    public final Run getRun(RunName name) {
        GetRunRequest request = GetRunRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRun(request);
    }

    public final Run getRun(String name) {
        GetRunRequest request = GetRunRequest.newBuilder().setName(name).build();
        return this.getRun(request);
    }

    public final Run getRun(GetRunRequest request) {
        return (Run)this.getRunCallable().call((Object)request);
    }

    public final UnaryCallable<GetRunRequest, Run> getRunCallable() {
        return this.stub.getRunCallable();
    }

    public final ListRunsPagedResponse listRuns(ProcessName parent) {
        ListRunsRequest request = ListRunsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRuns(request);
    }

    public final ListRunsPagedResponse listRuns(String parent) {
        ListRunsRequest request = ListRunsRequest.newBuilder().setParent(parent).build();
        return this.listRuns(request);
    }

    public final ListRunsPagedResponse listRuns(ListRunsRequest request) {
        return (ListRunsPagedResponse)((Object)this.listRunsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRunsRequest, ListRunsPagedResponse> listRunsPagedCallable() {
        return this.stub.listRunsPagedCallable();
    }

    public final UnaryCallable<ListRunsRequest, ListRunsResponse> listRunsCallable() {
        return this.stub.listRunsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRunAsync(RunName name) {
        DeleteRunRequest request = DeleteRunRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRunAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRunAsync(String name) {
        DeleteRunRequest request = DeleteRunRequest.newBuilder().setName(name).build();
        return this.deleteRunAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRunAsync(DeleteRunRequest request) {
        return this.deleteRunOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRunRequest, Empty, OperationMetadata> deleteRunOperationCallable() {
        return this.stub.deleteRunOperationCallable();
    }

    public final UnaryCallable<DeleteRunRequest, Operation> deleteRunCallable() {
        return this.stub.deleteRunCallable();
    }

    public final LineageEvent createLineageEvent(RunName parent, LineageEvent lineageEvent) {
        CreateLineageEventRequest request = CreateLineageEventRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setLineageEvent(lineageEvent).build();
        return this.createLineageEvent(request);
    }

    public final LineageEvent createLineageEvent(String parent, LineageEvent lineageEvent) {
        CreateLineageEventRequest request = CreateLineageEventRequest.newBuilder().setParent(parent).setLineageEvent(lineageEvent).build();
        return this.createLineageEvent(request);
    }

    public final LineageEvent createLineageEvent(CreateLineageEventRequest request) {
        return (LineageEvent)this.createLineageEventCallable().call((Object)request);
    }

    public final UnaryCallable<CreateLineageEventRequest, LineageEvent> createLineageEventCallable() {
        return this.stub.createLineageEventCallable();
    }

    public final LineageEvent getLineageEvent(LineageEventName name) {
        GetLineageEventRequest request = GetLineageEventRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getLineageEvent(request);
    }

    public final LineageEvent getLineageEvent(String name) {
        GetLineageEventRequest request = GetLineageEventRequest.newBuilder().setName(name).build();
        return this.getLineageEvent(request);
    }

    public final LineageEvent getLineageEvent(GetLineageEventRequest request) {
        return (LineageEvent)this.getLineageEventCallable().call((Object)request);
    }

    public final UnaryCallable<GetLineageEventRequest, LineageEvent> getLineageEventCallable() {
        return this.stub.getLineageEventCallable();
    }

    public final ListLineageEventsPagedResponse listLineageEvents(RunName parent) {
        ListLineageEventsRequest request = ListLineageEventsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listLineageEvents(request);
    }

    public final ListLineageEventsPagedResponse listLineageEvents(String parent) {
        ListLineageEventsRequest request = ListLineageEventsRequest.newBuilder().setParent(parent).build();
        return this.listLineageEvents(request);
    }

    public final ListLineageEventsPagedResponse listLineageEvents(ListLineageEventsRequest request) {
        return (ListLineageEventsPagedResponse)((Object)this.listLineageEventsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLineageEventsRequest, ListLineageEventsPagedResponse> listLineageEventsPagedCallable() {
        return this.stub.listLineageEventsPagedCallable();
    }

    public final UnaryCallable<ListLineageEventsRequest, ListLineageEventsResponse> listLineageEventsCallable() {
        return this.stub.listLineageEventsCallable();
    }

    public final void deleteLineageEvent(LineageEventName name) {
        DeleteLineageEventRequest request = DeleteLineageEventRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteLineageEvent(request);
    }

    public final void deleteLineageEvent(String name) {
        DeleteLineageEventRequest request = DeleteLineageEventRequest.newBuilder().setName(name).build();
        this.deleteLineageEvent(request);
    }

    public final void deleteLineageEvent(DeleteLineageEventRequest request) {
        this.deleteLineageEventCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteLineageEventRequest, Empty> deleteLineageEventCallable() {
        return this.stub.deleteLineageEventCallable();
    }

    public final SearchLinksPagedResponse searchLinks(SearchLinksRequest request) {
        return (SearchLinksPagedResponse)((Object)this.searchLinksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchLinksRequest, SearchLinksPagedResponse> searchLinksPagedCallable() {
        return this.stub.searchLinksPagedCallable();
    }

    public final UnaryCallable<SearchLinksRequest, SearchLinksResponse> searchLinksCallable() {
        return this.stub.searchLinksCallable();
    }

    public final BatchSearchLinkProcessesPagedResponse batchSearchLinkProcesses(BatchSearchLinkProcessesRequest request) {
        return (BatchSearchLinkProcessesPagedResponse)((Object)this.batchSearchLinkProcessesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesPagedResponse> batchSearchLinkProcessesPagedCallable() {
        return this.stub.batchSearchLinkProcessesPagedCallable();
    }

    public final UnaryCallable<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse> batchSearchLinkProcessesCallable() {
        return this.stub.batchSearchLinkProcessesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class BatchSearchLinkProcessesFixedSizeCollection
    extends AbstractFixedSizeCollection<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse, ProcessLinks, BatchSearchLinkProcessesPage, BatchSearchLinkProcessesFixedSizeCollection> {
        private BatchSearchLinkProcessesFixedSizeCollection(List<BatchSearchLinkProcessesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static BatchSearchLinkProcessesFixedSizeCollection createEmptyCollection() {
            return new BatchSearchLinkProcessesFixedSizeCollection(null, 0);
        }

        protected BatchSearchLinkProcessesFixedSizeCollection createCollection(List<BatchSearchLinkProcessesPage> pages, int collectionSize) {
            return new BatchSearchLinkProcessesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class BatchSearchLinkProcessesPage
    extends AbstractPage<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse, ProcessLinks, BatchSearchLinkProcessesPage> {
        private BatchSearchLinkProcessesPage(PageContext<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse, ProcessLinks> context, BatchSearchLinkProcessesResponse response) {
            super(context, (Object)response);
        }

        private static BatchSearchLinkProcessesPage createEmptyPage() {
            return new BatchSearchLinkProcessesPage(null, null);
        }

        protected BatchSearchLinkProcessesPage createPage(PageContext<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse, ProcessLinks> context, BatchSearchLinkProcessesResponse response) {
            return new BatchSearchLinkProcessesPage(context, response);
        }

        public ApiFuture<BatchSearchLinkProcessesPage> createPageAsync(PageContext<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse, ProcessLinks> context, ApiFuture<BatchSearchLinkProcessesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class BatchSearchLinkProcessesPagedResponse
    extends AbstractPagedListResponse<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse, ProcessLinks, BatchSearchLinkProcessesPage, BatchSearchLinkProcessesFixedSizeCollection> {
        public static ApiFuture<BatchSearchLinkProcessesPagedResponse> createAsync(PageContext<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse, ProcessLinks> context, ApiFuture<BatchSearchLinkProcessesResponse> futureResponse) {
            ApiFuture<BatchSearchLinkProcessesPage> futurePage = BatchSearchLinkProcessesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new BatchSearchLinkProcessesPagedResponse((BatchSearchLinkProcessesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private BatchSearchLinkProcessesPagedResponse(BatchSearchLinkProcessesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)BatchSearchLinkProcessesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchLinksFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchLinksRequest, SearchLinksResponse, Link, SearchLinksPage, SearchLinksFixedSizeCollection> {
        private SearchLinksFixedSizeCollection(List<SearchLinksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchLinksFixedSizeCollection createEmptyCollection() {
            return new SearchLinksFixedSizeCollection(null, 0);
        }

        protected SearchLinksFixedSizeCollection createCollection(List<SearchLinksPage> pages, int collectionSize) {
            return new SearchLinksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchLinksPage
    extends AbstractPage<SearchLinksRequest, SearchLinksResponse, Link, SearchLinksPage> {
        private SearchLinksPage(PageContext<SearchLinksRequest, SearchLinksResponse, Link> context, SearchLinksResponse response) {
            super(context, (Object)response);
        }

        private static SearchLinksPage createEmptyPage() {
            return new SearchLinksPage(null, null);
        }

        protected SearchLinksPage createPage(PageContext<SearchLinksRequest, SearchLinksResponse, Link> context, SearchLinksResponse response) {
            return new SearchLinksPage(context, response);
        }

        public ApiFuture<SearchLinksPage> createPageAsync(PageContext<SearchLinksRequest, SearchLinksResponse, Link> context, ApiFuture<SearchLinksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchLinksPagedResponse
    extends AbstractPagedListResponse<SearchLinksRequest, SearchLinksResponse, Link, SearchLinksPage, SearchLinksFixedSizeCollection> {
        public static ApiFuture<SearchLinksPagedResponse> createAsync(PageContext<SearchLinksRequest, SearchLinksResponse, Link> context, ApiFuture<SearchLinksResponse> futureResponse) {
            ApiFuture<SearchLinksPage> futurePage = SearchLinksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchLinksPagedResponse((SearchLinksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchLinksPagedResponse(SearchLinksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchLinksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListLineageEventsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLineageEventsRequest, ListLineageEventsResponse, LineageEvent, ListLineageEventsPage, ListLineageEventsFixedSizeCollection> {
        private ListLineageEventsFixedSizeCollection(List<ListLineageEventsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLineageEventsFixedSizeCollection createEmptyCollection() {
            return new ListLineageEventsFixedSizeCollection(null, 0);
        }

        protected ListLineageEventsFixedSizeCollection createCollection(List<ListLineageEventsPage> pages, int collectionSize) {
            return new ListLineageEventsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLineageEventsPage
    extends AbstractPage<ListLineageEventsRequest, ListLineageEventsResponse, LineageEvent, ListLineageEventsPage> {
        private ListLineageEventsPage(PageContext<ListLineageEventsRequest, ListLineageEventsResponse, LineageEvent> context, ListLineageEventsResponse response) {
            super(context, (Object)response);
        }

        private static ListLineageEventsPage createEmptyPage() {
            return new ListLineageEventsPage(null, null);
        }

        protected ListLineageEventsPage createPage(PageContext<ListLineageEventsRequest, ListLineageEventsResponse, LineageEvent> context, ListLineageEventsResponse response) {
            return new ListLineageEventsPage(context, response);
        }

        public ApiFuture<ListLineageEventsPage> createPageAsync(PageContext<ListLineageEventsRequest, ListLineageEventsResponse, LineageEvent> context, ApiFuture<ListLineageEventsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLineageEventsPagedResponse
    extends AbstractPagedListResponse<ListLineageEventsRequest, ListLineageEventsResponse, LineageEvent, ListLineageEventsPage, ListLineageEventsFixedSizeCollection> {
        public static ApiFuture<ListLineageEventsPagedResponse> createAsync(PageContext<ListLineageEventsRequest, ListLineageEventsResponse, LineageEvent> context, ApiFuture<ListLineageEventsResponse> futureResponse) {
            ApiFuture<ListLineageEventsPage> futurePage = ListLineageEventsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLineageEventsPagedResponse((ListLineageEventsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLineageEventsPagedResponse(ListLineageEventsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLineageEventsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRunsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRunsRequest, ListRunsResponse, Run, ListRunsPage, ListRunsFixedSizeCollection> {
        private ListRunsFixedSizeCollection(List<ListRunsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRunsFixedSizeCollection createEmptyCollection() {
            return new ListRunsFixedSizeCollection(null, 0);
        }

        protected ListRunsFixedSizeCollection createCollection(List<ListRunsPage> pages, int collectionSize) {
            return new ListRunsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRunsPage
    extends AbstractPage<ListRunsRequest, ListRunsResponse, Run, ListRunsPage> {
        private ListRunsPage(PageContext<ListRunsRequest, ListRunsResponse, Run> context, ListRunsResponse response) {
            super(context, (Object)response);
        }

        private static ListRunsPage createEmptyPage() {
            return new ListRunsPage(null, null);
        }

        protected ListRunsPage createPage(PageContext<ListRunsRequest, ListRunsResponse, Run> context, ListRunsResponse response) {
            return new ListRunsPage(context, response);
        }

        public ApiFuture<ListRunsPage> createPageAsync(PageContext<ListRunsRequest, ListRunsResponse, Run> context, ApiFuture<ListRunsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRunsPagedResponse
    extends AbstractPagedListResponse<ListRunsRequest, ListRunsResponse, Run, ListRunsPage, ListRunsFixedSizeCollection> {
        public static ApiFuture<ListRunsPagedResponse> createAsync(PageContext<ListRunsRequest, ListRunsResponse, Run> context, ApiFuture<ListRunsResponse> futureResponse) {
            ApiFuture<ListRunsPage> futurePage = ListRunsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRunsPagedResponse((ListRunsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRunsPagedResponse(ListRunsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRunsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListProcessesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProcessesRequest, ListProcessesResponse, Process, ListProcessesPage, ListProcessesFixedSizeCollection> {
        private ListProcessesFixedSizeCollection(List<ListProcessesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProcessesFixedSizeCollection createEmptyCollection() {
            return new ListProcessesFixedSizeCollection(null, 0);
        }

        protected ListProcessesFixedSizeCollection createCollection(List<ListProcessesPage> pages, int collectionSize) {
            return new ListProcessesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProcessesPage
    extends AbstractPage<ListProcessesRequest, ListProcessesResponse, Process, ListProcessesPage> {
        private ListProcessesPage(PageContext<ListProcessesRequest, ListProcessesResponse, Process> context, ListProcessesResponse response) {
            super(context, (Object)response);
        }

        private static ListProcessesPage createEmptyPage() {
            return new ListProcessesPage(null, null);
        }

        protected ListProcessesPage createPage(PageContext<ListProcessesRequest, ListProcessesResponse, Process> context, ListProcessesResponse response) {
            return new ListProcessesPage(context, response);
        }

        public ApiFuture<ListProcessesPage> createPageAsync(PageContext<ListProcessesRequest, ListProcessesResponse, Process> context, ApiFuture<ListProcessesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProcessesPagedResponse
    extends AbstractPagedListResponse<ListProcessesRequest, ListProcessesResponse, Process, ListProcessesPage, ListProcessesFixedSizeCollection> {
        public static ApiFuture<ListProcessesPagedResponse> createAsync(PageContext<ListProcessesRequest, ListProcessesResponse, Process> context, ApiFuture<ListProcessesResponse> futureResponse) {
            ApiFuture<ListProcessesPage> futurePage = ListProcessesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProcessesPagedResponse((ListProcessesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProcessesPagedResponse(ListProcessesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProcessesFixedSizeCollection.createEmptyCollection());
        }
    }
}

