/*
 * Decompiled with CFR 0.152.
 */
package com.google.dataflow.v1beta3.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.dataflow.v1beta3.DeleteSnapshotRequest;
import com.google.dataflow.v1beta3.DeleteSnapshotResponse;
import com.google.dataflow.v1beta3.GetSnapshotRequest;
import com.google.dataflow.v1beta3.ListSnapshotsRequest;
import com.google.dataflow.v1beta3.ListSnapshotsResponse;
import com.google.dataflow.v1beta3.Snapshot;
import com.google.dataflow.v1beta3.stub.GrpcSnapshotsV1Beta3CallableFactory;
import com.google.dataflow.v1beta3.stub.SnapshotsV1Beta3Stub;
import com.google.dataflow.v1beta3.stub.SnapshotsV1Beta3StubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcSnapshotsV1Beta3Stub
extends SnapshotsV1Beta3Stub {
    private static final MethodDescriptor<GetSnapshotRequest, Snapshot> getSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.dataflow.v1beta3.SnapshotsV1Beta3/GetSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Snapshot.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteSnapshotRequest, DeleteSnapshotResponse> deleteSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.dataflow.v1beta3.SnapshotsV1Beta3/DeleteSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DeleteSnapshotResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.dataflow.v1beta3.SnapshotsV1Beta3/ListSnapshots").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSnapshotsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSnapshotsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetSnapshotRequest, Snapshot> getSnapshotCallable;
    private final UnaryCallable<DeleteSnapshotRequest, DeleteSnapshotResponse> deleteSnapshotCallable;
    private final UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSnapshotsV1Beta3Stub create(SnapshotsV1Beta3StubSettings settings) throws IOException {
        return new GrpcSnapshotsV1Beta3Stub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSnapshotsV1Beta3Stub create(ClientContext clientContext) throws IOException {
        return new GrpcSnapshotsV1Beta3Stub(SnapshotsV1Beta3StubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSnapshotsV1Beta3Stub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSnapshotsV1Beta3Stub(SnapshotsV1Beta3StubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSnapshotsV1Beta3Stub(SnapshotsV1Beta3StubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSnapshotsV1Beta3CallableFactory());
    }

    protected GrpcSnapshotsV1Beta3Stub(SnapshotsV1Beta3StubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSnapshotMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"location", (Object)String.valueOf(request.getLocation()));
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            params.put((Object)"snapshot_id", (Object)String.valueOf(request.getSnapshotId()));
            return params.build();
        }).build();
        GrpcCallSettings deleteSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSnapshotMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"location", (Object)String.valueOf(request.getLocation()));
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            params.put((Object)"snapshot_id", (Object)String.valueOf(request.getSnapshotId()));
            return params.build();
        }).build();
        GrpcCallSettings listSnapshotsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSnapshotsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"job_id", (Object)String.valueOf(request.getJobId()));
            params.put((Object)"location", (Object)String.valueOf(request.getLocation()));
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            return params.build();
        }).build();
        this.getSnapshotCallable = callableFactory.createUnaryCallable(getSnapshotTransportSettings, settings.getSnapshotSettings(), clientContext);
        this.deleteSnapshotCallable = callableFactory.createUnaryCallable(deleteSnapshotTransportSettings, settings.deleteSnapshotSettings(), clientContext);
        this.listSnapshotsCallable = callableFactory.createUnaryCallable(listSnapshotsTransportSettings, settings.listSnapshotsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetSnapshotRequest, Snapshot> getSnapshotCallable() {
        return this.getSnapshotCallable;
    }

    @Override
    public UnaryCallable<DeleteSnapshotRequest, DeleteSnapshotResponse> deleteSnapshotCallable() {
        return this.deleteSnapshotCallable;
    }

    @Override
    public UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsCallable() {
        return this.listSnapshotsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

