/*
 * Decompiled with CFR 0.152.
 */
package com.google.dataflow.v1beta3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.dataflow.v1beta3.JobMessage;
import com.google.dataflow.v1beta3.ListJobMessagesRequest;
import com.google.dataflow.v1beta3.ListJobMessagesResponse;
import com.google.dataflow.v1beta3.MessagesV1Beta3Client;
import com.google.dataflow.v1beta3.stub.GrpcMessagesV1Beta3Stub;
import com.google.dataflow.v1beta3.stub.HttpJsonMessagesV1Beta3Stub;
import com.google.dataflow.v1beta3.stub.MessagesV1Beta3Stub;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class MessagesV1Beta3StubSettings
extends StubSettings<MessagesV1Beta3StubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/userinfo.email").build();
    private final PagedCallSettings<ListJobMessagesRequest, ListJobMessagesResponse, MessagesV1Beta3Client.ListJobMessagesPagedResponse> listJobMessagesSettings;
    private static final PagedListDescriptor<ListJobMessagesRequest, ListJobMessagesResponse, JobMessage> LIST_JOB_MESSAGES_PAGE_STR_DESC = new PagedListDescriptor<ListJobMessagesRequest, ListJobMessagesResponse, JobMessage>(){

        public String emptyToken() {
            return "";
        }

        public ListJobMessagesRequest injectToken(ListJobMessagesRequest payload, String token) {
            return ListJobMessagesRequest.newBuilder((ListJobMessagesRequest)payload).setPageToken(token).build();
        }

        public ListJobMessagesRequest injectPageSize(ListJobMessagesRequest payload, int pageSize) {
            return ListJobMessagesRequest.newBuilder((ListJobMessagesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListJobMessagesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListJobMessagesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<JobMessage> extractResources(ListJobMessagesResponse payload) {
            return payload.getJobMessagesList() == null ? ImmutableList.of() : payload.getJobMessagesList();
        }
    };
    private static final PagedListResponseFactory<ListJobMessagesRequest, ListJobMessagesResponse, MessagesV1Beta3Client.ListJobMessagesPagedResponse> LIST_JOB_MESSAGES_PAGE_STR_FACT = new PagedListResponseFactory<ListJobMessagesRequest, ListJobMessagesResponse, MessagesV1Beta3Client.ListJobMessagesPagedResponse>(){

        public ApiFuture<MessagesV1Beta3Client.ListJobMessagesPagedResponse> getFuturePagedResponse(UnaryCallable<ListJobMessagesRequest, ListJobMessagesResponse> callable, ListJobMessagesRequest request, ApiCallContext context, ApiFuture<ListJobMessagesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_JOB_MESSAGES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MessagesV1Beta3Client.ListJobMessagesPagedResponse.createAsync((PageContext<ListJobMessagesRequest, ListJobMessagesResponse, JobMessage>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListJobMessagesRequest, ListJobMessagesResponse, MessagesV1Beta3Client.ListJobMessagesPagedResponse> listJobMessagesSettings() {
        return this.listJobMessagesSettings;
    }

    public MessagesV1Beta3Stub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcMessagesV1Beta3Stub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonMessagesV1Beta3Stub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dataflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "dataflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dataflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MessagesV1Beta3StubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MessagesV1Beta3StubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MessagesV1Beta3StubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return MessagesV1Beta3StubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MessagesV1Beta3StubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listJobMessagesSettings = settingsBuilder.listJobMessagesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MessagesV1Beta3StubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListJobMessagesRequest, ListJobMessagesResponse, MessagesV1Beta3Client.ListJobMessagesPagedResponse> listJobMessagesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listJobMessagesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_JOB_MESSAGES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listJobMessagesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(MessagesV1Beta3StubSettings settings) {
            super((StubSettings)settings);
            this.listJobMessagesSettings = settings.listJobMessagesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listJobMessagesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MessagesV1Beta3StubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MessagesV1Beta3StubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MessagesV1Beta3StubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MessagesV1Beta3StubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)MessagesV1Beta3StubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)MessagesV1Beta3StubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MessagesV1Beta3StubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MessagesV1Beta3StubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listJobMessagesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListJobMessagesRequest, ListJobMessagesResponse, MessagesV1Beta3Client.ListJobMessagesPagedResponse> listJobMessagesSettings() {
            return this.listJobMessagesSettings;
        }

        public MessagesV1Beta3StubSettings build() throws IOException {
            return new MessagesV1Beta3StubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

