/*
 * Decompiled with CFR 0.152.
 */
package com.google.dataflow.v1beta3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.dataflow.v1beta3.GetJobExecutionDetailsRequest;
import com.google.dataflow.v1beta3.GetJobMetricsRequest;
import com.google.dataflow.v1beta3.GetStageExecutionDetailsRequest;
import com.google.dataflow.v1beta3.JobExecutionDetails;
import com.google.dataflow.v1beta3.JobMetrics;
import com.google.dataflow.v1beta3.MetricsV1Beta3Client;
import com.google.dataflow.v1beta3.StageExecutionDetails;
import com.google.dataflow.v1beta3.StageSummary;
import com.google.dataflow.v1beta3.WorkerDetails;
import com.google.dataflow.v1beta3.stub.GrpcMetricsV1Beta3Stub;
import com.google.dataflow.v1beta3.stub.HttpJsonMetricsV1Beta3Stub;
import com.google.dataflow.v1beta3.stub.MetricsV1Beta3Stub;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class MetricsV1Beta3StubSettings
extends StubSettings<MetricsV1Beta3StubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/userinfo.email").build();
    private final UnaryCallSettings<GetJobMetricsRequest, JobMetrics> getJobMetricsSettings;
    private final PagedCallSettings<GetJobExecutionDetailsRequest, JobExecutionDetails, MetricsV1Beta3Client.GetJobExecutionDetailsPagedResponse> getJobExecutionDetailsSettings;
    private final PagedCallSettings<GetStageExecutionDetailsRequest, StageExecutionDetails, MetricsV1Beta3Client.GetStageExecutionDetailsPagedResponse> getStageExecutionDetailsSettings;
    private static final PagedListDescriptor<GetJobExecutionDetailsRequest, JobExecutionDetails, StageSummary> GET_JOB_EXECUTION_DETAILS_PAGE_STR_DESC = new PagedListDescriptor<GetJobExecutionDetailsRequest, JobExecutionDetails, StageSummary>(){

        public String emptyToken() {
            return "";
        }

        public GetJobExecutionDetailsRequest injectToken(GetJobExecutionDetailsRequest payload, String token) {
            return GetJobExecutionDetailsRequest.newBuilder((GetJobExecutionDetailsRequest)payload).setPageToken(token).build();
        }

        public GetJobExecutionDetailsRequest injectPageSize(GetJobExecutionDetailsRequest payload, int pageSize) {
            return GetJobExecutionDetailsRequest.newBuilder((GetJobExecutionDetailsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(GetJobExecutionDetailsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(JobExecutionDetails payload) {
            return payload.getNextPageToken();
        }

        public Iterable<StageSummary> extractResources(JobExecutionDetails payload) {
            return payload.getStagesList() == null ? ImmutableList.of() : payload.getStagesList();
        }
    };
    private static final PagedListDescriptor<GetStageExecutionDetailsRequest, StageExecutionDetails, WorkerDetails> GET_STAGE_EXECUTION_DETAILS_PAGE_STR_DESC = new PagedListDescriptor<GetStageExecutionDetailsRequest, StageExecutionDetails, WorkerDetails>(){

        public String emptyToken() {
            return "";
        }

        public GetStageExecutionDetailsRequest injectToken(GetStageExecutionDetailsRequest payload, String token) {
            return GetStageExecutionDetailsRequest.newBuilder((GetStageExecutionDetailsRequest)payload).setPageToken(token).build();
        }

        public GetStageExecutionDetailsRequest injectPageSize(GetStageExecutionDetailsRequest payload, int pageSize) {
            return GetStageExecutionDetailsRequest.newBuilder((GetStageExecutionDetailsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(GetStageExecutionDetailsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(StageExecutionDetails payload) {
            return payload.getNextPageToken();
        }

        public Iterable<WorkerDetails> extractResources(StageExecutionDetails payload) {
            return payload.getWorkersList() == null ? ImmutableList.of() : payload.getWorkersList();
        }
    };
    private static final PagedListResponseFactory<GetJobExecutionDetailsRequest, JobExecutionDetails, MetricsV1Beta3Client.GetJobExecutionDetailsPagedResponse> GET_JOB_EXECUTION_DETAILS_PAGE_STR_FACT = new PagedListResponseFactory<GetJobExecutionDetailsRequest, JobExecutionDetails, MetricsV1Beta3Client.GetJobExecutionDetailsPagedResponse>(){

        public ApiFuture<MetricsV1Beta3Client.GetJobExecutionDetailsPagedResponse> getFuturePagedResponse(UnaryCallable<GetJobExecutionDetailsRequest, JobExecutionDetails> callable, GetJobExecutionDetailsRequest request, ApiCallContext context, ApiFuture<JobExecutionDetails> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)GET_JOB_EXECUTION_DETAILS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MetricsV1Beta3Client.GetJobExecutionDetailsPagedResponse.createAsync((PageContext<GetJobExecutionDetailsRequest, JobExecutionDetails, StageSummary>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<GetStageExecutionDetailsRequest, StageExecutionDetails, MetricsV1Beta3Client.GetStageExecutionDetailsPagedResponse> GET_STAGE_EXECUTION_DETAILS_PAGE_STR_FACT = new PagedListResponseFactory<GetStageExecutionDetailsRequest, StageExecutionDetails, MetricsV1Beta3Client.GetStageExecutionDetailsPagedResponse>(){

        public ApiFuture<MetricsV1Beta3Client.GetStageExecutionDetailsPagedResponse> getFuturePagedResponse(UnaryCallable<GetStageExecutionDetailsRequest, StageExecutionDetails> callable, GetStageExecutionDetailsRequest request, ApiCallContext context, ApiFuture<StageExecutionDetails> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)GET_STAGE_EXECUTION_DETAILS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MetricsV1Beta3Client.GetStageExecutionDetailsPagedResponse.createAsync((PageContext<GetStageExecutionDetailsRequest, StageExecutionDetails, WorkerDetails>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetJobMetricsRequest, JobMetrics> getJobMetricsSettings() {
        return this.getJobMetricsSettings;
    }

    public PagedCallSettings<GetJobExecutionDetailsRequest, JobExecutionDetails, MetricsV1Beta3Client.GetJobExecutionDetailsPagedResponse> getJobExecutionDetailsSettings() {
        return this.getJobExecutionDetailsSettings;
    }

    public PagedCallSettings<GetStageExecutionDetailsRequest, StageExecutionDetails, MetricsV1Beta3Client.GetStageExecutionDetailsPagedResponse> getStageExecutionDetailsSettings() {
        return this.getStageExecutionDetailsSettings;
    }

    public MetricsV1Beta3Stub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcMetricsV1Beta3Stub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonMetricsV1Beta3Stub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dataflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dataflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dataflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MetricsV1Beta3StubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MetricsV1Beta3StubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MetricsV1Beta3StubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return MetricsV1Beta3StubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MetricsV1Beta3StubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getJobMetricsSettings = settingsBuilder.getJobMetricsSettings().build();
        this.getJobExecutionDetailsSettings = settingsBuilder.getJobExecutionDetailsSettings().build();
        this.getStageExecutionDetailsSettings = settingsBuilder.getStageExecutionDetailsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MetricsV1Beta3StubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetJobMetricsRequest, JobMetrics> getJobMetricsSettings;
        private final PagedCallSettings.Builder<GetJobExecutionDetailsRequest, JobExecutionDetails, MetricsV1Beta3Client.GetJobExecutionDetailsPagedResponse> getJobExecutionDetailsSettings;
        private final PagedCallSettings.Builder<GetStageExecutionDetailsRequest, StageExecutionDetails, MetricsV1Beta3Client.GetStageExecutionDetailsPagedResponse> getStageExecutionDetailsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getJobMetricsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getJobExecutionDetailsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)GET_JOB_EXECUTION_DETAILS_PAGE_STR_FACT);
            this.getStageExecutionDetailsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)GET_STAGE_EXECUTION_DETAILS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getJobMetricsSettings, this.getJobExecutionDetailsSettings, this.getStageExecutionDetailsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(MetricsV1Beta3StubSettings settings) {
            super((StubSettings)settings);
            this.getJobMetricsSettings = settings.getJobMetricsSettings.toBuilder();
            this.getJobExecutionDetailsSettings = settings.getJobExecutionDetailsSettings.toBuilder();
            this.getStageExecutionDetailsSettings = settings.getStageExecutionDetailsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getJobMetricsSettings, this.getJobExecutionDetailsSettings, this.getStageExecutionDetailsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MetricsV1Beta3StubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MetricsV1Beta3StubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MetricsV1Beta3StubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MetricsV1Beta3StubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)MetricsV1Beta3StubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)MetricsV1Beta3StubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MetricsV1Beta3StubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MetricsV1Beta3StubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getJobMetricsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getJobExecutionDetailsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getStageExecutionDetailsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetJobMetricsRequest, JobMetrics> getJobMetricsSettings() {
            return this.getJobMetricsSettings;
        }

        public PagedCallSettings.Builder<GetJobExecutionDetailsRequest, JobExecutionDetails, MetricsV1Beta3Client.GetJobExecutionDetailsPagedResponse> getJobExecutionDetailsSettings() {
            return this.getJobExecutionDetailsSettings;
        }

        public PagedCallSettings.Builder<GetStageExecutionDetailsRequest, StageExecutionDetails, MetricsV1Beta3Client.GetStageExecutionDetailsPagedResponse> getStageExecutionDetailsSettings() {
            return this.getStageExecutionDetailsSettings;
        }

        public MetricsV1Beta3StubSettings build() throws IOException {
            return new MetricsV1Beta3StubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

