/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datacatalog.v1.CreatePolicyTagRequest;
import com.google.cloud.datacatalog.v1.CreateTaxonomyRequest;
import com.google.cloud.datacatalog.v1.DeletePolicyTagRequest;
import com.google.cloud.datacatalog.v1.DeleteTaxonomyRequest;
import com.google.cloud.datacatalog.v1.GetPolicyTagRequest;
import com.google.cloud.datacatalog.v1.GetTaxonomyRequest;
import com.google.cloud.datacatalog.v1.ListPolicyTagsRequest;
import com.google.cloud.datacatalog.v1.ListPolicyTagsResponse;
import com.google.cloud.datacatalog.v1.ListTaxonomiesRequest;
import com.google.cloud.datacatalog.v1.ListTaxonomiesResponse;
import com.google.cloud.datacatalog.v1.PolicyTag;
import com.google.cloud.datacatalog.v1.PolicyTagManagerClient;
import com.google.cloud.datacatalog.v1.Taxonomy;
import com.google.cloud.datacatalog.v1.UpdatePolicyTagRequest;
import com.google.cloud.datacatalog.v1.UpdateTaxonomyRequest;
import com.google.cloud.datacatalog.v1.stub.GrpcPolicyTagManagerCallableFactory;
import com.google.cloud.datacatalog.v1.stub.PolicyTagManagerStub;
import com.google.cloud.datacatalog.v1.stub.PolicyTagManagerStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcPolicyTagManagerStub
extends PolicyTagManagerStub {
    private static final MethodDescriptor<CreateTaxonomyRequest, Taxonomy> createTaxonomyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datacatalog.v1.PolicyTagManager/CreateTaxonomy").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateTaxonomyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Taxonomy.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteTaxonomyRequest, Empty> deleteTaxonomyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datacatalog.v1.PolicyTagManager/DeleteTaxonomy").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteTaxonomyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateTaxonomyRequest, Taxonomy> updateTaxonomyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datacatalog.v1.PolicyTagManager/UpdateTaxonomy").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateTaxonomyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Taxonomy.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTaxonomiesRequest, ListTaxonomiesResponse> listTaxonomiesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datacatalog.v1.PolicyTagManager/ListTaxonomies").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTaxonomiesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTaxonomiesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetTaxonomyRequest, Taxonomy> getTaxonomyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datacatalog.v1.PolicyTagManager/GetTaxonomy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTaxonomyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Taxonomy.getDefaultInstance())).build();
    private static final MethodDescriptor<CreatePolicyTagRequest, PolicyTag> createPolicyTagMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datacatalog.v1.PolicyTagManager/CreatePolicyTag").setRequestMarshaller(ProtoUtils.marshaller((Message)CreatePolicyTagRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PolicyTag.getDefaultInstance())).build();
    private static final MethodDescriptor<DeletePolicyTagRequest, Empty> deletePolicyTagMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datacatalog.v1.PolicyTagManager/DeletePolicyTag").setRequestMarshaller(ProtoUtils.marshaller((Message)DeletePolicyTagRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdatePolicyTagRequest, PolicyTag> updatePolicyTagMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datacatalog.v1.PolicyTagManager/UpdatePolicyTag").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdatePolicyTagRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PolicyTag.getDefaultInstance())).build();
    private static final MethodDescriptor<ListPolicyTagsRequest, ListPolicyTagsResponse> listPolicyTagsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datacatalog.v1.PolicyTagManager/ListPolicyTags").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPolicyTagsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPolicyTagsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetPolicyTagRequest, PolicyTag> getPolicyTagMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datacatalog.v1.PolicyTagManager/GetPolicyTag").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPolicyTagRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PolicyTag.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datacatalog.v1.PolicyTagManager/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datacatalog.v1.PolicyTagManager/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datacatalog.v1.PolicyTagManager/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateTaxonomyRequest, Taxonomy> createTaxonomyCallable;
    private final UnaryCallable<DeleteTaxonomyRequest, Empty> deleteTaxonomyCallable;
    private final UnaryCallable<UpdateTaxonomyRequest, Taxonomy> updateTaxonomyCallable;
    private final UnaryCallable<ListTaxonomiesRequest, ListTaxonomiesResponse> listTaxonomiesCallable;
    private final UnaryCallable<ListTaxonomiesRequest, PolicyTagManagerClient.ListTaxonomiesPagedResponse> listTaxonomiesPagedCallable;
    private final UnaryCallable<GetTaxonomyRequest, Taxonomy> getTaxonomyCallable;
    private final UnaryCallable<CreatePolicyTagRequest, PolicyTag> createPolicyTagCallable;
    private final UnaryCallable<DeletePolicyTagRequest, Empty> deletePolicyTagCallable;
    private final UnaryCallable<UpdatePolicyTagRequest, PolicyTag> updatePolicyTagCallable;
    private final UnaryCallable<ListPolicyTagsRequest, ListPolicyTagsResponse> listPolicyTagsCallable;
    private final UnaryCallable<ListPolicyTagsRequest, PolicyTagManagerClient.ListPolicyTagsPagedResponse> listPolicyTagsPagedCallable;
    private final UnaryCallable<GetPolicyTagRequest, PolicyTag> getPolicyTagCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcPolicyTagManagerStub create(PolicyTagManagerStubSettings settings) throws IOException {
        return new GrpcPolicyTagManagerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcPolicyTagManagerStub create(ClientContext clientContext) throws IOException {
        return new GrpcPolicyTagManagerStub(PolicyTagManagerStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcPolicyTagManagerStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcPolicyTagManagerStub(PolicyTagManagerStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcPolicyTagManagerStub(PolicyTagManagerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcPolicyTagManagerCallableFactory());
    }

    protected GrpcPolicyTagManagerStub(PolicyTagManagerStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createTaxonomyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTaxonomyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings deleteTaxonomyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteTaxonomyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateTaxonomyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateTaxonomyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"taxonomy.name", (Object)String.valueOf(request.getTaxonomy().getName()));
            return params.build();
        }).build();
        GrpcCallSettings listTaxonomiesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTaxonomiesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getTaxonomyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTaxonomyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createPolicyTagTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createPolicyTagMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings deletePolicyTagTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deletePolicyTagMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updatePolicyTagTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updatePolicyTagMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"policy_tag.name", (Object)String.valueOf(request.getPolicyTag().getName()));
            return params.build();
        }).build();
        GrpcCallSettings listPolicyTagsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPolicyTagsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getPolicyTagTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPolicyTagMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        this.createTaxonomyCallable = callableFactory.createUnaryCallable(createTaxonomyTransportSettings, settings.createTaxonomySettings(), clientContext);
        this.deleteTaxonomyCallable = callableFactory.createUnaryCallable(deleteTaxonomyTransportSettings, settings.deleteTaxonomySettings(), clientContext);
        this.updateTaxonomyCallable = callableFactory.createUnaryCallable(updateTaxonomyTransportSettings, settings.updateTaxonomySettings(), clientContext);
        this.listTaxonomiesCallable = callableFactory.createUnaryCallable(listTaxonomiesTransportSettings, settings.listTaxonomiesSettings(), clientContext);
        this.listTaxonomiesPagedCallable = callableFactory.createPagedCallable(listTaxonomiesTransportSettings, settings.listTaxonomiesSettings(), clientContext);
        this.getTaxonomyCallable = callableFactory.createUnaryCallable(getTaxonomyTransportSettings, settings.getTaxonomySettings(), clientContext);
        this.createPolicyTagCallable = callableFactory.createUnaryCallable(createPolicyTagTransportSettings, settings.createPolicyTagSettings(), clientContext);
        this.deletePolicyTagCallable = callableFactory.createUnaryCallable(deletePolicyTagTransportSettings, settings.deletePolicyTagSettings(), clientContext);
        this.updatePolicyTagCallable = callableFactory.createUnaryCallable(updatePolicyTagTransportSettings, settings.updatePolicyTagSettings(), clientContext);
        this.listPolicyTagsCallable = callableFactory.createUnaryCallable(listPolicyTagsTransportSettings, settings.listPolicyTagsSettings(), clientContext);
        this.listPolicyTagsPagedCallable = callableFactory.createPagedCallable(listPolicyTagsTransportSettings, settings.listPolicyTagsSettings(), clientContext);
        this.getPolicyTagCallable = callableFactory.createUnaryCallable(getPolicyTagTransportSettings, settings.getPolicyTagSettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateTaxonomyRequest, Taxonomy> createTaxonomyCallable() {
        return this.createTaxonomyCallable;
    }

    @Override
    public UnaryCallable<DeleteTaxonomyRequest, Empty> deleteTaxonomyCallable() {
        return this.deleteTaxonomyCallable;
    }

    @Override
    public UnaryCallable<UpdateTaxonomyRequest, Taxonomy> updateTaxonomyCallable() {
        return this.updateTaxonomyCallable;
    }

    @Override
    public UnaryCallable<ListTaxonomiesRequest, ListTaxonomiesResponse> listTaxonomiesCallable() {
        return this.listTaxonomiesCallable;
    }

    @Override
    public UnaryCallable<ListTaxonomiesRequest, PolicyTagManagerClient.ListTaxonomiesPagedResponse> listTaxonomiesPagedCallable() {
        return this.listTaxonomiesPagedCallable;
    }

    @Override
    public UnaryCallable<GetTaxonomyRequest, Taxonomy> getTaxonomyCallable() {
        return this.getTaxonomyCallable;
    }

    @Override
    public UnaryCallable<CreatePolicyTagRequest, PolicyTag> createPolicyTagCallable() {
        return this.createPolicyTagCallable;
    }

    @Override
    public UnaryCallable<DeletePolicyTagRequest, Empty> deletePolicyTagCallable() {
        return this.deletePolicyTagCallable;
    }

    @Override
    public UnaryCallable<UpdatePolicyTagRequest, PolicyTag> updatePolicyTagCallable() {
        return this.updatePolicyTagCallable;
    }

    @Override
    public UnaryCallable<ListPolicyTagsRequest, ListPolicyTagsResponse> listPolicyTagsCallable() {
        return this.listPolicyTagsCallable;
    }

    @Override
    public UnaryCallable<ListPolicyTagsRequest, PolicyTagManagerClient.ListPolicyTagsPagedResponse> listPolicyTagsPagedCallable() {
        return this.listPolicyTagsPagedCallable;
    }

    @Override
    public UnaryCallable<GetPolicyTagRequest, PolicyTag> getPolicyTagCallable() {
        return this.getPolicyTagCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

