/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datacatalog.v1beta1.CreatePolicyTagRequest;
import com.google.cloud.datacatalog.v1beta1.CreateTaxonomyRequest;
import com.google.cloud.datacatalog.v1beta1.DeletePolicyTagRequest;
import com.google.cloud.datacatalog.v1beta1.DeleteTaxonomyRequest;
import com.google.cloud.datacatalog.v1beta1.GetPolicyTagRequest;
import com.google.cloud.datacatalog.v1beta1.GetTaxonomyRequest;
import com.google.cloud.datacatalog.v1beta1.ListPolicyTagsRequest;
import com.google.cloud.datacatalog.v1beta1.ListPolicyTagsResponse;
import com.google.cloud.datacatalog.v1beta1.ListTaxonomiesRequest;
import com.google.cloud.datacatalog.v1beta1.ListTaxonomiesResponse;
import com.google.cloud.datacatalog.v1beta1.LocationName;
import com.google.cloud.datacatalog.v1beta1.PolicyTag;
import com.google.cloud.datacatalog.v1beta1.PolicyTagManagerSettings;
import com.google.cloud.datacatalog.v1beta1.PolicyTagName;
import com.google.cloud.datacatalog.v1beta1.Taxonomy;
import com.google.cloud.datacatalog.v1beta1.TaxonomyName;
import com.google.cloud.datacatalog.v1beta1.UpdatePolicyTagRequest;
import com.google.cloud.datacatalog.v1beta1.UpdateTaxonomyRequest;
import com.google.cloud.datacatalog.v1beta1.stub.PolicyTagManagerStub;
import com.google.cloud.datacatalog.v1beta1.stub.PolicyTagManagerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PolicyTagManagerClient
implements BackgroundResource {
    private final PolicyTagManagerSettings settings;
    private final PolicyTagManagerStub stub;

    public static final PolicyTagManagerClient create() throws IOException {
        return PolicyTagManagerClient.create(PolicyTagManagerSettings.newBuilder().build());
    }

    public static final PolicyTagManagerClient create(PolicyTagManagerSettings settings) throws IOException {
        return new PolicyTagManagerClient(settings);
    }

    public static final PolicyTagManagerClient create(PolicyTagManagerStub stub) {
        return new PolicyTagManagerClient(stub);
    }

    protected PolicyTagManagerClient(PolicyTagManagerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PolicyTagManagerStubSettings)settings.getStubSettings()).createStub();
    }

    protected PolicyTagManagerClient(PolicyTagManagerStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PolicyTagManagerSettings getSettings() {
        return this.settings;
    }

    public PolicyTagManagerStub getStub() {
        return this.stub;
    }

    public final Taxonomy createTaxonomy(LocationName parent, Taxonomy taxonomy) {
        CreateTaxonomyRequest request = CreateTaxonomyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTaxonomy(taxonomy).build();
        return this.createTaxonomy(request);
    }

    public final Taxonomy createTaxonomy(String parent, Taxonomy taxonomy) {
        CreateTaxonomyRequest request = CreateTaxonomyRequest.newBuilder().setParent(parent).setTaxonomy(taxonomy).build();
        return this.createTaxonomy(request);
    }

    public final Taxonomy createTaxonomy(CreateTaxonomyRequest request) {
        return (Taxonomy)this.createTaxonomyCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTaxonomyRequest, Taxonomy> createTaxonomyCallable() {
        return this.stub.createTaxonomyCallable();
    }

    public final void deleteTaxonomy(TaxonomyName name) {
        DeleteTaxonomyRequest request = DeleteTaxonomyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTaxonomy(request);
    }

    public final void deleteTaxonomy(String name) {
        DeleteTaxonomyRequest request = DeleteTaxonomyRequest.newBuilder().setName(name).build();
        this.deleteTaxonomy(request);
    }

    public final void deleteTaxonomy(DeleteTaxonomyRequest request) {
        this.deleteTaxonomyCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTaxonomyRequest, Empty> deleteTaxonomyCallable() {
        return this.stub.deleteTaxonomyCallable();
    }

    public final Taxonomy updateTaxonomy(Taxonomy taxonomy) {
        UpdateTaxonomyRequest request = UpdateTaxonomyRequest.newBuilder().setTaxonomy(taxonomy).build();
        return this.updateTaxonomy(request);
    }

    public final Taxonomy updateTaxonomy(UpdateTaxonomyRequest request) {
        return (Taxonomy)this.updateTaxonomyCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTaxonomyRequest, Taxonomy> updateTaxonomyCallable() {
        return this.stub.updateTaxonomyCallable();
    }

    public final ListTaxonomiesPagedResponse listTaxonomies(LocationName parent) {
        ListTaxonomiesRequest request = ListTaxonomiesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTaxonomies(request);
    }

    public final ListTaxonomiesPagedResponse listTaxonomies(String parent) {
        ListTaxonomiesRequest request = ListTaxonomiesRequest.newBuilder().setParent(parent).build();
        return this.listTaxonomies(request);
    }

    public final ListTaxonomiesPagedResponse listTaxonomies(ListTaxonomiesRequest request) {
        return (ListTaxonomiesPagedResponse)((Object)this.listTaxonomiesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTaxonomiesRequest, ListTaxonomiesPagedResponse> listTaxonomiesPagedCallable() {
        return this.stub.listTaxonomiesPagedCallable();
    }

    public final UnaryCallable<ListTaxonomiesRequest, ListTaxonomiesResponse> listTaxonomiesCallable() {
        return this.stub.listTaxonomiesCallable();
    }

    public final Taxonomy getTaxonomy(TaxonomyName name) {
        GetTaxonomyRequest request = GetTaxonomyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTaxonomy(request);
    }

    public final Taxonomy getTaxonomy(String name) {
        GetTaxonomyRequest request = GetTaxonomyRequest.newBuilder().setName(name).build();
        return this.getTaxonomy(request);
    }

    public final Taxonomy getTaxonomy(GetTaxonomyRequest request) {
        return (Taxonomy)this.getTaxonomyCallable().call((Object)request);
    }

    public final UnaryCallable<GetTaxonomyRequest, Taxonomy> getTaxonomyCallable() {
        return this.stub.getTaxonomyCallable();
    }

    public final PolicyTag createPolicyTag(TaxonomyName parent, PolicyTag policyTag) {
        CreatePolicyTagRequest request = CreatePolicyTagRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPolicyTag(policyTag).build();
        return this.createPolicyTag(request);
    }

    public final PolicyTag createPolicyTag(String parent, PolicyTag policyTag) {
        CreatePolicyTagRequest request = CreatePolicyTagRequest.newBuilder().setParent(parent).setPolicyTag(policyTag).build();
        return this.createPolicyTag(request);
    }

    public final PolicyTag createPolicyTag(CreatePolicyTagRequest request) {
        return (PolicyTag)this.createPolicyTagCallable().call((Object)request);
    }

    public final UnaryCallable<CreatePolicyTagRequest, PolicyTag> createPolicyTagCallable() {
        return this.stub.createPolicyTagCallable();
    }

    public final void deletePolicyTag(PolicyTagName name) {
        DeletePolicyTagRequest request = DeletePolicyTagRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deletePolicyTag(request);
    }

    public final void deletePolicyTag(String name) {
        DeletePolicyTagRequest request = DeletePolicyTagRequest.newBuilder().setName(name).build();
        this.deletePolicyTag(request);
    }

    public final void deletePolicyTag(DeletePolicyTagRequest request) {
        this.deletePolicyTagCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePolicyTagRequest, Empty> deletePolicyTagCallable() {
        return this.stub.deletePolicyTagCallable();
    }

    public final PolicyTag updatePolicyTag(PolicyTag policyTag) {
        UpdatePolicyTagRequest request = UpdatePolicyTagRequest.newBuilder().setPolicyTag(policyTag).build();
        return this.updatePolicyTag(request);
    }

    public final PolicyTag updatePolicyTag(UpdatePolicyTagRequest request) {
        return (PolicyTag)this.updatePolicyTagCallable().call((Object)request);
    }

    public final UnaryCallable<UpdatePolicyTagRequest, PolicyTag> updatePolicyTagCallable() {
        return this.stub.updatePolicyTagCallable();
    }

    public final ListPolicyTagsPagedResponse listPolicyTags(TaxonomyName parent) {
        ListPolicyTagsRequest request = ListPolicyTagsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPolicyTags(request);
    }

    public final ListPolicyTagsPagedResponse listPolicyTags(String parent) {
        ListPolicyTagsRequest request = ListPolicyTagsRequest.newBuilder().setParent(parent).build();
        return this.listPolicyTags(request);
    }

    public final ListPolicyTagsPagedResponse listPolicyTags(ListPolicyTagsRequest request) {
        return (ListPolicyTagsPagedResponse)((Object)this.listPolicyTagsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPolicyTagsRequest, ListPolicyTagsPagedResponse> listPolicyTagsPagedCallable() {
        return this.stub.listPolicyTagsPagedCallable();
    }

    public final UnaryCallable<ListPolicyTagsRequest, ListPolicyTagsResponse> listPolicyTagsCallable() {
        return this.stub.listPolicyTagsCallable();
    }

    public final PolicyTag getPolicyTag(PolicyTagName name) {
        GetPolicyTagRequest request = GetPolicyTagRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPolicyTag(request);
    }

    public final PolicyTag getPolicyTag(String name) {
        GetPolicyTagRequest request = GetPolicyTagRequest.newBuilder().setName(name).build();
        return this.getPolicyTag(request);
    }

    public final PolicyTag getPolicyTag(GetPolicyTagRequest request) {
        return (PolicyTag)this.getPolicyTagCallable().call((Object)request);
    }

    public final UnaryCallable<GetPolicyTagRequest, PolicyTag> getPolicyTagCallable() {
        return this.stub.getPolicyTagCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPolicyTagsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPolicyTagsRequest, ListPolicyTagsResponse, PolicyTag, ListPolicyTagsPage, ListPolicyTagsFixedSizeCollection> {
        private ListPolicyTagsFixedSizeCollection(List<ListPolicyTagsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPolicyTagsFixedSizeCollection createEmptyCollection() {
            return new ListPolicyTagsFixedSizeCollection(null, 0);
        }

        protected ListPolicyTagsFixedSizeCollection createCollection(List<ListPolicyTagsPage> pages, int collectionSize) {
            return new ListPolicyTagsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPolicyTagsPage
    extends AbstractPage<ListPolicyTagsRequest, ListPolicyTagsResponse, PolicyTag, ListPolicyTagsPage> {
        private ListPolicyTagsPage(PageContext<ListPolicyTagsRequest, ListPolicyTagsResponse, PolicyTag> context, ListPolicyTagsResponse response) {
            super(context, (Object)response);
        }

        private static ListPolicyTagsPage createEmptyPage() {
            return new ListPolicyTagsPage(null, null);
        }

        protected ListPolicyTagsPage createPage(PageContext<ListPolicyTagsRequest, ListPolicyTagsResponse, PolicyTag> context, ListPolicyTagsResponse response) {
            return new ListPolicyTagsPage(context, response);
        }

        public ApiFuture<ListPolicyTagsPage> createPageAsync(PageContext<ListPolicyTagsRequest, ListPolicyTagsResponse, PolicyTag> context, ApiFuture<ListPolicyTagsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPolicyTagsPagedResponse
    extends AbstractPagedListResponse<ListPolicyTagsRequest, ListPolicyTagsResponse, PolicyTag, ListPolicyTagsPage, ListPolicyTagsFixedSizeCollection> {
        public static ApiFuture<ListPolicyTagsPagedResponse> createAsync(PageContext<ListPolicyTagsRequest, ListPolicyTagsResponse, PolicyTag> context, ApiFuture<ListPolicyTagsResponse> futureResponse) {
            ApiFuture<ListPolicyTagsPage> futurePage = ListPolicyTagsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPolicyTagsPagedResponse((ListPolicyTagsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPolicyTagsPagedResponse(ListPolicyTagsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPolicyTagsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTaxonomiesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTaxonomiesRequest, ListTaxonomiesResponse, Taxonomy, ListTaxonomiesPage, ListTaxonomiesFixedSizeCollection> {
        private ListTaxonomiesFixedSizeCollection(List<ListTaxonomiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTaxonomiesFixedSizeCollection createEmptyCollection() {
            return new ListTaxonomiesFixedSizeCollection(null, 0);
        }

        protected ListTaxonomiesFixedSizeCollection createCollection(List<ListTaxonomiesPage> pages, int collectionSize) {
            return new ListTaxonomiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTaxonomiesPage
    extends AbstractPage<ListTaxonomiesRequest, ListTaxonomiesResponse, Taxonomy, ListTaxonomiesPage> {
        private ListTaxonomiesPage(PageContext<ListTaxonomiesRequest, ListTaxonomiesResponse, Taxonomy> context, ListTaxonomiesResponse response) {
            super(context, (Object)response);
        }

        private static ListTaxonomiesPage createEmptyPage() {
            return new ListTaxonomiesPage(null, null);
        }

        protected ListTaxonomiesPage createPage(PageContext<ListTaxonomiesRequest, ListTaxonomiesResponse, Taxonomy> context, ListTaxonomiesResponse response) {
            return new ListTaxonomiesPage(context, response);
        }

        public ApiFuture<ListTaxonomiesPage> createPageAsync(PageContext<ListTaxonomiesRequest, ListTaxonomiesResponse, Taxonomy> context, ApiFuture<ListTaxonomiesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTaxonomiesPagedResponse
    extends AbstractPagedListResponse<ListTaxonomiesRequest, ListTaxonomiesResponse, Taxonomy, ListTaxonomiesPage, ListTaxonomiesFixedSizeCollection> {
        public static ApiFuture<ListTaxonomiesPagedResponse> createAsync(PageContext<ListTaxonomiesRequest, ListTaxonomiesResponse, Taxonomy> context, ApiFuture<ListTaxonomiesResponse> futureResponse) {
            ApiFuture<ListTaxonomiesPage> futurePage = ListTaxonomiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTaxonomiesPagedResponse((ListTaxonomiesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTaxonomiesPagedResponse(ListTaxonomiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTaxonomiesFixedSizeCollection.createEmptyCollection());
        }
    }
}

