/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datacatalog.v1beta1.ExportTaxonomiesRequest;
import com.google.cloud.datacatalog.v1beta1.ExportTaxonomiesResponse;
import com.google.cloud.datacatalog.v1beta1.ImportTaxonomiesRequest;
import com.google.cloud.datacatalog.v1beta1.ImportTaxonomiesResponse;
import com.google.cloud.datacatalog.v1beta1.stub.GrpcPolicyTagManagerSerializationCallableFactory;
import com.google.cloud.datacatalog.v1beta1.stub.PolicyTagManagerSerializationStub;
import com.google.cloud.datacatalog.v1beta1.stub.PolicyTagManagerSerializationStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcPolicyTagManagerSerializationStub
extends PolicyTagManagerSerializationStub {
    private static final MethodDescriptor<ImportTaxonomiesRequest, ImportTaxonomiesResponse> importTaxonomiesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization/ImportTaxonomies").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportTaxonomiesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ImportTaxonomiesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ExportTaxonomiesRequest, ExportTaxonomiesResponse> exportTaxonomiesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization/ExportTaxonomies").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportTaxonomiesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ExportTaxonomiesResponse.getDefaultInstance())).build();
    private final UnaryCallable<ImportTaxonomiesRequest, ImportTaxonomiesResponse> importTaxonomiesCallable;
    private final UnaryCallable<ExportTaxonomiesRequest, ExportTaxonomiesResponse> exportTaxonomiesCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcPolicyTagManagerSerializationStub create(PolicyTagManagerSerializationStubSettings settings) throws IOException {
        return new GrpcPolicyTagManagerSerializationStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcPolicyTagManagerSerializationStub create(ClientContext clientContext) throws IOException {
        return new GrpcPolicyTagManagerSerializationStub(PolicyTagManagerSerializationStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcPolicyTagManagerSerializationStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcPolicyTagManagerSerializationStub(PolicyTagManagerSerializationStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcPolicyTagManagerSerializationStub(PolicyTagManagerSerializationStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcPolicyTagManagerSerializationCallableFactory());
    }

    protected GrpcPolicyTagManagerSerializationStub(PolicyTagManagerSerializationStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings importTaxonomiesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importTaxonomiesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings exportTaxonomiesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportTaxonomiesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.importTaxonomiesCallable = callableFactory.createUnaryCallable(importTaxonomiesTransportSettings, settings.importTaxonomiesSettings(), clientContext);
        this.exportTaxonomiesCallable = callableFactory.createUnaryCallable(exportTaxonomiesTransportSettings, settings.exportTaxonomiesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ImportTaxonomiesRequest, ImportTaxonomiesResponse> importTaxonomiesCallable() {
        return this.importTaxonomiesCallable;
    }

    @Override
    public UnaryCallable<ExportTaxonomiesRequest, ExportTaxonomiesResponse> exportTaxonomiesCallable() {
        return this.exportTaxonomiesCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

