/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.datacatalog.v1.ExportTaxonomiesRequest;
import com.google.cloud.datacatalog.v1.ExportTaxonomiesResponse;
import com.google.cloud.datacatalog.v1.ImportTaxonomiesRequest;
import com.google.cloud.datacatalog.v1.ImportTaxonomiesResponse;
import com.google.cloud.datacatalog.v1.ReplaceTaxonomyRequest;
import com.google.cloud.datacatalog.v1.Taxonomy;
import com.google.cloud.datacatalog.v1.stub.GrpcPolicyTagManagerSerializationStub;
import com.google.cloud.datacatalog.v1.stub.HttpJsonPolicyTagManagerSerializationStub;
import com.google.cloud.datacatalog.v1.stub.PolicyTagManagerSerializationStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class PolicyTagManagerSerializationStubSettings
extends StubSettings<PolicyTagManagerSerializationStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ReplaceTaxonomyRequest, Taxonomy> replaceTaxonomySettings;
    private final UnaryCallSettings<ImportTaxonomiesRequest, ImportTaxonomiesResponse> importTaxonomiesSettings;
    private final UnaryCallSettings<ExportTaxonomiesRequest, ExportTaxonomiesResponse> exportTaxonomiesSettings;

    public UnaryCallSettings<ReplaceTaxonomyRequest, Taxonomy> replaceTaxonomySettings() {
        return this.replaceTaxonomySettings;
    }

    public UnaryCallSettings<ImportTaxonomiesRequest, ImportTaxonomiesResponse> importTaxonomiesSettings() {
        return this.importTaxonomiesSettings;
    }

    public UnaryCallSettings<ExportTaxonomiesRequest, ExportTaxonomiesResponse> exportTaxonomiesSettings() {
        return this.exportTaxonomiesSettings;
    }

    public PolicyTagManagerSerializationStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcPolicyTagManagerSerializationStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPolicyTagManagerSerializationStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "datacatalog";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "datacatalog.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "datacatalog.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PolicyTagManagerSerializationStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PolicyTagManagerSerializationStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PolicyTagManagerSerializationStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return PolicyTagManagerSerializationStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PolicyTagManagerSerializationStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.replaceTaxonomySettings = settingsBuilder.replaceTaxonomySettings().build();
        this.importTaxonomiesSettings = settingsBuilder.importTaxonomiesSettings().build();
        this.exportTaxonomiesSettings = settingsBuilder.exportTaxonomiesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PolicyTagManagerSerializationStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ReplaceTaxonomyRequest, Taxonomy> replaceTaxonomySettings;
        private final UnaryCallSettings.Builder<ImportTaxonomiesRequest, ImportTaxonomiesResponse> importTaxonomiesSettings;
        private final UnaryCallSettings.Builder<ExportTaxonomiesRequest, ExportTaxonomiesResponse> exportTaxonomiesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.replaceTaxonomySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importTaxonomiesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportTaxonomiesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.replaceTaxonomySettings, this.importTaxonomiesSettings, this.exportTaxonomiesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(PolicyTagManagerSerializationStubSettings settings) {
            super((StubSettings)settings);
            this.replaceTaxonomySettings = settings.replaceTaxonomySettings.toBuilder();
            this.importTaxonomiesSettings = settings.importTaxonomiesSettings.toBuilder();
            this.exportTaxonomiesSettings = settings.exportTaxonomiesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.replaceTaxonomySettings, this.importTaxonomiesSettings, this.exportTaxonomiesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PolicyTagManagerSerializationStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PolicyTagManagerSerializationStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PolicyTagManagerSerializationStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PolicyTagManagerSerializationStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)PolicyTagManagerSerializationStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)PolicyTagManagerSerializationStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PolicyTagManagerSerializationStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PolicyTagManagerSerializationStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.replaceTaxonomySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.importTaxonomiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.exportTaxonomiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ReplaceTaxonomyRequest, Taxonomy> replaceTaxonomySettings() {
            return this.replaceTaxonomySettings;
        }

        public UnaryCallSettings.Builder<ImportTaxonomiesRequest, ImportTaxonomiesResponse> importTaxonomiesSettings() {
            return this.importTaxonomiesSettings;
        }

        public UnaryCallSettings.Builder<ExportTaxonomiesRequest, ExportTaxonomiesResponse> exportTaxonomiesSettings() {
            return this.exportTaxonomiesSettings;
        }

        public PolicyTagManagerSerializationStubSettings build() throws IOException {
            return new PolicyTagManagerSerializationStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

