/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.datacatalog.v1beta1.CreateEntryGroupRequest;
import com.google.cloud.datacatalog.v1beta1.CreateEntryRequest;
import com.google.cloud.datacatalog.v1beta1.CreateTagRequest;
import com.google.cloud.datacatalog.v1beta1.CreateTagTemplateFieldRequest;
import com.google.cloud.datacatalog.v1beta1.CreateTagTemplateRequest;
import com.google.cloud.datacatalog.v1beta1.DataCatalogSettings;
import com.google.cloud.datacatalog.v1beta1.DeleteEntryGroupRequest;
import com.google.cloud.datacatalog.v1beta1.DeleteEntryRequest;
import com.google.cloud.datacatalog.v1beta1.DeleteTagRequest;
import com.google.cloud.datacatalog.v1beta1.DeleteTagTemplateFieldRequest;
import com.google.cloud.datacatalog.v1beta1.DeleteTagTemplateRequest;
import com.google.cloud.datacatalog.v1beta1.Entry;
import com.google.cloud.datacatalog.v1beta1.EntryGroup;
import com.google.cloud.datacatalog.v1beta1.GetEntryGroupRequest;
import com.google.cloud.datacatalog.v1beta1.GetEntryRequest;
import com.google.cloud.datacatalog.v1beta1.GetTagTemplateRequest;
import com.google.cloud.datacatalog.v1beta1.ListTagsRequest;
import com.google.cloud.datacatalog.v1beta1.ListTagsResponse;
import com.google.cloud.datacatalog.v1beta1.LookupEntryRequest;
import com.google.cloud.datacatalog.v1beta1.RenameTagTemplateFieldRequest;
import com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest;
import com.google.cloud.datacatalog.v1beta1.SearchCatalogResponse;
import com.google.cloud.datacatalog.v1beta1.SearchCatalogResult;
import com.google.cloud.datacatalog.v1beta1.Tag;
import com.google.cloud.datacatalog.v1beta1.TagTemplate;
import com.google.cloud.datacatalog.v1beta1.TagTemplateField;
import com.google.cloud.datacatalog.v1beta1.UpdateEntryRequest;
import com.google.cloud.datacatalog.v1beta1.UpdateTagRequest;
import com.google.cloud.datacatalog.v1beta1.UpdateTagTemplateFieldRequest;
import com.google.cloud.datacatalog.v1beta1.UpdateTagTemplateRequest;
import com.google.cloud.datacatalog.v1beta1.stub.DataCatalogStub;
import com.google.cloud.datacatalog.v1beta1.stub.DataCatalogStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DataCatalogClient
implements BackgroundResource {
    private final DataCatalogSettings settings;
    private final DataCatalogStub stub;
    private static final PathTemplate ENTRY_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}");
    private static final PathTemplate ENTRY_GROUP_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/entryGroups/{entry_group}");
    private static final PathTemplate FIELD_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/tagTemplates/{tag_template}/fields/{field}");
    private static final PathTemplate LOCATION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}");
    private static final PathTemplate TAG_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}/tags/{tag}");
    private static final PathTemplate TAG_TEMPLATE_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/tagTemplates/{tag_template}");

    @Deprecated
    public static final String formatEntryName(String project, String location, String entryGroup, String entry) {
        return ENTRY_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "entry_group", entryGroup, "entry", entry});
    }

    @Deprecated
    public static final String formatEntryGroupName(String project, String location, String entryGroup) {
        return ENTRY_GROUP_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "entry_group", entryGroup});
    }

    @Deprecated
    public static final String formatFieldName(String project, String location, String tagTemplate, String field) {
        return FIELD_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "tag_template", tagTemplate, "field", field});
    }

    @Deprecated
    public static final String formatLocationName(String project, String location) {
        return LOCATION_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location});
    }

    @Deprecated
    public static final String formatTagName(String project, String location, String entryGroup, String entry, String tag) {
        return TAG_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "entry_group", entryGroup, "entry", entry, "tag", tag});
    }

    @Deprecated
    public static final String formatTagTemplateName(String project, String location, String tagTemplate) {
        return TAG_TEMPLATE_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "tag_template", tagTemplate});
    }

    @Deprecated
    public static final String parseProjectFromEntryName(String entryName) {
        return ENTRY_PATH_TEMPLATE.parse(entryName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromEntryName(String entryName) {
        return ENTRY_PATH_TEMPLATE.parse(entryName).get((Object)"location");
    }

    @Deprecated
    public static final String parseEntryGroupFromEntryName(String entryName) {
        return ENTRY_PATH_TEMPLATE.parse(entryName).get((Object)"entry_group");
    }

    @Deprecated
    public static final String parseEntryFromEntryName(String entryName) {
        return ENTRY_PATH_TEMPLATE.parse(entryName).get((Object)"entry");
    }

    @Deprecated
    public static final String parseProjectFromEntryGroupName(String entryGroupName) {
        return ENTRY_GROUP_PATH_TEMPLATE.parse(entryGroupName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromEntryGroupName(String entryGroupName) {
        return ENTRY_GROUP_PATH_TEMPLATE.parse(entryGroupName).get((Object)"location");
    }

    @Deprecated
    public static final String parseEntryGroupFromEntryGroupName(String entryGroupName) {
        return ENTRY_GROUP_PATH_TEMPLATE.parse(entryGroupName).get((Object)"entry_group");
    }

    @Deprecated
    public static final String parseProjectFromFieldName(String fieldName) {
        return FIELD_PATH_TEMPLATE.parse(fieldName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromFieldName(String fieldName) {
        return FIELD_PATH_TEMPLATE.parse(fieldName).get((Object)"location");
    }

    @Deprecated
    public static final String parseTagTemplateFromFieldName(String fieldName) {
        return FIELD_PATH_TEMPLATE.parse(fieldName).get((Object)"tag_template");
    }

    @Deprecated
    public static final String parseFieldFromFieldName(String fieldName) {
        return FIELD_PATH_TEMPLATE.parse(fieldName).get((Object)"field");
    }

    @Deprecated
    public static final String parseProjectFromLocationName(String locationName) {
        return LOCATION_PATH_TEMPLATE.parse(locationName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromLocationName(String locationName) {
        return LOCATION_PATH_TEMPLATE.parse(locationName).get((Object)"location");
    }

    @Deprecated
    public static final String parseProjectFromTagName(String tagName) {
        return TAG_PATH_TEMPLATE.parse(tagName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromTagName(String tagName) {
        return TAG_PATH_TEMPLATE.parse(tagName).get((Object)"location");
    }

    @Deprecated
    public static final String parseEntryGroupFromTagName(String tagName) {
        return TAG_PATH_TEMPLATE.parse(tagName).get((Object)"entry_group");
    }

    @Deprecated
    public static final String parseEntryFromTagName(String tagName) {
        return TAG_PATH_TEMPLATE.parse(tagName).get((Object)"entry");
    }

    @Deprecated
    public static final String parseTagFromTagName(String tagName) {
        return TAG_PATH_TEMPLATE.parse(tagName).get((Object)"tag");
    }

    @Deprecated
    public static final String parseProjectFromTagTemplateName(String tagTemplateName) {
        return TAG_TEMPLATE_PATH_TEMPLATE.parse(tagTemplateName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromTagTemplateName(String tagTemplateName) {
        return TAG_TEMPLATE_PATH_TEMPLATE.parse(tagTemplateName).get((Object)"location");
    }

    @Deprecated
    public static final String parseTagTemplateFromTagTemplateName(String tagTemplateName) {
        return TAG_TEMPLATE_PATH_TEMPLATE.parse(tagTemplateName).get((Object)"tag_template");
    }

    public static final DataCatalogClient create() throws IOException {
        return DataCatalogClient.create(DataCatalogSettings.newBuilder().build());
    }

    public static final DataCatalogClient create(DataCatalogSettings settings) throws IOException {
        return new DataCatalogClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DataCatalogClient create(DataCatalogStub stub) {
        return new DataCatalogClient(stub);
    }

    protected DataCatalogClient(DataCatalogSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataCatalogStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DataCatalogClient(DataCatalogStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DataCatalogSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DataCatalogStub getStub() {
        return this.stub;
    }

    public final SearchCatalogPagedResponse searchCatalog(SearchCatalogRequest.Scope scope, String query, String orderBy) {
        SearchCatalogRequest request = SearchCatalogRequest.newBuilder().setScope(scope).setQuery(query).setOrderBy(orderBy).build();
        return this.searchCatalog(request);
    }

    public final SearchCatalogPagedResponse searchCatalog(SearchCatalogRequest request) {
        return (SearchCatalogPagedResponse)((Object)this.searchCatalogPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchCatalogRequest, SearchCatalogPagedResponse> searchCatalogPagedCallable() {
        return this.stub.searchCatalogPagedCallable();
    }

    public final UnaryCallable<SearchCatalogRequest, SearchCatalogResponse> searchCatalogCallable() {
        return this.stub.searchCatalogCallable();
    }

    public final EntryGroup createEntryGroup(String parent, String entryGroupId, EntryGroup entryGroup) {
        LOCATION_PATH_TEMPLATE.validate(parent, "createEntryGroup");
        CreateEntryGroupRequest request = CreateEntryGroupRequest.newBuilder().setParent(parent).setEntryGroupId(entryGroupId).setEntryGroup(entryGroup).build();
        return this.createEntryGroup(request);
    }

    public final EntryGroup createEntryGroup(CreateEntryGroupRequest request) {
        return (EntryGroup)this.createEntryGroupCallable().call((Object)request);
    }

    public final UnaryCallable<CreateEntryGroupRequest, EntryGroup> createEntryGroupCallable() {
        return this.stub.createEntryGroupCallable();
    }

    public final EntryGroup getEntryGroup(String name, FieldMask readMask) {
        ENTRY_GROUP_PATH_TEMPLATE.validate(name, "getEntryGroup");
        GetEntryGroupRequest request = GetEntryGroupRequest.newBuilder().setName(name).setReadMask(readMask).build();
        return this.getEntryGroup(request);
    }

    public final EntryGroup getEntryGroup(GetEntryGroupRequest request) {
        return (EntryGroup)this.getEntryGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetEntryGroupRequest, EntryGroup> getEntryGroupCallable() {
        return this.stub.getEntryGroupCallable();
    }

    public final void deleteEntryGroup(String name) {
        ENTRY_GROUP_PATH_TEMPLATE.validate(name, "deleteEntryGroup");
        DeleteEntryGroupRequest request = DeleteEntryGroupRequest.newBuilder().setName(name).build();
        this.deleteEntryGroup(request);
    }

    public final void deleteEntryGroup(DeleteEntryGroupRequest request) {
        this.deleteEntryGroupCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEntryGroupRequest, Empty> deleteEntryGroupCallable() {
        return this.stub.deleteEntryGroupCallable();
    }

    public final Entry createEntry(String parent, String entryId, Entry entry) {
        ENTRY_GROUP_PATH_TEMPLATE.validate(parent, "createEntry");
        CreateEntryRequest request = CreateEntryRequest.newBuilder().setParent(parent).setEntryId(entryId).setEntry(entry).build();
        return this.createEntry(request);
    }

    public final Entry createEntry(CreateEntryRequest request) {
        return (Entry)this.createEntryCallable().call((Object)request);
    }

    public final UnaryCallable<CreateEntryRequest, Entry> createEntryCallable() {
        return this.stub.createEntryCallable();
    }

    public final Entry updateEntry(Entry entry, FieldMask updateMask) {
        UpdateEntryRequest request = UpdateEntryRequest.newBuilder().setEntry(entry).setUpdateMask(updateMask).build();
        return this.updateEntry(request);
    }

    public final Entry updateEntry(UpdateEntryRequest request) {
        return (Entry)this.updateEntryCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEntryRequest, Entry> updateEntryCallable() {
        return this.stub.updateEntryCallable();
    }

    public final void deleteEntry(String name) {
        ENTRY_PATH_TEMPLATE.validate(name, "deleteEntry");
        DeleteEntryRequest request = DeleteEntryRequest.newBuilder().setName(name).build();
        this.deleteEntry(request);
    }

    public final void deleteEntry(DeleteEntryRequest request) {
        this.deleteEntryCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEntryRequest, Empty> deleteEntryCallable() {
        return this.stub.deleteEntryCallable();
    }

    public final Entry getEntry(String name) {
        ENTRY_PATH_TEMPLATE.validate(name, "getEntry");
        GetEntryRequest request = GetEntryRequest.newBuilder().setName(name).build();
        return this.getEntry(request);
    }

    public final Entry getEntry(GetEntryRequest request) {
        return (Entry)this.getEntryCallable().call((Object)request);
    }

    public final UnaryCallable<GetEntryRequest, Entry> getEntryCallable() {
        return this.stub.getEntryCallable();
    }

    public final Entry lookupEntry(LookupEntryRequest request) {
        return (Entry)this.lookupEntryCallable().call((Object)request);
    }

    public final UnaryCallable<LookupEntryRequest, Entry> lookupEntryCallable() {
        return this.stub.lookupEntryCallable();
    }

    public final TagTemplate createTagTemplate(String parent, String tagTemplateId, TagTemplate tagTemplate) {
        LOCATION_PATH_TEMPLATE.validate(parent, "createTagTemplate");
        CreateTagTemplateRequest request = CreateTagTemplateRequest.newBuilder().setParent(parent).setTagTemplateId(tagTemplateId).setTagTemplate(tagTemplate).build();
        return this.createTagTemplate(request);
    }

    public final TagTemplate createTagTemplate(CreateTagTemplateRequest request) {
        return (TagTemplate)this.createTagTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTagTemplateRequest, TagTemplate> createTagTemplateCallable() {
        return this.stub.createTagTemplateCallable();
    }

    public final TagTemplate getTagTemplate(String name) {
        TAG_TEMPLATE_PATH_TEMPLATE.validate(name, "getTagTemplate");
        GetTagTemplateRequest request = GetTagTemplateRequest.newBuilder().setName(name).build();
        return this.getTagTemplate(request);
    }

    public final TagTemplate getTagTemplate(GetTagTemplateRequest request) {
        return (TagTemplate)this.getTagTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<GetTagTemplateRequest, TagTemplate> getTagTemplateCallable() {
        return this.stub.getTagTemplateCallable();
    }

    public final TagTemplate updateTagTemplate(TagTemplate tagTemplate, FieldMask updateMask) {
        UpdateTagTemplateRequest request = UpdateTagTemplateRequest.newBuilder().setTagTemplate(tagTemplate).setUpdateMask(updateMask).build();
        return this.updateTagTemplate(request);
    }

    public final TagTemplate updateTagTemplate(UpdateTagTemplateRequest request) {
        return (TagTemplate)this.updateTagTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTagTemplateRequest, TagTemplate> updateTagTemplateCallable() {
        return this.stub.updateTagTemplateCallable();
    }

    public final void deleteTagTemplate(String name, boolean force) {
        TAG_TEMPLATE_PATH_TEMPLATE.validate(name, "deleteTagTemplate");
        DeleteTagTemplateRequest request = DeleteTagTemplateRequest.newBuilder().setName(name).setForce(force).build();
        this.deleteTagTemplate(request);
    }

    public final void deleteTagTemplate(DeleteTagTemplateRequest request) {
        this.deleteTagTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTagTemplateRequest, Empty> deleteTagTemplateCallable() {
        return this.stub.deleteTagTemplateCallable();
    }

    public final TagTemplateField createTagTemplateField(String parent, String tagTemplateFieldId, TagTemplateField tagTemplateField) {
        TAG_TEMPLATE_PATH_TEMPLATE.validate(parent, "createTagTemplateField");
        CreateTagTemplateFieldRequest request = CreateTagTemplateFieldRequest.newBuilder().setParent(parent).setTagTemplateFieldId(tagTemplateFieldId).setTagTemplateField(tagTemplateField).build();
        return this.createTagTemplateField(request);
    }

    public final TagTemplateField createTagTemplateField(CreateTagTemplateFieldRequest request) {
        return (TagTemplateField)this.createTagTemplateFieldCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTagTemplateFieldRequest, TagTemplateField> createTagTemplateFieldCallable() {
        return this.stub.createTagTemplateFieldCallable();
    }

    public final TagTemplateField updateTagTemplateField(String name, TagTemplateField tagTemplateField, FieldMask updateMask) {
        FIELD_PATH_TEMPLATE.validate(name, "updateTagTemplateField");
        UpdateTagTemplateFieldRequest request = UpdateTagTemplateFieldRequest.newBuilder().setName(name).setTagTemplateField(tagTemplateField).setUpdateMask(updateMask).build();
        return this.updateTagTemplateField(request);
    }

    public final TagTemplateField updateTagTemplateField(UpdateTagTemplateFieldRequest request) {
        return (TagTemplateField)this.updateTagTemplateFieldCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTagTemplateFieldRequest, TagTemplateField> updateTagTemplateFieldCallable() {
        return this.stub.updateTagTemplateFieldCallable();
    }

    public final TagTemplateField renameTagTemplateField(String name, String newTagTemplateFieldId) {
        FIELD_PATH_TEMPLATE.validate(name, "renameTagTemplateField");
        RenameTagTemplateFieldRequest request = RenameTagTemplateFieldRequest.newBuilder().setName(name).setNewTagTemplateFieldId(newTagTemplateFieldId).build();
        return this.renameTagTemplateField(request);
    }

    public final TagTemplateField renameTagTemplateField(RenameTagTemplateFieldRequest request) {
        return (TagTemplateField)this.renameTagTemplateFieldCallable().call((Object)request);
    }

    public final UnaryCallable<RenameTagTemplateFieldRequest, TagTemplateField> renameTagTemplateFieldCallable() {
        return this.stub.renameTagTemplateFieldCallable();
    }

    public final void deleteTagTemplateField(String name, boolean force) {
        FIELD_PATH_TEMPLATE.validate(name, "deleteTagTemplateField");
        DeleteTagTemplateFieldRequest request = DeleteTagTemplateFieldRequest.newBuilder().setName(name).setForce(force).build();
        this.deleteTagTemplateField(request);
    }

    public final void deleteTagTemplateField(DeleteTagTemplateFieldRequest request) {
        this.deleteTagTemplateFieldCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTagTemplateFieldRequest, Empty> deleteTagTemplateFieldCallable() {
        return this.stub.deleteTagTemplateFieldCallable();
    }

    public final Tag createTag(String parent, Tag tag) {
        ENTRY_PATH_TEMPLATE.validate(parent, "createTag");
        CreateTagRequest request = CreateTagRequest.newBuilder().setParent(parent).setTag(tag).build();
        return this.createTag(request);
    }

    public final Tag createTag(CreateTagRequest request) {
        return (Tag)this.createTagCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTagRequest, Tag> createTagCallable() {
        return this.stub.createTagCallable();
    }

    public final Tag updateTag(Tag tag, FieldMask updateMask) {
        UpdateTagRequest request = UpdateTagRequest.newBuilder().setTag(tag).setUpdateMask(updateMask).build();
        return this.updateTag(request);
    }

    public final Tag updateTag(UpdateTagRequest request) {
        return (Tag)this.updateTagCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTagRequest, Tag> updateTagCallable() {
        return this.stub.updateTagCallable();
    }

    public final void deleteTag(String name) {
        TAG_PATH_TEMPLATE.validate(name, "deleteTag");
        DeleteTagRequest request = DeleteTagRequest.newBuilder().setName(name).build();
        this.deleteTag(request);
    }

    public final void deleteTag(DeleteTagRequest request) {
        this.deleteTagCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTagRequest, Empty> deleteTagCallable() {
        return this.stub.deleteTagCallable();
    }

    public final ListTagsPagedResponse listTags(String parent) {
        ENTRY_PATH_TEMPLATE.validate(parent, "listTags");
        ListTagsRequest request = ListTagsRequest.newBuilder().setParent(parent).build();
        return this.listTags(request);
    }

    public final ListTagsPagedResponse listTags(ListTagsRequest request) {
        return (ListTagsPagedResponse)((Object)this.listTagsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTagsRequest, ListTagsPagedResponse> listTagsPagedCallable() {
        return this.stub.listTagsPagedCallable();
    }

    public final UnaryCallable<ListTagsRequest, ListTagsResponse> listTagsCallable() {
        return this.stub.listTagsCallable();
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        TAG_TEMPLATE_PATH_TEMPLATE.validate(resource, "setIamPolicy");
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(String resource) {
        TAG_TEMPLATE_PATH_TEMPLATE.validate(resource, "getIamPolicy");
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TAG_TEMPLATE_PATH_TEMPLATE.validate(resource, "testIamPermissions");
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTagsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTagsRequest, ListTagsResponse, Tag, ListTagsPage, ListTagsFixedSizeCollection> {
        private ListTagsFixedSizeCollection(List<ListTagsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTagsFixedSizeCollection createEmptyCollection() {
            return new ListTagsFixedSizeCollection(null, 0);
        }

        protected ListTagsFixedSizeCollection createCollection(List<ListTagsPage> pages, int collectionSize) {
            return new ListTagsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTagsPage
    extends AbstractPage<ListTagsRequest, ListTagsResponse, Tag, ListTagsPage> {
        private ListTagsPage(PageContext<ListTagsRequest, ListTagsResponse, Tag> context, ListTagsResponse response) {
            super(context, (Object)response);
        }

        private static ListTagsPage createEmptyPage() {
            return new ListTagsPage(null, null);
        }

        protected ListTagsPage createPage(PageContext<ListTagsRequest, ListTagsResponse, Tag> context, ListTagsResponse response) {
            return new ListTagsPage(context, response);
        }

        public ApiFuture<ListTagsPage> createPageAsync(PageContext<ListTagsRequest, ListTagsResponse, Tag> context, ApiFuture<ListTagsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTagsPagedResponse
    extends AbstractPagedListResponse<ListTagsRequest, ListTagsResponse, Tag, ListTagsPage, ListTagsFixedSizeCollection> {
        public static ApiFuture<ListTagsPagedResponse> createAsync(PageContext<ListTagsRequest, ListTagsResponse, Tag> context, ApiFuture<ListTagsResponse> futureResponse) {
            ApiFuture<ListTagsPage> futurePage = ListTagsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTagsPage, ListTagsPagedResponse>(){

                public ListTagsPagedResponse apply(ListTagsPage input) {
                    return new ListTagsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTagsPagedResponse(ListTagsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTagsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchCatalogFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult, SearchCatalogPage, SearchCatalogFixedSizeCollection> {
        private SearchCatalogFixedSizeCollection(List<SearchCatalogPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchCatalogFixedSizeCollection createEmptyCollection() {
            return new SearchCatalogFixedSizeCollection(null, 0);
        }

        protected SearchCatalogFixedSizeCollection createCollection(List<SearchCatalogPage> pages, int collectionSize) {
            return new SearchCatalogFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchCatalogPage
    extends AbstractPage<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult, SearchCatalogPage> {
        private SearchCatalogPage(PageContext<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult> context, SearchCatalogResponse response) {
            super(context, (Object)response);
        }

        private static SearchCatalogPage createEmptyPage() {
            return new SearchCatalogPage(null, null);
        }

        protected SearchCatalogPage createPage(PageContext<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult> context, SearchCatalogResponse response) {
            return new SearchCatalogPage(context, response);
        }

        public ApiFuture<SearchCatalogPage> createPageAsync(PageContext<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult> context, ApiFuture<SearchCatalogResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchCatalogPagedResponse
    extends AbstractPagedListResponse<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult, SearchCatalogPage, SearchCatalogFixedSizeCollection> {
        public static ApiFuture<SearchCatalogPagedResponse> createAsync(PageContext<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult> context, ApiFuture<SearchCatalogResponse> futureResponse) {
            ApiFuture<SearchCatalogPage> futurePage = SearchCatalogPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<SearchCatalogPage, SearchCatalogPagedResponse>(){

                public SearchCatalogPagedResponse apply(SearchCatalogPage input) {
                    return new SearchCatalogPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private SearchCatalogPagedResponse(SearchCatalogPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchCatalogFixedSizeCollection.createEmptyCollection());
        }
    }
}

