/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.databasecenter.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.databasecenter.v1beta.DatabaseCenterClient;
import com.google.cloud.databasecenter.v1beta.Product;
import com.google.cloud.databasecenter.v1beta.QueryProductsRequest;
import com.google.cloud.databasecenter.v1beta.QueryProductsResponse;
import com.google.cloud.databasecenter.v1beta.stub.DatabaseCenterStub;
import com.google.cloud.databasecenter.v1beta.stub.GrpcDatabaseCenterStub;
import com.google.cloud.databasecenter.v1beta.stub.HttpJsonDatabaseCenterStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class DatabaseCenterStubSettings
extends StubSettings<DatabaseCenterStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<QueryProductsRequest, QueryProductsResponse, DatabaseCenterClient.QueryProductsPagedResponse> queryProductsSettings;
    private static final PagedListDescriptor<QueryProductsRequest, QueryProductsResponse, Product> QUERY_PRODUCTS_PAGE_STR_DESC = new PagedListDescriptor<QueryProductsRequest, QueryProductsResponse, Product>(){

        public String emptyToken() {
            return "";
        }

        public QueryProductsRequest injectToken(QueryProductsRequest payload, String token) {
            return QueryProductsRequest.newBuilder((QueryProductsRequest)payload).setPageToken(token).build();
        }

        public QueryProductsRequest injectPageSize(QueryProductsRequest payload, int pageSize) {
            return QueryProductsRequest.newBuilder((QueryProductsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(QueryProductsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(QueryProductsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Product> extractResources(QueryProductsResponse payload) {
            return payload.getProductsList();
        }
    };
    private static final PagedListResponseFactory<QueryProductsRequest, QueryProductsResponse, DatabaseCenterClient.QueryProductsPagedResponse> QUERY_PRODUCTS_PAGE_STR_FACT = new PagedListResponseFactory<QueryProductsRequest, QueryProductsResponse, DatabaseCenterClient.QueryProductsPagedResponse>(){

        public ApiFuture<DatabaseCenterClient.QueryProductsPagedResponse> getFuturePagedResponse(UnaryCallable<QueryProductsRequest, QueryProductsResponse> callable, QueryProductsRequest request, ApiCallContext context, ApiFuture<QueryProductsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)QUERY_PRODUCTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatabaseCenterClient.QueryProductsPagedResponse.createAsync((PageContext<QueryProductsRequest, QueryProductsResponse, Product>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<QueryProductsRequest, QueryProductsResponse, DatabaseCenterClient.QueryProductsPagedResponse> queryProductsSettings() {
        return this.queryProductsSettings;
    }

    public DatabaseCenterStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDatabaseCenterStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDatabaseCenterStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "databasecenter";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "databasecenter.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "databasecenter.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DatabaseCenterStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DatabaseCenterStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DatabaseCenterStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DatabaseCenterStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DatabaseCenterStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.queryProductsSettings = settingsBuilder.queryProductsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DatabaseCenterStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<QueryProductsRequest, QueryProductsResponse, DatabaseCenterClient.QueryProductsPagedResponse> queryProductsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.queryProductsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)QUERY_PRODUCTS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.queryProductsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DatabaseCenterStubSettings settings) {
            super((StubSettings)settings);
            this.queryProductsSettings = settings.queryProductsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.queryProductsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DatabaseCenterStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DatabaseCenterStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DatabaseCenterStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DatabaseCenterStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DatabaseCenterStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DatabaseCenterStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DatabaseCenterStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DatabaseCenterStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.queryProductsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<QueryProductsRequest, QueryProductsResponse, DatabaseCenterClient.QueryProductsPagedResponse> queryProductsSettings() {
            return this.queryProductsSettings;
        }

        public DatabaseCenterStubSettings build() throws IOException {
            return new DatabaseCenterStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

