/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.databasecenter.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.databasecenter.v1beta.DatabaseCenterSettings;
import com.google.cloud.databasecenter.v1beta.Product;
import com.google.cloud.databasecenter.v1beta.QueryProductsRequest;
import com.google.cloud.databasecenter.v1beta.QueryProductsResponse;
import com.google.cloud.databasecenter.v1beta.stub.DatabaseCenterStub;
import com.google.cloud.databasecenter.v1beta.stub.DatabaseCenterStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DatabaseCenterClient
implements BackgroundResource {
    private final DatabaseCenterSettings settings;
    private final DatabaseCenterStub stub;

    public static final DatabaseCenterClient create() throws IOException {
        return DatabaseCenterClient.create(DatabaseCenterSettings.newBuilder().build());
    }

    public static final DatabaseCenterClient create(DatabaseCenterSettings settings) throws IOException {
        return new DatabaseCenterClient(settings);
    }

    public static final DatabaseCenterClient create(DatabaseCenterStub stub) {
        return new DatabaseCenterClient(stub);
    }

    protected DatabaseCenterClient(DatabaseCenterSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DatabaseCenterStubSettings)settings.getStubSettings()).createStub();
    }

    protected DatabaseCenterClient(DatabaseCenterStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DatabaseCenterSettings getSettings() {
        return this.settings;
    }

    public DatabaseCenterStub getStub() {
        return this.stub;
    }

    public final QueryProductsPagedResponse queryProducts(QueryProductsRequest request) {
        return (QueryProductsPagedResponse)((Object)this.queryProductsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<QueryProductsRequest, QueryProductsPagedResponse> queryProductsPagedCallable() {
        return this.stub.queryProductsPagedCallable();
    }

    public final UnaryCallable<QueryProductsRequest, QueryProductsResponse> queryProductsCallable() {
        return this.stub.queryProductsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class QueryProductsFixedSizeCollection
    extends AbstractFixedSizeCollection<QueryProductsRequest, QueryProductsResponse, Product, QueryProductsPage, QueryProductsFixedSizeCollection> {
        private QueryProductsFixedSizeCollection(List<QueryProductsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static QueryProductsFixedSizeCollection createEmptyCollection() {
            return new QueryProductsFixedSizeCollection(null, 0);
        }

        protected QueryProductsFixedSizeCollection createCollection(List<QueryProductsPage> pages, int collectionSize) {
            return new QueryProductsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class QueryProductsPage
    extends AbstractPage<QueryProductsRequest, QueryProductsResponse, Product, QueryProductsPage> {
        private QueryProductsPage(PageContext<QueryProductsRequest, QueryProductsResponse, Product> context, QueryProductsResponse response) {
            super(context, (Object)response);
        }

        private static QueryProductsPage createEmptyPage() {
            return new QueryProductsPage(null, null);
        }

        protected QueryProductsPage createPage(PageContext<QueryProductsRequest, QueryProductsResponse, Product> context, QueryProductsResponse response) {
            return new QueryProductsPage(context, response);
        }

        public ApiFuture<QueryProductsPage> createPageAsync(PageContext<QueryProductsRequest, QueryProductsResponse, Product> context, ApiFuture<QueryProductsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class QueryProductsPagedResponse
    extends AbstractPagedListResponse<QueryProductsRequest, QueryProductsResponse, Product, QueryProductsPage, QueryProductsFixedSizeCollection> {
        public static ApiFuture<QueryProductsPagedResponse> createAsync(PageContext<QueryProductsRequest, QueryProductsResponse, Product> context, ApiFuture<QueryProductsResponse> futureResponse) {
            ApiFuture<QueryProductsPage> futurePage = QueryProductsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new QueryProductsPagedResponse((QueryProductsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private QueryProductsPagedResponse(QueryProductsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)QueryProductsFixedSizeCollection.createEmptyCollection());
        }
    }
}

