/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateDocumentLinkRequest;
import com.google.cloud.contentwarehouse.v1.DeleteDocumentLinkRequest;
import com.google.cloud.contentwarehouse.v1.DocumentLink;
import com.google.cloud.contentwarehouse.v1.DocumentLinkServiceClient;
import com.google.cloud.contentwarehouse.v1.ListLinkedSourcesRequest;
import com.google.cloud.contentwarehouse.v1.ListLinkedSourcesResponse;
import com.google.cloud.contentwarehouse.v1.ListLinkedTargetsRequest;
import com.google.cloud.contentwarehouse.v1.ListLinkedTargetsResponse;
import com.google.cloud.contentwarehouse.v1.stub.DocumentLinkServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.GrpcDocumentLinkServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.HttpJsonDocumentLinkServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class DocumentLinkServiceStubSettings
extends StubSettings<DocumentLinkServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ListLinkedTargetsRequest, ListLinkedTargetsResponse> listLinkedTargetsSettings;
    private final PagedCallSettings<ListLinkedSourcesRequest, ListLinkedSourcesResponse, DocumentLinkServiceClient.ListLinkedSourcesPagedResponse> listLinkedSourcesSettings;
    private final UnaryCallSettings<CreateDocumentLinkRequest, DocumentLink> createDocumentLinkSettings;
    private final UnaryCallSettings<DeleteDocumentLinkRequest, Empty> deleteDocumentLinkSettings;
    private static final PagedListDescriptor<ListLinkedSourcesRequest, ListLinkedSourcesResponse, DocumentLink> LIST_LINKED_SOURCES_PAGE_STR_DESC = new PagedListDescriptor<ListLinkedSourcesRequest, ListLinkedSourcesResponse, DocumentLink>(){

        public String emptyToken() {
            return "";
        }

        public ListLinkedSourcesRequest injectToken(ListLinkedSourcesRequest payload, String token) {
            return ListLinkedSourcesRequest.newBuilder((ListLinkedSourcesRequest)payload).setPageToken(token).build();
        }

        public ListLinkedSourcesRequest injectPageSize(ListLinkedSourcesRequest payload, int pageSize) {
            return ListLinkedSourcesRequest.newBuilder((ListLinkedSourcesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLinkedSourcesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLinkedSourcesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DocumentLink> extractResources(ListLinkedSourcesResponse payload) {
            return payload.getDocumentLinksList() == null ? ImmutableList.of() : payload.getDocumentLinksList();
        }
    };
    private static final PagedListResponseFactory<ListLinkedSourcesRequest, ListLinkedSourcesResponse, DocumentLinkServiceClient.ListLinkedSourcesPagedResponse> LIST_LINKED_SOURCES_PAGE_STR_FACT = new PagedListResponseFactory<ListLinkedSourcesRequest, ListLinkedSourcesResponse, DocumentLinkServiceClient.ListLinkedSourcesPagedResponse>(){

        public ApiFuture<DocumentLinkServiceClient.ListLinkedSourcesPagedResponse> getFuturePagedResponse(UnaryCallable<ListLinkedSourcesRequest, ListLinkedSourcesResponse> callable, ListLinkedSourcesRequest request, ApiCallContext context, ApiFuture<ListLinkedSourcesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LINKED_SOURCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DocumentLinkServiceClient.ListLinkedSourcesPagedResponse.createAsync((PageContext<ListLinkedSourcesRequest, ListLinkedSourcesResponse, DocumentLink>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<ListLinkedTargetsRequest, ListLinkedTargetsResponse> listLinkedTargetsSettings() {
        return this.listLinkedTargetsSettings;
    }

    public PagedCallSettings<ListLinkedSourcesRequest, ListLinkedSourcesResponse, DocumentLinkServiceClient.ListLinkedSourcesPagedResponse> listLinkedSourcesSettings() {
        return this.listLinkedSourcesSettings;
    }

    public UnaryCallSettings<CreateDocumentLinkRequest, DocumentLink> createDocumentLinkSettings() {
        return this.createDocumentLinkSettings;
    }

    public UnaryCallSettings<DeleteDocumentLinkRequest, Empty> deleteDocumentLinkSettings() {
        return this.deleteDocumentLinkSettings;
    }

    public DocumentLinkServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDocumentLinkServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDocumentLinkServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "contentwarehouse.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "contentwarehouse.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DocumentLinkServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DocumentLinkServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DocumentLinkServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DocumentLinkServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DocumentLinkServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listLinkedTargetsSettings = settingsBuilder.listLinkedTargetsSettings().build();
        this.listLinkedSourcesSettings = settingsBuilder.listLinkedSourcesSettings().build();
        this.createDocumentLinkSettings = settingsBuilder.createDocumentLinkSettings().build();
        this.deleteDocumentLinkSettings = settingsBuilder.deleteDocumentLinkSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DocumentLinkServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ListLinkedTargetsRequest, ListLinkedTargetsResponse> listLinkedTargetsSettings;
        private final PagedCallSettings.Builder<ListLinkedSourcesRequest, ListLinkedSourcesResponse, DocumentLinkServiceClient.ListLinkedSourcesPagedResponse> listLinkedSourcesSettings;
        private final UnaryCallSettings.Builder<CreateDocumentLinkRequest, DocumentLink> createDocumentLinkSettings;
        private final UnaryCallSettings.Builder<DeleteDocumentLinkRequest, Empty> deleteDocumentLinkSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listLinkedTargetsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLinkedSourcesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LINKED_SOURCES_PAGE_STR_FACT);
            this.createDocumentLinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDocumentLinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listLinkedTargetsSettings, this.listLinkedSourcesSettings, this.createDocumentLinkSettings, this.deleteDocumentLinkSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DocumentLinkServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listLinkedTargetsSettings = settings.listLinkedTargetsSettings.toBuilder();
            this.listLinkedSourcesSettings = settings.listLinkedSourcesSettings.toBuilder();
            this.createDocumentLinkSettings = settings.createDocumentLinkSettings.toBuilder();
            this.deleteDocumentLinkSettings = settings.deleteDocumentLinkSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listLinkedTargetsSettings, this.listLinkedSourcesSettings, this.createDocumentLinkSettings, this.deleteDocumentLinkSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DocumentLinkServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DocumentLinkServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DocumentLinkServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DocumentLinkServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DocumentLinkServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DocumentLinkServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DocumentLinkServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DocumentLinkServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DocumentLinkServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DocumentLinkServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listLinkedTargetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.listLinkedSourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.createDocumentLinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.deleteDocumentLinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ListLinkedTargetsRequest, ListLinkedTargetsResponse> listLinkedTargetsSettings() {
            return this.listLinkedTargetsSettings;
        }

        public PagedCallSettings.Builder<ListLinkedSourcesRequest, ListLinkedSourcesResponse, DocumentLinkServiceClient.ListLinkedSourcesPagedResponse> listLinkedSourcesSettings() {
            return this.listLinkedSourcesSettings;
        }

        public UnaryCallSettings.Builder<CreateDocumentLinkRequest, DocumentLink> createDocumentLinkSettings() {
            return this.createDocumentLinkSettings;
        }

        public UnaryCallSettings.Builder<DeleteDocumentLinkRequest, Empty> deleteDocumentLinkSettings() {
            return this.deleteDocumentLinkSettings;
        }

        public DocumentLinkServiceStubSettings build() throws IOException {
            return new DocumentLinkServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)180000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)180000L)).setTotalTimeout(Duration.ofMillis((long)180000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

