/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.RunPipelineMetadata;
import com.google.cloud.contentwarehouse.v1.RunPipelineRequest;
import com.google.cloud.contentwarehouse.v1.RunPipelineResponse;
import com.google.cloud.contentwarehouse.v1.stub.HttpJsonPipelineServiceCallableFactory;
import com.google.cloud.contentwarehouse.v1.stub.PipelineServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.PipelineServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonPipelineServiceStub
extends PipelineServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(RunPipelineResponse.getDescriptor()).add(RunPipelineMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<RunPipelineRequest, Operation> runPipelineMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.PipelineService/RunPipeline").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*}:runPipeline", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<RunPipelineRequest, Operation> runPipelineCallable;
    private final OperationCallable<RunPipelineRequest, RunPipelineResponse, RunPipelineMetadata> runPipelineOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonPipelineServiceStub create(PipelineServiceStubSettings settings) throws IOException {
        return new HttpJsonPipelineServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonPipelineServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonPipelineServiceStub(PipelineServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonPipelineServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonPipelineServiceStub(PipelineServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonPipelineServiceStub(PipelineServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonPipelineServiceCallableFactory());
    }

    protected HttpJsonPipelineServiceStub(PipelineServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).build());
        HttpJsonCallSettings runPipelineTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(runPipelineMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.runPipelineCallable = callableFactory.createUnaryCallable(runPipelineTransportSettings, settings.runPipelineSettings(), clientContext);
        this.runPipelineOperationCallable = callableFactory.createOperationCallable(runPipelineTransportSettings, settings.runPipelineOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(runPipelineMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<RunPipelineRequest, Operation> runPipelineCallable() {
        return this.runPipelineCallable;
    }

    @Override
    public OperationCallable<RunPipelineRequest, RunPipelineResponse, RunPipelineMetadata> runPipelineOperationCallable() {
        return this.runPipelineOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

