/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateDocumentRequest;
import com.google.cloud.contentwarehouse.v1.CreateDocumentResponse;
import com.google.cloud.contentwarehouse.v1.DeleteDocumentRequest;
import com.google.cloud.contentwarehouse.v1.Document;
import com.google.cloud.contentwarehouse.v1.DocumentName;
import com.google.cloud.contentwarehouse.v1.DocumentServiceSettings;
import com.google.cloud.contentwarehouse.v1.FetchAclRequest;
import com.google.cloud.contentwarehouse.v1.FetchAclResponse;
import com.google.cloud.contentwarehouse.v1.GetDocumentRequest;
import com.google.cloud.contentwarehouse.v1.LocationName;
import com.google.cloud.contentwarehouse.v1.SearchDocumentsRequest;
import com.google.cloud.contentwarehouse.v1.SearchDocumentsResponse;
import com.google.cloud.contentwarehouse.v1.SetAclRequest;
import com.google.cloud.contentwarehouse.v1.SetAclResponse;
import com.google.cloud.contentwarehouse.v1.UpdateDocumentRequest;
import com.google.cloud.contentwarehouse.v1.UpdateDocumentResponse;
import com.google.cloud.contentwarehouse.v1.stub.DocumentServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.DocumentServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.Policy;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DocumentServiceClient
implements BackgroundResource {
    private final DocumentServiceSettings settings;
    private final DocumentServiceStub stub;

    public static final DocumentServiceClient create() throws IOException {
        return DocumentServiceClient.create(DocumentServiceSettings.newBuilder().build());
    }

    public static final DocumentServiceClient create(DocumentServiceSettings settings) throws IOException {
        return new DocumentServiceClient(settings);
    }

    public static final DocumentServiceClient create(DocumentServiceStub stub) {
        return new DocumentServiceClient(stub);
    }

    protected DocumentServiceClient(DocumentServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DocumentServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DocumentServiceClient(DocumentServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DocumentServiceSettings getSettings() {
        return this.settings;
    }

    public DocumentServiceStub getStub() {
        return this.stub;
    }

    public final CreateDocumentResponse createDocument(LocationName parent, Document document) {
        CreateDocumentRequest request = CreateDocumentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDocument(document).build();
        return this.createDocument(request);
    }

    public final CreateDocumentResponse createDocument(String parent, Document document) {
        CreateDocumentRequest request = CreateDocumentRequest.newBuilder().setParent(parent).setDocument(document).build();
        return this.createDocument(request);
    }

    public final CreateDocumentResponse createDocument(CreateDocumentRequest request) {
        return (CreateDocumentResponse)this.createDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDocumentRequest, CreateDocumentResponse> createDocumentCallable() {
        return this.stub.createDocumentCallable();
    }

    public final Document getDocument(DocumentName name) {
        GetDocumentRequest request = GetDocumentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDocument(request);
    }

    public final Document getDocument(String name) {
        GetDocumentRequest request = GetDocumentRequest.newBuilder().setName(name).build();
        return this.getDocument(request);
    }

    public final Document getDocument(GetDocumentRequest request) {
        return (Document)this.getDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<GetDocumentRequest, Document> getDocumentCallable() {
        return this.stub.getDocumentCallable();
    }

    public final UpdateDocumentResponse updateDocument(DocumentName name, Document document) {
        UpdateDocumentRequest request = UpdateDocumentRequest.newBuilder().setName(name == null ? null : name.toString()).setDocument(document).build();
        return this.updateDocument(request);
    }

    public final UpdateDocumentResponse updateDocument(String name, Document document) {
        UpdateDocumentRequest request = UpdateDocumentRequest.newBuilder().setName(name).setDocument(document).build();
        return this.updateDocument(request);
    }

    public final UpdateDocumentResponse updateDocument(UpdateDocumentRequest request) {
        return (UpdateDocumentResponse)this.updateDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDocumentRequest, UpdateDocumentResponse> updateDocumentCallable() {
        return this.stub.updateDocumentCallable();
    }

    public final void deleteDocument(DocumentName name) {
        DeleteDocumentRequest request = DeleteDocumentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDocument(request);
    }

    public final void deleteDocument(String name) {
        DeleteDocumentRequest request = DeleteDocumentRequest.newBuilder().setName(name).build();
        this.deleteDocument(request);
    }

    public final void deleteDocument(DeleteDocumentRequest request) {
        this.deleteDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDocumentRequest, Empty> deleteDocumentCallable() {
        return this.stub.deleteDocumentCallable();
    }

    public final SearchDocumentsPagedResponse searchDocuments(LocationName parent) {
        SearchDocumentsRequest request = SearchDocumentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.searchDocuments(request);
    }

    public final SearchDocumentsPagedResponse searchDocuments(String parent) {
        SearchDocumentsRequest request = SearchDocumentsRequest.newBuilder().setParent(parent).build();
        return this.searchDocuments(request);
    }

    public final SearchDocumentsPagedResponse searchDocuments(SearchDocumentsRequest request) {
        return (SearchDocumentsPagedResponse)((Object)this.searchDocumentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchDocumentsRequest, SearchDocumentsPagedResponse> searchDocumentsPagedCallable() {
        return this.stub.searchDocumentsPagedCallable();
    }

    public final UnaryCallable<SearchDocumentsRequest, SearchDocumentsResponse> searchDocumentsCallable() {
        return this.stub.searchDocumentsCallable();
    }

    public final FetchAclResponse fetchAcl(String resource) {
        FetchAclRequest request = FetchAclRequest.newBuilder().setResource(resource).build();
        return this.fetchAcl(request);
    }

    public final FetchAclResponse fetchAcl(FetchAclRequest request) {
        return (FetchAclResponse)this.fetchAclCallable().call((Object)request);
    }

    public final UnaryCallable<FetchAclRequest, FetchAclResponse> fetchAclCallable() {
        return this.stub.fetchAclCallable();
    }

    public final SetAclResponse setAcl(String resource, Policy policy) {
        SetAclRequest request = SetAclRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setAcl(request);
    }

    public final SetAclResponse setAcl(SetAclRequest request) {
        return (SetAclResponse)this.setAclCallable().call((Object)request);
    }

    public final UnaryCallable<SetAclRequest, SetAclResponse> setAclCallable() {
        return this.stub.setAclCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchDocumentsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchDocumentsRequest, SearchDocumentsResponse, SearchDocumentsResponse.MatchingDocument, SearchDocumentsPage, SearchDocumentsFixedSizeCollection> {
        private SearchDocumentsFixedSizeCollection(List<SearchDocumentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchDocumentsFixedSizeCollection createEmptyCollection() {
            return new SearchDocumentsFixedSizeCollection(null, 0);
        }

        protected SearchDocumentsFixedSizeCollection createCollection(List<SearchDocumentsPage> pages, int collectionSize) {
            return new SearchDocumentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchDocumentsPage
    extends AbstractPage<SearchDocumentsRequest, SearchDocumentsResponse, SearchDocumentsResponse.MatchingDocument, SearchDocumentsPage> {
        private SearchDocumentsPage(PageContext<SearchDocumentsRequest, SearchDocumentsResponse, SearchDocumentsResponse.MatchingDocument> context, SearchDocumentsResponse response) {
            super(context, (Object)response);
        }

        private static SearchDocumentsPage createEmptyPage() {
            return new SearchDocumentsPage(null, null);
        }

        protected SearchDocumentsPage createPage(PageContext<SearchDocumentsRequest, SearchDocumentsResponse, SearchDocumentsResponse.MatchingDocument> context, SearchDocumentsResponse response) {
            return new SearchDocumentsPage(context, response);
        }

        public ApiFuture<SearchDocumentsPage> createPageAsync(PageContext<SearchDocumentsRequest, SearchDocumentsResponse, SearchDocumentsResponse.MatchingDocument> context, ApiFuture<SearchDocumentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchDocumentsPagedResponse
    extends AbstractPagedListResponse<SearchDocumentsRequest, SearchDocumentsResponse, SearchDocumentsResponse.MatchingDocument, SearchDocumentsPage, SearchDocumentsFixedSizeCollection> {
        public static ApiFuture<SearchDocumentsPagedResponse> createAsync(PageContext<SearchDocumentsRequest, SearchDocumentsResponse, SearchDocumentsResponse.MatchingDocument> context, ApiFuture<SearchDocumentsResponse> futureResponse) {
            ApiFuture<SearchDocumentsPage> futurePage = SearchDocumentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchDocumentsPagedResponse((SearchDocumentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchDocumentsPagedResponse(SearchDocumentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchDocumentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

