/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateDocumentLinkRequest;
import com.google.cloud.contentwarehouse.v1.DeleteDocumentLinkRequest;
import com.google.cloud.contentwarehouse.v1.DocumentLink;
import com.google.cloud.contentwarehouse.v1.DocumentLinkName;
import com.google.cloud.contentwarehouse.v1.DocumentLinkServiceSettings;
import com.google.cloud.contentwarehouse.v1.DocumentName;
import com.google.cloud.contentwarehouse.v1.ListLinkedSourcesRequest;
import com.google.cloud.contentwarehouse.v1.ListLinkedSourcesResponse;
import com.google.cloud.contentwarehouse.v1.ListLinkedTargetsRequest;
import com.google.cloud.contentwarehouse.v1.ListLinkedTargetsResponse;
import com.google.cloud.contentwarehouse.v1.stub.DocumentLinkServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.DocumentLinkServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DocumentLinkServiceClient
implements BackgroundResource {
    private final DocumentLinkServiceSettings settings;
    private final DocumentLinkServiceStub stub;

    public static final DocumentLinkServiceClient create() throws IOException {
        return DocumentLinkServiceClient.create(DocumentLinkServiceSettings.newBuilder().build());
    }

    public static final DocumentLinkServiceClient create(DocumentLinkServiceSettings settings) throws IOException {
        return new DocumentLinkServiceClient(settings);
    }

    public static final DocumentLinkServiceClient create(DocumentLinkServiceStub stub) {
        return new DocumentLinkServiceClient(stub);
    }

    protected DocumentLinkServiceClient(DocumentLinkServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DocumentLinkServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DocumentLinkServiceClient(DocumentLinkServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DocumentLinkServiceSettings getSettings() {
        return this.settings;
    }

    public DocumentLinkServiceStub getStub() {
        return this.stub;
    }

    public final ListLinkedTargetsResponse listLinkedTargets(DocumentName parent) {
        ListLinkedTargetsRequest request = ListLinkedTargetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listLinkedTargets(request);
    }

    public final ListLinkedTargetsResponse listLinkedTargets(String parent) {
        ListLinkedTargetsRequest request = ListLinkedTargetsRequest.newBuilder().setParent(parent).build();
        return this.listLinkedTargets(request);
    }

    public final ListLinkedTargetsResponse listLinkedTargets(ListLinkedTargetsRequest request) {
        return (ListLinkedTargetsResponse)this.listLinkedTargetsCallable().call((Object)request);
    }

    public final UnaryCallable<ListLinkedTargetsRequest, ListLinkedTargetsResponse> listLinkedTargetsCallable() {
        return this.stub.listLinkedTargetsCallable();
    }

    public final ListLinkedSourcesPagedResponse listLinkedSources(DocumentName parent) {
        ListLinkedSourcesRequest request = ListLinkedSourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listLinkedSources(request);
    }

    public final ListLinkedSourcesPagedResponse listLinkedSources(String parent) {
        ListLinkedSourcesRequest request = ListLinkedSourcesRequest.newBuilder().setParent(parent).build();
        return this.listLinkedSources(request);
    }

    public final ListLinkedSourcesPagedResponse listLinkedSources(ListLinkedSourcesRequest request) {
        return (ListLinkedSourcesPagedResponse)((Object)this.listLinkedSourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLinkedSourcesRequest, ListLinkedSourcesPagedResponse> listLinkedSourcesPagedCallable() {
        return this.stub.listLinkedSourcesPagedCallable();
    }

    public final UnaryCallable<ListLinkedSourcesRequest, ListLinkedSourcesResponse> listLinkedSourcesCallable() {
        return this.stub.listLinkedSourcesCallable();
    }

    public final DocumentLink createDocumentLink(DocumentName parent, DocumentLink documentLink) {
        CreateDocumentLinkRequest request = CreateDocumentLinkRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDocumentLink(documentLink).build();
        return this.createDocumentLink(request);
    }

    public final DocumentLink createDocumentLink(String parent, DocumentLink documentLink) {
        CreateDocumentLinkRequest request = CreateDocumentLinkRequest.newBuilder().setParent(parent).setDocumentLink(documentLink).build();
        return this.createDocumentLink(request);
    }

    public final DocumentLink createDocumentLink(CreateDocumentLinkRequest request) {
        return (DocumentLink)this.createDocumentLinkCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDocumentLinkRequest, DocumentLink> createDocumentLinkCallable() {
        return this.stub.createDocumentLinkCallable();
    }

    public final void deleteDocumentLink(DocumentLinkName name) {
        DeleteDocumentLinkRequest request = DeleteDocumentLinkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDocumentLink(request);
    }

    public final void deleteDocumentLink(String name) {
        DeleteDocumentLinkRequest request = DeleteDocumentLinkRequest.newBuilder().setName(name).build();
        this.deleteDocumentLink(request);
    }

    public final void deleteDocumentLink(DeleteDocumentLinkRequest request) {
        this.deleteDocumentLinkCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDocumentLinkRequest, Empty> deleteDocumentLinkCallable() {
        return this.stub.deleteDocumentLinkCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLinkedSourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLinkedSourcesRequest, ListLinkedSourcesResponse, DocumentLink, ListLinkedSourcesPage, ListLinkedSourcesFixedSizeCollection> {
        private ListLinkedSourcesFixedSizeCollection(List<ListLinkedSourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLinkedSourcesFixedSizeCollection createEmptyCollection() {
            return new ListLinkedSourcesFixedSizeCollection(null, 0);
        }

        protected ListLinkedSourcesFixedSizeCollection createCollection(List<ListLinkedSourcesPage> pages, int collectionSize) {
            return new ListLinkedSourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLinkedSourcesPage
    extends AbstractPage<ListLinkedSourcesRequest, ListLinkedSourcesResponse, DocumentLink, ListLinkedSourcesPage> {
        private ListLinkedSourcesPage(PageContext<ListLinkedSourcesRequest, ListLinkedSourcesResponse, DocumentLink> context, ListLinkedSourcesResponse response) {
            super(context, (Object)response);
        }

        private static ListLinkedSourcesPage createEmptyPage() {
            return new ListLinkedSourcesPage(null, null);
        }

        protected ListLinkedSourcesPage createPage(PageContext<ListLinkedSourcesRequest, ListLinkedSourcesResponse, DocumentLink> context, ListLinkedSourcesResponse response) {
            return new ListLinkedSourcesPage(context, response);
        }

        public ApiFuture<ListLinkedSourcesPage> createPageAsync(PageContext<ListLinkedSourcesRequest, ListLinkedSourcesResponse, DocumentLink> context, ApiFuture<ListLinkedSourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLinkedSourcesPagedResponse
    extends AbstractPagedListResponse<ListLinkedSourcesRequest, ListLinkedSourcesResponse, DocumentLink, ListLinkedSourcesPage, ListLinkedSourcesFixedSizeCollection> {
        public static ApiFuture<ListLinkedSourcesPagedResponse> createAsync(PageContext<ListLinkedSourcesRequest, ListLinkedSourcesResponse, DocumentLink> context, ApiFuture<ListLinkedSourcesResponse> futureResponse) {
            ApiFuture<ListLinkedSourcesPage> futurePage = ListLinkedSourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLinkedSourcesPagedResponse((ListLinkedSourcesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLinkedSourcesPagedResponse(ListLinkedSourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLinkedSourcesFixedSizeCollection.createEmptyCollection());
        }
    }
}

