/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateDocumentRequest;
import com.google.cloud.contentwarehouse.v1.CreateDocumentResponse;
import com.google.cloud.contentwarehouse.v1.DeleteDocumentRequest;
import com.google.cloud.contentwarehouse.v1.Document;
import com.google.cloud.contentwarehouse.v1.DocumentServiceClient;
import com.google.cloud.contentwarehouse.v1.FetchAclRequest;
import com.google.cloud.contentwarehouse.v1.FetchAclResponse;
import com.google.cloud.contentwarehouse.v1.GetDocumentRequest;
import com.google.cloud.contentwarehouse.v1.LockDocumentRequest;
import com.google.cloud.contentwarehouse.v1.SearchDocumentsRequest;
import com.google.cloud.contentwarehouse.v1.SearchDocumentsResponse;
import com.google.cloud.contentwarehouse.v1.SetAclRequest;
import com.google.cloud.contentwarehouse.v1.SetAclResponse;
import com.google.cloud.contentwarehouse.v1.UpdateDocumentRequest;
import com.google.cloud.contentwarehouse.v1.UpdateDocumentResponse;
import com.google.cloud.contentwarehouse.v1.stub.DocumentServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.GrpcDocumentServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.HttpJsonDocumentServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class DocumentServiceStubSettings
extends StubSettings<DocumentServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateDocumentRequest, CreateDocumentResponse> createDocumentSettings;
    private final UnaryCallSettings<GetDocumentRequest, Document> getDocumentSettings;
    private final UnaryCallSettings<UpdateDocumentRequest, UpdateDocumentResponse> updateDocumentSettings;
    private final UnaryCallSettings<DeleteDocumentRequest, Empty> deleteDocumentSettings;
    private final PagedCallSettings<SearchDocumentsRequest, SearchDocumentsResponse, DocumentServiceClient.SearchDocumentsPagedResponse> searchDocumentsSettings;
    private final UnaryCallSettings<LockDocumentRequest, Document> lockDocumentSettings;
    private final UnaryCallSettings<FetchAclRequest, FetchAclResponse> fetchAclSettings;
    private final UnaryCallSettings<SetAclRequest, SetAclResponse> setAclSettings;
    private static final PagedListDescriptor<SearchDocumentsRequest, SearchDocumentsResponse, SearchDocumentsResponse.MatchingDocument> SEARCH_DOCUMENTS_PAGE_STR_DESC = new PagedListDescriptor<SearchDocumentsRequest, SearchDocumentsResponse, SearchDocumentsResponse.MatchingDocument>(){

        public String emptyToken() {
            return "";
        }

        public SearchDocumentsRequest injectToken(SearchDocumentsRequest payload, String token) {
            return SearchDocumentsRequest.newBuilder((SearchDocumentsRequest)payload).setPageToken(token).build();
        }

        public SearchDocumentsRequest injectPageSize(SearchDocumentsRequest payload, int pageSize) {
            return SearchDocumentsRequest.newBuilder((SearchDocumentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchDocumentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchDocumentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SearchDocumentsResponse.MatchingDocument> extractResources(SearchDocumentsResponse payload) {
            return payload.getMatchingDocumentsList() == null ? ImmutableList.of() : payload.getMatchingDocumentsList();
        }
    };
    private static final PagedListResponseFactory<SearchDocumentsRequest, SearchDocumentsResponse, DocumentServiceClient.SearchDocumentsPagedResponse> SEARCH_DOCUMENTS_PAGE_STR_FACT = new PagedListResponseFactory<SearchDocumentsRequest, SearchDocumentsResponse, DocumentServiceClient.SearchDocumentsPagedResponse>(){

        public ApiFuture<DocumentServiceClient.SearchDocumentsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchDocumentsRequest, SearchDocumentsResponse> callable, SearchDocumentsRequest request, ApiCallContext context, ApiFuture<SearchDocumentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_DOCUMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DocumentServiceClient.SearchDocumentsPagedResponse.createAsync((PageContext<SearchDocumentsRequest, SearchDocumentsResponse, SearchDocumentsResponse.MatchingDocument>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDocumentRequest, CreateDocumentResponse> createDocumentSettings() {
        return this.createDocumentSettings;
    }

    public UnaryCallSettings<GetDocumentRequest, Document> getDocumentSettings() {
        return this.getDocumentSettings;
    }

    public UnaryCallSettings<UpdateDocumentRequest, UpdateDocumentResponse> updateDocumentSettings() {
        return this.updateDocumentSettings;
    }

    public UnaryCallSettings<DeleteDocumentRequest, Empty> deleteDocumentSettings() {
        return this.deleteDocumentSettings;
    }

    public PagedCallSettings<SearchDocumentsRequest, SearchDocumentsResponse, DocumentServiceClient.SearchDocumentsPagedResponse> searchDocumentsSettings() {
        return this.searchDocumentsSettings;
    }

    public UnaryCallSettings<LockDocumentRequest, Document> lockDocumentSettings() {
        return this.lockDocumentSettings;
    }

    public UnaryCallSettings<FetchAclRequest, FetchAclResponse> fetchAclSettings() {
        return this.fetchAclSettings;
    }

    public UnaryCallSettings<SetAclRequest, SetAclResponse> setAclSettings() {
        return this.setAclSettings;
    }

    public DocumentServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDocumentServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDocumentServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return DocumentServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "contentwarehouse";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "contentwarehouse.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "contentwarehouse.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DocumentServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DocumentServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DocumentServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DocumentServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DocumentServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDocumentSettings = settingsBuilder.createDocumentSettings().build();
        this.getDocumentSettings = settingsBuilder.getDocumentSettings().build();
        this.updateDocumentSettings = settingsBuilder.updateDocumentSettings().build();
        this.deleteDocumentSettings = settingsBuilder.deleteDocumentSettings().build();
        this.searchDocumentsSettings = settingsBuilder.searchDocumentsSettings().build();
        this.lockDocumentSettings = settingsBuilder.lockDocumentSettings().build();
        this.fetchAclSettings = settingsBuilder.fetchAclSettings().build();
        this.setAclSettings = settingsBuilder.setAclSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DocumentServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDocumentRequest, CreateDocumentResponse> createDocumentSettings;
        private final UnaryCallSettings.Builder<GetDocumentRequest, Document> getDocumentSettings;
        private final UnaryCallSettings.Builder<UpdateDocumentRequest, UpdateDocumentResponse> updateDocumentSettings;
        private final UnaryCallSettings.Builder<DeleteDocumentRequest, Empty> deleteDocumentSettings;
        private final PagedCallSettings.Builder<SearchDocumentsRequest, SearchDocumentsResponse, DocumentServiceClient.SearchDocumentsPagedResponse> searchDocumentsSettings;
        private final UnaryCallSettings.Builder<LockDocumentRequest, Document> lockDocumentSettings;
        private final UnaryCallSettings.Builder<FetchAclRequest, FetchAclResponse> fetchAclSettings;
        private final UnaryCallSettings.Builder<SetAclRequest, SetAclResponse> setAclSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchDocumentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_DOCUMENTS_PAGE_STR_FACT);
            this.lockDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.fetchAclSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setAclSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDocumentSettings, this.getDocumentSettings, this.updateDocumentSettings, this.deleteDocumentSettings, this.searchDocumentsSettings, this.lockDocumentSettings, this.fetchAclSettings, this.setAclSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DocumentServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createDocumentSettings = settings.createDocumentSettings.toBuilder();
            this.getDocumentSettings = settings.getDocumentSettings.toBuilder();
            this.updateDocumentSettings = settings.updateDocumentSettings.toBuilder();
            this.deleteDocumentSettings = settings.deleteDocumentSettings.toBuilder();
            this.searchDocumentsSettings = settings.searchDocumentsSettings.toBuilder();
            this.lockDocumentSettings = settings.lockDocumentSettings.toBuilder();
            this.fetchAclSettings = settings.fetchAclSettings.toBuilder();
            this.setAclSettings = settings.setAclSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDocumentSettings, this.getDocumentSettings, this.updateDocumentSettings, this.deleteDocumentSettings, this.searchDocumentsSettings, this.lockDocumentSettings, this.fetchAclSettings, this.setAclSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DocumentServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DocumentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DocumentServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DocumentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DocumentServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DocumentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DocumentServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DocumentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.getDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.deleteDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.searchDocumentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.lockDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.fetchAclSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setAclSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDocumentRequest, CreateDocumentResponse> createDocumentSettings() {
            return this.createDocumentSettings;
        }

        public UnaryCallSettings.Builder<GetDocumentRequest, Document> getDocumentSettings() {
            return this.getDocumentSettings;
        }

        public UnaryCallSettings.Builder<UpdateDocumentRequest, UpdateDocumentResponse> updateDocumentSettings() {
            return this.updateDocumentSettings;
        }

        public UnaryCallSettings.Builder<DeleteDocumentRequest, Empty> deleteDocumentSettings() {
            return this.deleteDocumentSettings;
        }

        public PagedCallSettings.Builder<SearchDocumentsRequest, SearchDocumentsResponse, DocumentServiceClient.SearchDocumentsPagedResponse> searchDocumentsSettings() {
            return this.searchDocumentsSettings;
        }

        public UnaryCallSettings.Builder<LockDocumentRequest, Document> lockDocumentSettings() {
            return this.lockDocumentSettings;
        }

        public UnaryCallSettings.Builder<FetchAclRequest, FetchAclResponse> fetchAclSettings() {
            return this.fetchAclSettings;
        }

        public UnaryCallSettings.Builder<SetAclRequest, SetAclResponse> setAclSettings() {
            return this.setAclSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return DocumentServiceStubSettings.getDefaultEndpoint();
        }

        public DocumentServiceStubSettings build() throws IOException {
            return new DocumentServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)180000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)180000L)).setTotalTimeout(Duration.ofMillis((long)180000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

