/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateDocumentSchemaRequest;
import com.google.cloud.contentwarehouse.v1.DeleteDocumentSchemaRequest;
import com.google.cloud.contentwarehouse.v1.DocumentSchema;
import com.google.cloud.contentwarehouse.v1.DocumentSchemaName;
import com.google.cloud.contentwarehouse.v1.DocumentSchemaServiceSettings;
import com.google.cloud.contentwarehouse.v1.GetDocumentSchemaRequest;
import com.google.cloud.contentwarehouse.v1.ListDocumentSchemasRequest;
import com.google.cloud.contentwarehouse.v1.ListDocumentSchemasResponse;
import com.google.cloud.contentwarehouse.v1.LocationName;
import com.google.cloud.contentwarehouse.v1.UpdateDocumentSchemaRequest;
import com.google.cloud.contentwarehouse.v1.stub.DocumentSchemaServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.DocumentSchemaServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DocumentSchemaServiceClient
implements BackgroundResource {
    private final DocumentSchemaServiceSettings settings;
    private final DocumentSchemaServiceStub stub;

    public static final DocumentSchemaServiceClient create() throws IOException {
        return DocumentSchemaServiceClient.create(DocumentSchemaServiceSettings.newBuilder().build());
    }

    public static final DocumentSchemaServiceClient create(DocumentSchemaServiceSettings settings) throws IOException {
        return new DocumentSchemaServiceClient(settings);
    }

    public static final DocumentSchemaServiceClient create(DocumentSchemaServiceStub stub) {
        return new DocumentSchemaServiceClient(stub);
    }

    protected DocumentSchemaServiceClient(DocumentSchemaServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DocumentSchemaServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DocumentSchemaServiceClient(DocumentSchemaServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DocumentSchemaServiceSettings getSettings() {
        return this.settings;
    }

    public DocumentSchemaServiceStub getStub() {
        return this.stub;
    }

    public final DocumentSchema createDocumentSchema(LocationName parent, DocumentSchema documentSchema) {
        CreateDocumentSchemaRequest request = CreateDocumentSchemaRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDocumentSchema(documentSchema).build();
        return this.createDocumentSchema(request);
    }

    public final DocumentSchema createDocumentSchema(String parent, DocumentSchema documentSchema) {
        CreateDocumentSchemaRequest request = CreateDocumentSchemaRequest.newBuilder().setParent(parent).setDocumentSchema(documentSchema).build();
        return this.createDocumentSchema(request);
    }

    public final DocumentSchema createDocumentSchema(CreateDocumentSchemaRequest request) {
        return (DocumentSchema)this.createDocumentSchemaCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDocumentSchemaRequest, DocumentSchema> createDocumentSchemaCallable() {
        return this.stub.createDocumentSchemaCallable();
    }

    public final DocumentSchema updateDocumentSchema(DocumentSchemaName name, DocumentSchema documentSchema) {
        UpdateDocumentSchemaRequest request = UpdateDocumentSchemaRequest.newBuilder().setName(name == null ? null : name.toString()).setDocumentSchema(documentSchema).build();
        return this.updateDocumentSchema(request);
    }

    public final DocumentSchema updateDocumentSchema(String name, DocumentSchema documentSchema) {
        UpdateDocumentSchemaRequest request = UpdateDocumentSchemaRequest.newBuilder().setName(name).setDocumentSchema(documentSchema).build();
        return this.updateDocumentSchema(request);
    }

    public final DocumentSchema updateDocumentSchema(UpdateDocumentSchemaRequest request) {
        return (DocumentSchema)this.updateDocumentSchemaCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDocumentSchemaRequest, DocumentSchema> updateDocumentSchemaCallable() {
        return this.stub.updateDocumentSchemaCallable();
    }

    public final DocumentSchema getDocumentSchema(DocumentSchemaName name) {
        GetDocumentSchemaRequest request = GetDocumentSchemaRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDocumentSchema(request);
    }

    public final DocumentSchema getDocumentSchema(String name) {
        GetDocumentSchemaRequest request = GetDocumentSchemaRequest.newBuilder().setName(name).build();
        return this.getDocumentSchema(request);
    }

    public final DocumentSchema getDocumentSchema(GetDocumentSchemaRequest request) {
        return (DocumentSchema)this.getDocumentSchemaCallable().call((Object)request);
    }

    public final UnaryCallable<GetDocumentSchemaRequest, DocumentSchema> getDocumentSchemaCallable() {
        return this.stub.getDocumentSchemaCallable();
    }

    public final void deleteDocumentSchema(DocumentSchemaName name) {
        DeleteDocumentSchemaRequest request = DeleteDocumentSchemaRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDocumentSchema(request);
    }

    public final void deleteDocumentSchema(String name) {
        DeleteDocumentSchemaRequest request = DeleteDocumentSchemaRequest.newBuilder().setName(name).build();
        this.deleteDocumentSchema(request);
    }

    public final void deleteDocumentSchema(DeleteDocumentSchemaRequest request) {
        this.deleteDocumentSchemaCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDocumentSchemaRequest, Empty> deleteDocumentSchemaCallable() {
        return this.stub.deleteDocumentSchemaCallable();
    }

    public final ListDocumentSchemasPagedResponse listDocumentSchemas(LocationName parent) {
        ListDocumentSchemasRequest request = ListDocumentSchemasRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDocumentSchemas(request);
    }

    public final ListDocumentSchemasPagedResponse listDocumentSchemas(String parent) {
        ListDocumentSchemasRequest request = ListDocumentSchemasRequest.newBuilder().setParent(parent).build();
        return this.listDocumentSchemas(request);
    }

    public final ListDocumentSchemasPagedResponse listDocumentSchemas(ListDocumentSchemasRequest request) {
        return (ListDocumentSchemasPagedResponse)((Object)this.listDocumentSchemasPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDocumentSchemasRequest, ListDocumentSchemasPagedResponse> listDocumentSchemasPagedCallable() {
        return this.stub.listDocumentSchemasPagedCallable();
    }

    public final UnaryCallable<ListDocumentSchemasRequest, ListDocumentSchemasResponse> listDocumentSchemasCallable() {
        return this.stub.listDocumentSchemasCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDocumentSchemasFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDocumentSchemasRequest, ListDocumentSchemasResponse, DocumentSchema, ListDocumentSchemasPage, ListDocumentSchemasFixedSizeCollection> {
        private ListDocumentSchemasFixedSizeCollection(List<ListDocumentSchemasPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDocumentSchemasFixedSizeCollection createEmptyCollection() {
            return new ListDocumentSchemasFixedSizeCollection(null, 0);
        }

        protected ListDocumentSchemasFixedSizeCollection createCollection(List<ListDocumentSchemasPage> pages, int collectionSize) {
            return new ListDocumentSchemasFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDocumentSchemasPage
    extends AbstractPage<ListDocumentSchemasRequest, ListDocumentSchemasResponse, DocumentSchema, ListDocumentSchemasPage> {
        private ListDocumentSchemasPage(PageContext<ListDocumentSchemasRequest, ListDocumentSchemasResponse, DocumentSchema> context, ListDocumentSchemasResponse response) {
            super(context, (Object)response);
        }

        private static ListDocumentSchemasPage createEmptyPage() {
            return new ListDocumentSchemasPage(null, null);
        }

        protected ListDocumentSchemasPage createPage(PageContext<ListDocumentSchemasRequest, ListDocumentSchemasResponse, DocumentSchema> context, ListDocumentSchemasResponse response) {
            return new ListDocumentSchemasPage(context, response);
        }

        public ApiFuture<ListDocumentSchemasPage> createPageAsync(PageContext<ListDocumentSchemasRequest, ListDocumentSchemasResponse, DocumentSchema> context, ApiFuture<ListDocumentSchemasResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDocumentSchemasPagedResponse
    extends AbstractPagedListResponse<ListDocumentSchemasRequest, ListDocumentSchemasResponse, DocumentSchema, ListDocumentSchemasPage, ListDocumentSchemasFixedSizeCollection> {
        public static ApiFuture<ListDocumentSchemasPagedResponse> createAsync(PageContext<ListDocumentSchemasRequest, ListDocumentSchemasResponse, DocumentSchema> context, ApiFuture<ListDocumentSchemasResponse> futureResponse) {
            ApiFuture<ListDocumentSchemasPage> futurePage = ListDocumentSchemasPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDocumentSchemasPagedResponse((ListDocumentSchemasPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDocumentSchemasPagedResponse(ListDocumentSchemasPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDocumentSchemasFixedSizeCollection.createEmptyCollection());
        }
    }
}

