/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateRuleSetRequest;
import com.google.cloud.contentwarehouse.v1.DeleteRuleSetRequest;
import com.google.cloud.contentwarehouse.v1.GetRuleSetRequest;
import com.google.cloud.contentwarehouse.v1.ListRuleSetsRequest;
import com.google.cloud.contentwarehouse.v1.ListRuleSetsResponse;
import com.google.cloud.contentwarehouse.v1.RuleSet;
import com.google.cloud.contentwarehouse.v1.RuleSetServiceClient;
import com.google.cloud.contentwarehouse.v1.UpdateRuleSetRequest;
import com.google.cloud.contentwarehouse.v1.stub.HttpJsonRuleSetServiceCallableFactory;
import com.google.cloud.contentwarehouse.v1.stub.RuleSetServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.RuleSetServiceStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonRuleSetServiceStub
extends RuleSetServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateRuleSetRequest, RuleSet> createRuleSetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.RuleSetService/CreateRuleSet").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/ruleSets", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("ruleSet", (Message)request.getRuleSet(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RuleSet.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetRuleSetRequest, RuleSet> getRuleSetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.RuleSetService/GetRuleSet").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/ruleSets/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RuleSet.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateRuleSetRequest, RuleSet> updateRuleSetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.RuleSetService/UpdateRuleSet").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/ruleSets/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RuleSet.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteRuleSetRequest, Empty> deleteRuleSetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.RuleSetService/DeleteRuleSet").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/ruleSets/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListRuleSetsRequest, ListRuleSetsResponse> listRuleSetsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.RuleSetService/ListRuleSets").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/ruleSets", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListRuleSetsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateRuleSetRequest, RuleSet> createRuleSetCallable;
    private final UnaryCallable<GetRuleSetRequest, RuleSet> getRuleSetCallable;
    private final UnaryCallable<UpdateRuleSetRequest, RuleSet> updateRuleSetCallable;
    private final UnaryCallable<DeleteRuleSetRequest, Empty> deleteRuleSetCallable;
    private final UnaryCallable<ListRuleSetsRequest, ListRuleSetsResponse> listRuleSetsCallable;
    private final UnaryCallable<ListRuleSetsRequest, RuleSetServiceClient.ListRuleSetsPagedResponse> listRuleSetsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRuleSetServiceStub create(RuleSetServiceStubSettings settings) throws IOException {
        return new HttpJsonRuleSetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRuleSetServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRuleSetServiceStub(RuleSetServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonRuleSetServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRuleSetServiceStub(RuleSetServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRuleSetServiceStub(RuleSetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRuleSetServiceCallableFactory());
    }

    protected HttpJsonRuleSetServiceStub(RuleSetServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createRuleSetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createRuleSetMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getRuleSetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRuleSetMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateRuleSetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateRuleSetMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteRuleSetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteRuleSetMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listRuleSetsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRuleSetsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createRuleSetCallable = callableFactory.createUnaryCallable(createRuleSetTransportSettings, settings.createRuleSetSettings(), clientContext);
        this.getRuleSetCallable = callableFactory.createUnaryCallable(getRuleSetTransportSettings, settings.getRuleSetSettings(), clientContext);
        this.updateRuleSetCallable = callableFactory.createUnaryCallable(updateRuleSetTransportSettings, settings.updateRuleSetSettings(), clientContext);
        this.deleteRuleSetCallable = callableFactory.createUnaryCallable(deleteRuleSetTransportSettings, settings.deleteRuleSetSettings(), clientContext);
        this.listRuleSetsCallable = callableFactory.createUnaryCallable(listRuleSetsTransportSettings, settings.listRuleSetsSettings(), clientContext);
        this.listRuleSetsPagedCallable = callableFactory.createPagedCallable(listRuleSetsTransportSettings, settings.listRuleSetsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createRuleSetMethodDescriptor);
        methodDescriptors.add(getRuleSetMethodDescriptor);
        methodDescriptors.add(updateRuleSetMethodDescriptor);
        methodDescriptors.add(deleteRuleSetMethodDescriptor);
        methodDescriptors.add(listRuleSetsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateRuleSetRequest, RuleSet> createRuleSetCallable() {
        return this.createRuleSetCallable;
    }

    @Override
    public UnaryCallable<GetRuleSetRequest, RuleSet> getRuleSetCallable() {
        return this.getRuleSetCallable;
    }

    @Override
    public UnaryCallable<UpdateRuleSetRequest, RuleSet> updateRuleSetCallable() {
        return this.updateRuleSetCallable;
    }

    @Override
    public UnaryCallable<DeleteRuleSetRequest, Empty> deleteRuleSetCallable() {
        return this.deleteRuleSetCallable;
    }

    @Override
    public UnaryCallable<ListRuleSetsRequest, ListRuleSetsResponse> listRuleSetsCallable() {
        return this.listRuleSetsCallable;
    }

    @Override
    public UnaryCallable<ListRuleSetsRequest, RuleSetServiceClient.ListRuleSetsPagedResponse> listRuleSetsPagedCallable() {
        return this.listRuleSetsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

