/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.devtools.containeranalysis.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1Settings;
import com.google.cloud.devtools.containeranalysis.v1beta1.stub.ContainerAnalysisV1Beta1Stub;
import com.google.cloud.devtools.containeranalysis.v1beta1.stub.ContainerAnalysisV1Beta1StubSettings;
import com.google.containeranalysis.v1beta1.GetScanConfigRequest;
import com.google.containeranalysis.v1beta1.IamResourceName;
import com.google.containeranalysis.v1beta1.ListScanConfigsRequest;
import com.google.containeranalysis.v1beta1.ListScanConfigsResponse;
import com.google.containeranalysis.v1beta1.ProjectName;
import com.google.containeranalysis.v1beta1.ScanConfig;
import com.google.containeranalysis.v1beta1.ScanConfigName;
import com.google.containeranalysis.v1beta1.UpdateScanConfigRequest;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ContainerAnalysisV1Beta1Client
implements BackgroundResource {
    private final ContainerAnalysisV1Beta1Settings settings;
    private final ContainerAnalysisV1Beta1Stub stub;

    public static final ContainerAnalysisV1Beta1Client create() throws IOException {
        return ContainerAnalysisV1Beta1Client.create(ContainerAnalysisV1Beta1Settings.newBuilder().build());
    }

    public static final ContainerAnalysisV1Beta1Client create(ContainerAnalysisV1Beta1Settings settings) throws IOException {
        return new ContainerAnalysisV1Beta1Client(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ContainerAnalysisV1Beta1Client create(ContainerAnalysisV1Beta1Stub stub) {
        return new ContainerAnalysisV1Beta1Client(stub);
    }

    protected ContainerAnalysisV1Beta1Client(ContainerAnalysisV1Beta1Settings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ContainerAnalysisV1Beta1StubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ContainerAnalysisV1Beta1Client(ContainerAnalysisV1Beta1Stub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ContainerAnalysisV1Beta1Settings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ContainerAnalysisV1Beta1Stub getStub() {
        return this.stub;
    }

    public final Policy setIamPolicy(IamResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(IamResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    private final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(IamResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final ScanConfig getScanConfig(ScanConfigName name) {
        GetScanConfigRequest request = GetScanConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getScanConfig(request);
    }

    public final ScanConfig getScanConfig(String name) {
        GetScanConfigRequest request = GetScanConfigRequest.newBuilder().setName(name).build();
        return this.getScanConfig(request);
    }

    private final ScanConfig getScanConfig(GetScanConfigRequest request) {
        return (ScanConfig)this.getScanConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetScanConfigRequest, ScanConfig> getScanConfigCallable() {
        return this.stub.getScanConfigCallable();
    }

    public final ListScanConfigsPagedResponse listScanConfigs(ProjectName parent, String filter) {
        ListScanConfigsRequest request = ListScanConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).build();
        return this.listScanConfigs(request);
    }

    public final ListScanConfigsPagedResponse listScanConfigs(String parent, String filter) {
        ListScanConfigsRequest request = ListScanConfigsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listScanConfigs(request);
    }

    public final ListScanConfigsPagedResponse listScanConfigs(ListScanConfigsRequest request) {
        return (ListScanConfigsPagedResponse)((Object)this.listScanConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListScanConfigsRequest, ListScanConfigsPagedResponse> listScanConfigsPagedCallable() {
        return this.stub.listScanConfigsPagedCallable();
    }

    public final UnaryCallable<ListScanConfigsRequest, ListScanConfigsResponse> listScanConfigsCallable() {
        return this.stub.listScanConfigsCallable();
    }

    public final ScanConfig updateScanConfig(ScanConfigName name, ScanConfig scanConfig) {
        UpdateScanConfigRequest request = UpdateScanConfigRequest.newBuilder().setName(name == null ? null : name.toString()).setScanConfig(scanConfig).build();
        return this.updateScanConfig(request);
    }

    public final ScanConfig updateScanConfig(String name, ScanConfig scanConfig) {
        UpdateScanConfigRequest request = UpdateScanConfigRequest.newBuilder().setName(name).setScanConfig(scanConfig).build();
        return this.updateScanConfig(request);
    }

    public final ScanConfig updateScanConfig(UpdateScanConfigRequest request) {
        return (ScanConfig)this.updateScanConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateScanConfigRequest, ScanConfig> updateScanConfigCallable() {
        return this.stub.updateScanConfigCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListScanConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig, ListScanConfigsPage, ListScanConfigsFixedSizeCollection> {
        private ListScanConfigsFixedSizeCollection(List<ListScanConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListScanConfigsFixedSizeCollection createEmptyCollection() {
            return new ListScanConfigsFixedSizeCollection(null, 0);
        }

        protected ListScanConfigsFixedSizeCollection createCollection(List<ListScanConfigsPage> pages, int collectionSize) {
            return new ListScanConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListScanConfigsPage
    extends AbstractPage<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig, ListScanConfigsPage> {
        private ListScanConfigsPage(PageContext<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig> context, ListScanConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListScanConfigsPage createEmptyPage() {
            return new ListScanConfigsPage(null, null);
        }

        protected ListScanConfigsPage createPage(PageContext<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig> context, ListScanConfigsResponse response) {
            return new ListScanConfigsPage(context, response);
        }

        public ApiFuture<ListScanConfigsPage> createPageAsync(PageContext<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig> context, ApiFuture<ListScanConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListScanConfigsPagedResponse
    extends AbstractPagedListResponse<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig, ListScanConfigsPage, ListScanConfigsFixedSizeCollection> {
        public static ApiFuture<ListScanConfigsPagedResponse> createAsync(PageContext<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig> context, ApiFuture<ListScanConfigsResponse> futureResponse) {
            ApiFuture<ListScanConfigsPage> futurePage = ListScanConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListScanConfigsPage, ListScanConfigsPagedResponse>(){

                public ListScanConfigsPagedResponse apply(ListScanConfigsPage input) {
                    return new ListScanConfigsPagedResponse(input);
                }
            });
        }

        private ListScanConfigsPagedResponse(ListScanConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListScanConfigsFixedSizeCollection.createEmptyCollection());
        }
    }
}

