/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.container.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.container.v1.ClusterManagerClient;
import com.google.cloud.container.v1.stub.ClusterManagerStub;
import com.google.cloud.container.v1.stub.GrpcClusterManagerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.container.v1.CancelOperationRequest;
import com.google.container.v1.CheckAutopilotCompatibilityRequest;
import com.google.container.v1.CheckAutopilotCompatibilityResponse;
import com.google.container.v1.Cluster;
import com.google.container.v1.CompleteIPRotationRequest;
import com.google.container.v1.CompleteNodePoolUpgradeRequest;
import com.google.container.v1.CreateClusterRequest;
import com.google.container.v1.CreateNodePoolRequest;
import com.google.container.v1.DeleteClusterRequest;
import com.google.container.v1.DeleteNodePoolRequest;
import com.google.container.v1.GetClusterRequest;
import com.google.container.v1.GetJSONWebKeysRequest;
import com.google.container.v1.GetJSONWebKeysResponse;
import com.google.container.v1.GetNodePoolRequest;
import com.google.container.v1.GetOperationRequest;
import com.google.container.v1.GetServerConfigRequest;
import com.google.container.v1.ListClustersRequest;
import com.google.container.v1.ListClustersResponse;
import com.google.container.v1.ListNodePoolsRequest;
import com.google.container.v1.ListNodePoolsResponse;
import com.google.container.v1.ListOperationsRequest;
import com.google.container.v1.ListOperationsResponse;
import com.google.container.v1.ListUsableSubnetworksRequest;
import com.google.container.v1.ListUsableSubnetworksResponse;
import com.google.container.v1.NodePool;
import com.google.container.v1.Operation;
import com.google.container.v1.RollbackNodePoolUpgradeRequest;
import com.google.container.v1.ServerConfig;
import com.google.container.v1.SetAddonsConfigRequest;
import com.google.container.v1.SetLabelsRequest;
import com.google.container.v1.SetLegacyAbacRequest;
import com.google.container.v1.SetLocationsRequest;
import com.google.container.v1.SetLoggingServiceRequest;
import com.google.container.v1.SetMaintenancePolicyRequest;
import com.google.container.v1.SetMasterAuthRequest;
import com.google.container.v1.SetMonitoringServiceRequest;
import com.google.container.v1.SetNetworkPolicyRequest;
import com.google.container.v1.SetNodePoolAutoscalingRequest;
import com.google.container.v1.SetNodePoolManagementRequest;
import com.google.container.v1.SetNodePoolSizeRequest;
import com.google.container.v1.StartIPRotationRequest;
import com.google.container.v1.UpdateClusterRequest;
import com.google.container.v1.UpdateMasterRequest;
import com.google.container.v1.UpdateNodePoolRequest;
import com.google.container.v1.UsableSubnetwork;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ClusterManagerStubSettings
extends StubSettings<ClusterManagerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ListClustersRequest, ListClustersResponse> listClustersSettings;
    private final UnaryCallSettings<GetClusterRequest, Cluster> getClusterSettings;
    private final UnaryCallSettings<CreateClusterRequest, Operation> createClusterSettings;
    private final UnaryCallSettings<UpdateClusterRequest, Operation> updateClusterSettings;
    private final UnaryCallSettings<UpdateNodePoolRequest, Operation> updateNodePoolSettings;
    private final UnaryCallSettings<SetNodePoolAutoscalingRequest, Operation> setNodePoolAutoscalingSettings;
    private final UnaryCallSettings<SetLoggingServiceRequest, Operation> setLoggingServiceSettings;
    private final UnaryCallSettings<SetMonitoringServiceRequest, Operation> setMonitoringServiceSettings;
    private final UnaryCallSettings<SetAddonsConfigRequest, Operation> setAddonsConfigSettings;
    private final UnaryCallSettings<SetLocationsRequest, Operation> setLocationsSettings;
    private final UnaryCallSettings<UpdateMasterRequest, Operation> updateMasterSettings;
    private final UnaryCallSettings<SetMasterAuthRequest, Operation> setMasterAuthSettings;
    private final UnaryCallSettings<DeleteClusterRequest, Operation> deleteClusterSettings;
    private final UnaryCallSettings<ListOperationsRequest, ListOperationsResponse> listOperationsSettings;
    private final UnaryCallSettings<GetOperationRequest, Operation> getOperationSettings;
    private final UnaryCallSettings<CancelOperationRequest, Empty> cancelOperationSettings;
    private final UnaryCallSettings<GetServerConfigRequest, ServerConfig> getServerConfigSettings;
    private final UnaryCallSettings<GetJSONWebKeysRequest, GetJSONWebKeysResponse> getJSONWebKeysSettings;
    private final UnaryCallSettings<ListNodePoolsRequest, ListNodePoolsResponse> listNodePoolsSettings;
    private final UnaryCallSettings<GetNodePoolRequest, NodePool> getNodePoolSettings;
    private final UnaryCallSettings<CreateNodePoolRequest, Operation> createNodePoolSettings;
    private final UnaryCallSettings<DeleteNodePoolRequest, Operation> deleteNodePoolSettings;
    private final UnaryCallSettings<CompleteNodePoolUpgradeRequest, Empty> completeNodePoolUpgradeSettings;
    private final UnaryCallSettings<RollbackNodePoolUpgradeRequest, Operation> rollbackNodePoolUpgradeSettings;
    private final UnaryCallSettings<SetNodePoolManagementRequest, Operation> setNodePoolManagementSettings;
    private final UnaryCallSettings<SetLabelsRequest, Operation> setLabelsSettings;
    private final UnaryCallSettings<SetLegacyAbacRequest, Operation> setLegacyAbacSettings;
    private final UnaryCallSettings<StartIPRotationRequest, Operation> startIPRotationSettings;
    private final UnaryCallSettings<CompleteIPRotationRequest, Operation> completeIPRotationSettings;
    private final UnaryCallSettings<SetNodePoolSizeRequest, Operation> setNodePoolSizeSettings;
    private final UnaryCallSettings<SetNetworkPolicyRequest, Operation> setNetworkPolicySettings;
    private final UnaryCallSettings<SetMaintenancePolicyRequest, Operation> setMaintenancePolicySettings;
    private final PagedCallSettings<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse, ClusterManagerClient.ListUsableSubnetworksPagedResponse> listUsableSubnetworksSettings;
    private final UnaryCallSettings<CheckAutopilotCompatibilityRequest, CheckAutopilotCompatibilityResponse> checkAutopilotCompatibilitySettings;
    private static final PagedListDescriptor<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse, UsableSubnetwork> LIST_USABLE_SUBNETWORKS_PAGE_STR_DESC = new PagedListDescriptor<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse, UsableSubnetwork>(){

        public String emptyToken() {
            return "";
        }

        public ListUsableSubnetworksRequest injectToken(ListUsableSubnetworksRequest payload, String token) {
            return ListUsableSubnetworksRequest.newBuilder((ListUsableSubnetworksRequest)payload).setPageToken(token).build();
        }

        public ListUsableSubnetworksRequest injectPageSize(ListUsableSubnetworksRequest payload, int pageSize) {
            return ListUsableSubnetworksRequest.newBuilder((ListUsableSubnetworksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListUsableSubnetworksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListUsableSubnetworksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<UsableSubnetwork> extractResources(ListUsableSubnetworksResponse payload) {
            return payload.getSubnetworksList() == null ? ImmutableList.of() : payload.getSubnetworksList();
        }
    };
    private static final PagedListResponseFactory<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse, ClusterManagerClient.ListUsableSubnetworksPagedResponse> LIST_USABLE_SUBNETWORKS_PAGE_STR_FACT = new PagedListResponseFactory<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse, ClusterManagerClient.ListUsableSubnetworksPagedResponse>(){

        public ApiFuture<ClusterManagerClient.ListUsableSubnetworksPagedResponse> getFuturePagedResponse(UnaryCallable<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse> callable, ListUsableSubnetworksRequest request, ApiCallContext context, ApiFuture<ListUsableSubnetworksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_USABLE_SUBNETWORKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ClusterManagerClient.ListUsableSubnetworksPagedResponse.createAsync((PageContext<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse, UsableSubnetwork>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<ListClustersRequest, ListClustersResponse> listClustersSettings() {
        return this.listClustersSettings;
    }

    public UnaryCallSettings<GetClusterRequest, Cluster> getClusterSettings() {
        return this.getClusterSettings;
    }

    public UnaryCallSettings<CreateClusterRequest, Operation> createClusterSettings() {
        return this.createClusterSettings;
    }

    public UnaryCallSettings<UpdateClusterRequest, Operation> updateClusterSettings() {
        return this.updateClusterSettings;
    }

    public UnaryCallSettings<UpdateNodePoolRequest, Operation> updateNodePoolSettings() {
        return this.updateNodePoolSettings;
    }

    public UnaryCallSettings<SetNodePoolAutoscalingRequest, Operation> setNodePoolAutoscalingSettings() {
        return this.setNodePoolAutoscalingSettings;
    }

    public UnaryCallSettings<SetLoggingServiceRequest, Operation> setLoggingServiceSettings() {
        return this.setLoggingServiceSettings;
    }

    public UnaryCallSettings<SetMonitoringServiceRequest, Operation> setMonitoringServiceSettings() {
        return this.setMonitoringServiceSettings;
    }

    public UnaryCallSettings<SetAddonsConfigRequest, Operation> setAddonsConfigSettings() {
        return this.setAddonsConfigSettings;
    }

    @Deprecated
    public UnaryCallSettings<SetLocationsRequest, Operation> setLocationsSettings() {
        return this.setLocationsSettings;
    }

    public UnaryCallSettings<UpdateMasterRequest, Operation> updateMasterSettings() {
        return this.updateMasterSettings;
    }

    public UnaryCallSettings<SetMasterAuthRequest, Operation> setMasterAuthSettings() {
        return this.setMasterAuthSettings;
    }

    public UnaryCallSettings<DeleteClusterRequest, Operation> deleteClusterSettings() {
        return this.deleteClusterSettings;
    }

    public UnaryCallSettings<ListOperationsRequest, ListOperationsResponse> listOperationsSettings() {
        return this.listOperationsSettings;
    }

    public UnaryCallSettings<GetOperationRequest, Operation> getOperationSettings() {
        return this.getOperationSettings;
    }

    public UnaryCallSettings<CancelOperationRequest, Empty> cancelOperationSettings() {
        return this.cancelOperationSettings;
    }

    public UnaryCallSettings<GetServerConfigRequest, ServerConfig> getServerConfigSettings() {
        return this.getServerConfigSettings;
    }

    public UnaryCallSettings<GetJSONWebKeysRequest, GetJSONWebKeysResponse> getJSONWebKeysSettings() {
        return this.getJSONWebKeysSettings;
    }

    public UnaryCallSettings<ListNodePoolsRequest, ListNodePoolsResponse> listNodePoolsSettings() {
        return this.listNodePoolsSettings;
    }

    public UnaryCallSettings<GetNodePoolRequest, NodePool> getNodePoolSettings() {
        return this.getNodePoolSettings;
    }

    public UnaryCallSettings<CreateNodePoolRequest, Operation> createNodePoolSettings() {
        return this.createNodePoolSettings;
    }

    public UnaryCallSettings<DeleteNodePoolRequest, Operation> deleteNodePoolSettings() {
        return this.deleteNodePoolSettings;
    }

    public UnaryCallSettings<CompleteNodePoolUpgradeRequest, Empty> completeNodePoolUpgradeSettings() {
        return this.completeNodePoolUpgradeSettings;
    }

    public UnaryCallSettings<RollbackNodePoolUpgradeRequest, Operation> rollbackNodePoolUpgradeSettings() {
        return this.rollbackNodePoolUpgradeSettings;
    }

    public UnaryCallSettings<SetNodePoolManagementRequest, Operation> setNodePoolManagementSettings() {
        return this.setNodePoolManagementSettings;
    }

    public UnaryCallSettings<SetLabelsRequest, Operation> setLabelsSettings() {
        return this.setLabelsSettings;
    }

    public UnaryCallSettings<SetLegacyAbacRequest, Operation> setLegacyAbacSettings() {
        return this.setLegacyAbacSettings;
    }

    public UnaryCallSettings<StartIPRotationRequest, Operation> startIPRotationSettings() {
        return this.startIPRotationSettings;
    }

    public UnaryCallSettings<CompleteIPRotationRequest, Operation> completeIPRotationSettings() {
        return this.completeIPRotationSettings;
    }

    public UnaryCallSettings<SetNodePoolSizeRequest, Operation> setNodePoolSizeSettings() {
        return this.setNodePoolSizeSettings;
    }

    public UnaryCallSettings<SetNetworkPolicyRequest, Operation> setNetworkPolicySettings() {
        return this.setNetworkPolicySettings;
    }

    public UnaryCallSettings<SetMaintenancePolicyRequest, Operation> setMaintenancePolicySettings() {
        return this.setMaintenancePolicySettings;
    }

    public PagedCallSettings<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse, ClusterManagerClient.ListUsableSubnetworksPagedResponse> listUsableSubnetworksSettings() {
        return this.listUsableSubnetworksSettings;
    }

    public UnaryCallSettings<CheckAutopilotCompatibilityRequest, CheckAutopilotCompatibilityResponse> checkAutopilotCompatibilitySettings() {
        return this.checkAutopilotCompatibilitySettings;
    }

    public ClusterManagerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcClusterManagerStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "container";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "container.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "container.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ClusterManagerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ClusterManagerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ClusterManagerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listClustersSettings = settingsBuilder.listClustersSettings().build();
        this.getClusterSettings = settingsBuilder.getClusterSettings().build();
        this.createClusterSettings = settingsBuilder.createClusterSettings().build();
        this.updateClusterSettings = settingsBuilder.updateClusterSettings().build();
        this.updateNodePoolSettings = settingsBuilder.updateNodePoolSettings().build();
        this.setNodePoolAutoscalingSettings = settingsBuilder.setNodePoolAutoscalingSettings().build();
        this.setLoggingServiceSettings = settingsBuilder.setLoggingServiceSettings().build();
        this.setMonitoringServiceSettings = settingsBuilder.setMonitoringServiceSettings().build();
        this.setAddonsConfigSettings = settingsBuilder.setAddonsConfigSettings().build();
        this.setLocationsSettings = settingsBuilder.setLocationsSettings().build();
        this.updateMasterSettings = settingsBuilder.updateMasterSettings().build();
        this.setMasterAuthSettings = settingsBuilder.setMasterAuthSettings().build();
        this.deleteClusterSettings = settingsBuilder.deleteClusterSettings().build();
        this.listOperationsSettings = settingsBuilder.listOperationsSettings().build();
        this.getOperationSettings = settingsBuilder.getOperationSettings().build();
        this.cancelOperationSettings = settingsBuilder.cancelOperationSettings().build();
        this.getServerConfigSettings = settingsBuilder.getServerConfigSettings().build();
        this.getJSONWebKeysSettings = settingsBuilder.getJSONWebKeysSettings().build();
        this.listNodePoolsSettings = settingsBuilder.listNodePoolsSettings().build();
        this.getNodePoolSettings = settingsBuilder.getNodePoolSettings().build();
        this.createNodePoolSettings = settingsBuilder.createNodePoolSettings().build();
        this.deleteNodePoolSettings = settingsBuilder.deleteNodePoolSettings().build();
        this.completeNodePoolUpgradeSettings = settingsBuilder.completeNodePoolUpgradeSettings().build();
        this.rollbackNodePoolUpgradeSettings = settingsBuilder.rollbackNodePoolUpgradeSettings().build();
        this.setNodePoolManagementSettings = settingsBuilder.setNodePoolManagementSettings().build();
        this.setLabelsSettings = settingsBuilder.setLabelsSettings().build();
        this.setLegacyAbacSettings = settingsBuilder.setLegacyAbacSettings().build();
        this.startIPRotationSettings = settingsBuilder.startIPRotationSettings().build();
        this.completeIPRotationSettings = settingsBuilder.completeIPRotationSettings().build();
        this.setNodePoolSizeSettings = settingsBuilder.setNodePoolSizeSettings().build();
        this.setNetworkPolicySettings = settingsBuilder.setNetworkPolicySettings().build();
        this.setMaintenancePolicySettings = settingsBuilder.setMaintenancePolicySettings().build();
        this.listUsableSubnetworksSettings = settingsBuilder.listUsableSubnetworksSettings().build();
        this.checkAutopilotCompatibilitySettings = settingsBuilder.checkAutopilotCompatibilitySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ClusterManagerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ListClustersRequest, ListClustersResponse> listClustersSettings;
        private final UnaryCallSettings.Builder<GetClusterRequest, Cluster> getClusterSettings;
        private final UnaryCallSettings.Builder<CreateClusterRequest, Operation> createClusterSettings;
        private final UnaryCallSettings.Builder<UpdateClusterRequest, Operation> updateClusterSettings;
        private final UnaryCallSettings.Builder<UpdateNodePoolRequest, Operation> updateNodePoolSettings;
        private final UnaryCallSettings.Builder<SetNodePoolAutoscalingRequest, Operation> setNodePoolAutoscalingSettings;
        private final UnaryCallSettings.Builder<SetLoggingServiceRequest, Operation> setLoggingServiceSettings;
        private final UnaryCallSettings.Builder<SetMonitoringServiceRequest, Operation> setMonitoringServiceSettings;
        private final UnaryCallSettings.Builder<SetAddonsConfigRequest, Operation> setAddonsConfigSettings;
        private final UnaryCallSettings.Builder<SetLocationsRequest, Operation> setLocationsSettings;
        private final UnaryCallSettings.Builder<UpdateMasterRequest, Operation> updateMasterSettings;
        private final UnaryCallSettings.Builder<SetMasterAuthRequest, Operation> setMasterAuthSettings;
        private final UnaryCallSettings.Builder<DeleteClusterRequest, Operation> deleteClusterSettings;
        private final UnaryCallSettings.Builder<ListOperationsRequest, ListOperationsResponse> listOperationsSettings;
        private final UnaryCallSettings.Builder<GetOperationRequest, Operation> getOperationSettings;
        private final UnaryCallSettings.Builder<CancelOperationRequest, Empty> cancelOperationSettings;
        private final UnaryCallSettings.Builder<GetServerConfigRequest, ServerConfig> getServerConfigSettings;
        private final UnaryCallSettings.Builder<GetJSONWebKeysRequest, GetJSONWebKeysResponse> getJSONWebKeysSettings;
        private final UnaryCallSettings.Builder<ListNodePoolsRequest, ListNodePoolsResponse> listNodePoolsSettings;
        private final UnaryCallSettings.Builder<GetNodePoolRequest, NodePool> getNodePoolSettings;
        private final UnaryCallSettings.Builder<CreateNodePoolRequest, Operation> createNodePoolSettings;
        private final UnaryCallSettings.Builder<DeleteNodePoolRequest, Operation> deleteNodePoolSettings;
        private final UnaryCallSettings.Builder<CompleteNodePoolUpgradeRequest, Empty> completeNodePoolUpgradeSettings;
        private final UnaryCallSettings.Builder<RollbackNodePoolUpgradeRequest, Operation> rollbackNodePoolUpgradeSettings;
        private final UnaryCallSettings.Builder<SetNodePoolManagementRequest, Operation> setNodePoolManagementSettings;
        private final UnaryCallSettings.Builder<SetLabelsRequest, Operation> setLabelsSettings;
        private final UnaryCallSettings.Builder<SetLegacyAbacRequest, Operation> setLegacyAbacSettings;
        private final UnaryCallSettings.Builder<StartIPRotationRequest, Operation> startIPRotationSettings;
        private final UnaryCallSettings.Builder<CompleteIPRotationRequest, Operation> completeIPRotationSettings;
        private final UnaryCallSettings.Builder<SetNodePoolSizeRequest, Operation> setNodePoolSizeSettings;
        private final UnaryCallSettings.Builder<SetNetworkPolicyRequest, Operation> setNetworkPolicySettings;
        private final UnaryCallSettings.Builder<SetMaintenancePolicyRequest, Operation> setMaintenancePolicySettings;
        private final PagedCallSettings.Builder<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse, ClusterManagerClient.ListUsableSubnetworksPagedResponse> listUsableSubnetworksSettings;
        private final UnaryCallSettings.Builder<CheckAutopilotCompatibilityRequest, CheckAutopilotCompatibilityResponse> checkAutopilotCompatibilitySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listClustersSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateNodePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setNodePoolAutoscalingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLoggingServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setMonitoringServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setAddonsConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLocationsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateMasterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setMasterAuthSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listOperationsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cancelOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getServerConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getJSONWebKeysSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listNodePoolsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getNodePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createNodePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteNodePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.completeNodePoolUpgradeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.rollbackNodePoolUpgradeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setNodePoolManagementSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLabelsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLegacyAbacSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startIPRotationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.completeIPRotationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setNodePoolSizeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setNetworkPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setMaintenancePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listUsableSubnetworksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_USABLE_SUBNETWORKS_PAGE_STR_FACT);
            this.checkAutopilotCompatibilitySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listClustersSettings, this.getClusterSettings, this.createClusterSettings, this.updateClusterSettings, this.updateNodePoolSettings, this.setNodePoolAutoscalingSettings, this.setLoggingServiceSettings, this.setMonitoringServiceSettings, this.setAddonsConfigSettings, this.setLocationsSettings, this.updateMasterSettings, this.setMasterAuthSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteClusterSettings, this.listOperationsSettings, this.getOperationSettings, this.cancelOperationSettings, this.getServerConfigSettings, this.getJSONWebKeysSettings, this.listNodePoolsSettings, this.getNodePoolSettings, this.createNodePoolSettings, this.deleteNodePoolSettings, this.completeNodePoolUpgradeSettings, this.rollbackNodePoolUpgradeSettings, this.setNodePoolManagementSettings, this.setLabelsSettings, this.setLegacyAbacSettings, this.startIPRotationSettings, this.completeIPRotationSettings, this.setNodePoolSizeSettings, this.setNetworkPolicySettings, this.setMaintenancePolicySettings, this.listUsableSubnetworksSettings, this.checkAutopilotCompatibilitySettings});
            Builder.initDefaults(this);
        }

        protected Builder(ClusterManagerStubSettings settings) {
            super((StubSettings)settings);
            this.listClustersSettings = settings.listClustersSettings.toBuilder();
            this.getClusterSettings = settings.getClusterSettings.toBuilder();
            this.createClusterSettings = settings.createClusterSettings.toBuilder();
            this.updateClusterSettings = settings.updateClusterSettings.toBuilder();
            this.updateNodePoolSettings = settings.updateNodePoolSettings.toBuilder();
            this.setNodePoolAutoscalingSettings = settings.setNodePoolAutoscalingSettings.toBuilder();
            this.setLoggingServiceSettings = settings.setLoggingServiceSettings.toBuilder();
            this.setMonitoringServiceSettings = settings.setMonitoringServiceSettings.toBuilder();
            this.setAddonsConfigSettings = settings.setAddonsConfigSettings.toBuilder();
            this.setLocationsSettings = settings.setLocationsSettings.toBuilder();
            this.updateMasterSettings = settings.updateMasterSettings.toBuilder();
            this.setMasterAuthSettings = settings.setMasterAuthSettings.toBuilder();
            this.deleteClusterSettings = settings.deleteClusterSettings.toBuilder();
            this.listOperationsSettings = settings.listOperationsSettings.toBuilder();
            this.getOperationSettings = settings.getOperationSettings.toBuilder();
            this.cancelOperationSettings = settings.cancelOperationSettings.toBuilder();
            this.getServerConfigSettings = settings.getServerConfigSettings.toBuilder();
            this.getJSONWebKeysSettings = settings.getJSONWebKeysSettings.toBuilder();
            this.listNodePoolsSettings = settings.listNodePoolsSettings.toBuilder();
            this.getNodePoolSettings = settings.getNodePoolSettings.toBuilder();
            this.createNodePoolSettings = settings.createNodePoolSettings.toBuilder();
            this.deleteNodePoolSettings = settings.deleteNodePoolSettings.toBuilder();
            this.completeNodePoolUpgradeSettings = settings.completeNodePoolUpgradeSettings.toBuilder();
            this.rollbackNodePoolUpgradeSettings = settings.rollbackNodePoolUpgradeSettings.toBuilder();
            this.setNodePoolManagementSettings = settings.setNodePoolManagementSettings.toBuilder();
            this.setLabelsSettings = settings.setLabelsSettings.toBuilder();
            this.setLegacyAbacSettings = settings.setLegacyAbacSettings.toBuilder();
            this.startIPRotationSettings = settings.startIPRotationSettings.toBuilder();
            this.completeIPRotationSettings = settings.completeIPRotationSettings.toBuilder();
            this.setNodePoolSizeSettings = settings.setNodePoolSizeSettings.toBuilder();
            this.setNetworkPolicySettings = settings.setNetworkPolicySettings.toBuilder();
            this.setMaintenancePolicySettings = settings.setMaintenancePolicySettings.toBuilder();
            this.listUsableSubnetworksSettings = settings.listUsableSubnetworksSettings.toBuilder();
            this.checkAutopilotCompatibilitySettings = settings.checkAutopilotCompatibilitySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listClustersSettings, this.getClusterSettings, this.createClusterSettings, this.updateClusterSettings, this.updateNodePoolSettings, this.setNodePoolAutoscalingSettings, this.setLoggingServiceSettings, this.setMonitoringServiceSettings, this.setAddonsConfigSettings, this.setLocationsSettings, this.updateMasterSettings, this.setMasterAuthSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteClusterSettings, this.listOperationsSettings, this.getOperationSettings, this.cancelOperationSettings, this.getServerConfigSettings, this.getJSONWebKeysSettings, this.listNodePoolsSettings, this.getNodePoolSettings, this.createNodePoolSettings, this.deleteNodePoolSettings, this.completeNodePoolUpgradeSettings, this.rollbackNodePoolUpgradeSettings, this.setNodePoolManagementSettings, this.setLabelsSettings, this.setLegacyAbacSettings, this.startIPRotationSettings, this.completeIPRotationSettings, this.setNodePoolSizeSettings, this.setNetworkPolicySettings, this.setMaintenancePolicySettings, this.listUsableSubnetworksSettings, this.checkAutopilotCompatibilitySettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ClusterManagerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ClusterManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ClusterManagerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ClusterManagerStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ClusterManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listClustersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateNodePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setNodePoolAutoscalingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setLoggingServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setMonitoringServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setAddonsConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateMasterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setMasterAuthSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listOperationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.cancelOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getServerConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getJSONWebKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listNodePoolsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getNodePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createNodePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteNodePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.completeNodePoolUpgradeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.rollbackNodePoolUpgradeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setNodePoolManagementSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setLabelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setLegacyAbacSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.startIPRotationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.completeIPRotationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setNodePoolSizeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setNetworkPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setMaintenancePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listUsableSubnetworksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.checkAutopilotCompatibilitySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ListClustersRequest, ListClustersResponse> listClustersSettings() {
            return this.listClustersSettings;
        }

        public UnaryCallSettings.Builder<GetClusterRequest, Cluster> getClusterSettings() {
            return this.getClusterSettings;
        }

        public UnaryCallSettings.Builder<CreateClusterRequest, Operation> createClusterSettings() {
            return this.createClusterSettings;
        }

        public UnaryCallSettings.Builder<UpdateClusterRequest, Operation> updateClusterSettings() {
            return this.updateClusterSettings;
        }

        public UnaryCallSettings.Builder<UpdateNodePoolRequest, Operation> updateNodePoolSettings() {
            return this.updateNodePoolSettings;
        }

        public UnaryCallSettings.Builder<SetNodePoolAutoscalingRequest, Operation> setNodePoolAutoscalingSettings() {
            return this.setNodePoolAutoscalingSettings;
        }

        public UnaryCallSettings.Builder<SetLoggingServiceRequest, Operation> setLoggingServiceSettings() {
            return this.setLoggingServiceSettings;
        }

        public UnaryCallSettings.Builder<SetMonitoringServiceRequest, Operation> setMonitoringServiceSettings() {
            return this.setMonitoringServiceSettings;
        }

        public UnaryCallSettings.Builder<SetAddonsConfigRequest, Operation> setAddonsConfigSettings() {
            return this.setAddonsConfigSettings;
        }

        @Deprecated
        public UnaryCallSettings.Builder<SetLocationsRequest, Operation> setLocationsSettings() {
            return this.setLocationsSettings;
        }

        public UnaryCallSettings.Builder<UpdateMasterRequest, Operation> updateMasterSettings() {
            return this.updateMasterSettings;
        }

        public UnaryCallSettings.Builder<SetMasterAuthRequest, Operation> setMasterAuthSettings() {
            return this.setMasterAuthSettings;
        }

        public UnaryCallSettings.Builder<DeleteClusterRequest, Operation> deleteClusterSettings() {
            return this.deleteClusterSettings;
        }

        public UnaryCallSettings.Builder<ListOperationsRequest, ListOperationsResponse> listOperationsSettings() {
            return this.listOperationsSettings;
        }

        public UnaryCallSettings.Builder<GetOperationRequest, Operation> getOperationSettings() {
            return this.getOperationSettings;
        }

        public UnaryCallSettings.Builder<CancelOperationRequest, Empty> cancelOperationSettings() {
            return this.cancelOperationSettings;
        }

        public UnaryCallSettings.Builder<GetServerConfigRequest, ServerConfig> getServerConfigSettings() {
            return this.getServerConfigSettings;
        }

        public UnaryCallSettings.Builder<GetJSONWebKeysRequest, GetJSONWebKeysResponse> getJSONWebKeysSettings() {
            return this.getJSONWebKeysSettings;
        }

        public UnaryCallSettings.Builder<ListNodePoolsRequest, ListNodePoolsResponse> listNodePoolsSettings() {
            return this.listNodePoolsSettings;
        }

        public UnaryCallSettings.Builder<GetNodePoolRequest, NodePool> getNodePoolSettings() {
            return this.getNodePoolSettings;
        }

        public UnaryCallSettings.Builder<CreateNodePoolRequest, Operation> createNodePoolSettings() {
            return this.createNodePoolSettings;
        }

        public UnaryCallSettings.Builder<DeleteNodePoolRequest, Operation> deleteNodePoolSettings() {
            return this.deleteNodePoolSettings;
        }

        public UnaryCallSettings.Builder<CompleteNodePoolUpgradeRequest, Empty> completeNodePoolUpgradeSettings() {
            return this.completeNodePoolUpgradeSettings;
        }

        public UnaryCallSettings.Builder<RollbackNodePoolUpgradeRequest, Operation> rollbackNodePoolUpgradeSettings() {
            return this.rollbackNodePoolUpgradeSettings;
        }

        public UnaryCallSettings.Builder<SetNodePoolManagementRequest, Operation> setNodePoolManagementSettings() {
            return this.setNodePoolManagementSettings;
        }

        public UnaryCallSettings.Builder<SetLabelsRequest, Operation> setLabelsSettings() {
            return this.setLabelsSettings;
        }

        public UnaryCallSettings.Builder<SetLegacyAbacRequest, Operation> setLegacyAbacSettings() {
            return this.setLegacyAbacSettings;
        }

        public UnaryCallSettings.Builder<StartIPRotationRequest, Operation> startIPRotationSettings() {
            return this.startIPRotationSettings;
        }

        public UnaryCallSettings.Builder<CompleteIPRotationRequest, Operation> completeIPRotationSettings() {
            return this.completeIPRotationSettings;
        }

        public UnaryCallSettings.Builder<SetNodePoolSizeRequest, Operation> setNodePoolSizeSettings() {
            return this.setNodePoolSizeSettings;
        }

        public UnaryCallSettings.Builder<SetNetworkPolicyRequest, Operation> setNetworkPolicySettings() {
            return this.setNetworkPolicySettings;
        }

        public UnaryCallSettings.Builder<SetMaintenancePolicyRequest, Operation> setMaintenancePolicySettings() {
            return this.setMaintenancePolicySettings;
        }

        public PagedCallSettings.Builder<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse, ClusterManagerClient.ListUsableSubnetworksPagedResponse> listUsableSubnetworksSettings() {
            return this.listUsableSubnetworksSettings;
        }

        public UnaryCallSettings.Builder<CheckAutopilotCompatibilityRequest, CheckAutopilotCompatibilityResponse> checkAutopilotCompatibilitySettings() {
            return this.checkAutopilotCompatibilitySettings;
        }

        public ClusterManagerStubSettings build() throws IOException {
            return new ClusterManagerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)20000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)45000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)45000L)).setTotalTimeout(Duration.ofMillis((long)45000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

