/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.container.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.container.v1.ClusterManagerSettings;
import com.google.cloud.container.v1.stub.ClusterManagerStub;
import com.google.cloud.container.v1.stub.ClusterManagerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.container.v1.AddonsConfig;
import com.google.container.v1.CancelOperationRequest;
import com.google.container.v1.Cluster;
import com.google.container.v1.ClusterUpdate;
import com.google.container.v1.CompleteIPRotationRequest;
import com.google.container.v1.CreateClusterRequest;
import com.google.container.v1.CreateNodePoolRequest;
import com.google.container.v1.DeleteClusterRequest;
import com.google.container.v1.DeleteNodePoolRequest;
import com.google.container.v1.GetClusterRequest;
import com.google.container.v1.GetJSONWebKeysRequest;
import com.google.container.v1.GetJSONWebKeysResponse;
import com.google.container.v1.GetNodePoolRequest;
import com.google.container.v1.GetOperationRequest;
import com.google.container.v1.GetServerConfigRequest;
import com.google.container.v1.ListClustersRequest;
import com.google.container.v1.ListClustersResponse;
import com.google.container.v1.ListNodePoolsRequest;
import com.google.container.v1.ListNodePoolsResponse;
import com.google.container.v1.ListOperationsRequest;
import com.google.container.v1.ListOperationsResponse;
import com.google.container.v1.ListUsableSubnetworksRequest;
import com.google.container.v1.ListUsableSubnetworksResponse;
import com.google.container.v1.MaintenancePolicy;
import com.google.container.v1.NetworkPolicy;
import com.google.container.v1.NodePool;
import com.google.container.v1.Operation;
import com.google.container.v1.RollbackNodePoolUpgradeRequest;
import com.google.container.v1.ServerConfig;
import com.google.container.v1.SetAddonsConfigRequest;
import com.google.container.v1.SetLabelsRequest;
import com.google.container.v1.SetLegacyAbacRequest;
import com.google.container.v1.SetLocationsRequest;
import com.google.container.v1.SetLoggingServiceRequest;
import com.google.container.v1.SetMaintenancePolicyRequest;
import com.google.container.v1.SetMasterAuthRequest;
import com.google.container.v1.SetMonitoringServiceRequest;
import com.google.container.v1.SetNetworkPolicyRequest;
import com.google.container.v1.SetNodePoolAutoscalingRequest;
import com.google.container.v1.SetNodePoolManagementRequest;
import com.google.container.v1.SetNodePoolSizeRequest;
import com.google.container.v1.StartIPRotationRequest;
import com.google.container.v1.UpdateClusterRequest;
import com.google.container.v1.UpdateMasterRequest;
import com.google.container.v1.UpdateNodePoolRequest;
import com.google.container.v1.UsableSubnetwork;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ClusterManagerClient
implements BackgroundResource {
    private final ClusterManagerSettings settings;
    private final ClusterManagerStub stub;

    public static final ClusterManagerClient create() throws IOException {
        return ClusterManagerClient.create(ClusterManagerSettings.newBuilder().build());
    }

    public static final ClusterManagerClient create(ClusterManagerSettings settings) throws IOException {
        return new ClusterManagerClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ClusterManagerClient create(ClusterManagerStub stub) {
        return new ClusterManagerClient(stub);
    }

    protected ClusterManagerClient(ClusterManagerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ClusterManagerStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ClusterManagerClient(ClusterManagerStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ClusterManagerSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ClusterManagerStub getStub() {
        return this.stub;
    }

    public final ListClustersResponse listClusters(String parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent).build();
        return this.listClusters(request);
    }

    public final ListClustersResponse listClusters(String projectId, String zone) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setProjectId(projectId).setZone(zone).build();
        return this.listClusters(request);
    }

    public final ListClustersResponse listClusters(ListClustersRequest request) {
        return (ListClustersResponse)this.listClustersCallable().call((Object)request);
    }

    public final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.stub.listClustersCallable();
    }

    public final Cluster getCluster(String name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(String projectId, String zone, String clusterId) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(GetClusterRequest request) {
        return (Cluster)this.getClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.stub.getClusterCallable();
    }

    public final Operation createCluster(String parent, Cluster cluster) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent).setCluster(cluster).build();
        return this.createCluster(request);
    }

    public final Operation createCluster(String projectId, String zone, Cluster cluster) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setProjectId(projectId).setZone(zone).setCluster(cluster).build();
        return this.createCluster(request);
    }

    public final Operation createCluster(CreateClusterRequest request) {
        return (Operation)this.createClusterCallable().call((Object)request);
    }

    public final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.stub.createClusterCallable();
    }

    public final Operation updateCluster(String name, ClusterUpdate update) {
        UpdateClusterRequest request = UpdateClusterRequest.newBuilder().setName(name).setUpdate(update).build();
        return this.updateCluster(request);
    }

    public final Operation updateCluster(String projectId, String zone, String clusterId, ClusterUpdate update) {
        UpdateClusterRequest request = UpdateClusterRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).setUpdate(update).build();
        return this.updateCluster(request);
    }

    public final Operation updateCluster(UpdateClusterRequest request) {
        return (Operation)this.updateClusterCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable() {
        return this.stub.updateClusterCallable();
    }

    public final Operation updateNodePool(UpdateNodePoolRequest request) {
        return (Operation)this.updateNodePoolCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateNodePoolRequest, Operation> updateNodePoolCallable() {
        return this.stub.updateNodePoolCallable();
    }

    public final Operation setNodePoolAutoscaling(SetNodePoolAutoscalingRequest request) {
        return (Operation)this.setNodePoolAutoscalingCallable().call((Object)request);
    }

    public final UnaryCallable<SetNodePoolAutoscalingRequest, Operation> setNodePoolAutoscalingCallable() {
        return this.stub.setNodePoolAutoscalingCallable();
    }

    public final Operation setLoggingService(String name, String loggingService) {
        SetLoggingServiceRequest request = SetLoggingServiceRequest.newBuilder().setName(name).setLoggingService(loggingService).build();
        return this.setLoggingService(request);
    }

    public final Operation setLoggingService(String projectId, String zone, String clusterId, String loggingService) {
        SetLoggingServiceRequest request = SetLoggingServiceRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).setLoggingService(loggingService).build();
        return this.setLoggingService(request);
    }

    public final Operation setLoggingService(SetLoggingServiceRequest request) {
        return (Operation)this.setLoggingServiceCallable().call((Object)request);
    }

    public final UnaryCallable<SetLoggingServiceRequest, Operation> setLoggingServiceCallable() {
        return this.stub.setLoggingServiceCallable();
    }

    public final Operation setMonitoringService(String name, String monitoringService) {
        SetMonitoringServiceRequest request = SetMonitoringServiceRequest.newBuilder().setName(name).setMonitoringService(monitoringService).build();
        return this.setMonitoringService(request);
    }

    public final Operation setMonitoringService(String projectId, String zone, String clusterId, String monitoringService) {
        SetMonitoringServiceRequest request = SetMonitoringServiceRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).setMonitoringService(monitoringService).build();
        return this.setMonitoringService(request);
    }

    public final Operation setMonitoringService(SetMonitoringServiceRequest request) {
        return (Operation)this.setMonitoringServiceCallable().call((Object)request);
    }

    public final UnaryCallable<SetMonitoringServiceRequest, Operation> setMonitoringServiceCallable() {
        return this.stub.setMonitoringServiceCallable();
    }

    public final Operation setAddonsConfig(String name, AddonsConfig addonsConfig) {
        SetAddonsConfigRequest request = SetAddonsConfigRequest.newBuilder().setName(name).setAddonsConfig(addonsConfig).build();
        return this.setAddonsConfig(request);
    }

    public final Operation setAddonsConfig(String projectId, String zone, String clusterId, AddonsConfig addonsConfig) {
        SetAddonsConfigRequest request = SetAddonsConfigRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).setAddonsConfig(addonsConfig).build();
        return this.setAddonsConfig(request);
    }

    public final Operation setAddonsConfig(SetAddonsConfigRequest request) {
        return (Operation)this.setAddonsConfigCallable().call((Object)request);
    }

    public final UnaryCallable<SetAddonsConfigRequest, Operation> setAddonsConfigCallable() {
        return this.stub.setAddonsConfigCallable();
    }

    public final Operation setLocations(String name, List<String> locations) {
        SetLocationsRequest request = SetLocationsRequest.newBuilder().setName(name).addAllLocations(locations).build();
        return this.setLocations(request);
    }

    public final Operation setLocations(String projectId, String zone, String clusterId, List<String> locations) {
        SetLocationsRequest request = SetLocationsRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).addAllLocations(locations).build();
        return this.setLocations(request);
    }

    public final Operation setLocations(SetLocationsRequest request) {
        return (Operation)this.setLocationsCallable().call((Object)request);
    }

    public final UnaryCallable<SetLocationsRequest, Operation> setLocationsCallable() {
        return this.stub.setLocationsCallable();
    }

    public final Operation updateMaster(String name, String masterVersion) {
        UpdateMasterRequest request = UpdateMasterRequest.newBuilder().setName(name).setMasterVersion(masterVersion).build();
        return this.updateMaster(request);
    }

    public final Operation updateMaster(String projectId, String zone, String clusterId, String masterVersion) {
        UpdateMasterRequest request = UpdateMasterRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).setMasterVersion(masterVersion).build();
        return this.updateMaster(request);
    }

    public final Operation updateMaster(UpdateMasterRequest request) {
        return (Operation)this.updateMasterCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateMasterRequest, Operation> updateMasterCallable() {
        return this.stub.updateMasterCallable();
    }

    public final Operation setMasterAuth(SetMasterAuthRequest request) {
        return (Operation)this.setMasterAuthCallable().call((Object)request);
    }

    public final UnaryCallable<SetMasterAuthRequest, Operation> setMasterAuthCallable() {
        return this.stub.setMasterAuthCallable();
    }

    public final Operation deleteCluster(String name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name).build();
        return this.deleteCluster(request);
    }

    public final Operation deleteCluster(String projectId, String zone, String clusterId) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).build();
        return this.deleteCluster(request);
    }

    public final Operation deleteCluster(DeleteClusterRequest request) {
        return (Operation)this.deleteClusterCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable() {
        return this.stub.deleteClusterCallable();
    }

    public final ListOperationsResponse listOperations(String projectId, String zone) {
        ListOperationsRequest request = ListOperationsRequest.newBuilder().setProjectId(projectId).setZone(zone).build();
        return this.listOperations(request);
    }

    public final ListOperationsResponse listOperations(ListOperationsRequest request) {
        return (ListOperationsResponse)this.listOperationsCallable().call((Object)request);
    }

    public final UnaryCallable<ListOperationsRequest, ListOperationsResponse> listOperationsCallable() {
        return this.stub.listOperationsCallable();
    }

    public final Operation getOperation(String name) {
        GetOperationRequest request = GetOperationRequest.newBuilder().setName(name).build();
        return this.getOperation(request);
    }

    public final Operation getOperation(String projectId, String zone, String operationId) {
        GetOperationRequest request = GetOperationRequest.newBuilder().setProjectId(projectId).setZone(zone).setOperationId(operationId).build();
        return this.getOperation(request);
    }

    public final Operation getOperation(GetOperationRequest request) {
        return (Operation)this.getOperationCallable().call((Object)request);
    }

    public final UnaryCallable<GetOperationRequest, Operation> getOperationCallable() {
        return this.stub.getOperationCallable();
    }

    public final void cancelOperation(String name) {
        CancelOperationRequest request = CancelOperationRequest.newBuilder().setName(name).build();
        this.cancelOperation(request);
    }

    public final void cancelOperation(String projectId, String zone, String operationId) {
        CancelOperationRequest request = CancelOperationRequest.newBuilder().setProjectId(projectId).setZone(zone).setOperationId(operationId).build();
        this.cancelOperation(request);
    }

    public final void cancelOperation(CancelOperationRequest request) {
        this.cancelOperationCallable().call((Object)request);
    }

    public final UnaryCallable<CancelOperationRequest, Empty> cancelOperationCallable() {
        return this.stub.cancelOperationCallable();
    }

    public final ServerConfig getServerConfig(String name) {
        GetServerConfigRequest request = GetServerConfigRequest.newBuilder().setName(name).build();
        return this.getServerConfig(request);
    }

    public final ServerConfig getServerConfig(String projectId, String zone) {
        GetServerConfigRequest request = GetServerConfigRequest.newBuilder().setProjectId(projectId).setZone(zone).build();
        return this.getServerConfig(request);
    }

    public final ServerConfig getServerConfig(GetServerConfigRequest request) {
        return (ServerConfig)this.getServerConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetServerConfigRequest, ServerConfig> getServerConfigCallable() {
        return this.stub.getServerConfigCallable();
    }

    public final GetJSONWebKeysResponse getJSONWebKeys(GetJSONWebKeysRequest request) {
        return (GetJSONWebKeysResponse)this.getJSONWebKeysCallable().call((Object)request);
    }

    public final UnaryCallable<GetJSONWebKeysRequest, GetJSONWebKeysResponse> getJSONWebKeysCallable() {
        return this.stub.getJSONWebKeysCallable();
    }

    public final ListNodePoolsResponse listNodePools(String parent) {
        ListNodePoolsRequest request = ListNodePoolsRequest.newBuilder().setParent(parent).build();
        return this.listNodePools(request);
    }

    public final ListNodePoolsResponse listNodePools(String projectId, String zone, String clusterId) {
        ListNodePoolsRequest request = ListNodePoolsRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).build();
        return this.listNodePools(request);
    }

    public final ListNodePoolsResponse listNodePools(ListNodePoolsRequest request) {
        return (ListNodePoolsResponse)this.listNodePoolsCallable().call((Object)request);
    }

    public final UnaryCallable<ListNodePoolsRequest, ListNodePoolsResponse> listNodePoolsCallable() {
        return this.stub.listNodePoolsCallable();
    }

    public final NodePool getNodePool(String name) {
        GetNodePoolRequest request = GetNodePoolRequest.newBuilder().setName(name).build();
        return this.getNodePool(request);
    }

    public final NodePool getNodePool(String projectId, String zone, String clusterId, String nodePoolId) {
        GetNodePoolRequest request = GetNodePoolRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).setNodePoolId(nodePoolId).build();
        return this.getNodePool(request);
    }

    public final NodePool getNodePool(GetNodePoolRequest request) {
        return (NodePool)this.getNodePoolCallable().call((Object)request);
    }

    public final UnaryCallable<GetNodePoolRequest, NodePool> getNodePoolCallable() {
        return this.stub.getNodePoolCallable();
    }

    public final Operation createNodePool(String parent, NodePool nodePool) {
        CreateNodePoolRequest request = CreateNodePoolRequest.newBuilder().setParent(parent).setNodePool(nodePool).build();
        return this.createNodePool(request);
    }

    public final Operation createNodePool(String projectId, String zone, String clusterId, NodePool nodePool) {
        CreateNodePoolRequest request = CreateNodePoolRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).setNodePool(nodePool).build();
        return this.createNodePool(request);
    }

    public final Operation createNodePool(CreateNodePoolRequest request) {
        return (Operation)this.createNodePoolCallable().call((Object)request);
    }

    public final UnaryCallable<CreateNodePoolRequest, Operation> createNodePoolCallable() {
        return this.stub.createNodePoolCallable();
    }

    public final Operation deleteNodePool(String name) {
        DeleteNodePoolRequest request = DeleteNodePoolRequest.newBuilder().setName(name).build();
        return this.deleteNodePool(request);
    }

    public final Operation deleteNodePool(String projectId, String zone, String clusterId, String nodePoolId) {
        DeleteNodePoolRequest request = DeleteNodePoolRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).setNodePoolId(nodePoolId).build();
        return this.deleteNodePool(request);
    }

    public final Operation deleteNodePool(DeleteNodePoolRequest request) {
        return (Operation)this.deleteNodePoolCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteNodePoolRequest, Operation> deleteNodePoolCallable() {
        return this.stub.deleteNodePoolCallable();
    }

    public final Operation rollbackNodePoolUpgrade(String name) {
        RollbackNodePoolUpgradeRequest request = RollbackNodePoolUpgradeRequest.newBuilder().setName(name).build();
        return this.rollbackNodePoolUpgrade(request);
    }

    public final Operation rollbackNodePoolUpgrade(String projectId, String zone, String clusterId, String nodePoolId) {
        RollbackNodePoolUpgradeRequest request = RollbackNodePoolUpgradeRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).setNodePoolId(nodePoolId).build();
        return this.rollbackNodePoolUpgrade(request);
    }

    public final Operation rollbackNodePoolUpgrade(RollbackNodePoolUpgradeRequest request) {
        return (Operation)this.rollbackNodePoolUpgradeCallable().call((Object)request);
    }

    public final UnaryCallable<RollbackNodePoolUpgradeRequest, Operation> rollbackNodePoolUpgradeCallable() {
        return this.stub.rollbackNodePoolUpgradeCallable();
    }

    public final Operation setNodePoolManagement(SetNodePoolManagementRequest request) {
        return (Operation)this.setNodePoolManagementCallable().call((Object)request);
    }

    public final UnaryCallable<SetNodePoolManagementRequest, Operation> setNodePoolManagementCallable() {
        return this.stub.setNodePoolManagementCallable();
    }

    public final Operation setLabels(SetLabelsRequest request) {
        return (Operation)this.setLabelsCallable().call((Object)request);
    }

    public final UnaryCallable<SetLabelsRequest, Operation> setLabelsCallable() {
        return this.stub.setLabelsCallable();
    }

    public final Operation setLegacyAbac(String name, boolean enabled) {
        SetLegacyAbacRequest request = SetLegacyAbacRequest.newBuilder().setName(name).setEnabled(enabled).build();
        return this.setLegacyAbac(request);
    }

    public final Operation setLegacyAbac(String projectId, String zone, String clusterId, boolean enabled) {
        SetLegacyAbacRequest request = SetLegacyAbacRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).setEnabled(enabled).build();
        return this.setLegacyAbac(request);
    }

    public final Operation setLegacyAbac(SetLegacyAbacRequest request) {
        return (Operation)this.setLegacyAbacCallable().call((Object)request);
    }

    public final UnaryCallable<SetLegacyAbacRequest, Operation> setLegacyAbacCallable() {
        return this.stub.setLegacyAbacCallable();
    }

    public final Operation startIPRotation(String name) {
        StartIPRotationRequest request = StartIPRotationRequest.newBuilder().setName(name).build();
        return this.startIPRotation(request);
    }

    public final Operation startIPRotation(String projectId, String zone, String clusterId) {
        StartIPRotationRequest request = StartIPRotationRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).build();
        return this.startIPRotation(request);
    }

    public final Operation startIPRotation(StartIPRotationRequest request) {
        return (Operation)this.startIPRotationCallable().call((Object)request);
    }

    public final UnaryCallable<StartIPRotationRequest, Operation> startIPRotationCallable() {
        return this.stub.startIPRotationCallable();
    }

    public final Operation completeIPRotation(String name) {
        CompleteIPRotationRequest request = CompleteIPRotationRequest.newBuilder().setName(name).build();
        return this.completeIPRotation(request);
    }

    public final Operation completeIPRotation(String projectId, String zone, String clusterId) {
        CompleteIPRotationRequest request = CompleteIPRotationRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).build();
        return this.completeIPRotation(request);
    }

    public final Operation completeIPRotation(CompleteIPRotationRequest request) {
        return (Operation)this.completeIPRotationCallable().call((Object)request);
    }

    public final UnaryCallable<CompleteIPRotationRequest, Operation> completeIPRotationCallable() {
        return this.stub.completeIPRotationCallable();
    }

    public final Operation setNodePoolSize(SetNodePoolSizeRequest request) {
        return (Operation)this.setNodePoolSizeCallable().call((Object)request);
    }

    public final UnaryCallable<SetNodePoolSizeRequest, Operation> setNodePoolSizeCallable() {
        return this.stub.setNodePoolSizeCallable();
    }

    public final Operation setNetworkPolicy(String name, NetworkPolicy networkPolicy) {
        SetNetworkPolicyRequest request = SetNetworkPolicyRequest.newBuilder().setName(name).setNetworkPolicy(networkPolicy).build();
        return this.setNetworkPolicy(request);
    }

    public final Operation setNetworkPolicy(String projectId, String zone, String clusterId, NetworkPolicy networkPolicy) {
        SetNetworkPolicyRequest request = SetNetworkPolicyRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).setNetworkPolicy(networkPolicy).build();
        return this.setNetworkPolicy(request);
    }

    public final Operation setNetworkPolicy(SetNetworkPolicyRequest request) {
        return (Operation)this.setNetworkPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetNetworkPolicyRequest, Operation> setNetworkPolicyCallable() {
        return this.stub.setNetworkPolicyCallable();
    }

    public final Operation setMaintenancePolicy(String name, MaintenancePolicy maintenancePolicy) {
        SetMaintenancePolicyRequest request = SetMaintenancePolicyRequest.newBuilder().setName(name).setMaintenancePolicy(maintenancePolicy).build();
        return this.setMaintenancePolicy(request);
    }

    public final Operation setMaintenancePolicy(String projectId, String zone, String clusterId, MaintenancePolicy maintenancePolicy) {
        SetMaintenancePolicyRequest request = SetMaintenancePolicyRequest.newBuilder().setProjectId(projectId).setZone(zone).setClusterId(clusterId).setMaintenancePolicy(maintenancePolicy).build();
        return this.setMaintenancePolicy(request);
    }

    public final Operation setMaintenancePolicy(SetMaintenancePolicyRequest request) {
        return (Operation)this.setMaintenancePolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetMaintenancePolicyRequest, Operation> setMaintenancePolicyCallable() {
        return this.stub.setMaintenancePolicyCallable();
    }

    public final ListUsableSubnetworksPagedResponse listUsableSubnetworks(ListUsableSubnetworksRequest request) {
        return (ListUsableSubnetworksPagedResponse)((Object)this.listUsableSubnetworksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListUsableSubnetworksRequest, ListUsableSubnetworksPagedResponse> listUsableSubnetworksPagedCallable() {
        return this.stub.listUsableSubnetworksPagedCallable();
    }

    public final UnaryCallable<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse> listUsableSubnetworksCallable() {
        return this.stub.listUsableSubnetworksCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListUsableSubnetworksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse, UsableSubnetwork, ListUsableSubnetworksPage, ListUsableSubnetworksFixedSizeCollection> {
        private ListUsableSubnetworksFixedSizeCollection(List<ListUsableSubnetworksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUsableSubnetworksFixedSizeCollection createEmptyCollection() {
            return new ListUsableSubnetworksFixedSizeCollection(null, 0);
        }

        protected ListUsableSubnetworksFixedSizeCollection createCollection(List<ListUsableSubnetworksPage> pages, int collectionSize) {
            return new ListUsableSubnetworksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUsableSubnetworksPage
    extends AbstractPage<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse, UsableSubnetwork, ListUsableSubnetworksPage> {
        private ListUsableSubnetworksPage(PageContext<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse, UsableSubnetwork> context, ListUsableSubnetworksResponse response) {
            super(context, (Object)response);
        }

        private static ListUsableSubnetworksPage createEmptyPage() {
            return new ListUsableSubnetworksPage(null, null);
        }

        protected ListUsableSubnetworksPage createPage(PageContext<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse, UsableSubnetwork> context, ListUsableSubnetworksResponse response) {
            return new ListUsableSubnetworksPage(context, response);
        }

        public ApiFuture<ListUsableSubnetworksPage> createPageAsync(PageContext<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse, UsableSubnetwork> context, ApiFuture<ListUsableSubnetworksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUsableSubnetworksPagedResponse
    extends AbstractPagedListResponse<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse, UsableSubnetwork, ListUsableSubnetworksPage, ListUsableSubnetworksFixedSizeCollection> {
        public static ApiFuture<ListUsableSubnetworksPagedResponse> createAsync(PageContext<ListUsableSubnetworksRequest, ListUsableSubnetworksResponse, UsableSubnetwork> context, ApiFuture<ListUsableSubnetworksResponse> futureResponse) {
            ApiFuture<ListUsableSubnetworksPage> futurePage = ListUsableSubnetworksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListUsableSubnetworksPage, ListUsableSubnetworksPagedResponse>(){

                public ListUsableSubnetworksPagedResponse apply(ListUsableSubnetworksPage input) {
                    return new ListUsableSubnetworksPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListUsableSubnetworksPagedResponse(ListUsableSubnetworksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListUsableSubnetworksFixedSizeCollection.createEmptyCollection());
        }
    }
}

