/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contactcenterinsights.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contactcenterinsights.v1.Analysis;
import com.google.cloud.contactcenterinsights.v1.AnalysisName;
import com.google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsRequest;
import com.google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsResponse;
import com.google.cloud.contactcenterinsights.v1.CalculateStatsRequest;
import com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse;
import com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsSettings;
import com.google.cloud.contactcenterinsights.v1.Conversation;
import com.google.cloud.contactcenterinsights.v1.ConversationName;
import com.google.cloud.contactcenterinsights.v1.CreateAnalysisOperationMetadata;
import com.google.cloud.contactcenterinsights.v1.CreateAnalysisRequest;
import com.google.cloud.contactcenterinsights.v1.CreateConversationRequest;
import com.google.cloud.contactcenterinsights.v1.CreatePhraseMatcherRequest;
import com.google.cloud.contactcenterinsights.v1.DeleteAnalysisRequest;
import com.google.cloud.contactcenterinsights.v1.DeleteConversationRequest;
import com.google.cloud.contactcenterinsights.v1.DeletePhraseMatcherRequest;
import com.google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata;
import com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest;
import com.google.cloud.contactcenterinsights.v1.ExportInsightsDataResponse;
import com.google.cloud.contactcenterinsights.v1.GetAnalysisRequest;
import com.google.cloud.contactcenterinsights.v1.GetConversationRequest;
import com.google.cloud.contactcenterinsights.v1.GetIssueModelRequest;
import com.google.cloud.contactcenterinsights.v1.GetIssueRequest;
import com.google.cloud.contactcenterinsights.v1.GetPhraseMatcherRequest;
import com.google.cloud.contactcenterinsights.v1.GetSettingsRequest;
import com.google.cloud.contactcenterinsights.v1.Issue;
import com.google.cloud.contactcenterinsights.v1.IssueModel;
import com.google.cloud.contactcenterinsights.v1.IssueModelName;
import com.google.cloud.contactcenterinsights.v1.IssueName;
import com.google.cloud.contactcenterinsights.v1.ListAnalysesRequest;
import com.google.cloud.contactcenterinsights.v1.ListAnalysesResponse;
import com.google.cloud.contactcenterinsights.v1.ListConversationsRequest;
import com.google.cloud.contactcenterinsights.v1.ListConversationsResponse;
import com.google.cloud.contactcenterinsights.v1.ListIssueModelsRequest;
import com.google.cloud.contactcenterinsights.v1.ListIssueModelsResponse;
import com.google.cloud.contactcenterinsights.v1.ListIssuesRequest;
import com.google.cloud.contactcenterinsights.v1.ListIssuesResponse;
import com.google.cloud.contactcenterinsights.v1.ListPhraseMatchersRequest;
import com.google.cloud.contactcenterinsights.v1.ListPhraseMatchersResponse;
import com.google.cloud.contactcenterinsights.v1.LocationName;
import com.google.cloud.contactcenterinsights.v1.PhraseMatcher;
import com.google.cloud.contactcenterinsights.v1.PhraseMatcherName;
import com.google.cloud.contactcenterinsights.v1.Settings;
import com.google.cloud.contactcenterinsights.v1.SettingsName;
import com.google.cloud.contactcenterinsights.v1.UpdateConversationRequest;
import com.google.cloud.contactcenterinsights.v1.UpdateSettingsRequest;
import com.google.cloud.contactcenterinsights.v1.stub.ContactCenterInsightsStub;
import com.google.cloud.contactcenterinsights.v1.stub.ContactCenterInsightsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ContactCenterInsightsClient
implements BackgroundResource {
    private final ContactCenterInsightsSettings settings;
    private final ContactCenterInsightsStub stub;
    private final OperationsClient operationsClient;

    public static final ContactCenterInsightsClient create() throws IOException {
        return ContactCenterInsightsClient.create(ContactCenterInsightsSettings.newBuilder().build());
    }

    public static final ContactCenterInsightsClient create(ContactCenterInsightsSettings settings) throws IOException {
        return new ContactCenterInsightsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ContactCenterInsightsClient create(ContactCenterInsightsStub stub) {
        return new ContactCenterInsightsClient(stub);
    }

    protected ContactCenterInsightsClient(ContactCenterInsightsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ContactCenterInsightsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ContactCenterInsightsClient(ContactCenterInsightsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ContactCenterInsightsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ContactCenterInsightsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Conversation createConversation(LocationName parent, Conversation conversation, String conversationId) {
        CreateConversationRequest request = CreateConversationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConversation(conversation).setConversationId(conversationId).build();
        return this.createConversation(request);
    }

    public final Conversation createConversation(String parent, Conversation conversation, String conversationId) {
        CreateConversationRequest request = CreateConversationRequest.newBuilder().setParent(parent).setConversation(conversation).setConversationId(conversationId).build();
        return this.createConversation(request);
    }

    public final Conversation createConversation(CreateConversationRequest request) {
        return (Conversation)this.createConversationCallable().call((Object)request);
    }

    public final UnaryCallable<CreateConversationRequest, Conversation> createConversationCallable() {
        return this.stub.createConversationCallable();
    }

    public final Conversation updateConversation(Conversation conversation, FieldMask updateMask) {
        UpdateConversationRequest request = UpdateConversationRequest.newBuilder().setConversation(conversation).setUpdateMask(updateMask).build();
        return this.updateConversation(request);
    }

    public final Conversation updateConversation(UpdateConversationRequest request) {
        return (Conversation)this.updateConversationCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateConversationRequest, Conversation> updateConversationCallable() {
        return this.stub.updateConversationCallable();
    }

    public final Conversation getConversation(ConversationName name) {
        GetConversationRequest request = GetConversationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConversation(request);
    }

    public final Conversation getConversation(String name) {
        GetConversationRequest request = GetConversationRequest.newBuilder().setName(name).build();
        return this.getConversation(request);
    }

    public final Conversation getConversation(GetConversationRequest request) {
        return (Conversation)this.getConversationCallable().call((Object)request);
    }

    public final UnaryCallable<GetConversationRequest, Conversation> getConversationCallable() {
        return this.stub.getConversationCallable();
    }

    public final ListConversationsPagedResponse listConversations(LocationName parent) {
        ListConversationsRequest request = ListConversationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConversations(request);
    }

    public final ListConversationsPagedResponse listConversations(String parent) {
        ListConversationsRequest request = ListConversationsRequest.newBuilder().setParent(parent).build();
        return this.listConversations(request);
    }

    public final ListConversationsPagedResponse listConversations(ListConversationsRequest request) {
        return (ListConversationsPagedResponse)((Object)this.listConversationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConversationsRequest, ListConversationsPagedResponse> listConversationsPagedCallable() {
        return this.stub.listConversationsPagedCallable();
    }

    public final UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable() {
        return this.stub.listConversationsCallable();
    }

    public final void deleteConversation(ConversationName name) {
        DeleteConversationRequest request = DeleteConversationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteConversation(request);
    }

    public final void deleteConversation(String name) {
        DeleteConversationRequest request = DeleteConversationRequest.newBuilder().setName(name).build();
        this.deleteConversation(request);
    }

    public final void deleteConversation(DeleteConversationRequest request) {
        this.deleteConversationCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteConversationRequest, Empty> deleteConversationCallable() {
        return this.stub.deleteConversationCallable();
    }

    public final OperationFuture<Analysis, CreateAnalysisOperationMetadata> createAnalysisAsync(ConversationName parent, Analysis analysis) {
        CreateAnalysisRequest request = CreateAnalysisRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAnalysis(analysis).build();
        return this.createAnalysisAsync(request);
    }

    public final OperationFuture<Analysis, CreateAnalysisOperationMetadata> createAnalysisAsync(String parent, Analysis analysis) {
        CreateAnalysisRequest request = CreateAnalysisRequest.newBuilder().setParent(parent).setAnalysis(analysis).build();
        return this.createAnalysisAsync(request);
    }

    public final OperationFuture<Analysis, CreateAnalysisOperationMetadata> createAnalysisAsync(CreateAnalysisRequest request) {
        return this.createAnalysisOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAnalysisRequest, Analysis, CreateAnalysisOperationMetadata> createAnalysisOperationCallable() {
        return this.stub.createAnalysisOperationCallable();
    }

    public final UnaryCallable<CreateAnalysisRequest, Operation> createAnalysisCallable() {
        return this.stub.createAnalysisCallable();
    }

    public final Analysis getAnalysis(AnalysisName name) {
        GetAnalysisRequest request = GetAnalysisRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAnalysis(request);
    }

    public final Analysis getAnalysis(String name) {
        GetAnalysisRequest request = GetAnalysisRequest.newBuilder().setName(name).build();
        return this.getAnalysis(request);
    }

    public final Analysis getAnalysis(GetAnalysisRequest request) {
        return (Analysis)this.getAnalysisCallable().call((Object)request);
    }

    public final UnaryCallable<GetAnalysisRequest, Analysis> getAnalysisCallable() {
        return this.stub.getAnalysisCallable();
    }

    public final ListAnalysesPagedResponse listAnalyses(ConversationName parent) {
        ListAnalysesRequest request = ListAnalysesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAnalyses(request);
    }

    public final ListAnalysesPagedResponse listAnalyses(String parent) {
        ListAnalysesRequest request = ListAnalysesRequest.newBuilder().setParent(parent).build();
        return this.listAnalyses(request);
    }

    public final ListAnalysesPagedResponse listAnalyses(ListAnalysesRequest request) {
        return (ListAnalysesPagedResponse)((Object)this.listAnalysesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAnalysesRequest, ListAnalysesPagedResponse> listAnalysesPagedCallable() {
        return this.stub.listAnalysesPagedCallable();
    }

    public final UnaryCallable<ListAnalysesRequest, ListAnalysesResponse> listAnalysesCallable() {
        return this.stub.listAnalysesCallable();
    }

    public final void deleteAnalysis(AnalysisName name) {
        DeleteAnalysisRequest request = DeleteAnalysisRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAnalysis(request);
    }

    public final void deleteAnalysis(String name) {
        DeleteAnalysisRequest request = DeleteAnalysisRequest.newBuilder().setName(name).build();
        this.deleteAnalysis(request);
    }

    public final void deleteAnalysis(DeleteAnalysisRequest request) {
        this.deleteAnalysisCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAnalysisRequest, Empty> deleteAnalysisCallable() {
        return this.stub.deleteAnalysisCallable();
    }

    public final OperationFuture<ExportInsightsDataResponse, ExportInsightsDataMetadata> exportInsightsDataAsync(LocationName parent) {
        ExportInsightsDataRequest request = ExportInsightsDataRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.exportInsightsDataAsync(request);
    }

    public final OperationFuture<ExportInsightsDataResponse, ExportInsightsDataMetadata> exportInsightsDataAsync(String parent) {
        ExportInsightsDataRequest request = ExportInsightsDataRequest.newBuilder().setParent(parent).build();
        return this.exportInsightsDataAsync(request);
    }

    public final OperationFuture<ExportInsightsDataResponse, ExportInsightsDataMetadata> exportInsightsDataAsync(ExportInsightsDataRequest request) {
        return this.exportInsightsDataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportInsightsDataRequest, ExportInsightsDataResponse, ExportInsightsDataMetadata> exportInsightsDataOperationCallable() {
        return this.stub.exportInsightsDataOperationCallable();
    }

    public final UnaryCallable<ExportInsightsDataRequest, Operation> exportInsightsDataCallable() {
        return this.stub.exportInsightsDataCallable();
    }

    public final IssueModel getIssueModel(IssueModelName name) {
        GetIssueModelRequest request = GetIssueModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getIssueModel(request);
    }

    public final IssueModel getIssueModel(String name) {
        GetIssueModelRequest request = GetIssueModelRequest.newBuilder().setName(name).build();
        return this.getIssueModel(request);
    }

    public final IssueModel getIssueModel(GetIssueModelRequest request) {
        return (IssueModel)this.getIssueModelCallable().call((Object)request);
    }

    public final UnaryCallable<GetIssueModelRequest, IssueModel> getIssueModelCallable() {
        return this.stub.getIssueModelCallable();
    }

    public final ListIssueModelsResponse listIssueModels(LocationName parent) {
        ListIssueModelsRequest request = ListIssueModelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listIssueModels(request);
    }

    public final ListIssueModelsResponse listIssueModels(String parent) {
        ListIssueModelsRequest request = ListIssueModelsRequest.newBuilder().setParent(parent).build();
        return this.listIssueModels(request);
    }

    public final ListIssueModelsResponse listIssueModels(ListIssueModelsRequest request) {
        return (ListIssueModelsResponse)this.listIssueModelsCallable().call((Object)request);
    }

    public final UnaryCallable<ListIssueModelsRequest, ListIssueModelsResponse> listIssueModelsCallable() {
        return this.stub.listIssueModelsCallable();
    }

    public final Issue getIssue(IssueName name) {
        GetIssueRequest request = GetIssueRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getIssue(request);
    }

    public final Issue getIssue(String name) {
        GetIssueRequest request = GetIssueRequest.newBuilder().setName(name).build();
        return this.getIssue(request);
    }

    public final Issue getIssue(GetIssueRequest request) {
        return (Issue)this.getIssueCallable().call((Object)request);
    }

    public final UnaryCallable<GetIssueRequest, Issue> getIssueCallable() {
        return this.stub.getIssueCallable();
    }

    public final ListIssuesResponse listIssues(IssueModelName parent) {
        ListIssuesRequest request = ListIssuesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listIssues(request);
    }

    public final ListIssuesResponse listIssues(String parent) {
        ListIssuesRequest request = ListIssuesRequest.newBuilder().setParent(parent).build();
        return this.listIssues(request);
    }

    public final ListIssuesResponse listIssues(ListIssuesRequest request) {
        return (ListIssuesResponse)this.listIssuesCallable().call((Object)request);
    }

    public final UnaryCallable<ListIssuesRequest, ListIssuesResponse> listIssuesCallable() {
        return this.stub.listIssuesCallable();
    }

    public final CalculateIssueModelStatsResponse calculateIssueModelStats(IssueModelName issueModel) {
        CalculateIssueModelStatsRequest request = CalculateIssueModelStatsRequest.newBuilder().setIssueModel(issueModel == null ? null : issueModel.toString()).build();
        return this.calculateIssueModelStats(request);
    }

    public final CalculateIssueModelStatsResponse calculateIssueModelStats(String issueModel) {
        CalculateIssueModelStatsRequest request = CalculateIssueModelStatsRequest.newBuilder().setIssueModel(issueModel).build();
        return this.calculateIssueModelStats(request);
    }

    public final CalculateIssueModelStatsResponse calculateIssueModelStats(CalculateIssueModelStatsRequest request) {
        return (CalculateIssueModelStatsResponse)this.calculateIssueModelStatsCallable().call((Object)request);
    }

    public final UnaryCallable<CalculateIssueModelStatsRequest, CalculateIssueModelStatsResponse> calculateIssueModelStatsCallable() {
        return this.stub.calculateIssueModelStatsCallable();
    }

    public final PhraseMatcher createPhraseMatcher(LocationName parent, PhraseMatcher phraseMatcher) {
        CreatePhraseMatcherRequest request = CreatePhraseMatcherRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPhraseMatcher(phraseMatcher).build();
        return this.createPhraseMatcher(request);
    }

    public final PhraseMatcher createPhraseMatcher(String parent, PhraseMatcher phraseMatcher) {
        CreatePhraseMatcherRequest request = CreatePhraseMatcherRequest.newBuilder().setParent(parent).setPhraseMatcher(phraseMatcher).build();
        return this.createPhraseMatcher(request);
    }

    public final PhraseMatcher createPhraseMatcher(CreatePhraseMatcherRequest request) {
        return (PhraseMatcher)this.createPhraseMatcherCallable().call((Object)request);
    }

    public final UnaryCallable<CreatePhraseMatcherRequest, PhraseMatcher> createPhraseMatcherCallable() {
        return this.stub.createPhraseMatcherCallable();
    }

    public final PhraseMatcher getPhraseMatcher(PhraseMatcherName name) {
        GetPhraseMatcherRequest request = GetPhraseMatcherRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPhraseMatcher(request);
    }

    public final PhraseMatcher getPhraseMatcher(String name) {
        GetPhraseMatcherRequest request = GetPhraseMatcherRequest.newBuilder().setName(name).build();
        return this.getPhraseMatcher(request);
    }

    public final PhraseMatcher getPhraseMatcher(GetPhraseMatcherRequest request) {
        return (PhraseMatcher)this.getPhraseMatcherCallable().call((Object)request);
    }

    public final UnaryCallable<GetPhraseMatcherRequest, PhraseMatcher> getPhraseMatcherCallable() {
        return this.stub.getPhraseMatcherCallable();
    }

    public final ListPhraseMatchersPagedResponse listPhraseMatchers(LocationName parent) {
        ListPhraseMatchersRequest request = ListPhraseMatchersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPhraseMatchers(request);
    }

    public final ListPhraseMatchersPagedResponse listPhraseMatchers(String parent) {
        ListPhraseMatchersRequest request = ListPhraseMatchersRequest.newBuilder().setParent(parent).build();
        return this.listPhraseMatchers(request);
    }

    public final ListPhraseMatchersPagedResponse listPhraseMatchers(ListPhraseMatchersRequest request) {
        return (ListPhraseMatchersPagedResponse)((Object)this.listPhraseMatchersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPhraseMatchersRequest, ListPhraseMatchersPagedResponse> listPhraseMatchersPagedCallable() {
        return this.stub.listPhraseMatchersPagedCallable();
    }

    public final UnaryCallable<ListPhraseMatchersRequest, ListPhraseMatchersResponse> listPhraseMatchersCallable() {
        return this.stub.listPhraseMatchersCallable();
    }

    public final void deletePhraseMatcher(PhraseMatcherName name) {
        DeletePhraseMatcherRequest request = DeletePhraseMatcherRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deletePhraseMatcher(request);
    }

    public final void deletePhraseMatcher(String name) {
        DeletePhraseMatcherRequest request = DeletePhraseMatcherRequest.newBuilder().setName(name).build();
        this.deletePhraseMatcher(request);
    }

    public final void deletePhraseMatcher(DeletePhraseMatcherRequest request) {
        this.deletePhraseMatcherCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePhraseMatcherRequest, Empty> deletePhraseMatcherCallable() {
        return this.stub.deletePhraseMatcherCallable();
    }

    public final CalculateStatsResponse calculateStats(LocationName location) {
        CalculateStatsRequest request = CalculateStatsRequest.newBuilder().setLocation(location == null ? null : location.toString()).build();
        return this.calculateStats(request);
    }

    public final CalculateStatsResponse calculateStats(String location) {
        CalculateStatsRequest request = CalculateStatsRequest.newBuilder().setLocation(location).build();
        return this.calculateStats(request);
    }

    public final CalculateStatsResponse calculateStats(CalculateStatsRequest request) {
        return (CalculateStatsResponse)this.calculateStatsCallable().call((Object)request);
    }

    public final UnaryCallable<CalculateStatsRequest, CalculateStatsResponse> calculateStatsCallable() {
        return this.stub.calculateStatsCallable();
    }

    public final Settings getSettings(SettingsName name) {
        GetSettingsRequest request = GetSettingsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSettings(request);
    }

    public final Settings getSettings(String name) {
        GetSettingsRequest request = GetSettingsRequest.newBuilder().setName(name).build();
        return this.getSettings(request);
    }

    public final Settings getSettings(GetSettingsRequest request) {
        return (Settings)this.getSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<GetSettingsRequest, Settings> getSettingsCallable() {
        return this.stub.getSettingsCallable();
    }

    public final Settings updateSettings(Settings settings, FieldMask updateMask) {
        UpdateSettingsRequest request = UpdateSettingsRequest.newBuilder().setSettings(settings).setUpdateMask(updateMask).build();
        return this.updateSettings(request);
    }

    public final Settings updateSettings(UpdateSettingsRequest request) {
        return (Settings)this.updateSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSettingsRequest, Settings> updateSettingsCallable() {
        return this.stub.updateSettingsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPhraseMatchersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPhraseMatchersRequest, ListPhraseMatchersResponse, PhraseMatcher, ListPhraseMatchersPage, ListPhraseMatchersFixedSizeCollection> {
        private ListPhraseMatchersFixedSizeCollection(List<ListPhraseMatchersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPhraseMatchersFixedSizeCollection createEmptyCollection() {
            return new ListPhraseMatchersFixedSizeCollection(null, 0);
        }

        protected ListPhraseMatchersFixedSizeCollection createCollection(List<ListPhraseMatchersPage> pages, int collectionSize) {
            return new ListPhraseMatchersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPhraseMatchersPage
    extends AbstractPage<ListPhraseMatchersRequest, ListPhraseMatchersResponse, PhraseMatcher, ListPhraseMatchersPage> {
        private ListPhraseMatchersPage(PageContext<ListPhraseMatchersRequest, ListPhraseMatchersResponse, PhraseMatcher> context, ListPhraseMatchersResponse response) {
            super(context, (Object)response);
        }

        private static ListPhraseMatchersPage createEmptyPage() {
            return new ListPhraseMatchersPage(null, null);
        }

        protected ListPhraseMatchersPage createPage(PageContext<ListPhraseMatchersRequest, ListPhraseMatchersResponse, PhraseMatcher> context, ListPhraseMatchersResponse response) {
            return new ListPhraseMatchersPage(context, response);
        }

        public ApiFuture<ListPhraseMatchersPage> createPageAsync(PageContext<ListPhraseMatchersRequest, ListPhraseMatchersResponse, PhraseMatcher> context, ApiFuture<ListPhraseMatchersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPhraseMatchersPagedResponse
    extends AbstractPagedListResponse<ListPhraseMatchersRequest, ListPhraseMatchersResponse, PhraseMatcher, ListPhraseMatchersPage, ListPhraseMatchersFixedSizeCollection> {
        public static ApiFuture<ListPhraseMatchersPagedResponse> createAsync(PageContext<ListPhraseMatchersRequest, ListPhraseMatchersResponse, PhraseMatcher> context, ApiFuture<ListPhraseMatchersResponse> futureResponse) {
            ApiFuture<ListPhraseMatchersPage> futurePage = ListPhraseMatchersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPhraseMatchersPagedResponse((ListPhraseMatchersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPhraseMatchersPagedResponse(ListPhraseMatchersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPhraseMatchersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAnalysesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAnalysesRequest, ListAnalysesResponse, Analysis, ListAnalysesPage, ListAnalysesFixedSizeCollection> {
        private ListAnalysesFixedSizeCollection(List<ListAnalysesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAnalysesFixedSizeCollection createEmptyCollection() {
            return new ListAnalysesFixedSizeCollection(null, 0);
        }

        protected ListAnalysesFixedSizeCollection createCollection(List<ListAnalysesPage> pages, int collectionSize) {
            return new ListAnalysesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAnalysesPage
    extends AbstractPage<ListAnalysesRequest, ListAnalysesResponse, Analysis, ListAnalysesPage> {
        private ListAnalysesPage(PageContext<ListAnalysesRequest, ListAnalysesResponse, Analysis> context, ListAnalysesResponse response) {
            super(context, (Object)response);
        }

        private static ListAnalysesPage createEmptyPage() {
            return new ListAnalysesPage(null, null);
        }

        protected ListAnalysesPage createPage(PageContext<ListAnalysesRequest, ListAnalysesResponse, Analysis> context, ListAnalysesResponse response) {
            return new ListAnalysesPage(context, response);
        }

        public ApiFuture<ListAnalysesPage> createPageAsync(PageContext<ListAnalysesRequest, ListAnalysesResponse, Analysis> context, ApiFuture<ListAnalysesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAnalysesPagedResponse
    extends AbstractPagedListResponse<ListAnalysesRequest, ListAnalysesResponse, Analysis, ListAnalysesPage, ListAnalysesFixedSizeCollection> {
        public static ApiFuture<ListAnalysesPagedResponse> createAsync(PageContext<ListAnalysesRequest, ListAnalysesResponse, Analysis> context, ApiFuture<ListAnalysesResponse> futureResponse) {
            ApiFuture<ListAnalysesPage> futurePage = ListAnalysesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAnalysesPagedResponse((ListAnalysesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAnalysesPagedResponse(ListAnalysesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAnalysesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConversationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage, ListConversationsFixedSizeCollection> {
        private ListConversationsFixedSizeCollection(List<ListConversationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConversationsFixedSizeCollection createEmptyCollection() {
            return new ListConversationsFixedSizeCollection(null, 0);
        }

        protected ListConversationsFixedSizeCollection createCollection(List<ListConversationsPage> pages, int collectionSize) {
            return new ListConversationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConversationsPage
    extends AbstractPage<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage> {
        private ListConversationsPage(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ListConversationsResponse response) {
            super(context, (Object)response);
        }

        private static ListConversationsPage createEmptyPage() {
            return new ListConversationsPage(null, null);
        }

        protected ListConversationsPage createPage(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ListConversationsResponse response) {
            return new ListConversationsPage(context, response);
        }

        public ApiFuture<ListConversationsPage> createPageAsync(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ApiFuture<ListConversationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConversationsPagedResponse
    extends AbstractPagedListResponse<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage, ListConversationsFixedSizeCollection> {
        public static ApiFuture<ListConversationsPagedResponse> createAsync(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ApiFuture<ListConversationsResponse> futureResponse) {
            ApiFuture<ListConversationsPage> futurePage = ListConversationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConversationsPagedResponse((ListConversationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConversationsPagedResponse(ListConversationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConversationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

